/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.lang.parser.EvaluationException;
import gw.lang.reflect.IMethodCallHandler;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.TypeSystem;
import gw.util.GosuClassUtil;
import gw.util.GosuExceptionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MethodCallAdapter
implements IMethodCallHandler {
    private Method _method = null;
    private Class[] _argTypes = null;

    public MethodCallAdapter(Method method) {
        this._method = method;
        this._argTypes = method.getParameterTypes();
        this._method.setAccessible(true);
    }

    public Object handleCall(Object ctx, Object ... argValues) {
        if (argValues == null ? this._argTypes.length != 0 : this._argTypes.length != argValues.length) {
            throw new EvaluationException("Wrong number of arguments for method " + this._method.getName() + " in class " + this._method.getDeclaringClass().getName());
        }
        if (!Modifier.isStatic((int)this._method.getModifiers())) {
            if (ctx == null) {
                throw new EvaluationException("Tried to invoke method from null reference: " + this._method.getDeclaringClass().getName() + "#" + this._method.getName());
            }
            if (!this._method.getDeclaringClass().isAssignableFrom(ctx.getClass())) {
                throw new EvaluationException("Tried to invoke method from a context not compatible with method's declaring class.\nContext: " + ctx.getClass().getName() + "\nMethod: " + this._method.getDeclaringClass().getName() + "#" + this._method.getName());
            }
        }
        ClassLoader previousClassLoader = null;
        boolean bMethodOnThread = Thread.class.isAssignableFrom(this._method.getDeclaringClass());
        if (!bMethodOnThread) {
            previousClassLoader = Thread.currentThread().getContextClassLoader();
            if (TypeSystem.getCurrentModule() != null) {
                Thread.currentThread().setContextClassLoader(TypeSystem.getGosuClassLoader().getActualLoader());
            }
        }
        try {
            Object object = this._method.invoke(ctx, argValues);
            return object;
        }
        catch (InvocationTargetException ex) {
            throw GosuExceptionUtil.forceThrow((Throwable)ex.getCause());
        }
        catch (IllegalArgumentException ie) {
            GosuExceptionUtil.throwArgMismatchException((IllegalArgumentException)ie, (String)("method \"" + GosuClassUtil.getShortClassName(this._method.getDeclaringClass()) + "#" + this._method.getName() + "\""), (Class[])this._method.getParameterTypes(), (Object[])argValues);
            Object var6_9 = null;
            return var6_9;
        }
        catch (Throwable t) {
            throw this.makeMethodCallEvaluationException(this._method, t);
        }
        finally {
            if (!bMethodOnThread) {
                Thread.currentThread().setContextClassLoader(previousClassLoader);
            }
        }
    }

    public Method getMethod() {
        return this._method;
    }

    private RuntimeException makeMethodCallEvaluationException(Method method, Throwable t) {
        Object params = "";
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            Class<?> aClass = method.getParameterTypes()[i];
            if (i != 0) {
                params = (String)params + ", ";
            }
            params = (String)params + aClass.getName();
        }
        return new RuntimeException("could not invoke " + method.getName() + "(" + (String)params + ") on class " + this._method.getDeclaringClass().getName(), t);
    }
}

