/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.ClassAnnotationInfo;
import gw.internal.gosu.parser.GenericTypeVariable;
import gw.internal.gosu.parser.TypeJavaClassType;
import gw.internal.gosu.parser.TypeVariableJavaTypeVariable;
import gw.internal.gosu.parser.java.classinfo.JavaSourceUtil;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.java.IJavaAnnotatedElement;
import gw.lang.reflect.java.IJavaClassBytecodeMethod;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.IJavaClassType;
import gw.lang.reflect.java.IJavaClassTypeVariable;
import gw.lang.reflect.java.IJavaMethodInfo;
import gw.lang.reflect.java.Parameter;
import gw.lang.reflect.module.IModule;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MethodJavaClassMethod
implements IJavaClassMethod,
IJavaClassBytecodeMethod {
    private Method _method;
    private IModule _module;

    public MethodJavaClassMethod(Method method, IModule module) {
        this._method = method;
        this._module = module;
    }

    public IType getReturnType() {
        return TypeSystem.get(this._method.getReturnType());
    }

    public IJavaClassInfo getReturnClassInfo() {
        return JavaSourceUtil.getClassInfo(this._method.getReturnType(), this._module);
    }

    public String getName() {
        return this._method.getName();
    }

    public List<Parameter> getParameterInfos() {
        java.lang.reflect.Parameter[] params = this._method.getParameters();
        if (params != null) {
            ArrayList<Parameter> paramInfos = new ArrayList<Parameter>();
            for (java.lang.reflect.Parameter p : params) {
                paramInfos.add(new Parameter(p.isNamePresent() ? p.getName() : null, p.getModifiers()));
            }
            return paramInfos;
        }
        return Collections.emptyList();
    }

    public IJavaClassInfo getEnclosingClass() {
        return JavaSourceUtil.getClassInfo(this._method.getDeclaringClass(), this._module);
    }

    public IJavaClassInfo[] getParameterTypes() {
        Class<?>[] rawTypes = this._method.getParameterTypes();
        IJavaClassInfo[] types = new IJavaClassInfo[rawTypes.length];
        for (int i = 0; i < rawTypes.length; ++i) {
            types[i] = JavaSourceUtil.getClassInfo(rawTypes[i], this._module);
        }
        return types;
    }

    public int getModifiers() {
        return this._method.getModifiers();
    }

    public boolean isSynthetic() {
        return this._method.isSynthetic();
    }

    public boolean isBridge() {
        return this._method.isBridge();
    }

    public IJavaClassInfo[] getExceptionTypes() {
        Class<?>[] rawTypes = this._method.getExceptionTypes();
        IJavaClassInfo[] types = new IJavaClassInfo[rawTypes.length];
        for (int i = 0; i < rawTypes.length; ++i) {
            types[i] = JavaSourceUtil.getClassInfo(rawTypes[i], this._module);
        }
        return types;
    }

    public Object getDefaultValue() {
        return this._method.getDefaultValue();
    }

    public String getReturnTypeName() {
        return this._method.getReturnType().getName();
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this._method.isAnnotationPresent(annotationClass);
    }

    public IAnnotationInfo getAnnotation(Class annotationClass) {
        Object annotation = this._method.getAnnotation(annotationClass);
        return annotation != null ? new ClassAnnotationInfo((Annotation)annotation, (IJavaAnnotatedElement)this) : null;
    }

    public IAnnotationInfo[] getDeclaredAnnotations() {
        Annotation[] annotations = this._method.getDeclaredAnnotations();
        IAnnotationInfo[] declaredAnnotations = new IAnnotationInfo[annotations.length];
        for (int i = 0; i < declaredAnnotations.length; ++i) {
            declaredAnnotations[i] = new ClassAnnotationInfo(annotations[i], (IJavaAnnotatedElement)this);
        }
        return declaredAnnotations;
    }

    public void setAccessible(boolean accessible) {
        this._method.setAccessible(accessible);
    }

    public Object invoke(Object ctx, Object[] args) throws InvocationTargetException, IllegalAccessException {
        return this._method.invoke(ctx, args);
    }

    public IGenericTypeVariable[] getTypeVariables(IJavaMethodInfo mi) {
        TypeVariable<Method>[] rawTypeVariables = this._method.getTypeParameters();
        IJavaClassTypeVariable[] typeVariables = new IJavaClassTypeVariable[rawTypeVariables.length];
        for (int i = 0; i < rawTypeVariables.length; ++i) {
            typeVariables[i] = new TypeVariableJavaTypeVariable(rawTypeVariables[i], this._module);
        }
        FunctionType functionType = new FunctionType((IMethodInfo)mi, true);
        return GenericTypeVariable.convertTypeVars((IType)functionType, mi.getOwnersType(), typeVariables);
    }

    public IJavaClassType[] getGenericParameterTypes() {
        Type[] rawTypes = this._method.getGenericParameterTypes();
        IJavaClassType[] types = new IJavaClassType[rawTypes.length];
        for (int i = 0; i < rawTypes.length; ++i) {
            IJavaClassType type;
            Type rawType = rawTypes[i];
            types[i] = type = TypeJavaClassType.createType(rawType, this._module);
        }
        return types;
    }

    public IJavaClassType getGenericReturnType() {
        return TypeJavaClassType.createType(this._method.getGenericReturnType(), this._module);
    }

    public Class[] getJavaParameterTypes() {
        return this._method.getParameterTypes();
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.getParameterTypes());
        result = 31 * result + this.getReturnType().hashCode();
        result = 31 * result + this.getName().hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IJavaClassMethod)) {
            return false;
        }
        IJavaClassMethod jcm = (IJavaClassMethod)o;
        return this.getName().equals(jcm.getName()) && this.getReturnType() == jcm.getReturnType() && Arrays.equals(this.getParameterTypes(), jcm.getParameterTypes());
    }

    public int compareTo(IJavaClassMethod o) {
        return this.getName().compareTo(o.getName());
    }

    public Method getJavaMethod() {
        return this._method;
    }

    public String toString() {
        return this._method.toString();
    }
}

