/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.internal.gosu.ir.transform.AbstractElementTransformer;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.util.IRTypeResolver;
import gw.internal.gosu.parser.expressions.MapInitializerExpression;
import gw.internal.gosu.parser.expressions.NewExpression;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.parser.IExpression;
import gw.lang.parser.IParsedElement;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.JavaTypes;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MapInitializerExpressionTransformer
extends AbstractElementTransformer<MapInitializerExpression> {
    public static List<IRStatement> compile(TopLevelTransformationContext cc, MapInitializerExpression expr, IRExpression root) {
        MapInitializerExpressionTransformer gen = new MapInitializerExpressionTransformer(cc, expr);
        return gen.compile(root);
    }

    private MapInitializerExpressionTransformer(TopLevelTransformationContext cc, MapInitializerExpression expr) {
        super(cc, expr);
    }

    private List<IRStatement> compile(IRExpression root) {
        Class mapType = this.getMapType();
        List<IExpression> keys = ((MapInitializerExpression)this.getParsedElement()).getKeys();
        List<IExpression> values = ((MapInitializerExpression)this.getParsedElement()).getValues();
        ArrayList<IRStatement> statements = new ArrayList<IRStatement>();
        for (int i = 0; i < keys.size(); ++i) {
            IExpression keyExpr = keys.get(i);
            IRExpression irKeyExpr = ExpressionTransformer.compile(keyExpr, this._cc());
            IExpression valueExpr = values.get(i);
            IRExpression irValueExpr = ExpressionTransformer.compile(valueExpr, this._cc());
            IRExpression putCall = this.callMethod(mapType, "put", new Class[]{Object.class, Object.class}, root, MapInitializerExpressionTransformer.exprList(irKeyExpr, irValueExpr));
            statements.add((IRStatement)this.buildMethodCall(putCall));
        }
        return statements;
    }

    private Class getMapType() {
        Class<AbstractMap> mapType = Map.class;
        IParsedElement parent = ((MapInitializerExpression)this.getParsedElement()).getParent();
        if (parent instanceof NewExpression) {
            Class<AbstractMap> javaBackedClass;
            IType newType = ((NewExpression)parent).getType();
            IJavaClassInfo classInfo = IRTypeResolver.getJavaBackedClass(newType);
            Class<AbstractMap> clazz = javaBackedClass = classInfo != null ? classInfo.getBackingClass() : null;
            if (classInfo != null && javaBackedClass != null) {
                mapType = javaBackedClass;
            } else if (JavaTypes.getJreType(AbstractMap.class).isAssignableFrom(newType)) {
                mapType = AbstractMap.class;
            }
        }
        return mapType;
    }
}

