/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.AbstractDynamicSymbol;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.ParameterizedDynamicFunctionSymbol;
import gw.internal.gosu.parser.ReducedDynamicFunctionSymbol;
import gw.internal.gosu.parser.Statement;
import gw.internal.gosu.parser.SuperConstructorFunctionSymbol;
import gw.internal.gosu.parser.Symbol;
import gw.internal.gosu.parser.ThisConstructorFunctionSymbol;
import gw.internal.gosu.parser.statements.FunctionStatement;
import gw.internal.gosu.parser.statements.MethodCallStatement;
import gw.lang.parser.IDynamicFunctionSymbol;
import gw.lang.parser.IExpression;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IReducedDynamicFunctionSymbol;
import gw.lang.parser.IStatement;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IDFSBackedFeatureInfo;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.TypeInfoUtil;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.gs.IProgramInstance;
import gw.util.GosuExceptionUtil;
import java.util.Collections;
import java.util.List;

public class DynamicFunctionSymbol
extends AbstractDynamicSymbol
implements IDynamicFunctionSymbol {
    private static final Object DEFINITION_CLEARED = new Object(){

        public String toString() {
            return "<cleared>";
        }
    };
    private static final Object NULL_MI = new Object(){

        public String toString() {
            return "null_mi";
        }
    };
    private String _strDisplayName;
    private List<ISymbol> _args;
    private MethodCallStatement _initializer;
    private FunctionStatement _functionStmt;
    private DynamicFunctionSymbol _superDfs;
    private boolean _bLoopImplicitReturn;
    private IExpression _annotationDefault;
    private volatile Object _mi;

    public DynamicFunctionSymbol(ISymbolTable symTable, CharSequence strName, IFunctionType type, List<ISymbol> args, IStatement value) {
        this(symTable, strName, type, args, (Object)value);
    }

    public DynamicFunctionSymbol(ISymbolTable symTable, CharSequence strName, IFunctionType type, List<ISymbol> args, IExpression value) {
        this(symTable, strName, type, args, (Object)value);
    }

    protected DynamicFunctionSymbol(ISymbolTable symTable, CharSequence name, IFunctionType type, List<ISymbol> args, Object value) {
        super(symTable, name, (IType)type);
        this._value = value;
        assert (value instanceof Statement || value instanceof Symbol || value == null || value instanceof Expression) : "Invalid type for DFS value: " + value.getClass();
        this._args = args == null || args.isEmpty() ? Collections.emptyList() : args;
        this._strDisplayName = name.toString();
        this.setName(this.getSignatureName(name));
    }

    public DynamicFunctionSymbol(DynamicFunctionSymbol dfs) {
        super(dfs._symTable, dfs.getName(), dfs.getType());
        this._value = dfs._value;
        this._args = dfs._args;
        this._initializer = dfs._initializer;
        this.setName(dfs.getName());
        this.setDisplayName(dfs.getDisplayName());
        this._scriptPartId = dfs._scriptPartId;
        this.replaceModifierInfo(dfs.getModifierInfo());
    }

    @Override
    public void renameAsErrantDuplicate(int iIndex) {
        this.setName(this.getSignatureName(iIndex + "_duplicate_" + this._strDisplayName));
    }

    @Override
    public String getDisplayName() {
        return this._strDisplayName;
    }

    protected void setDisplayName(String strDisplayName) {
        this._strDisplayName = strDisplayName;
    }

    public List<ISymbol> getArgs() {
        return this._args;
    }

    public IType[] getArgTypes() {
        IType[] types = new IType[this._args == null ? 0 : this._args.size()];
        for (int i = 0; i < types.length; ++i) {
            assert (this._args != null);
            types[i] = this._args.get(i).getType();
        }
        return types;
    }

    public IType getReturnType() {
        return ((FunctionType)this.getType()).getReturnType();
    }

    @Override
    public Object invoke(Object[] args) {
        return this.invokeFromBytecode(args);
    }

    private Object invokeFromBytecode(Object[] args) {
        IGosuClass gsClass;
        IParsedElement stmts = (IParsedElement)this.getValueDirectly();
        if (stmts == null) {
            this.ensureDeclaringClassIsCompiled();
            stmts = (IParsedElement)this.getValueDirectly();
        }
        if ((gsClass = this.findGosuClassOrProgram(stmts)) == null) {
            throw new IllegalStateException("Did not find Gosu Class/Program");
        }
        Class javaClass = gsClass.getBackingClass();
        IProgramInstance instance = null;
        if (gsClass instanceof IGosuProgram) {
            try {
                instance = (IProgramInstance)javaClass.newInstance();
                instance.evaluate(null);
            }
            catch (Exception e) {
                throw GosuExceptionUtil.forceThrow((Throwable)e);
            }
        }
        IMethodInfo mi = gsClass.getTypeInfo().getMethod((IType)gsClass, (CharSequence)this.getDisplayName(), this.getArgTypes());
        return mi.getCallHandler().handleCall((Object)instance, args);
    }

    private void ensureDeclaringClassIsCompiled() {
        IGosuClassInternal gsClass = this.getGosuClass();
        if (gsClass != null) {
            gsClass.isValid();
        }
    }

    private IGosuClass findGosuClassOrProgram(IParsedElement pe) {
        if (pe == null) {
            return null;
        }
        Object gsClass = pe.getGosuProgram();
        if (gsClass != null) {
            return gsClass;
        }
        gsClass = this.getGosuClass();
        if (gsClass != null) {
            return gsClass;
        }
        return this.findGosuClassOrProgram(pe.getParent());
    }

    protected String getCannonicalName() {
        return this.getName();
    }

    @Override
    public boolean isClassMember() {
        return super.isClassMember() && !this.isConstructor();
    }

    @Override
    public void clearDebugInfo() {
        super.clearDebugInfo();
        if (this._functionStmt != null) {
            this._functionStmt.clearParseTreeInformation();
        }
    }

    @Override
    public boolean isReified() {
        return super.isReified() || this.isConstructor();
    }

    public boolean isConstructor() {
        return this.getInitializer() != null;
    }

    @Override
    public String getSignatureDescription() {
        return this.getMethodSignature();
    }

    @Override
    public ISymbol getLightWeightReference() {
        return this;
    }

    public String getMethodSignature() {
        return this.getDisplayName() + this.getParameterDisplay(true) + " : " + TypeInfoUtil.getTypeName((IType)((FunctionType)this.getType()).getReturnType());
    }

    public static String getSignatureName(CharSequence strName, List<ISymbol> args) {
        return strName + DynamicFunctionSymbol.getUniqueNameForParameters(args);
    }

    protected String getSignatureName(CharSequence strName) {
        return DynamicFunctionSymbol.getSignatureName(strName, this.getArgs());
    }

    public String getParameterDisplay(boolean bRelative) {
        IType[] paramTypes = ((FunctionType)this.getType()).getParameterTypes();
        if (paramTypes == null || paramTypes.length == 0) {
            return "()";
        }
        Object strParams = "(";
        for (int i = 0; i < paramTypes.length; ++i) {
            strParams = (String)strParams + (i == 0 ? "" : ", ") + (bRelative ? paramTypes[i].getRelativeName() : paramTypes[i].getName());
        }
        strParams = (String)strParams + ")";
        return strParams;
    }

    private static String getUniqueNameForParameters(List<ISymbol> args) {
        if (args == null || args.size() == 0) {
            return "()";
        }
        Object strParams = "(";
        for (int i = 0; i < args.size(); ++i) {
            strParams = (String)strParams + (i == 0 ? "" : ", ") + args.get(i).getType().getName();
        }
        strParams = (String)strParams + ")";
        return strParams;
    }

    protected DynamicFunctionSymbol getFunctionSymbol() {
        ISymbol symbol = this._symTable.getSymbol((CharSequence)this.getName());
        if (symbol != null) {
            return (DynamicFunctionSymbol)symbol;
        }
        return this;
    }

    public void setInitializer(MethodCallStatement initializer) {
        this._initializer = initializer;
    }

    public MethodCallStatement getInitializer() {
        return this._initializer;
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract((int)this.getModifiers());
    }

    @Override
    public void setAbstract(boolean bAbstract) {
        this.setModifiers(Modifier.setAbstract((int)this.getModifiers(), (boolean)bAbstract));
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal((int)this.getModifiers());
    }

    @Override
    public void setFinal(boolean bFinal) {
        this.setModifiers(Modifier.setFinal((int)this.getModifiers(), (boolean)bFinal));
    }

    public IDynamicFunctionSymbol getBackingDfs() {
        return this;
    }

    public IAttributedFeatureInfo getMethodOrConstructorInfo(boolean acceptNone) {
        IAttributedFeatureInfo methodOrConstructorInfo = this.getMethodOrConstructorInfo();
        if (methodOrConstructorInfo == null && !acceptNone) {
            throw new IllegalStateException("Should have found method/ctor info for " + this.getName());
        }
        return methodOrConstructorInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IAttributedFeatureInfo getMethodOrConstructorInfo() {
        block13: {
            block11: {
                if (this._mi != null) {
                    if (this._mi == DynamicFunctionSymbol.NULL_MI) {
                        return null;
                    }
                    v0 = (IAttributedFeatureInfo)this._mi;
                    return v0;
                }
                cachedMi = null;
                try {
                    block15: {
                        scriptPart = this.getScriptPart();
                        v1 = declaringType = scriptPart == null ? null : scriptPart.getContainingType();
                        if (declaringType == null) break block11;
                        if (declaringType instanceof IGosuClass && ((IGosuClass)declaringType).isCompilingDeclarations()) {
                            System.out.println("!!! Attempted to acquire declarations while compiling declarations");
                        }
                        methods = (typeInfo = declaringType.getTypeInfo()) instanceof IRelativeTypeInfo != false ? ((IRelativeTypeInfo)typeInfo).getMethods(declaringType) : typeInfo.getMethods();
                        thisRS = this.createReducedSymbol();
                        for (IMethodInfo mi : methods) {
                            if (!(mi instanceof IDFSBackedFeatureInfo) || !thisRS.equals(dfs = ((IDFSBackedFeatureInfo)mi).getDfs()) && !thisRS.getBackingDfs().equals(dfs)) continue;
                            var10_10 = cachedMi = mi;
                            ** break block14
                        }
                        ctors = typeInfo instanceof IRelativeTypeInfo != false ? ((IRelativeTypeInfo)typeInfo).getConstructors(declaringType) : typeInfo.getConstructors();
                        var8_8 = ctors.iterator();
                        break block15;
lbl-1000:
                        // 1 sources

                        {
                            this._mi = cachedMi == null ? DynamicFunctionSymbol.NULL_MI : cachedMi;
                        }
                        return var10_10;
                    }
                    while (var8_8.hasNext()) {
                        ci = (IConstructorInfo)var8_8.next();
                        if (!(ci instanceof IDFSBackedFeatureInfo)) break block12;
                        dfs = ((IDFSBackedFeatureInfo)ci).getDfs();
                        if (thisRS.equals(dfs) || thisRS.getBackingDfs().equals(dfs)) {
                            cachedMi = ci;
                            var11_12 = cachedMi;
                            v2 = cachedMi == null ? DynamicFunctionSymbol.NULL_MI : cachedMi;
                            break block13;
                        }
                        if (!(this instanceof SuperConstructorFunctionSymbol) && !(this instanceof ThisConstructorFunctionSymbol) || !dfs.getArgs().equals(this.getArgs())) break block12;
                        cachedMi = ci;
                        var11_13 = cachedMi;
                        this._mi = cachedMi == null ? DynamicFunctionSymbol.NULL_MI : cachedMi;
                    }
                }
                catch (Throwable var12_14) {
                    this._mi = cachedMi == null ? DynamicFunctionSymbol.NULL_MI : cachedMi;
                    throw var12_14;
                }
                {
                    block12: {
                        return var11_13;
                    }
                    continue;
                }
            }
            this._mi = cachedMi == null ? DynamicFunctionSymbol.NULL_MI : cachedMi;
            return cachedMi;
        }
        this._mi = v2;
        return var11_12;
    }

    public ITypeInfo getDeclaringTypeInfo() {
        IType type;
        IType iType = type = this.getScriptPart() == null ? null : this.getScriptPart().getContainingType();
        if (type == null) {
            return null;
        }
        return type.getTypeInfo();
    }

    @Override
    public String getFullDescription() {
        return this.getModifierInfo() == null ? "" : this.getModifierInfo().getDescription();
    }

    @Override
    public void setValue(Object value) {
        assert (value == null || value instanceof Statement || value instanceof Symbol || value instanceof Expression) : "Invalid type for DFS value: " + value.getClass();
        super.setValue(value);
    }

    public FunctionStatement getDeclFunctionStmt() {
        return this._functionStmt;
    }

    public void setDeclFunctionStmt(FunctionStatement declFunctionStmt) {
        this._functionStmt = declFunctionStmt;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof DynamicFunctionSymbol)) {
            return false;
        }
        DynamicFunctionSymbol that = (DynamicFunctionSymbol)o;
        String strName = this.getName();
        return !(strName == null ? that.getName() != null : !strName.equals(that.getName()));
    }

    @Override
    public DynamicFunctionSymbol getParameterizedVersion(IGosuClass gsClass) {
        return new ParameterizedDynamicFunctionSymbol(this, gsClass);
    }

    public void clearDefn() {
        this.setValueDirectly(DEFINITION_CLEARED);
    }

    public void setArgs(List<ISymbol> args) {
        this._args = args;
    }

    public void setSuperDfs(DynamicFunctionSymbol superDfs) {
        this._superDfs = superDfs;
    }

    public DynamicFunctionSymbol getSuperDfs() {
        return this._superDfs;
    }

    @Override
    public boolean hasTypeVariables() {
        IGenericTypeVariable[] tvs = this.getType().getGenericTypeVariables();
        return tvs != null && tvs.length != 0;
    }

    public boolean hasOptionalParameters() {
        List<ISymbol> args = this.getArgs();
        if (args != null) {
            for (ISymbol arg : args) {
                if (arg.getDefaultValueExpression() == null) continue;
                return true;
            }
        }
        return false;
    }

    public IReducedDynamicFunctionSymbol createReducedSymbol() {
        return new ReducedDynamicFunctionSymbol(this);
    }

    public void setLoopImplicitReturn(boolean bLoopImplicitReturn) {
        this._bLoopImplicitReturn = bLoopImplicitReturn;
    }

    public boolean isLoopImplicitReturn() {
        return this._bLoopImplicitReturn;
    }

    public IExpression getAnnotationDefault() {
        return this._annotationDefault;
    }

    public void setAnnotationDefault(IExpression annotationDefault) {
        this._annotationDefault = annotationDefault;
    }
}

