/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.internal.gosu.parser.GosuBaseAttributedFeatureInfo;
import gw.internal.gosu.parser.GosuClassTypeInfo;
import gw.internal.gosu.parser.IGosuAnnotation;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.ReducedSuperConstructorFunctionSymbol;
import gw.internal.gosu.parser.ReducedSymbol;
import gw.internal.gosu.parser.ReducedThisConstructorFunctionSymbol;
import gw.internal.gosu.parser.SuperConstructorFunctionSymbol;
import gw.internal.gosu.parser.ThisConstructorFunctionSymbol;
import gw.internal.gosu.parser.VarPropertyGetFunctionSymbol;
import gw.internal.gosu.parser.VarPropertySetFunctionSymbol;
import gw.lang.parser.IDynamicFunctionSymbol;
import gw.lang.parser.IReducedDynamicFunctionSymbol;
import gw.lang.parser.IReducedSymbol;
import gw.lang.parser.ISymbol;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IDFSBackedFeatureInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IModifierInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.gs.IGosuClassTypeInfo;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.gs.IProgramInstance;
import gw.util.GosuExceptionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ReducedDynamicFunctionSymbol
extends ReducedSymbol
implements IReducedDynamicFunctionSymbol {
    private IType[] _argTypes;
    private IType _returnType;
    private List<IReducedSymbol> _args;
    private IReducedDynamicFunctionSymbol _superDfs;
    private final boolean _isConstructor;

    ReducedDynamicFunctionSymbol(DynamicFunctionSymbol dfs) {
        super(dfs);
        this._isConstructor = dfs.isConstructor();
        this._argTypes = dfs.getArgTypes();
        this._returnType = dfs.getReturnType();
        this._args = this.makeArgs(dfs);
        this._fullDescription = dfs.getFullDescription();
        DynamicFunctionSymbol superDfs = dfs.getSuperDfs();
        if (superDfs != null) {
            this._superDfs = superDfs.createReducedSymbol();
        }
    }

    private List<IReducedSymbol> makeArgs(IDynamicFunctionSymbol dfs) {
        List args = dfs.getArgs();
        ArrayList<IReducedSymbol> newArgs = new ArrayList<IReducedSymbol>(args.size());
        for (ISymbol arg : args) {
            newArgs.add(arg.createReducedSymbol());
        }
        return newArgs;
    }

    public IType[] getArgTypes() {
        return this._argTypes;
    }

    public IType getReturnType() {
        return this._returnType;
    }

    @Override
    public String getFullDescription() {
        return this._fullDescription;
    }

    public List<IReducedSymbol> getArgs() {
        return this._args;
    }

    public IReducedDynamicFunctionSymbol getSuperDfs() {
        return this._superDfs;
    }

    public boolean isSuperOrThisConstructor() {
        return SuperConstructorFunctionSymbol.class.isAssignableFrom(this.getSymbolClass()) || ThisConstructorFunctionSymbol.class.isAssignableFrom(this.getSymbolClass());
    }

    public IReducedDynamicFunctionSymbol getBackingDfs() {
        return this;
    }

    public IAttributedFeatureInfo getMethodOrConstructorInfo() {
        IGosuClassInternal declaringType = this.getGosuClass();
        if (declaringType == null) {
            return null;
        }
        IGosuClassTypeInfo typeInfo = declaringType.getTypeInfo();
        MethodList methods = typeInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)typeInfo).getMethods((IType)declaringType) : typeInfo.getMethods();
        for (IMethodInfo mi : methods) {
            IReducedDynamicFunctionSymbol dfs;
            if (!(mi instanceof IDFSBackedFeatureInfo) || !this.equals(dfs = ((IDFSBackedFeatureInfo)mi).getDfs()) && !this.getBackingDfs().equals(dfs)) continue;
            return mi;
        }
        List ctors = typeInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)typeInfo).getConstructors((IType)declaringType) : typeInfo.getConstructors();
        for (IConstructorInfo ci : ctors) {
            if (!(ci instanceof IDFSBackedFeatureInfo)) continue;
            IReducedDynamicFunctionSymbol dfs = ((IDFSBackedFeatureInfo)ci).getDfs();
            if (this.equals(dfs) || this.getBackingDfs().equals(dfs)) {
                return ci;
            }
            if (!(this instanceof ReducedSuperConstructorFunctionSymbol) && !(this instanceof ReducedThisConstructorFunctionSymbol) || !dfs.getArgs().equals(this.getArgs())) continue;
            return ci;
        }
        return null;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ReducedDynamicFunctionSymbol)) {
            return false;
        }
        ReducedDynamicFunctionSymbol that = (ReducedDynamicFunctionSymbol)o;
        String strName = this.getName();
        return !(strName == null ? that.getName() != null : !strName.equals(that.getName()));
    }

    public Object invoke(Object[] args) {
        return this.invokeFromBytecode(args);
    }

    private Object invokeFromBytecode(Object[] args) {
        IGosuClassInternal gsClass = this.getGosuClass();
        if (gsClass == null) {
            throw new IllegalStateException("Did not find Gosu Class/Program");
        }
        Class javaClass = gsClass.getBackingClass();
        IProgramInstance instance = null;
        if (gsClass instanceof IGosuProgram) {
            try {
                instance = (IProgramInstance)javaClass.newInstance();
                instance.evaluate(null);
            }
            catch (Exception e) {
                throw GosuExceptionUtil.forceThrow((Throwable)e);
            }
        }
        IMethodInfo mi = gsClass.getTypeInfo().getMethod((IType)gsClass, (CharSequence)this.getDisplayName(), this.getArgTypes());
        return mi.getCallHandler().handleCall((Object)instance, args);
    }

    @Override
    public List<IGosuAnnotation> getAnnotations() {
        IModifierInfo modifierInfo;
        IAttributedFeatureInfo featureInfo = this.getMethodOrConstructorInfo();
        List result = featureInfo instanceof GosuBaseAttributedFeatureInfo ? ((modifierInfo = ((GosuClassTypeInfo)this.getGosuClass().getTypeInfo()).getModifierInfo((GosuBaseAttributedFeatureInfo)featureInfo)) != null ? modifierInfo.getAnnotations() : Collections.emptyList()) : Collections.emptyList();
        return result;
    }

    public boolean isVarPropertyGet() {
        return VarPropertyGetFunctionSymbol.class.isAssignableFrom(this.getSymbolClass());
    }

    public boolean isVarPropertySet() {
        return VarPropertySetFunctionSymbol.class.isAssignableFrom(this.getSymbolClass());
    }

    public boolean isConstructor() {
        return this._isConstructor;
    }
}

