/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.internal.gosu.parser.MetaType;
import gw.internal.gosu.parser.expressions.BlockType;
import gw.internal.gosu.parser.expressions.TypeLiteral;
import gw.lang.parser.IExpression;
import gw.lang.parser.expressions.IBlockLiteralExpression;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.JavaTypes;
import gw.util.concurrent.LockingLazyVar;
import java.util.ArrayList;
import java.util.List;

public class BlockLiteral
extends TypeLiteral
implements IBlockLiteralExpression {
    private ArrayList<IType> _argTypes;
    private ArrayList<String> _argNames;
    private ArrayList<IExpression> _defValues;
    private IType _returnType;
    private final LockingLazyVar<MetaType> _blockType = new LockingLazyVar<MetaType>(){

        protected MetaType init() {
            BlockType type = new BlockType(BlockLiteral.this._returnType, BlockLiteral.this._argTypes.toArray(new IType[BlockLiteral.this._argTypes.size()]), BlockLiteral.this._argNames, BlockLiteral.this._defValues);
            return MetaType.get((IType)type);
        }
    };

    public BlockLiteral() {
        super(JavaTypes.FUNCTION_TYPE());
    }

    public void setArgTypes(List<IType> paramTypes) {
        this._argTypes = new ArrayList();
        for (IType paramType : paramTypes) {
            this._argTypes.add(paramType);
        }
    }

    private IType getTypeFromLiteral(TypeLiteral typeLiteral) {
        MetaType metaType = typeLiteral.getType();
        IType type = metaType.getType();
        return type;
    }

    @Override
    public Object clone() {
        BlockLiteral clone = new BlockLiteral();
        clone._argTypes = new ArrayList<IType>(this._argTypes);
        clone._returnType = this._returnType;
        clone.setLocation(this.getLocation());
        return clone;
    }

    public void setReturnType(TypeLiteral returnType) {
        this._returnType = this.getTypeFromLiteral(returnType);
    }

    @Override
    public MetaType getTypeImpl() {
        return this._blockType == null ? null : (MetaType)((Object)this._blockType.get());
    }

    @Override
    public String toString() {
        Object returnStr = "block (";
        for (int i = 0; i < this._argTypes.size(); ++i) {
            IType iIntrinsicType = this._argTypes.get(i);
            String name = this._argNames.get(i);
            if (name.length() > 0) {
                returnStr = (String)returnStr + name + ":";
            }
            returnStr = (String)returnStr + iIntrinsicType.getName();
            if (i >= this._argTypes.size() - 1) continue;
            returnStr = (String)returnStr + ",";
        }
        returnStr = (String)returnStr + "):";
        returnStr = (String)returnStr + this._returnType.getName();
        return returnStr;
    }

    public void setArgNames(ArrayList<String> argNames) {
        this._argNames = argNames;
    }

    public void setDefValueExpressions(ArrayList<IExpression> defValues) {
        this._defValues = defValues;
    }
}

