/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.java.classinfo;

import gw.internal.gosu.parser.AnnotationInfoFactoryImpl;
import gw.internal.gosu.parser.FieldJavaClassField;
import gw.internal.gosu.parser.GosuParser;
import gw.internal.gosu.parser.Symbol;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.TypeUsesMap;
import gw.internal.gosu.parser.java.classinfo.JavaSourceField;
import gw.internal.gosu.parser.java.classinfo.JavaSourceType;
import gw.lang.parser.GosuParserFactory;
import gw.lang.parser.IExpression;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.parser.TypelessScriptPartId;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.ICompileTimeConstantValue;
import gw.lang.reflect.java.IJavaClassField;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.module.IModule;
import gw.util.Array;
import gw.util.GosuExceptionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;

public class CompileTimeExpressionParser {
    public static IExpression parse(String text, IJavaClassInfo enclosingType, IType resultType) {
        if (text.endsWith(".class")) {
            text = text.substring(0, text.lastIndexOf(".class"));
        }
        TypeUsesMap usesMap = null;
        List<String> staticImports = null;
        IJavaClassInfo outerMostEnclosingType = TypeLord.getOuterMostEnclosingClass(enclosingType);
        if (outerMostEnclosingType instanceof JavaSourceType) {
            usesMap = ((JavaSourceType)outerMostEnclosingType).getTypeUsesMap().copy();
            staticImports = ((JavaSourceType)outerMostEnclosingType).getStaticImports();
            CompileTimeExpressionParser.addInnerClassNames(enclosingType, usesMap);
        } else {
            usesMap = new TypeUsesMap();
            staticImports = Collections.emptyList();
        }
        usesMap.addToDefaultTypeUses("gw.lang.");
        TypeSystem.pushIncludeAll();
        CompileTimeExpressionParser.addEnclosingPackages(usesMap, enclosingType);
        try {
            IExpression expr;
            GosuParser scriptParser = (GosuParser)GosuParserFactory.createParser((String)text);
            CompileTimeExpressionParser.maybePushEnumTypes(scriptParser.getSymbolTable(), resultType);
            CompileTimeExpressionParser.pushLocalConstants(scriptParser.getSymbolTable(), enclosingType);
            CompileTimeExpressionParser.pushStaticImports(scriptParser.getSymbolTable(), staticImports, enclosingType);
            scriptParser.setTypeUsesMap(usesMap);
            IExpression iExpression = expr = scriptParser.parseExpOrProgram((IScriptPartId)new TypelessScriptPartId("compile-time annotation eval"), resultType, false, false);
            return iExpression;
        }
        catch (ParseResultsException e) {
            throw GosuExceptionUtil.forceThrow((Throwable)e);
        }
        finally {
            TypeSystem.popIncludeAll();
        }
    }

    private static void addInnerClassNames(IJavaClassInfo enclosingType, ITypeUsesMap usesMap) {
        if (enclosingType == null) {
            return;
        }
        usesMap.addToTypeUses(enclosingType.getName());
        for (IJavaClassInfo jci : enclosingType.getDeclaredClasses()) {
            usesMap.addToTypeUses(jci.getName());
        }
        CompileTimeExpressionParser.addInnerClassNames(enclosingType.getEnclosingClass(), usesMap);
    }

    private static void pushLocalConstants(ISymbolTable symbolTable, IJavaClassInfo enclosingClass) {
        for (IJavaClassField field : enclosingClass.getDeclaredFields()) {
            symbolTable.putSymbol((ISymbol)new CompileTimeFieldSymbol(field));
        }
    }

    private static void pushStaticImports(ISymbolTable symbolTable, List<String> staticImports, IJavaClassInfo enclosingType) {
        for (String imp : staticImports) {
            IJavaClassInfo javaClassInfo = TypeSystem.getJavaClassInfo((String)imp, (IModule)enclosingType.getModule());
            if (javaClassInfo != null) {
                for (IJavaClassField field : javaClassInfo.getFields()) {
                    symbolTable.putSymbol((ISymbol)new CompileTimeFieldSymbol(field));
                }
                continue;
            }
            int endIndex = imp.lastIndexOf(46);
            String typeName = imp.substring(0, endIndex);
            String fieldName = imp.substring(endIndex + 1);
            javaClassInfo = TypeSystem.getJavaClassInfo((String)typeName, (IModule)enclosingType.getModule());
            for (IJavaClassField field : javaClassInfo.getFields()) {
                if (!field.getName().equals(fieldName)) continue;
                symbolTable.putSymbol((ISymbol)new CompileTimeFieldSymbol(field));
            }
        }
    }

    private static void maybePushEnumTypes(ISymbolTable symbolTable, IType returnType) {
        if (!returnType.isEnum()) {
            return;
        }
        for (IPropertyInfo pi : returnType.getTypeInfo().getProperties()) {
            if (!pi.isStatic() || !pi.isPublic()) continue;
            symbolTable.putSymbol((ISymbol)new Symbol(pi.getName(), pi.getFeatureType(), null));
        }
    }

    private static void addEnclosingPackages(ITypeUsesMap map, IJavaClassInfo type) {
        map.addToDefaultTypeUses(type.getNamespace() + ".");
        if (type.getEnclosingType() != null) {
            CompileTimeExpressionParser.addEnclosingPackages(map, type.getEnclosingClass());
        }
    }

    public static Object convertValueToInfoFriendlyValue(Object value, IFeatureInfo enclosingType) {
        if (value == null) {
            return null;
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        if (value.getClass().isArray() && !IType.class.isAssignableFrom(value.getClass().getComponentType())) {
            Object arrayValue = null;
            for (int i = 0; i < Array.getLength((Object)value); ++i) {
                Object elemValue = CompileTimeExpressionParser.convertValueToInfoFriendlyValue(Array.get((Object)value, (int)i), enclosingType);
                if (arrayValue == null) {
                    arrayValue = Array.newInstance(elemValue.getClass(), (int)Array.getLength((Object)value));
                }
                Array.set((Object)arrayValue, (int)i, (Object)elemValue);
            }
            if (arrayValue == null) {
                arrayValue = value;
            }
            return arrayValue;
        }
        if (value instanceof Class) {
            return TypeSystem.get((Class)((Class)value));
        }
        if (value instanceof Annotation) {
            return AnnotationInfoFactoryImpl.instance().createJavaAnnotation((Annotation)value, enclosingType);
        }
        return value;
    }

    public static class CompileTimeFieldSymbol
    extends Symbol
    implements ICompileTimeConstantValue {
        private IJavaClassField _field;

        public CompileTimeFieldSymbol(IJavaClassField field) {
            super(field.getName(), field.getType().getJavaType(), null);
            this._field = field;
        }

        public IJavaClassField getField() {
            return this._field;
        }

        public boolean isCompileTimeConstantValue() {
            return Modifier.isStatic(this.getField().getModifiers()) && Modifier.isFinal(this.getField().getModifiers());
        }

        @Override
        public ISymbol getLightWeightReference() {
            return this;
        }

        public Object doCompileTimeEvaluation() {
            IJavaClassField field = this.getField();
            if (field instanceof JavaSourceField) {
                String rhs = ((JavaSourceField)field).getRhs();
                IExpression expr = CompileTimeExpressionParser.parse(rhs, field.getEnclosingClass(), field.getType().getJavaType());
                return expr.evaluate();
            }
            if (field instanceof FieldJavaClassField) {
                try {
                    Object value = ((FieldJavaClassField)field).get(null);
                    return CompileTimeExpressionParser.convertValueToInfoFriendlyValue(value, (IFeatureInfo)this._field.getEnclosingClass().getJavaType().getTypeInfo());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new IllegalStateException("Unexpected field type: " + field);
        }
    }
}

