/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.template;

import gw.internal.gosu.parser.CommonSymbolsScope;
import gw.internal.gosu.parser.CompiledGosuClassSymbolTable;
import gw.internal.gosu.parser.ContextInferenceManager;
import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.internal.gosu.parser.GosuParser;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.IGosuEnhancementInternal;
import gw.internal.gosu.parser.Symbol;
import gw.internal.gosu.parser.TypeLoaderAccess;
import gw.internal.gosu.parser.expressions.BlockExpression;
import gw.internal.gosu.parser.expressions.Identifier;
import gw.internal.gosu.parser.expressions.Program;
import gw.internal.gosu.template.TemplateTokenizerInstructor;
import gw.lang.parser.ExternalSymbolMapForMap;
import gw.lang.parser.GosuParserFactory;
import gw.lang.parser.GosuParserTypes;
import gw.lang.parser.IExpression;
import gw.lang.parser.IFunctionSymbol;
import gw.lang.parser.IGosuParser;
import gw.lang.parser.ILockedDownSymbol;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.ITokenizerInstructor;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.parser.Keyword;
import gw.lang.parser.ScriptPartId;
import gw.lang.parser.ScriptabilityModifiers;
import gw.lang.parser.TypelessScriptPartId;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.parser.expressions.IProgram;
import gw.lang.parser.resources.Res;
import gw.lang.parser.template.IEscapesAllContent;
import gw.lang.parser.template.ITemplateGenerator;
import gw.lang.parser.template.StringEscaper;
import gw.lang.parser.template.TemplateParseException;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.TypeSystemShutdownListener;
import gw.lang.reflect.gs.GosuClassTypeLoader;
import gw.lang.reflect.gs.IExternalSymbolMap;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.java.JavaTypes;
import gw.util.GosuClassUtil;
import gw.util.GosuEscapeUtil;
import gw.util.GosuStringUtil;
import gw.util.Stack;
import gw.util.StreamUtil;
import gw.util.concurrent.LockingLazyVar;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TemplateGenerator
implements ITemplateGenerator {
    public static final String GS_TEMPLATE = "GsTemplate";
    public static final String GS_TEMPLATE_PARSED = "GsTemplateParsed";
    public static final String SCRIPTLET_BEGIN = "<%";
    public static final String SCRIPTLET_END = "%>";
    public static final char EXPRESSION_SUFFIX = '=';
    public static final char DECLARATION_SUFFIX = '!';
    public static final char DIRECTIVE_SUFFIX = '@';
    public static final String COMMENT_BEGIN = "<%--";
    public static final String COMMENT_END = "--%>";
    public static final String ALTERNATE_EXPRESSION_BEGIN = "${";
    public static final String ALTERNATE_EXPRESSION_END = "}";
    public static final char ESCAPED_SCRIPTLET_MARKER = '\uffe0';
    public static final char ESCAPED_SCRIPTLET_BEGIN_CHAR = '\uffe1';
    public static final char ESCAPED_ALTERNATE_EXPRESSION_BEGIN_CHAR = '\uffe2';
    public static final int SCRIPTLET_BEGIN_LEN = "<%".length();
    public static final int SCRIPTLET_END_LEN = "%>".length();
    public static final int COMMENT_BEGIN_LEN = "<%--".length();
    public static final int COMMENT_END_LEN = "--%>".length();
    public static final int ALTERNATE_EXPRESSION_BEGIN_LEN = "${".length();
    public static final int ALTERNATE_EXPRESSION_END_LEN = "}".length();
    public static final LockingLazyVar<ISymbol> PRINT_CONTENT_SYMBOL = new LockingLazyVar<ISymbol>(){

        protected ISymbol init() {
            try {
                return new LockedDownSymbol((CharSequence)"printContent", (IType)new FunctionType("printContent", GosuParserTypes.NULL_TYPE(), new IType[]{GosuParserTypes.STRING_TYPE(), JavaTypes.pBOOLEAN()}), TemplateGenerator.class.getMethod("printContent", String.class, Boolean.TYPE));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    };
    public static final LockingLazyVar<ISymbol> PRINT_RANGE_SYMBOL = new LockingLazyVar<ISymbol>(){

        protected ISymbol init() {
            try {
                return new LockedDownSymbol((CharSequence)"printRange", (IType)new FunctionType("printRange", GosuParserTypes.NULL_TYPE(), new IType[]{JavaTypes.pINT(), JavaTypes.pINT()}), TemplateGenerator.class.getMethod("printRange", Integer.TYPE, Integer.TYPE));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    };
    public static final String TEMPLATE_LINE_NUMBER = "//#LN#";
    private static ThreadLocal<Stack<RuntimeData>> g_runtimeData;
    public static final int SUBSTR_CHUNKSIZE = 2048;
    private String _fqn;
    private String _scriptStr;
    private List<ISymbol> _params = new ArrayList<ISymbol>();
    private Program _program;
    private ISymbolTable _compileTimeSymbolTable;
    private IType _supertype;
    private boolean _useStudioEditorParser;
    private boolean _disableAlternative;
    private boolean _hasOwnSymbolScope;
    private ContextInferenceManager _ctxInferenceMgr;
    private boolean _bStringLiteralTemplate;

    public static void generateTemplate(Reader readerTemplate, Writer writerOut, ISymbolTable symTable) throws TemplateParseException {
        TemplateGenerator.generateTemplate(readerTemplate, writerOut, symTable, false);
    }

    public static void generateTemplate(Reader readerTemplate, Writer writerOut, ISymbolTable symTable, boolean strict) throws TemplateParseException {
        TemplateGenerator te = new TemplateGenerator(readerTemplate);
        te.setDisableAlternative(strict);
        te.execute(writerOut, symTable);
    }

    public static TemplateGenerator getTemplate(Reader readerTemplate) {
        return new TemplateGenerator(readerTemplate);
    }

    public static TemplateGenerator getTemplate(Reader readerTemplate, String fullyQualifiedName) {
        TemplateGenerator template = TemplateGenerator.getTemplate(readerTemplate);
        template.setFqn(fullyQualifiedName);
        template.setHasOwnSymbolScope(true);
        return template;
    }

    private void setHasOwnSymbolScope(boolean hasSymbolScope) {
        this._hasOwnSymbolScope = hasSymbolScope;
    }

    public Program getProgram() {
        return this._program;
    }

    private static RuntimeData getRuntimeData() {
        Stack<RuntimeData> stack = g_runtimeData.get();
        if (stack != null && stack.size() > 0) {
            return (RuntimeData)stack.peek();
        }
        return null;
    }

    private static void pushRuntimeData(RuntimeData pair) {
        Stack stack = g_runtimeData.get();
        if (stack == null) {
            stack = new Stack();
            g_runtimeData.set((Stack<RuntimeData>)stack);
        }
        stack.push((Object)pair);
    }

    private static void popRuntimeData() {
        Stack<RuntimeData> stack = g_runtimeData.get();
        stack.pop();
    }

    private TemplateGenerator(Reader reader) {
        try {
            this._scriptStr = StreamUtil.getContent((Reader)reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void execute(Writer writer, ISymbolTable symbolTable) throws TemplateParseException {
        this.execute(writer, null, symbolTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Writer writer, StringEscaper escaper, ISymbolTable symTable) throws TemplateParseException {
        symTable.pushScope();
        String strCompiledSource = null;
        try {
            symTable.putSymbol((ISymbol)PRINT_CONTENT_SYMBOL.get());
            symTable.putSymbol((ISymbol)PRINT_RANGE_SYMBOL.get());
            if (this._supertype != null) {
                symTable.putSymbol((ISymbol)new Symbol("this", this._supertype, null));
            }
            TemplateGenerator.pushRuntimeData(new RuntimeData(writer, escaper));
            try {
                IType contextType;
                if (this._program == null) {
                    TypeSystem.lock();
                    try {
                        if (this._program == null) {
                            ArrayList<TemplateParseException> exceptions = new ArrayList<TemplateParseException>();
                            strCompiledSource = this.transformTemplate(this._scriptStr, exceptions);
                            if (!exceptions.isEmpty()) {
                                throw (TemplateParseException)((Object)exceptions.get(0));
                            }
                            this._program = this.compile((Stack<IScriptPartId>)new Stack(), strCompiledSource, symTable, new HashMap<String, List<IFunctionSymbol>>(), null, null, null);
                            this._compileTimeSymbolTable = symTable.copy();
                        }
                        if (this._fqn == null) {
                            this._program.getGosuProgram().setThrowaway(true);
                        }
                    }
                    finally {
                        TypeSystem.unlock();
                    }
                }
                if (this._fqn != null && (contextType = this._program.getGosuProgram().getContextType()) == null) {
                    this._program.getGosuProgram().setContextType(TypeSystem.getByFullName((String)this._fqn));
                }
                this._program.evaluate(this.extractExternalSymbols(this._compileTimeSymbolTable, symTable));
            }
            finally {
                TemplateGenerator.popRuntimeData();
            }
        }
        catch (ParseResultsException e) {
            throw new TemplateParseException(e, strCompiledSource);
        }
        finally {
            symTable.popScope();
        }
    }

    public void compile(ISymbolTable symTable) throws TemplateParseException {
        this.compile((Stack<IScriptPartId>)new Stack(), symTable, new HashMap<String, List<IFunctionSymbol>>(), null, null, this._ctxInferenceMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(Stack<IScriptPartId> scriptPartIdStack, ISymbolTable symTable, Map<String, List<IFunctionSymbol>> dfsDeclByName, ITypeUsesMap typeUsesMap, Stack<BlockExpression> blocks, ContextInferenceManager ctxInferenceMgr) throws TemplateParseException {
        block13: {
            symTable.pushScope();
            if (ctxInferenceMgr != null) {
                ctxInferenceMgr.suspendRefCollection();
            }
            String strCompiledSource = null;
            try {
                symTable.putSymbol((ISymbol)PRINT_CONTENT_SYMBOL.get());
                symTable.putSymbol((ISymbol)PRINT_RANGE_SYMBOL.get());
                if (this._program != null) break block13;
                TypeSystem.lock();
                try {
                    if (this._program == null) {
                        ArrayList<TemplateParseException> exceptions = new ArrayList<TemplateParseException>();
                        strCompiledSource = this.transformTemplate(this._scriptStr, exceptions);
                        if (!exceptions.isEmpty()) {
                            throw (TemplateParseException)((Object)exceptions.get(0));
                        }
                        for (ISymbol param : this._params) {
                            Symbol s = new Symbol(param.getName(), param.getType(), null);
                            symTable.putSymbol((ISymbol)s);
                        }
                        this._program = this.compile(scriptPartIdStack, strCompiledSource, symTable, dfsDeclByName, typeUsesMap, blocks, ctxInferenceMgr);
                        this._compileTimeSymbolTable = symTable.copy();
                    }
                }
                finally {
                    TypeSystem.unlock();
                }
            }
            catch (ParseResultsException e) {
                throw new TemplateParseException(e, strCompiledSource);
            }
            finally {
                symTable.popScope();
                if (ctxInferenceMgr != null) {
                    ctxInferenceMgr.resumeRefCollection();
                }
            }
        }
    }

    private Program compile(Stack<IScriptPartId> scriptPartIdStack, String strCompiledSource, ISymbolTable symbolTable, Map<String, List<IFunctionSymbol>> dfsDeclByName, ITypeUsesMap typeUsesMap, Stack<BlockExpression> blocks, ContextInferenceManager ctxInferenceMgr) throws ParseResultsException {
        ISymbol thisSymbol;
        IGosuParser parser = GosuParserFactory.createParser((ISymbolTable)symbolTable, (IScriptabilityModifier)ScriptabilityModifiers.SCRIPTABLE);
        for (IScriptPartId id : scriptPartIdStack) {
            ((GosuParser)parser).pushScriptPart(id);
        }
        parser.setScript((CharSequence)strCompiledSource);
        if (parser instanceof GosuParser) {
            parser.setDfsDeclInSetByName(dfsDeclByName);
            if (ctxInferenceMgr != null) {
                ((GosuParser)parser).setContextInferenceManager(ctxInferenceMgr);
            }
        }
        if (typeUsesMap == null) {
            typeUsesMap = parser.getTypeUsesMap();
        } else {
            parser.setTypeUsesMap(typeUsesMap);
        }
        if (this._fqn != null) {
            typeUsesMap.addToTypeUses(GosuClassUtil.getPackage((String)this._fqn) + ".*");
        }
        if (blocks != null) {
            ((GosuParser)parser).setBlocks(blocks);
        }
        if (this._supertype != null && this._supertype instanceof IGosuClassInternal) {
            IGosuClassInternal supertype = (IGosuClassInternal)this._supertype;
            this.addStaticSymbols(symbolTable, (GosuParser)parser, supertype);
            List typeLoaders = TypeSystem.getCurrentModule().getTypeLoaders(GosuClassTypeLoader.class);
            for (GosuClassTypeLoader typeLoader : typeLoaders) {
                List enhancementsForType = typeLoader.getEnhancementIndex().getEnhancementsForType((IType)supertype);
                for (IGosuEnhancement enhancement : enhancementsForType) {
                    if (!(enhancement instanceof IGosuEnhancementInternal)) continue;
                    this.addStaticSymbols(symbolTable, (GosuParser)parser, (IGosuEnhancementInternal)enhancement);
                }
            }
            for (Map.Entry dfsDecls : parser.getDfsDecls().entrySet()) {
                Iterator it = ((List)dfsDecls.getValue()).iterator();
                while (it.hasNext()) {
                    IFunctionSymbol fs = (IFunctionSymbol)it.next();
                    if (!(fs instanceof Symbol) || !fs.isPrivate()) continue;
                    it.remove();
                }
            }
        }
        Object scriptPart = (thisSymbol = symbolTable.getSymbol((CharSequence)Keyword.KW_this.getName())) != null && thisSymbol.getType() instanceof IGosuClass ? new ScriptPartId(thisSymbol.getType(), GS_TEMPLATE_PARSED) : new TypelessScriptPartId(GS_TEMPLATE_PARSED);
        Program program = (Program)parser.parseProgram((IScriptPartId)scriptPart, null, null, true);
        program.clearParseTreeInformation();
        return program;
    }

    private void addStaticSymbols(ISymbolTable symbolTable, GosuParser parser, IGosuClassInternal supertype) {
        supertype.putClassMembers(parser, symbolTable, supertype, true);
        for (Map.Entry entryObj : symbolTable.getSymbols().entrySet()) {
            Map.Entry entry = entryObj;
            if (!((ISymbol)entry.getValue()).isPrivate()) continue;
            symbolTable.removeSymbol((CharSequence)entry.getKey());
        }
    }

    public void verify(IGosuParser parser, Map<String, List<IFunctionSymbol>> dfsDeclByName, ITypeUsesMap typeUsesMap) throws ParseResultsException {
        this.verify(parser, dfsDeclByName, typeUsesMap, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProgram verify(IGosuParser parser, Map<String, List<IFunctionSymbol>> dfsDeclByName, ITypeUsesMap typeUsesMap, boolean bDoNotThrowParseResultsException) throws ParseResultsException {
        assert (this._scriptStr != null) : "Cannot verify a template after it has been compiled";
        ISymbolTable symTable = parser.getSymbolTable();
        symTable.pushScope();
        try {
            parser.setScript((CharSequence)this._scriptStr);
            if (parser instanceof GosuParser) {
                parser.setTokenizerInstructor((ITokenizerInstructor)new TemplateTokenizerInstructor(((GosuParser)parser).getTokenizer()));
                parser.setDfsDeclInSetByName(dfsDeclByName);
            }
            if (typeUsesMap == null) {
                typeUsesMap = parser.getTypeUsesMap();
            } else {
                parser.setTypeUsesMap(typeUsesMap);
            }
            if (this._fqn != null) {
                typeUsesMap.addToTypeUses(GosuClassUtil.getPackage((String)this._fqn) + ".*");
            }
            parser.setTypeUsesMap(typeUsesMap);
            TypelessScriptPartId scriptPart = parser.getScriptPart() == null ? new TypelessScriptPartId(GS_TEMPLATE) : new ScriptPartId(parser.getScriptPart().getContainingType(), GS_TEMPLATE);
            IProgram iProgram = parser.parseProgram((IScriptPartId)scriptPart, true, false, null, null, false, bDoNotThrowParseResultsException);
            return iProgram;
        }
        finally {
            symTable.popScope();
            for (IParseTree parseTree : parser.getLocations()) {
                parseTree.setLength(Math.min(parseTree.getLength(), this._scriptStr.length() - parseTree.getOffset()));
            }
        }
    }

    public void verify(IGosuParser parser) throws ParseResultsException {
        this.verify(parser, false);
    }

    private IProgram verify(IGosuParser parser, boolean bDoNotThrowParseResultException) throws ParseResultsException {
        HashMap<String, List<IFunctionSymbol>> dfsMap = new HashMap<String, List<IFunctionSymbol>>();
        dfsMap.put("printContent", Collections.singletonList(new DynamicFunctionSymbol(parser.getSymbolTable(), (CharSequence)"printContent", (IFunctionType)new FunctionType("printContent", GosuParserTypes.NULL_TYPE(), new IType[]{GosuParserTypes.STRING_TYPE(), JavaTypes.pBOOLEAN()}), Arrays.asList(new Symbol("content", GosuParserTypes.STRING_TYPE(), null), new Symbol("escape", (IType)JavaTypes.pBOOLEAN(), null)), (IExpression)null)));
        dfsMap.put("printRange", Collections.singletonList(new DynamicFunctionSymbol(parser.getSymbolTable(), (CharSequence)"printRange", (IFunctionType)new FunctionType("printRange", GosuParserTypes.NULL_TYPE(), new IType[]{GosuParserTypes.STRING_TYPE(), JavaTypes.pINT(), JavaTypes.pINT()}), Arrays.asList(new Symbol("start", (IType)JavaTypes.pINT(), null), new Symbol("end", (IType)JavaTypes.pINT(), null)), (IExpression)null)));
        return this.verify(parser, dfsMap, null, bDoNotThrowParseResultException);
    }

    public List<TemplateParseException> getTemplateSyntaxProblems() {
        ArrayList<TemplateParseException> exceptions = new ArrayList<TemplateParseException>();
        this.transformTemplate(this._scriptStr, exceptions);
        return exceptions;
    }

    private String transformTemplate(String strSource, List<TemplateParseException> exceptions) {
        this._params.clear();
        StringBuilder sbTarget = new StringBuilder(strSource.length());
        int iIndex = 0;
        while (true) {
            int iIndex2 = strSource.indexOf(SCRIPTLET_BEGIN, iIndex);
            int altIndex2 = strSource.indexOf(ALTERNATE_EXPRESSION_BEGIN, iIndex);
            if (iIndex2 < 0 && altIndex2 < 0) break;
            if (iIndex2 >= 0 && (altIndex2 < 0 || iIndex2 < altIndex2)) {
                if (iIndex2 > 0 && strSource.charAt(iIndex2 - 1) == '\\') {
                    this.addRefText(sbTarget, iIndex, iIndex2 - 1);
                    this.addText(sbTarget, SCRIPTLET_BEGIN.substring(0, 1));
                    iIndex = iIndex2 + 1;
                    continue;
                }
                boolean bPrecedingContentEndsWithNewLine = iIndex2 - iIndex <= 0 || strSource.charAt(iIndex2 - 1) == '\n';
                this.addRefText(sbTarget, iIndex, iIndex2);
                iIndex = iIndex2 + SCRIPTLET_BEGIN_LEN;
                boolean bExpression = false;
                if (iIndex < strSource.length()) {
                    if (strSource.indexOf("--", iIndex) == iIndex) {
                        int iEndComment = strSource.indexOf(COMMENT_END, iIndex + 2);
                        if (iEndComment > 0) {
                            iIndex = iEndComment + COMMENT_END_LEN;
                            continue;
                        }
                        return sbTarget.toString();
                    }
                    bExpression = strSource.charAt(iIndex) == '=';
                    boolean bDeclaration = strSource.charAt(iIndex) == '!';
                    boolean bDirective = strSource.charAt(iIndex) == '@';
                    iIndex2 = strSource.indexOf(SCRIPTLET_END, iIndex += bExpression || bDeclaration || bDirective ? 1 : 0);
                    if (iIndex2 < 0) {
                        int iLineNumber = GosuStringUtil.getLineNumberForIndex((String)strSource, (int)(iIndex - 1));
                        int iColumn = this.getColumnForIndex(strSource, iIndex);
                        exceptions.add(new TemplateParseException(bExpression ? Res.MSG_TEMPLATE_MISSING_END_TAG_EXPRESSION : Res.MSG_TEMPLATE_MISSING_END_TAG_SCRIPTLET, iLineNumber, iColumn, iIndex, new String[0]));
                        return sbTarget.toString();
                    }
                    String strScript = strSource.substring(iIndex, iIndex2);
                    int iLineNumber = GosuStringUtil.getLineNumberForIndex((String)strSource, (int)(iIndex - 1));
                    if (bExpression) {
                        this.addExpression(sbTarget, strScript, iLineNumber);
                    } else if (bDirective) {
                        try {
                            int iColumn = this.getColumnForIndex(strSource, iIndex);
                            this.processDirective(strScript, iLineNumber, iColumn, iIndex);
                        }
                        catch (TemplateParseException e) {
                            exceptions.add(e);
                        }
                    } else {
                        this.addScriptlet(sbTarget, strScript, iLineNumber);
                    }
                }
                iIndex = iIndex2 + SCRIPTLET_END_LEN;
                if (bExpression || !bPrecedingContentEndsWithNewLine) continue;
                iIndex = this.ignoreTrailingLineSeparator(strSource, iIndex);
                continue;
            }
            if (this._disableAlternative && altIndex2 > 0 && strSource.charAt(altIndex2 - 1) != '\\') {
                this.addRefText(sbTarget, iIndex, altIndex2 - 1);
                this.addText(sbTarget, "\\" + ALTERNATE_EXPRESSION_BEGIN.substring(0, 1));
                iIndex = altIndex2 + 1;
                continue;
            }
            if (altIndex2 > 0 && strSource.charAt(altIndex2 - 1) == '\\') {
                this.addRefText(sbTarget, iIndex, altIndex2 - 1);
                this.addText(sbTarget, ALTERNATE_EXPRESSION_BEGIN.substring(0, 1));
                iIndex = altIndex2 + 1;
                continue;
            }
            this.addRefText(sbTarget, iIndex, altIndex2);
            iIndex = altIndex2 + ALTERNATE_EXPRESSION_BEGIN_LEN;
            altIndex2 = strSource.indexOf(ALTERNATE_EXPRESSION_END, iIndex);
            int nextOpen = strSource.indexOf("{", iIndex);
            if (nextOpen != -1 && nextOpen < altIndex2) {
                int numOpen = 2;
                while (numOpen > 1 && altIndex2 != -1) {
                    if ((nextOpen = strSource.indexOf("{", Math.min(nextOpen, altIndex2) + 1)) != -1 && nextOpen < altIndex2) {
                        ++numOpen;
                        continue;
                    }
                    --numOpen;
                    altIndex2 = strSource.indexOf(ALTERNATE_EXPRESSION_END, altIndex2 + ALTERNATE_EXPRESSION_END_LEN);
                }
            }
            if (altIndex2 < 0) {
                int iLineNumber = GosuStringUtil.getLineNumberForIndex((String)strSource, (int)(iIndex - 1));
                int iColumn = this.getColumnForIndex(strSource, iIndex);
                exceptions.add(new TemplateParseException(Res.MSG_TEMPLATE_MISSING_END_TAG_EXPRESSION_ALT, iLineNumber, iColumn, iIndex, new String[0]));
                return sbTarget.toString();
            }
            String strScript = strSource.substring(iIndex, altIndex2);
            this.addExpression(sbTarget, strScript, GosuStringUtil.getLineNumberForIndex((String)strSource, (int)iIndex));
            iIndex = altIndex2 + ALTERNATE_EXPRESSION_END_LEN;
        }
        this.addRefText(sbTarget, iIndex, strSource.length());
        return sbTarget.toString();
    }

    private int ignoreTrailingLineSeparator(String strSource, int iIndex) {
        if (iIndex < strSource.length()) {
            if (strSource.charAt(iIndex) == '\n') {
                ++iIndex;
            } else if (strSource.startsWith(System.lineSeparator(), iIndex)) {
                iIndex += System.lineSeparator().length();
            }
        }
        return iIndex;
    }

    private void processDirective(String strScript, int lineNumber, int column, int offset) throws TemplateParseException {
        if ((strScript = strScript.trim()).startsWith("params")) {
            if (!this._params.isEmpty()) {
                throw new TemplateParseException(Res.MSG_TEMPLATE_MULTIPLE_PARAMS, lineNumber, column, offset, new String[0]);
            }
            int iOpeningParen = strScript.indexOf("(");
            int iClosingParen = strScript.lastIndexOf(")");
            String strSignature = "";
            if (iOpeningParen > 0 && iClosingParen > 0) {
                strSignature = strScript.substring(iOpeningParen + 1, iClosingParen).trim();
            }
            if (strSignature.length() > 0) {
                ITypeUsesMap typeUsesMap22;
                GosuParser usesParser = (GosuParser)GosuParserFactory.createParser((String)this._scriptStr);
                usesParser.setTokenizerInstructor(new TemplateTokenizerInstructor(usesParser.getTokenizer()));
                if (this._fqn != null && (typeUsesMap22 = usesParser.getTypeUsesMap()) != null) {
                    typeUsesMap22.addToTypeUses(GosuClassUtil.getPackage((String)this._fqn) + ".*");
                }
                try {
                    usesParser.parseProgram((IScriptPartId)new TypelessScriptPartId(GS_TEMPLATE));
                }
                catch (ParseResultsException typeUsesMap22) {
                    // empty catch block
                }
                GosuParser parser = (GosuParser)GosuParserFactory.createParser((String)strSignature);
                parser.setEditorParser(this._useStudioEditorParser);
                parser.setTypeUsesMap(usesParser.getTypeUsesMap());
                parser.getTokenizer().nextToken();
                Identifier pe = new Identifier();
                this._params.addAll(parser.parseParameterDeclarationList(pe, false, null));
                if (pe.hasParseExceptions()) {
                    throw new TemplateParseException(Res.MSG_TEMPLATE_INVALID_PARAMS, lineNumber, column, offset, new String[]{strScript + ": " + pe.getParseExceptions().get(0).getConsoleMessage()});
                }
            }
        } else if (strScript.startsWith("extends")) {
            String typeName = strScript.substring(strScript.indexOf("extends") + "extends".length()).trim();
            this._supertype = TypeLoaderAccess.instance().getByFullNameIfValid(typeName);
            if (this._supertype == null) {
                throw new TemplateParseException(Res.MSG_INVALID_TYPE, lineNumber, column, offset, new String[]{typeName});
            }
        } else {
            throw new TemplateParseException(Res.MSG_TEMPLATE_UNKNOWN_DIRECTIVE, lineNumber, column, offset, new String[]{strScript});
        }
    }

    private void addText(StringBuilder strTarget, String strText) {
        if (!GosuStringUtil.isEmpty((String)strText)) {
            strText = this.escapeForGosuStringLiteral(strText);
            strTarget.append("printContent").append("(\"").append(strText).append("\", false)\r\n");
        }
    }

    private void addRefText(StringBuilder sbTarget, int iStart, int iEnd) {
        if (this.isForStringLiteral()) {
            this.addText(sbTarget, this._scriptStr.substring(iStart, iEnd));
        } else if (iEnd - iStart > 0) {
            sbTarget.append("printRange").append("(").append(iStart).append(",").append(iEnd).append(")\r\n");
        }
    }

    private void addExpression(StringBuilder strTarget, String strExpression, int iLineNumber) {
        if (strExpression.trim().length() != 0) {
            strTarget.append("printContent").append("((").append(strExpression).append(") as String, true)").append(" //#LN# ").append(iLineNumber).append("\r\n");
        }
    }

    private void addScriptlet(StringBuilder strTarget, String strScript, int iLineNumber) {
        int i = 0;
        while (i < strScript.length()) {
            int iIndex = strScript.indexOf("\r\n", i);
            int iLen = 2;
            if (iIndex < 0) {
                iIndex = strScript.indexOf("\n", i);
                iLen = 1;
            }
            if (iIndex >= 0) {
                strTarget.append(strScript.substring(i, iIndex)).append(" //#LN# ").append(iLineNumber).append("\r\n");
                i = iIndex + iLen;
                ++iLineNumber;
                continue;
            }
            strTarget.append(strScript.substring(i)).append(" //#LN# ").append(iLineNumber).append("\r\n");
            break;
        }
    }

    private String escapeForGosuStringLiteral(String strText) {
        if (strText == null) {
            return null;
        }
        strText = GosuEscapeUtil.escapeForGosuStringLiteral((String)strText);
        return strText;
    }

    private int getColumnForIndex(String strSource, int iIndex) {
        int lastLineBreak = 0;
        for (int i = 0; i <= iIndex && i < strSource.length(); ++i) {
            char c = strSource.charAt(i);
            if (c != '\n') continue;
            lastLineBreak = i;
        }
        return iIndex - lastLineBreak;
    }

    public static void printContent(String strContent, boolean escape) {
        try {
            RuntimeData pair = TemplateGenerator.getRuntimeData();
            Writer writer = pair._writer;
            if (escape && pair._esc != null) {
                strContent = pair._esc.escape(strContent);
            } else if (pair._esc instanceof IEscapesAllContent) {
                strContent = ((IEscapesAllContent)pair._esc).escapeBody(strContent);
            }
            writer.write(strContent == null ? "null" : strContent);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void printRange(int iStart, int iEnd) {
        try {
            RuntimeData runtimeData = TemplateGenerator.getRuntimeData();
            String strContent = runtimeData._templateSource.substring(iStart, iEnd);
            Writer writer = runtimeData._writer;
            writer.write(strContent);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setDisableAlternative(boolean disableAlternative) {
        this._disableAlternative = disableAlternative;
    }

    public void setContextInferenceManager(ContextInferenceManager ctxInferenceMgr) {
        this._ctxInferenceMgr = ctxInferenceMgr.copy();
    }

    public void setForStringLiteral(boolean bForStringLiteralTemplate) {
        this._bStringLiteralTemplate = bForStringLiteralTemplate;
    }

    public boolean isForStringLiteral() {
        return this._bStringLiteralTemplate;
    }

    public boolean isValid() {
        this.compileIfNotCompiled();
        return this._program != null && !this._program.hasParseExceptions();
    }

    private void setFqn(String fullyQualifiedName) {
        this._fqn = fullyQualifiedName;
    }

    public String getFullyQualifiedTypeName() {
        return this._fqn;
    }

    public List<ISymbol> getParameters() {
        this.compileIfNotCompiled();
        return this._params;
    }

    private void compileIfNotCompiled() {
        if (this._program == null) {
            if (this._hasOwnSymbolScope) {
                CompiledGosuClassSymbolTable.instance().pushCompileTimeSymbolTable();
            }
            try {
                this.compile((ISymbolTable)CompiledGosuClassSymbolTable.instance());
            }
            catch (TemplateParseException templateParseException) {
            }
            finally {
                if (this._hasOwnSymbolScope) {
                    CompiledGosuClassSymbolTable.instance().popCompileTimeSymbolTable();
                }
            }
        }
    }

    public IType getSuperType() {
        return this._supertype;
    }

    public void setUseStudioEditorParser(boolean useStudioEditorParser) {
        this._useStudioEditorParser = useStudioEditorParser;
    }

    public String toString() {
        if (this._scriptStr != null) {
            return this._scriptStr;
        }
        return this._program.toString();
    }

    public String getSource() {
        return this._scriptStr;
    }

    private IExternalSymbolMap extractExternalSymbols(ISymbolTable compileTimeSymbolTable, ISymbolTable runtimeSymbolTable) {
        HashMap<String, ISymbol> externalSymbolsMap = new HashMap<String, ISymbol>(8);
        this.putSymbols(compileTimeSymbolTable, externalSymbolsMap);
        this.putSymbols(runtimeSymbolTable, externalSymbolsMap);
        return new ExternalSymbolMapForMap(externalSymbolsMap);
    }

    private void putSymbols(ISymbolTable symTable, HashMap<String, ISymbol> externalSymbolsMap) {
        Map symbols = symTable.getSymbols();
        if (symbols != null) {
            for (ISymbol sym : symbols.values()) {
                if (sym instanceof CommonSymbolsScope.LockedDownSymbol || sym == null) continue;
                externalSymbolsMap.put(sym.getName(), sym);
            }
        }
    }

    static {
        TypeSystem.addShutdownListener((TypeSystemShutdownListener)new TypeSystemShutdownListener(){

            public void shutdown() {
                PRINT_CONTENT_SYMBOL.clear();
                PRINT_RANGE_SYMBOL.clear();
            }
        });
        g_runtimeData = new ThreadLocal();
    }

    public static class LockedDownSymbol
    extends Symbol
    implements ILockedDownSymbol {
        public LockedDownSymbol(CharSequence strName, IType type, Method value) {
            super(strName.toString(), type, value);
        }

        @Override
        public Object getValue() {
            return this.getValueDirectly();
        }
    }

    private class RuntimeData {
        Writer _writer;
        StringEscaper _esc;
        String _templateSource;

        public RuntimeData(Writer writer, StringEscaper esc) {
            this._writer = writer;
            this._esc = esc;
            this._templateSource = TemplateGenerator.this.getSource();
        }
    }
}

