/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.statement;

import gw.config.CommonServices;
import gw.internal.gosu.ir.nodes.IRMethod;
import gw.internal.gosu.ir.nodes.IRMethodFactory;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.statement.AbstractStatementTransformer;
import gw.internal.gosu.ir.transform.statement.BeanMethodCallStatementTransformer;
import gw.internal.gosu.ir.transform.statement.MemberAssignmentStatementTransformer;
import gw.internal.gosu.ir.transform.statement.ReturnStatementTransformer;
import gw.internal.gosu.ir.transform.statement.StatementListTransformer;
import gw.internal.gosu.ir.transform.util.IRTypeResolver;
import gw.internal.gosu.parser.DelegateFunctionSymbol;
import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.ProgramExecuteFunctionSymbol;
import gw.internal.gosu.parser.Statement;
import gw.internal.gosu.parser.Symbol;
import gw.internal.gosu.parser.TemplateRenderFunctionSymbol;
import gw.internal.gosu.parser.VarPropertyGetFunctionSymbol;
import gw.internal.gosu.parser.VarPropertySetFunctionSymbol;
import gw.internal.gosu.parser.expressions.ArrayAccess;
import gw.internal.gosu.parser.expressions.BeanMethodCallExpression;
import gw.internal.gosu.parser.expressions.Identifier;
import gw.internal.gosu.parser.expressions.ImplicitTypeAsExpression;
import gw.internal.gosu.parser.expressions.MemberAccess;
import gw.internal.gosu.parser.expressions.NewExpression;
import gw.internal.gosu.parser.expressions.NullExpression;
import gw.internal.gosu.parser.expressions.NumericLiteral;
import gw.internal.gosu.parser.expressions.TypeLiteral;
import gw.internal.gosu.parser.statements.ArrayAssignmentStatement;
import gw.internal.gosu.parser.statements.BeanMethodCallStatement;
import gw.internal.gosu.parser.statements.MemberAssignmentStatement;
import gw.internal.gosu.parser.statements.ReturnStatement;
import gw.internal.gosu.parser.statements.StatementList;
import gw.internal.gosu.parser.statements.SyntheticFunctionStatement;
import gw.internal.gosu.parser.statements.VarStatement;
import gw.lang.Gosu;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.statement.IRReturnStatement;
import gw.lang.ir.statement.IRStatementList;
import gw.lang.parser.IStackProvider;
import gw.lang.parser.ISymbol;
import gw.lang.parser.StandardSymbolTable;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.java.JavaTypes;
import java.util.ArrayList;
import java.util.Collections;

public class SyntheticFunctionStatementTransformer
extends AbstractStatementTransformer<SyntheticFunctionStatement> {
    private DynamicFunctionSymbol _dfs;

    public static IRStatement compile(DynamicFunctionSymbol dfs, TopLevelTransformationContext cc, SyntheticFunctionStatement stmt) {
        SyntheticFunctionStatementTransformer gen = new SyntheticFunctionStatementTransformer(dfs, cc, stmt);
        return gen.compile();
    }

    private SyntheticFunctionStatementTransformer(DynamicFunctionSymbol dfs, TopLevelTransformationContext cc, SyntheticFunctionStatement stmt) {
        super(cc, stmt);
        this._dfs = dfs;
    }

    @Override
    protected IRStatement compile_impl() {
        if (this._dfs instanceof VarPropertyGetFunctionSymbol) {
            return this.compileReturnStatementForGetter();
        }
        if (this._dfs instanceof VarPropertySetFunctionSymbol) {
            return this.compileAssignmentStatementForSetter();
        }
        if (this._dfs instanceof DelegateFunctionSymbol) {
            return this.compileDelegatedMethod();
        }
        if (this._dfs instanceof TemplateRenderFunctionSymbol) {
            return this.compileForwardingMethod();
        }
        if (this._dfs instanceof ProgramExecuteFunctionSymbol) {
            return this.compileProgramExecute();
        }
        throw new UnsupportedOperationException("Found a SyntheticFunctionStatement with an unexpected dynamic function symbol type " + this._dfs.getClass());
    }

    private IRStatement compileForwardingMethod() {
        TemplateRenderFunctionSymbol forwardingDfs = (TemplateRenderFunctionSymbol)this._dfs;
        BeanMethodCallExpression methodCall = new BeanMethodCallExpression();
        methodCall.setMethodDescriptor(forwardingDfs.getMi());
        methodCall.setType(forwardingDfs.getReturnType());
        ArrayList<Statement> stmts = new ArrayList<Statement>();
        IParameterInfo[] targetMethodParams = forwardingDfs.getMi().getParameters();
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(new TypeLiteral((IType)forwardingDfs.getTemplateType()));
        for (int i = 0; i < forwardingDfs.getArgs().size(); ++i) {
            if (i + 2 == targetMethodParams.length && targetMethodParams[i + 1].getFeatureType().isArray()) {
                Symbol forwarding_var_args_ = new Symbol("_forwarding_var_args_", JavaTypes.OBJECT().getArrayType(), null);
                forwarding_var_args_.setIndex(1);
                VarStatement arrayVarStmt = new VarStatement();
                arrayVarStmt.setSymbol((ISymbol)forwarding_var_args_);
                NewExpression arrayInit = new NewExpression();
                arrayInit.setType(forwarding_var_args_.getType());
                int iSize = forwardingDfs.getArgs().size() - i;
                arrayInit.addSizeExpression(new NumericLiteral(String.valueOf(iSize), iSize, (IType)JavaTypes.pINT()));
                arrayVarStmt.setAsExpression(arrayInit);
                stmts.add(arrayVarStmt);
                Identifier array = new Identifier();
                array.setSymbol((ISymbol)forwarding_var_args_, null);
                array.setType(JavaTypes.OBJECT().getArrayType());
                for (int j = i; j < forwardingDfs.getArgs().size(); ++j) {
                    Expression argId = new Identifier();
                    ISymbol argSym = forwardingDfs.getArgs().get(j);
                    argId.setSymbol(argSym, null);
                    argId.setType(argId.getSymbol().getType());
                    if (argSym.getType().isPrimitive()) {
                        argId = this.box(argId);
                    }
                    ArrayAccess access = new ArrayAccess();
                    access.setRootExpression(array);
                    access.setMemberExpression(new NumericLiteral(String.valueOf(j - i), j - i, (IType)JavaTypes.pINT()));
                    access.setType((IType)JavaTypes.OBJECT());
                    ArrayAssignmentStatement assignmentStmt = new ArrayAssignmentStatement();
                    assignmentStmt.setArrayAccessExpression(access);
                    assignmentStmt.setExpression(argId);
                    stmts.add(assignmentStmt);
                }
                args.add(array);
                break;
            }
            Identifier argId = new Identifier();
            argId.setSymbol(forwardingDfs.getArgs().get(i), null);
            argId.setType(argId.getSymbol().getType());
            args.add(argId);
        }
        if (args.size() < targetMethodParams.length) {
            args.add(new NullExpression());
        }
        methodCall.setArgs(args.toArray(new Expression[args.size()]));
        if (this._dfs.getReturnType() != JavaTypes.pVOID()) {
            ReturnStatement returnStatement = new ReturnStatement();
            returnStatement.setValue(methodCall);
            stmts.add(returnStatement);
        } else {
            BeanMethodCallStatement methodCallStatement = new BeanMethodCallStatement();
            methodCallStatement.setBeanMethodCall(methodCall);
            stmts.add(methodCallStatement);
        }
        StatementList stmtList = new StatementList((IStackProvider)new StandardSymbolTable());
        stmtList.setStatements(stmts);
        return StatementListTransformer.compile(this._cc(), stmtList);
    }

    private Expression box(Expression expr) {
        ImplicitTypeAsExpression cast = new ImplicitTypeAsExpression();
        cast.setLHS(expr);
        cast.setCoercer(CommonServices.getCoercionManager().resolveCoercerStatically((IType)JavaTypes.OBJECT(), expr.getType()));
        cast.setType(TypeSystem.getBoxType((IType)expr.getType()));
        return cast;
    }

    private IRStatement compileAssignmentStatementForSetter() {
        VarPropertySetFunctionSymbol setter = (VarPropertySetFunctionSymbol)this._dfs;
        if (this.getGosuClass().isInterface()) {
            return this.buildThrow(this.buildNewExpression(UnsupportedOperationException.class, new Class[]{String.class}, Collections.singletonList(this.pushConstant("Unimplemented set support for " + this._dfs.getDisplayName()))));
        }
        ISymbol valueSymbol = setter.getArgs().get(0);
        return this.buildFieldSet(SyntheticFunctionStatementTransformer.getDescriptor((IType)this.getGosuClass()), setter.getVarIdentifier(), SyntheticFunctionStatementTransformer.getDescriptor(valueSymbol.getType()), setter.isStatic() ? null : this.pushThis(), (IRExpression)this.identifier(this._cc().getSymbol(valueSymbol.getName())));
    }

    private IRStatement compileReturnStatementForGetter() {
        IRExpression returnValue;
        VarPropertyGetFunctionSymbol getter = (VarPropertyGetFunctionSymbol)this._dfs;
        if (this.getGosuClass().isInterface()) {
            VarStatement varStmt = this.getGosuClass().getParseInfo().getMemberFields().get(getter.getVarIdentifier());
            returnValue = ExpressionTransformer.compile(varStmt.getAsExpression(), this._cc());
        } else {
            returnValue = this.buildFieldGet(SyntheticFunctionStatementTransformer.getDescriptor((IType)this.getGosuClass()), getter.getVarIdentifier(), SyntheticFunctionStatementTransformer.getDescriptor(getter.getReturnType()), getter.isStatic() ? null : this.pushThis());
        }
        return new IRReturnStatement(null, returnValue);
    }

    private IRStatement compileDelegatedMethod() {
        DelegateFunctionSymbol delegateSymbol = (DelegateFunctionSymbol)this._dfs;
        Identifier id = new Identifier();
        ISymbol varSymbol = this.getGosuClass().getMemberField(delegateSymbol.getDelegateStmt().getIdentifierName()).getSymbol();
        id.setSymbol(varSymbol, null);
        id.setType(varSymbol.getType());
        if (delegateSymbol.getName().startsWith("@")) {
            String propertyName = delegateSymbol.getDisplayName().substring(1);
            if (delegateSymbol.getArgs().isEmpty()) {
                MemberAccess memberAccess = new MemberAccess();
                memberAccess.setRootExpression(id);
                memberAccess.setMemberName(propertyName);
                memberAccess.setType(delegateSymbol.getReturnType());
                ReturnStatement returnStatement = new ReturnStatement();
                returnStatement.setValue(memberAccess);
                return ReturnStatementTransformer.compile(this._cc(), returnStatement);
            }
            Identifier argId = new Identifier();
            argId.setSymbol(delegateSymbol.getArgs().get(0), null);
            argId.setType(argId.getSymbol().getType());
            MemberAssignmentStatement memberAssignment = new MemberAssignmentStatement();
            memberAssignment.setRootExpression(id);
            memberAssignment.setMemberName(propertyName);
            memberAssignment.setExpression(argId);
            return MemberAssignmentStatementTransformer.compile(this._cc(), memberAssignment);
        }
        BeanMethodCallExpression methodCall = new BeanMethodCallExpression();
        methodCall.setRootExpression(id);
        methodCall.setMethodDescriptor(delegateSymbol.getMi());
        methodCall.setType(delegateSymbol.getReturnType());
        methodCall.setFunctionType(this.getDelegateFunctionType(delegateSymbol));
        Expression[] args = new Expression[delegateSymbol.getArgs().size()];
        for (int i = 0; i < delegateSymbol.getArgs().size(); ++i) {
            Identifier argId = new Identifier();
            argId.setSymbol(delegateSymbol.getArgs().get(i), null);
            argId.setType(argId.getSymbol().getType());
            args[i] = argId;
        }
        methodCall.setArgs(args);
        if (this._dfs.getReturnType() != JavaTypes.pVOID()) {
            ReturnStatement returnStatement = new ReturnStatement();
            returnStatement.setValue(methodCall);
            return ReturnStatementTransformer.compile(this._cc(), returnStatement);
        }
        BeanMethodCallStatement methodCallStatement = new BeanMethodCallStatement();
        methodCallStatement.setBeanMethodCall(methodCall);
        return BeanMethodCallStatementTransformer.compile(this._cc(), methodCallStatement);
    }

    private IFunctionType getDelegateFunctionType(DelegateFunctionSymbol delegateSymbol) {
        FunctionType functionType = new FunctionType(delegateSymbol.getMi());
        if (!functionType.isGenericType()) {
            return functionType;
        }
        IGenericTypeVariable[] typeVariables = functionType.getGenericTypeVariables();
        IType[] typeParams = new IType[typeVariables.length];
        for (int i = 0; i < typeVariables.length; ++i) {
            IGenericTypeVariable gtv = typeVariables[i];
            typeParams[i] = gtv.getTypeVariableDefinition().getType();
        }
        return (IFunctionType)functionType.getParameterizedType(typeParams);
    }

    private IRStatement compileProgramExecute() {
        ArrayList<IType> paramTypes = new ArrayList<IType>();
        IMethodInfo evaluateMethod = null;
        for (IMethodInfo mi : this.getGosuClass().getTypeInfo().getMethods()) {
            if (!mi.getName().startsWith("evaluate(")) continue;
            evaluateMethod = mi;
            for (IParameterInfo param : mi.getParameters()) {
                IType paramType = param.getFeatureType();
                paramTypes.add(paramType);
            }
        }
        boolean bArgs = this._dfs.getArgTypes().length > 0;
        IRExpression newProgram = this.buildNewExpression(IRTypeResolver.getDescriptor((IType)this.getGosuClass()), Collections.emptyList(), Collections.emptyList());
        IRMethod evaluateIRMethod = IRMethodFactory.createIRMethod((IType)this.getGosuClass(), "evaluate", evaluateMethod.getReturnType(), paramTypes.toArray(new IType[paramTypes.size()]), IRelativeTypeInfo.Accessibility.PUBLIC, false);
        IRExpression callEvaluate = this.callMethod(evaluateIRMethod, newProgram, Collections.singletonList(this.nullLiteral()));
        IRExpression setRawArgs = this.callStaticMethod(Gosu.class, "setRawArgs", new Class[]{String[].class}, SyntheticFunctionStatementTransformer.exprList(new IRExpression[]{bArgs ? this.identifier(this._cc().getSymbol(this._dfs.getArgs().get(0).getName())) : this.pushNull()}));
        return new IRStatementList(true, new IRStatement[]{this.buildMethodCall(setRawArgs), new IRReturnStatement(null, callEvaluate)});
    }
}

