/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.module.fs;

import gw.config.CommonServices;
import gw.fs.IDirectory;
import gw.fs.IResource;
import gw.fs.ResourcePath;
import gw.internal.gosu.module.fs.JavaDirectoryImpl;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;

public abstract class JavaResourceImpl
implements IResource,
Serializable {
    protected File _file;

    protected JavaResourceImpl(File file) {
        this._file = file.getAbsoluteFile();
    }

    public IDirectory getParent() {
        File parentFile = this._file.getParentFile();
        if (parentFile == null) {
            return null;
        }
        return CommonServices.getFileSystem().getIDirectory(parentFile);
    }

    public String getName() {
        return this._file.getName();
    }

    public boolean delete() throws IOException {
        return this._file.delete();
    }

    public URI toURI() {
        return this._file.toURI();
    }

    public ResourcePath getPath() {
        return ResourcePath.parse((String)this._file.getAbsolutePath());
    }

    public boolean isChildOf(IDirectory dir) {
        return dir.equals(this.getParent());
    }

    public boolean isDescendantOf(IDirectory dir) {
        if (!(dir instanceof JavaDirectoryImpl)) {
            return false;
        }
        File javadir = ((JavaDirectoryImpl)dir)._file;
        for (File javafile = this._file.getParentFile(); javafile != null; javafile = javafile.getParentFile()) {
            if (!javafile.equals(javadir)) continue;
            return true;
        }
        return false;
    }

    public File toJavaFile() {
        return this._file;
    }

    public boolean isJavaFile() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaResourceImpl) {
            return this._file.equals(((JavaResourceImpl)obj)._file);
        }
        return false;
    }

    public int hashCode() {
        return this._file.hashCode();
    }

    public String toString() {
        return this._file.toString();
    }

    public boolean create() {
        return false;
    }

    public boolean isInJar() {
        return false;
    }
}

