/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.AbstractGenericMethodInfo;
import gw.internal.gosu.parser.JavaBaseFeatureInfo;
import gw.internal.gosu.parser.JavaTypeInfo;
import gw.internal.gosu.parser.MethodCallAdapter;
import gw.internal.gosu.parser.MethodJavaClassMethod;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.TypeVariableType;
import gw.internal.gosu.parser.java.classinfo.JavaSourceDefaultValue;
import gw.internal.gosu.parser.java.classinfo.JavaSourceElement;
import gw.lang.Deprecated;
import gw.lang.GosuShop;
import gw.lang.PublishedName;
import gw.lang.javadoc.IClassDocNode;
import gw.lang.javadoc.IDocRef;
import gw.lang.javadoc.IExceptionNode;
import gw.lang.javadoc.IMethodNode;
import gw.lang.javadoc.IParamNode;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IErrorType;
import gw.lang.reflect.IExceptionInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.ILocationInfo;
import gw.lang.reflect.IMethodCallHandler;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.SimpleParameterInfo;
import gw.lang.reflect.TypeInfoUtil;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.java.ClassInfoUtil;
import gw.lang.reflect.java.IJavaAnnotatedElement;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.IJavaClassType;
import gw.lang.reflect.java.IJavaMethodDescriptor;
import gw.lang.reflect.java.IJavaMethodInfo;
import gw.lang.reflect.java.JavaExceptionInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class JavaMethodInfo
extends JavaBaseFeatureInfo
implements IJavaMethodInfo {
    private static final int UNINITED = 0;
    private static final int TRUE_ENC = 1;
    private static final int FALSE_ENC = 2;
    private IJavaMethodDescriptor _md;
    private boolean _forceHidden;
    private IParameterInfo[] _params;
    private IType _retType;
    private IMethodCallHandler _callHandler;
    private IGenericTypeVariable[] _typeVars;
    private int _staticCache = 0;
    private List<IExceptionInfo> _exceptions;
    private IDocRef<IMethodNode> _methodDocs = new IDocRef<IMethodNode>(){

        public IMethodNode get() {
            if (JavaMethodInfo.this.getContainer() instanceof JavaTypeInfo) {
                IClassDocNode classDocs = (IClassDocNode)((JavaTypeInfo)JavaMethodInfo.this.getContainer()).getDocNode().get();
                return classDocs == null ? null : classDocs.getMethod(JavaMethodInfo.this._md);
            }
            return null;
        }
    };
    private String _name;
    private String _signature;

    public JavaMethodInfo(IFeatureInfo container, IJavaMethodDescriptor md, boolean forceHidden) {
        super(container);
        this._md = md;
        this._forceHidden = forceHidden;
        this._name = this._md.getName();
        if (this._md.getMethod().isAnnotationPresent(PublishedName.class)) {
            this._name = (String)this._md.getMethod().getAnnotation(PublishedName.class).getFieldValue("value");
        }
        this._signature = this.makeSignature();
    }

    public IParameterInfo[] getParameters() {
        if (this._params == null) {
            this._params = this.convertParameterDescriptors();
        }
        return this._params;
    }

    public IType getReturnType() {
        if (this._retType != null) {
            return this._retType;
        }
        IType retType = ClassInfoUtil.getActualReturnType((IJavaClassType)this._md.getMethod().getGenericReturnType(), (TypeVarToTypeMap)this.initTypeVarMap(), (boolean)true);
        if (TypeSystem.isDeleted((IType)retType)) {
            return null;
        }
        retType = ClassInfoUtil.getPublishedType((IType)retType, (IJavaClassInfo)this._md.getMethod().getEnclosingClass());
        this._retType = retType = TypeLord.replaceRawGenericTypesWithDefaultParameterizedTypes(retType);
        return retType;
    }

    public static TypeVarToTypeMap addEnclosingTypeParams(IType declaringClass, TypeVarToTypeMap actualParamByVarName) {
        while (declaringClass.getEnclosingType() != null && !Modifier.isStatic(declaringClass.getModifiers())) {
            IGenericTypeVariable[] typeVariables = (declaringClass = declaringClass.getEnclosingType()).getGenericTypeVariables();
            if (typeVariables == null) continue;
            for (IGenericTypeVariable typeVariable : typeVariables) {
                if (actualParamByVarName.isEmpty()) {
                    actualParamByVarName = new TypeVarToTypeMap();
                }
                actualParamByVarName.put(typeVariable.getTypeVariableDefinition().getType(), (IType)(typeVariable.getTypeVariableDefinition() != null ? typeVariable.getTypeVariableDefinition().getType() : new TypeVariableType(declaringClass, typeVariable)));
            }
        }
        return actualParamByVarName;
    }

    @Override
    public List<IAnnotationInfo> getDeclaredAnnotations() {
        List<IAnnotationInfo> annotations = super.getDeclaredAnnotations();
        if (this.getMethodDocs().get() != null && ((IMethodNode)this.getMethodDocs().get()).isDeprecated()) {
            annotations.add(GosuShop.getAnnotationInfoFactory().createJavaAnnotation((Annotation)this.makeDeprecated(((IMethodNode)this.getMethodDocs().get()).getDeprecated()), (IFeatureInfo)this));
        }
        return annotations;
    }

    public IGenericTypeVariable[] getTypeVariables() {
        if (this._typeVars == null) {
            this._typeVars = this._md.getMethod().getTypeVariables((IJavaMethodInfo)this);
        }
        return this._typeVars;
    }

    public IType getParameterizedReturnType(IType ... typeParams) {
        TypeVarToTypeMap actualParamByVarName = TypeLord.mapTypeByVarName(this.getOwnersType(), this._md.getMethod().getEnclosingClass().getJavaType());
        int i = 0;
        for (IGenericTypeVariable tv : this.getTypeVariables()) {
            if (actualParamByVarName.isEmpty()) {
                actualParamByVarName = new TypeVarToTypeMap();
            }
            actualParamByVarName.put(tv.getTypeVariableDefinition().getType(), typeParams[i++]);
        }
        return this._md.getMethod().getGenericReturnType().getActualType(actualParamByVarName, true);
    }

    public IType[] getParameterizedParameterTypes(IType ... typeParams) {
        return this.getParameterizedParameterTypes2(null, typeParams);
    }

    public IType[] getParameterizedParameterTypes2(IType ownersType, IType ... typeParams) {
        IType ot = ownersType == null ? this.getOwnersType() : ownersType;
        TypeVarToTypeMap actualParamByVarName = TypeLord.mapTypeByVarName(ot, this._md.getMethod().getEnclosingClass().getJavaType());
        int i = 0;
        for (IGenericTypeVariable tv : this.getTypeVariables()) {
            if (actualParamByVarName.isEmpty()) {
                actualParamByVarName = new TypeVarToTypeMap();
            }
            actualParamByVarName.put(tv.getTypeVariableDefinition().getType(), typeParams[i++]);
        }
        return ClassInfoUtil.getActualTypes((IJavaClassType[])this._md.getMethod().getGenericParameterTypes(), (TypeVarToTypeMap)actualParamByVarName, (boolean)true);
    }

    public TypeVarToTypeMap inferTypeParametersFromArgumentTypes(IType ... argTypes) {
        return this.inferTypeParametersFromArgumentTypes2(null, argTypes);
    }

    public TypeVarToTypeMap inferTypeParametersFromArgumentTypes2(IType owningParameterizedType, IType ... argTypes) {
        IGenericTypeVariable[] typeVars;
        IJavaClassType[] genParamTypes = this._md.getMethod().getGenericParameterTypes();
        IType ownersType = owningParameterizedType == null ? this.getOwnersType() : owningParameterizedType;
        IType[] types = this.convertTypes(genParamTypes, ownersType);
        TypeVarToTypeMap actualParamByVarName = TypeLord.mapTypeByVarName(ownersType, ownersType);
        for (IGenericTypeVariable tv : typeVars = this.getTypeVariables()) {
            if (actualParamByVarName.isEmpty()) {
                actualParamByVarName = new TypeVarToTypeMap();
            }
            if (!TypeLord.isRecursiveType(tv.getTypeVariableDefinition().getType(), tv.getBoundingType())) {
                actualParamByVarName.put(tv.getTypeVariableDefinition().getType(), tv.getBoundingType());
                continue;
            }
            actualParamByVarName.put(tv.getTypeVariableDefinition().getType(), TypeLord.getPureGenericType(tv.getBoundingType()));
        }
        TypeVarToTypeMap map = new TypeVarToTypeMap();
        for (int i = 0; i < argTypes.length; ++i) {
            if (types.length <= i) continue;
            TypeLord.inferTypeVariableTypesFromGenParamTypeAndConcreteType(types[i], argTypes[i], map);
            AbstractGenericMethodInfo.ensureInferredTypeAssignableToBoundingType(actualParamByVarName, map);
        }
        return map;
    }

    private IType[] convertTypes(IJavaClassType[] genParamTypes, IType ownersType) {
        IType ot = ownersType == null ? this.getOwnersType() : ownersType;
        TypeVarToTypeMap actualParamByVarName = TypeLord.mapTypeByVarName(ot, this._md.getMethod().getEnclosingClass().getJavaType());
        for (IGenericTypeVariable tv : this.getTypeVariables()) {
            if (actualParamByVarName.isEmpty()) {
                actualParamByVarName = new TypeVarToTypeMap();
            }
            actualParamByVarName.put(tv.getTypeVariableDefinition().getType(), (IType)tv.getTypeVariableDefinition().getType());
        }
        IType[] types = new IType[genParamTypes.length];
        for (int i = 0; i < genParamTypes.length; ++i) {
            types[i] = genParamTypes[i].getActualType(actualParamByVarName, true);
        }
        return types;
    }

    public IMethodCallHandler getCallHandler() {
        if (this._callHandler != null) {
            return this._callHandler;
        }
        IJavaClassMethod method = this._md.getMethod();
        if (!(method instanceof MethodJavaClassMethod)) {
            return null;
        }
        this._callHandler = new MethodCallAdapter(((MethodJavaClassMethod)method).getJavaMethod());
        return this._callHandler;
    }

    public String getReturnDescription() {
        return this.getMethodDocs().get() == null ? "" : ((IMethodNode)this.getMethodDocs().get()).getReturnDescription();
    }

    public List<IExceptionInfo> getExceptions() {
        if (this._exceptions == null) {
            IJavaClassMethod method = this._md.getMethod();
            IJavaClassInfo[] classes = method.getExceptionTypes();
            this._exceptions = new ArrayList<IExceptionInfo>();
            for (int i = 0; i < classes.length; ++i) {
                final IJavaClassInfo exceptionClass = classes[i];
                this._exceptions.add((IExceptionInfo)new JavaExceptionInfo((IFeatureInfo)this, exceptionClass, (IDocRef)new IDocRef<IExceptionNode>(){

                    public IExceptionNode get() {
                        return JavaMethodInfo.this.getMethodDocs().get() == null ? null : ((IMethodNode)JavaMethodInfo.this.getMethodDocs().get()).getException(exceptionClass);
                    }
                }));
            }
        }
        return this._exceptions;
    }

    public String getName() {
        return this._signature;
    }

    private String makeSignature() {
        String name = this.getDisplayName();
        name = name + TypeInfoUtil.getTypeVarList((IFeatureInfo)this, (boolean)true);
        name = name + "(";
        IParameterInfo[] parameterInfos = this.getParameters();
        if (parameterInfos.length > 0) {
            name = name + " ";
            for (int i = 0; i < parameterInfos.length; ++i) {
                IParameterInfo iParameterInfo = parameterInfos[i];
                if (i != 0) {
                    name = name + ", ";
                }
                name = name + iParameterInfo.getFeatureType().getName();
            }
            name = name + " ";
        }
        name = name + ")";
        return name;
    }

    public String getDisplayName() {
        return this._name;
    }

    public String getShortDescription() {
        return this.getMethodDocs().get() == null ? null : ((IMethodNode)this.getMethodDocs().get()).getDescription();
    }

    public String getDescription() {
        return this.getMethodDocs().get() == null ? null : ((IMethodNode)this.getMethodDocs().get()).getDescription();
    }

    @Override
    public boolean isHidden() {
        return this._forceHidden || super.isHidden();
    }

    @Override
    protected boolean isDefaultEnumFeature() {
        if (this.getOwnersType().isEnum()) {
            String name = this.getName();
            return this.isStatic() && (name.equals("values()") || name.equals("valueOf( java.lang.String )"));
        }
        return false;
    }

    @Override
    public boolean isVisible(IScriptabilityModifier constraint) {
        return !this._forceHidden && super.isVisible(constraint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStatic() {
        if (this._staticCache == 0) {
            JavaMethodInfo javaMethodInfo = this;
            synchronized (javaMethodInfo) {
                if (this._staticCache == 0) {
                    this._staticCache = Modifier.isStatic(this._md.getMethod().getModifiers()) ? 1 : 2;
                }
            }
        }
        return this._staticCache == 1;
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this._md.getMethod().getModifiers());
    }

    public boolean isInternal() {
        return !this.isPrivate() && !this.isPublic() && !this.isProtected();
    }

    public boolean isProtected() {
        return Modifier.isProtected(this._md.getMethod().getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this._md.getMethod().getModifiers());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this._md.getMethod().getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this._md.getMethod().getModifiers());
    }

    public boolean isDefaultImpl() {
        return (this.getModifiers() & 0x409) == 1 && this.getOwnersType().isInterface();
    }

    public boolean isDeprecated() {
        return this.isJavadocDeprecated() || super.isDeprecated() || this.getMethod().isAnnotationPresent(Deprecated.class) || this.getMethod().isAnnotationPresent(java.lang.Deprecated.class);
    }

    private boolean isJavadocDeprecated() {
        return (this.getModifiers() & 0x20000) > 0;
    }

    public String getDeprecatedReason() {
        String deprecated = super.getDeprecatedReason();
        if (this.isDeprecated() && deprecated == null) {
            IAnnotationInfo gwDeprecated = this.getMethod().getAnnotation(Deprecated.class);
            return gwDeprecated == null ? null : (String)gwDeprecated.getFieldValue("value");
        }
        return deprecated;
    }

    public boolean hasAnnotationDefault() {
        Object defaultValue = this.getMethod().getDefaultValue();
        return defaultValue != null && defaultValue != JavaSourceDefaultValue.NULL;
    }

    public Object getAnnotationDefault() {
        return this.getMethod().getDefaultValue();
    }

    private IParameterInfo[] convertParameterDescriptors() {
        IJavaClassType[] paramTypes = this._md.getMethod().getGenericParameterTypes();
        return JavaMethodInfo.convertGenericParameterTypes((IFeatureInfo)this, this.initTypeVarMap(), paramTypes, this._md.getMethod().getEnclosingClass());
    }

    private TypeVarToTypeMap initTypeVarMap() {
        TypeVarToTypeMap actualParamByVarName;
        IType declaringClass = this._md.getMethod().getEnclosingClass().getJavaType();
        if (this.isStatic()) {
            actualParamByVarName = TypeVarToTypeMap.EMPTY_MAP;
        } else {
            actualParamByVarName = TypeLord.mapTypeByVarName(this.getOwnersType(), declaringClass);
            actualParamByVarName = JavaMethodInfo.addEnclosingTypeParams(declaringClass, actualParamByVarName);
        }
        for (IGenericTypeVariable tv : this.getTypeVariables()) {
            if (actualParamByVarName.isEmpty()) {
                actualParamByVarName = new TypeVarToTypeMap();
            }
            actualParamByVarName.put(tv.getTypeVariableDefinition().getType(), (IType)(tv.getTypeVariableDefinition() != null ? tv.getTypeVariableDefinition().getType() : new TypeVariableType(this.getOwnersType(), tv)));
        }
        return actualParamByVarName;
    }

    static IParameterInfo[] convertGenericParameterTypes(IFeatureInfo container, TypeVarToTypeMap actualParamByVarName, IJavaClassType[] paramTypes, IJavaClassInfo declaringClass) {
        if (paramTypes == null) {
            return null;
        }
        IParameterInfo[] pi = new IParameterInfo[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            IErrorType parameterType = null;
            if (paramTypes[i] != null) {
                parameterType = paramTypes[i].getActualType(actualParamByVarName, true);
            }
            if (parameterType == null) {
                parameterType = TypeSystem.getErrorType();
            }
            parameterType = ClassInfoUtil.getPublishedType((IType)parameterType, (IJavaClassInfo)declaringClass);
            parameterType = TypeLord.replaceRawGenericTypesWithDefaultParameterizedTypes((IType)parameterType);
            pi[i] = new SimpleParameterInfo(container, (IType)parameterType, i);
        }
        return pi;
    }

    public IJavaClassMethod getMethod() {
        return this._md.getMethod();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    protected IJavaAnnotatedElement getAnnotatedElement() {
        return this._md.getMethod();
    }

    @Override
    protected boolean isVisibleViaFeatureDescriptor(IScriptabilityModifier constraint) {
        return this._md.isVisibleViaFeatureDescriptor(constraint);
    }

    @Override
    protected boolean isHiddenViaFeatureDescriptor() {
        return this._md.isHiddenViaFeatureDescriptor();
    }

    public IDocRef<IParamNode> getDocsForParam(final int paramIndex) {
        return new IDocRef<IParamNode>(){

            public IParamNode get() {
                List list;
                if (JavaMethodInfo.this.getMethodDocs().get() != null && (list = ((IMethodNode)JavaMethodInfo.this.getMethodDocs().get()).getParams()).size() > paramIndex) {
                    return (IParamNode)list.get(paramIndex);
                }
                return null;
            }
        };
    }

    public IDocRef<IMethodNode> getMethodDocs() {
        return this._methodDocs;
    }

    public Method getRawMethod() {
        return ((MethodJavaClassMethod)this._md.getMethod()).getJavaMethod();
    }

    public int getModifiers() {
        return this._md.getMethod().getModifiers();
    }

    public ILocationInfo getLocationInfo() {
        if (this.getMethod() instanceof JavaSourceElement) {
            return this.getMethod().getLocationInfo();
        }
        return super.getLocationInfo();
    }
}

