/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.internal.gosu.parser.CannotExecuteGosuException;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.TypeLord;
import gw.lang.parser.GosuParserTypes;
import gw.lang.parser.expressions.IMapAccessExpression;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.JavaTypes;

public final class MapAccess
extends Expression
implements IMapAccessExpression {
    private Expression _rootExpression;
    private boolean _bNullSafe;
    private Expression _keyExpression;
    private IType _keyType;

    public Expression getRootExpression() {
        return this._rootExpression;
    }

    public void setRootExpression(Expression rootExpression) {
        this._rootExpression = rootExpression;
        this.setTypeInternal(this._rootExpression.getType());
    }

    public Expression getKeyExpression() {
        return this._keyExpression;
    }

    public void setKeyExpression(Expression keyExpression) {
        this._keyExpression = keyExpression;
    }

    @Override
    public boolean isNullSafe() {
        return this._bNullSafe;
    }

    public void setNullSafe(boolean bNullSafe) {
        this._bNullSafe = bNullSafe;
    }

    @Override
    public Object evaluate() {
        if (!this.isCompileTimeConstant()) {
            return super.evaluate();
        }
        throw new CannotExecuteGosuException();
    }

    @Override
    public String toString() {
        return this.getRootExpression().toString() + "[" + this.getKeyExpression().toString() + "]";
    }

    public static boolean supportsMapAccess(IType type) {
        return JavaTypes.MAP().isAssignableFrom(type);
    }

    private void setTypeInternal(IType type) {
        IType paramedType = TypeLord.findParameterizedTypeInHierarchy(type, (IType)JavaTypes.MAP());
        if (paramedType != null) {
            IType[] parameters = paramedType.getTypeParameters();
            this._keyType = parameters[0];
            this.setType(parameters[1]);
        } else {
            this._keyType = GosuParserTypes.GENERIC_BEAN_TYPE();
            this.setType(GosuParserTypes.GENERIC_BEAN_TYPE());
        }
    }

    public static IType getKeyType(IType type) {
        IType paramedType = TypeLord.findParameterizedTypeInHierarchy(type, (IType)JavaTypes.MAP());
        if (paramedType != null) {
            IType[] parameters = paramedType.getTypeParameters();
            return parameters[0];
        }
        return GosuParserTypes.GENERIC_BEAN_TYPE();
    }

    public IType getComponentType() {
        return this.getType();
    }

    public IType getKeyType() {
        return this._keyType;
    }
}

