/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.java.compiler;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTool;
import gw.fs.IResource;
import gw.internal.gosu.parser.java.compiler.GosuJavaFileManager;
import gw.lang.javac.ClassJavaFileObject;
import gw.lang.javac.IJavaParser;
import gw.lang.javac.StringJavaFileObject;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.module.IModule;
import gw.util.Pair;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

public class JavaParser
implements IJavaParser {
    private static final JavaParser INSTANCE = new JavaParser();
    private JavaCompiler _javac;
    private StandardJavaFileManager _fileManager;
    private GosuJavaFileManager _gfm;

    public static JavaParser instance() {
        return INSTANCE;
    }

    private JavaParser() {
    }

    private void init() {
        if (this._javac == null) {
            this._javac = JavacTool.create();
            this._fileManager = this._javac.getStandardFileManager(null, null, Charset.forName("UTF-8"));
            try {
                IModule globalModule = TypeSystem.getGlobalModule();
                if (globalModule != null) {
                    this._fileManager.setLocation(StandardLocation.SOURCE_PATH, globalModule.getSourcePath().stream().map(IResource::toJavaFile).collect(Collectors.toList()));
                    this._fileManager.setLocation(StandardLocation.CLASS_PATH, globalModule.getJavaClassPath().stream().map(IResource::toJavaFile).collect(Collectors.toList()));
                }
                this._gfm = new GosuJavaFileManager(this._fileManager);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean parseType(String fqn, List<CompilationUnitTree> trees, DiagnosticCollector<JavaFileObject> errorHandler) {
        try {
            this.init();
            Pair<JavaFileObject, String> pair = this.findJavaSource(fqn);
            StringWriter errors = new StringWriter();
            JavaCompiler.CompilationTask task = this._javac.getTask(errors, this._fileManager, errorHandler, Arrays.asList("-proc:none"), null, Arrays.asList((JavaFileObject)pair.getFirst()));
            JavacTaskImpl javacTask = (JavacTaskImpl)task;
            Iterable<? extends CompilationUnitTree> iterable = javacTask.parse();
            for (CompilationUnitTree compilationUnitTree : iterable) {
                trees.add(compilationUnitTree);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean parseText(String src, List<CompilationUnitTree> trees, DiagnosticCollector<JavaFileObject> errorHandler) {
        try {
            this.init();
            ArrayList<StringJavaFileObject> javaStringObjects = new ArrayList<StringJavaFileObject>();
            javaStringObjects.add(new StringJavaFileObject("sample", src));
            StringWriter errors = new StringWriter();
            JavaCompiler.CompilationTask task = this._javac.getTask(errors, this._fileManager, errorHandler, Arrays.asList("-proc:none"), null, javaStringObjects);
            JavacTaskImpl javacTask = (JavacTaskImpl)task;
            Iterable<? extends CompilationUnitTree> iterable = javacTask.parse();
            for (CompilationUnitTree compilationUnitTree : iterable) {
                trees.add(compilationUnitTree);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public ClassJavaFileObject compile(String fqn, Iterable<String> options, DiagnosticCollector<JavaFileObject> errorHandler) {
        this.init();
        ClassJavaFileObject compiledClass = this._gfm.findCompiledFile(fqn);
        if (compiledClass != null) {
            return compiledClass;
        }
        Pair<JavaFileObject, String> fileObj = this.findJavaSource(fqn);
        if (fileObj == null) {
            return null;
        }
        StringWriter errors = new StringWriter();
        JavaCompiler.CompilationTask compilationTask = this._javac.getTask(errors, this._gfm, errorHandler, options, null, Arrays.asList((JavaFileObject)fileObj.getFirst()));
        compilationTask.call();
        return this._gfm.findCompiledFile((String)fileObj.getSecond());
    }

    public ClassJavaFileObject compile(JavaFileObject jfo, String fqn, Iterable<String> options, DiagnosticCollector<JavaFileObject> errorHandler) {
        this.init();
        StringWriter errors = new StringWriter();
        JavaCompiler.CompilationTask compilationTask = this._javac.getTask(errors, this._gfm, errorHandler, options, null, Arrays.asList(jfo));
        compilationTask.call();
        return this._gfm.findCompiledFile(fqn);
    }

    public Pair<JavaFileObject, String> findJavaSource(String fqn) {
        this.init();
        try {
            int iDot;
            JavaFileObject fileObj = this._gfm.getJavaFileForInput(StandardLocation.SOURCE_PATH, fqn, JavaFileObject.Kind.SOURCE);
            Pair<JavaFileObject, String> pair = new Pair<JavaFileObject, String>((Object)fileObj, (Object)fqn);
            if (pair.getFirst() == null && (iDot = fqn.lastIndexOf(46)) > 0) {
                String enclosingFqn = fqn.substring(0, iDot);
                pair = this.findJavaSource(enclosingFqn);
            }
            return pair;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        this._javac = null;
        try {
            this._fileManager.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

