/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.statements;

import gw.internal.gosu.parser.Statement;
import gw.lang.parser.statements.ITerminalStatement;
import gw.lang.parser.statements.IUsesStatement;
import gw.lang.parser.statements.IUsesStatementList;
import java.util.List;

public class UsesStatementList
extends Statement
implements IUsesStatementList {
    private List<IUsesStatement> _stmts;

    public List<IUsesStatement> getUsesStatements() {
        return this._stmts;
    }

    public void setUsesStatements(List<IUsesStatement> stmts) {
        this._stmts = stmts;
    }

    @Override
    public Object execute() {
        return Statement.VOID_RETURN_VALUE;
    }

    @Override
    protected ITerminalStatement getLeastSignificantTerminalStatement_internal(boolean[] bAbsolute) {
        bAbsolute[0] = false;
        return null;
    }

    @Override
    public boolean isNoOp() {
        return true;
    }

    public IUsesStatement conflicts(IUsesStatement stmt) {
        String fqn = stmt.getTypeName();
        if (fqn == null || stmt.getFeatureInfo() != null || stmt.isFeatureSpace()) {
            return null;
        }
        String relativeName = this.getRelativeName(fqn);
        boolean bPackage = relativeName.equals("*");
        for (IUsesStatement csrStmt : this._stmts) {
            String csrFqn;
            if (csrStmt.isFeatureSpace() || csrStmt.getFeatureInfo() != null || (csrFqn = csrStmt.getTypeName()) == null) continue;
            if (csrFqn.equals(fqn)) {
                return csrStmt;
            }
            String csrRelativeName = this.getRelativeName(csrFqn);
            if (bPackage || !csrRelativeName.equals(relativeName)) continue;
            return csrStmt;
        }
        return null;
    }

    private String getRelativeName(String fqn) {
        if (fqn == null) {
            return "";
        }
        int iDot = fqn.lastIndexOf(46);
        if (iDot >= 0) {
            fqn = iDot < fqn.length() - 1 ? fqn.substring(iDot + 1) : "";
        }
        return fqn;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this._stmts != null) {
            for (IUsesStatement stmt : this._stmts) {
                sb.append(stmt.toString() + "\n");
            }
        }
        return sb.toString();
    }
}

