/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.bytecode.expression;

import gw.internal.ext.org.objectweb.asm.MethodVisitor;
import gw.internal.gosu.ir.compiler.bytecode.AbstractBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeContext;
import gw.internal.gosu.ir.compiler.bytecode.expression.IREqualityExpressionCompiler;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRType;
import gw.lang.ir.expression.IRRelationalExpression;

public class IRRelationalExpressionCompiler
extends AbstractBytecodeCompiler {
    public static void compile(IRRelationalExpression expression, IRBytecodeContext context) {
        int asmOpcode;
        IRExpression rhs = expression.getRhs();
        IRType rhsType = rhs.getType();
        if (!expression.getLhs().getType().equals(rhsType)) {
            throw new IllegalStateException("Relational expression had one side as a " + expression.getLhs().getType().getName() + " and the other as a " + rhsType.getName());
        }
        IRBytecodeCompiler.compileIRExpression(expression.getLhs(), context);
        boolean isInteger0 = IREqualityExpressionCompiler.isInteger0(rhs, rhsType);
        if (!isInteger0) {
            IRBytecodeCompiler.compileIRExpression(rhs, context);
        }
        MethodVisitor mv = context.getMv();
        IRType type = expression.getLhs().getType();
        IRRelationalExpression.Operation op = expression.getOp();
        if (type.isLong() || type.isDouble() || type.isFloat()) {
            if (op == IRRelationalExpression.Operation.LTE || op == IRRelationalExpression.Operation.LT) {
                mv.visitInsn(type.isDouble() ? 152 : (type.isFloat() ? 150 : 148));
            } else {
                mv.visitInsn(type.isDouble() ? 151 : (type.isFloat() ? 149 : 148));
            }
            asmOpcode = IRRelationalExpressionCompiler.getOpcodeFor0(op);
        } else {
            asmOpcode = isInteger0 ? IRRelationalExpressionCompiler.getOpcodeFor0(op) : (op == IRRelationalExpression.Operation.LTE ? 164 : (op == IRRelationalExpression.Operation.LT ? 161 : (op == IRRelationalExpression.Operation.GTE ? 162 : 163)));
        }
        expression.getConditionContext().setOperator(asmOpcode);
        if (IRRelationalExpressionCompiler.isNotPartOfBooleanExpr((IRExpression)expression)) {
            IRRelationalExpressionCompiler.compileConditionAssignment((IRExpression)expression, mv);
        }
    }

    private static int getOpcodeFor0(IRRelationalExpression.Operation op) {
        int asmOpcode = op == IRRelationalExpression.Operation.LTE ? 158 : (op == IRRelationalExpression.Operation.LT ? 155 : (op == IRRelationalExpression.Operation.GTE ? 156 : 157));
        return asmOpcode;
    }
}

