/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.verifier;

import gw.internal.gosu.ir.compiler.bytecode.IRClassCompiler;
import gw.internal.gosu.ir.compiler.tree.IRTreeCompiler;
import gw.lang.ir.IRClass;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRType;
import gw.lang.ir.IRTypeConstants;
import gw.lang.ir.expression.IRArithmeticExpression;
import gw.lang.ir.expression.IRArrayLengthExpression;
import gw.lang.ir.expression.IRArrayLoadExpression;
import gw.lang.ir.expression.IRBooleanLiteral;
import gw.lang.ir.expression.IRCastExpression;
import gw.lang.ir.expression.IRCharacterLiteral;
import gw.lang.ir.expression.IRClassLiteral;
import gw.lang.ir.expression.IRCompositeExpression;
import gw.lang.ir.expression.IRConditionalAndExpression;
import gw.lang.ir.expression.IRConditionalOrExpression;
import gw.lang.ir.expression.IREqualityExpression;
import gw.lang.ir.expression.IRFieldGetExpression;
import gw.lang.ir.expression.IRIdentifier;
import gw.lang.ir.expression.IRInstanceOfExpression;
import gw.lang.ir.expression.IRMethodCallExpression;
import gw.lang.ir.expression.IRNegationExpression;
import gw.lang.ir.expression.IRNewArrayExpression;
import gw.lang.ir.expression.IRNewExpression;
import gw.lang.ir.expression.IRNewMultiDimensionalArrayExpression;
import gw.lang.ir.expression.IRNoOpExpression;
import gw.lang.ir.expression.IRNotExpression;
import gw.lang.ir.expression.IRNullLiteral;
import gw.lang.ir.expression.IRNumericLiteral;
import gw.lang.ir.expression.IRPrimitiveTypeConversion;
import gw.lang.ir.expression.IRRelationalExpression;
import gw.lang.ir.expression.IRStringLiteralExpression;
import gw.lang.ir.expression.IRTernaryExpression;
import gw.lang.ir.statement.IRArrayStoreStatement;
import gw.lang.ir.statement.IRAssignmentStatement;
import gw.lang.ir.statement.IRBreakStatement;
import gw.lang.ir.statement.IRCaseClause;
import gw.lang.ir.statement.IRCatchClause;
import gw.lang.ir.statement.IRContinueStatement;
import gw.lang.ir.statement.IRDoWhileStatement;
import gw.lang.ir.statement.IREvalStatement;
import gw.lang.ir.statement.IRFieldDecl;
import gw.lang.ir.statement.IRFieldSetStatement;
import gw.lang.ir.statement.IRForEachStatement;
import gw.lang.ir.statement.IRIfStatement;
import gw.lang.ir.statement.IRMethodCallStatement;
import gw.lang.ir.statement.IRMethodStatement;
import gw.lang.ir.statement.IRMonitorLockAcquireStatement;
import gw.lang.ir.statement.IRMonitorLockReleaseStatement;
import gw.lang.ir.statement.IRNoOpStatement;
import gw.lang.ir.statement.IRReturnStatement;
import gw.lang.ir.statement.IRStatementList;
import gw.lang.ir.statement.IRSwitchStatement;
import gw.lang.ir.statement.IRSyntheticStatement;
import gw.lang.ir.statement.IRThrowStatement;
import gw.lang.ir.statement.IRTryCatchFinallyStatement;
import gw.lang.ir.statement.IRWhileStatement;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class IRTreeVerifier {
    private List<String> _errors = new ArrayList<String>();
    private IRMethodStatement _enclosingMethodStatement;
    private IRClass _enclosingClass;

    public List<String> getErrors() {
        return this._errors;
    }

    public void printErrors() {
        if (this._errors.isEmpty()) {
            System.out.println("No errors detected");
        } else {
            for (String error : this._errors) {
                System.out.println("***ERROR: " + error);
            }
        }
    }

    public void verifyClassStatement(IRClass irClass) {
        this._enclosingClass = irClass;
        for (IRFieldDecl fieldDecl : irClass.getFields()) {
            this.verifyIRFieldDecl(fieldDecl);
        }
        HashSet<CallSite> methodSignatures = new HashSet<CallSite>();
        for (IRMethodStatement methodStatement : irClass.getMethods()) {
            String signature = methodStatement.getName() + IRClassCompiler.getMethodDescriptor(methodStatement);
            if (methodSignatures.add((CallSite)((Object)signature))) {
                this.verifyIRMethodStatement(methodStatement);
                continue;
            }
            this.error("Duplicate methods found with signature " + signature, (IRElement)methodStatement);
        }
    }

    private void verifyIRElement(IRElement element) {
        if (element instanceof IRStatement) {
            this.verifyIRStatement((IRStatement)element);
        } else {
            this.verifyIRExpression((IRExpression)element);
        }
    }

    private void verifyIRStatement(IRStatement statement) {
        if (statement == null) {
            return;
        }
        this.verifyParentIsSet((IRElement)statement);
        if (statement instanceof IRAssignmentStatement) {
            this.verifyIRAssignmentStatement((IRAssignmentStatement)statement);
        } else if (statement instanceof IRFieldDecl) {
            this.verifyIRFieldDecl((IRFieldDecl)statement);
        } else if (statement instanceof IRFieldSetStatement) {
            this.verifyIRFieldSetStatement((IRFieldSetStatement)statement);
        } else if (statement instanceof IRIfStatement) {
            this.verifyIRIfStatement((IRIfStatement)statement);
        } else if (statement instanceof IRMethodCallStatement) {
            this.verifyIRMethodCallStatement((IRMethodCallStatement)statement);
        } else if (statement instanceof IRMethodStatement) {
            this.verifyIRMethodStatement((IRMethodStatement)statement);
        } else if (statement instanceof IRNoOpStatement) {
            this.verifyIRNoOpStatement((IRNoOpStatement)statement);
        } else if (statement instanceof IRReturnStatement) {
            this.verifyIRReturnStatement((IRReturnStatement)statement);
        } else if (statement instanceof IRStatementList) {
            this.verifyIRStatementList((IRStatementList)statement);
        } else if (statement instanceof IRArrayStoreStatement) {
            this.verifyIRArrayStoreStatement((IRArrayStoreStatement)statement);
        } else if (statement instanceof IRThrowStatement) {
            this.verifyIRThrowStatement((IRThrowStatement)statement);
        } else if (statement instanceof IRTryCatchFinallyStatement) {
            this.verifyIRTryCatchFinallyStatement((IRTryCatchFinallyStatement)statement);
        } else if (statement instanceof IRSyntheticStatement) {
            this.verifyIRSyntheticStatement((IRSyntheticStatement)statement);
        } else if (statement instanceof IRForEachStatement) {
            this.verifyIRForEachStatement((IRForEachStatement)statement);
        } else if (statement instanceof IRBreakStatement) {
            this.verifyIRBreakStatement((IRBreakStatement)statement);
        } else if (statement instanceof IRContinueStatement) {
            this.verifyIRContinueStatement((IRContinueStatement)statement);
        } else if (statement instanceof IRWhileStatement) {
            this.verifyIRWhileStatement((IRWhileStatement)statement);
        } else if (statement instanceof IRDoWhileStatement) {
            this.verifyIRDoWhileStatement((IRDoWhileStatement)statement);
        } else if (statement instanceof IRMonitorLockAcquireStatement) {
            this.verifyIRIRMonitorLockAcquireStatement((IRMonitorLockAcquireStatement)statement);
        } else if (statement instanceof IRMonitorLockReleaseStatement) {
            this.verifyIRIRMonitorLockReleaseStatement((IRMonitorLockReleaseStatement)statement);
        } else if (statement instanceof IRSwitchStatement) {
            this.verifyIRSwitchStatement((IRSwitchStatement)statement);
        } else if (statement instanceof IREvalStatement) {
            this.verifyIREvalStatement((IREvalStatement)statement);
        } else {
            throw new IllegalArgumentException("Unrecognized statement of type " + statement.getClass());
        }
    }

    private void verifyIRSwitchStatement(IRSwitchStatement irSwitchStatement) {
        this.verifyIRStatement(irSwitchStatement.getInit());
        for (IRCaseClause caseClause : irSwitchStatement.getCases()) {
            this.verifyIRExpression(caseClause.getCondition());
            for (IRStatement caseStatement : caseClause.getStatements()) {
                this.verifyIRStatement(caseStatement);
            }
        }
        for (IRStatement defaultStatement : irSwitchStatement.getDefaultStatements()) {
            this.verifyIRStatement(defaultStatement);
        }
    }

    private void verifyIRIRMonitorLockAcquireStatement(IRMonitorLockAcquireStatement irMonitorLockAcquireStatement) {
    }

    private void verifyIRIRMonitorLockReleaseStatement(IRMonitorLockReleaseStatement irMonitorLockReleaseStatement) {
    }

    private void verifyIRDoWhileStatement(IRDoWhileStatement irDoWhileLoopStatement) {
        this.verifyIRExpression(irDoWhileLoopStatement.getLoopTest());
        this.verifyIRStatement(irDoWhileLoopStatement.getBody());
    }

    private void verifyIRWhileStatement(IRWhileStatement irWhileLoopStatement) {
        this.verifyIRExpression(irWhileLoopStatement.getLoopTest());
        this.verifyIRStatement(irWhileLoopStatement.getBody());
    }

    private void verifyIRContinueStatement(IRContinueStatement irContinueStatement) {
    }

    private void verifyIRBreakStatement(IRBreakStatement irBreakStatement) {
    }

    private void verifyIREvalStatement(IREvalStatement evalStmt) {
        this.verifyIRExpression(evalStmt.getExpression());
    }

    private void verifyIRForEachStatement(IRForEachStatement irForLoopStatement) {
        for (IRStatement s : irForLoopStatement.getInitializers()) {
            this.verifyIRStatement(s);
        }
        this.verifyIRExpression(irForLoopStatement.getLoopTest());
        for (IRStatement s : irForLoopStatement.getIncrementors()) {
            this.verifyIRStatement(s);
        }
        this.verifyIRStatement(irForLoopStatement.getBody());
    }

    private void verifyIRSyntheticStatement(IRSyntheticStatement irSyntheticStatement) {
        this.verifyIRExpression(irSyntheticStatement.getExpression());
    }

    private void verifyIRTryCatchFinallyStatement(IRTryCatchFinallyStatement irTryCatchFinallyStatement) {
        this.verifyIRStatement(irTryCatchFinallyStatement.getTryBody());
        for (IRCatchClause catchClause : irTryCatchFinallyStatement.getCatchStatements()) {
            this.verifyIRStatement(catchClause.getBody());
        }
        if (irTryCatchFinallyStatement.getFinallyBody() != null) {
            this.verifyIRStatement(irTryCatchFinallyStatement.getFinallyBody());
        }
    }

    private void verifyIRThrowStatement(IRThrowStatement irThrowStatement) {
        this.verifyIRExpression(irThrowStatement.getException());
    }

    private void verifyIRArrayStoreStatement(IRArrayStoreStatement irArrayStoreStatement) {
        if (!this.verifyExpressionIsOfType(irArrayStoreStatement.getTarget().getType().getComponentType(), irArrayStoreStatement.getValue())) {
            this.error("Attempting to store a value of type " + irArrayStoreStatement.getValue().getType().getName() + " in an array of type " + irArrayStoreStatement.getTarget().getType().getRelativeName(), (IRElement)irArrayStoreStatement);
        }
        this.verifyIRExpression(irArrayStoreStatement.getTarget());
        this.verifyIRExpression(irArrayStoreStatement.getIndex());
        this.verifyIRExpression(irArrayStoreStatement.getValue());
    }

    private void verifyIRFieldSetStatement(IRFieldSetStatement irFieldSetStatement) {
        this.verifyIRExpression(irFieldSetStatement.getLhs());
        this.verifyIRExpression(irFieldSetStatement.getRhs());
    }

    private void verifyIRIfStatement(IRIfStatement irIfStatement) {
        this.verifyIRExpression(irIfStatement.getExpression());
        this.verifyIRStatement(irIfStatement.getIfStatement());
        this.verifyIRStatement(irIfStatement.getElseStatement());
    }

    private void verifyIRMethodCallStatement(IRMethodCallStatement irMethodCallStatement) {
        this.verifyIRExpression(irMethodCallStatement.getExpression());
    }

    private void verifyIRNoOpStatement(IRNoOpStatement irNoOpStatement) {
    }

    private void verifyIRReturnStatement(IRReturnStatement irReturnStatement) {
        if (this._enclosingMethodStatement.getReturnType().isVoid()) {
            if (irReturnStatement.getReturnValue() != null) {
                this.error("Method " + this._enclosingMethodStatement.getName() + " has a void return type, but a return statement returned a value", (IRElement)irReturnStatement);
            }
        } else if (irReturnStatement.getReturnValue() == null) {
            this.error("Method " + this._enclosingMethodStatement.getName() + " has a non-void return type, but a return statement has no value", (IRElement)irReturnStatement);
        } else if (!this.verifyExpressionIsOfType(this._enclosingMethodStatement.getReturnType(), irReturnStatement.getReturnValue())) {
            this.error("Method " + this._enclosingMethodStatement.getName() + " has a return type of " + this._enclosingMethodStatement.getReturnType().getName() + " but a return statement has a value of type " + irReturnStatement.getReturnValue().getType().getName(), (IRElement)irReturnStatement);
        }
        this.verifyIRExpression(irReturnStatement.getReturnValue());
    }

    private void verifyIRStatementList(IRStatementList irStatementList) {
        for (IRStatement statement : irStatementList.getStatements()) {
            this.verifyIRStatement(statement);
        }
    }

    private void verifyIRAssignmentStatement(IRAssignmentStatement irAssignmentStatement) {
        if (!this.verifyExpressionIsOfType(irAssignmentStatement.getSymbol().getType(), irAssignmentStatement.getValue())) {
            this.error("Attempted to assign a value of type " + irAssignmentStatement.getValue().getType().getName() + " to a symbol of type " + irAssignmentStatement.getSymbol().getType().getName(), (IRElement)irAssignmentStatement);
        }
        this.verifyIRExpression(irAssignmentStatement.getValue());
    }

    private void verifyIRExpression(IRExpression expression) {
        if (expression == null) {
            return;
        }
        this.verifyParentIsSet((IRElement)expression);
        if (expression instanceof IRArithmeticExpression) {
            this.verifyIRAdditiveExpression((IRArithmeticExpression)expression);
        } else if (expression instanceof IRArrayLoadExpression) {
            this.verifyIRArrayLoadExpression((IRArrayLoadExpression)expression);
        } else if (expression instanceof IRBooleanLiteral) {
            this.verifyIRBooleanLiteral((IRBooleanLiteral)expression);
        } else if (expression instanceof IRCompositeExpression) {
            this.verifyIRCompositeExpression((IRCompositeExpression)expression);
        } else if (expression instanceof IREqualityExpression) {
            this.verifyIREqualityExpression((IREqualityExpression)expression);
        } else if (expression instanceof IRFieldGetExpression) {
            this.verifyIRFieldGetExpression((IRFieldGetExpression)expression);
        } else if (expression instanceof IRIdentifier) {
            this.verifyIRIdentifier((IRIdentifier)expression);
        } else if (expression instanceof IRMethodCallExpression) {
            this.verifyIRMethodCallExpression((IRMethodCallExpression)expression);
        } else if (expression instanceof IRNullLiteral) {
            this.verifyIRNullLiteral((IRNullLiteral)expression);
        } else if (expression instanceof IRPrimitiveTypeConversion) {
            this.verifyIRPrimitiveTypeConversion((IRPrimitiveTypeConversion)expression);
        } else if (expression instanceof IRTernaryExpression) {
            this.verifyIRTernaryExpression((IRTernaryExpression)expression);
        } else if (expression instanceof IRNumericLiteral) {
            this.verifyIRNumericLiteral((IRNumericLiteral)expression);
        } else if (expression instanceof IRCharacterLiteral) {
            this.verifyIRCharacterLiteral((IRCharacterLiteral)expression);
        } else if (expression instanceof IRStringLiteralExpression) {
            this.verifyIRStringLiteralExpression((IRStringLiteralExpression)expression);
        } else if (expression instanceof IRNewArrayExpression) {
            this.verifyIRNewArrayExpression((IRNewArrayExpression)expression);
        } else if (expression instanceof IRCastExpression) {
            this.verifyIRCastExpression((IRCastExpression)expression);
        } else if (expression instanceof IRNewExpression) {
            this.verifyIRNewExpression((IRNewExpression)expression);
        } else if (expression instanceof IRRelationalExpression) {
            this.verifyIRRelationalExpression((IRRelationalExpression)expression);
        } else if (expression instanceof IRNegationExpression) {
            this.verifyIRNegationExpression((IRNegationExpression)expression);
        } else if (expression instanceof IRConditionalOrExpression) {
            this.verifyIRConditionalOrExpression((IRConditionalOrExpression)expression);
        } else if (expression instanceof IRConditionalAndExpression) {
            this.verifyIRConditionalAndExpression((IRConditionalAndExpression)expression);
        } else if (expression instanceof IRArrayLengthExpression) {
            this.verifyIRArrayLengthExpression((IRArrayLengthExpression)expression);
        } else if (expression instanceof IRClassLiteral) {
            this.verifyIRClassLiteral((IRClassLiteral)expression);
        } else if (expression instanceof IRNotExpression) {
            this.verifyIRNotExpression((IRNotExpression)expression);
        } else if (expression instanceof IRInstanceOfExpression) {
            this.verifyIRInstanceOfExpression((IRInstanceOfExpression)expression);
        } else if (expression instanceof IRNewMultiDimensionalArrayExpression) {
            this.verifyIRNewMultiDimensionalArrayExpression((IRNewMultiDimensionalArrayExpression)expression);
        } else if (!(expression instanceof IRNoOpExpression)) {
            throw new IllegalArgumentException("Unrecognized expression of type " + expression.getClass());
        }
    }

    private void verifyIRNewMultiDimensionalArrayExpression(IRNewMultiDimensionalArrayExpression irNewMultiDimensionalArrayExpression) {
        for (IRExpression irExpression : irNewMultiDimensionalArrayExpression.getSizeExpressions()) {
            this.verifyIRExpression(irExpression);
        }
    }

    private void verifyIRInstanceOfExpression(IRInstanceOfExpression irInstanceOfExpression) {
        this.verifyIRExpression(irInstanceOfExpression.getRoot());
    }

    private void verifyIRNotExpression(IRNotExpression irNotExpression) {
        this.verifyIRExpression(irNotExpression.getRoot());
    }

    private void verifyIRClassLiteral(IRClassLiteral irClassLiteral) {
    }

    private void verifyIRArrayLengthExpression(IRArrayLengthExpression irArrayLengthExpression) {
        if (!irArrayLengthExpression.getRoot().getType().isArray()) {
            this.error("Array length expression root must be an array type, but was " + irArrayLengthExpression.getRoot().getType().getName(), (IRElement)irArrayLengthExpression);
        }
        this.verifyIRExpression(irArrayLengthExpression.getRoot());
    }

    private void verifyIRConditionalAndExpression(IRConditionalAndExpression irConditionalAndExpression) {
        this.verifyIRExpression(irConditionalAndExpression.getLhs());
        this.verifyIRExpression(irConditionalAndExpression.getRhs());
    }

    private void verifyIRConditionalOrExpression(IRConditionalOrExpression irConditionalOrExpression) {
        this.verifyIRExpression(irConditionalOrExpression.getLhs());
        this.verifyIRExpression(irConditionalOrExpression.getRhs());
    }

    private void verifyIRNegationExpression(IRNegationExpression irNegationExpression) {
        this.verifyIRExpression(irNegationExpression.getRoot());
    }

    private void verifyIRRelationalExpression(IRRelationalExpression irRelationalExpression) {
        this.verifyIRExpression(irRelationalExpression.getLhs());
        this.verifyIRExpression(irRelationalExpression.getRhs());
    }

    private void verifyIRNewExpression(IRNewExpression irNewExpression) {
        this.verifyTypeAgreement(irNewExpression.getParameterTypes(), irNewExpression.getArgs(), (IRElement)irNewExpression);
        for (IRExpression arg : irNewExpression.getArgs()) {
            this.verifyIRExpression(arg);
        }
    }

    private void verifyIRCastExpression(IRCastExpression irCastExpression) {
        this.verifyIRExpression(irCastExpression.getRoot());
    }

    private void verifyIRNewArrayExpression(IRNewArrayExpression irNewArrayExpression) {
        this.verifyIRExpression(irNewArrayExpression.getSizeExpression());
    }

    private void verifyIRStringLiteralExpression(IRStringLiteralExpression irStringLiteralExpression) {
    }

    private void verifyIRNumericLiteral(IRNumericLiteral irNumericLiteral) {
    }

    private void verifyIRCharacterLiteral(IRCharacterLiteral irNumericLiteral) {
    }

    private void verifyIRAdditiveExpression(IRArithmeticExpression irAdditiveExpression) {
        this.verifyIRExpression(irAdditiveExpression.getLhs());
        this.verifyIRExpression(irAdditiveExpression.getRhs());
    }

    private void verifyIRArrayLoadExpression(IRArrayLoadExpression irArrayLoadExpression) {
        this.verifyIRExpression(irArrayLoadExpression.getRoot());
        this.verifyIRExpression(irArrayLoadExpression.getIndex());
    }

    private void verifyIRBooleanLiteral(IRBooleanLiteral irBooleanLiteral) {
    }

    private void verifyIRCompositeExpression(IRCompositeExpression irCompositeExpression) {
        for (int i = 0; i < irCompositeExpression.getElements().size(); ++i) {
            IRElement element = (IRElement)irCompositeExpression.getElements().get(i);
            if (i < irCompositeExpression.getElements().size() - 1) {
                if (element instanceof IRStatement) continue;
                this.error("Composite does not consist of statements followed by a single expression: " + this.printElement((IRElement)irCompositeExpression), (IRElement)irCompositeExpression);
                continue;
            }
            if (element instanceof IRExpression) continue;
            this.error("Composite does not consist of statements followed by a single expression: " + this.printElement((IRElement)irCompositeExpression), (IRElement)irCompositeExpression);
        }
        for (IRElement element : irCompositeExpression.getElements()) {
            this.verifyIRElement(element);
        }
    }

    private void verifyIREqualityExpression(IREqualityExpression irEqualityExpression) {
        this.verifyIRElement((IRElement)irEqualityExpression.getLhs());
        this.verifyIRElement((IRElement)irEqualityExpression.getRhs());
    }

    private void verifyIRFieldGetExpression(IRFieldGetExpression irFieldGetExpression) {
        this.verifyIRElement((IRElement)irFieldGetExpression.getLhs());
    }

    private void verifyIRIdentifier(IRIdentifier irIdentifier) {
    }

    private void verifyIRMethodCallExpression(IRMethodCallExpression irMethodCallExpression) {
        this.verifyTypeAgreement(irMethodCallExpression.getParameterTypes(), irMethodCallExpression.getArgs(), (IRElement)irMethodCallExpression);
        if (irMethodCallExpression.getRoot() != null && !this.verifyExpressionIsOfType(irMethodCallExpression.getOwnersType(), irMethodCallExpression.getRoot())) {
            this.error("Owner type mismatch.  Owner is of type " + irMethodCallExpression.getOwnersType().getName() + " but root expression is of type " + irMethodCallExpression.getRoot().getType().getName() + ".  Error is in " + this.printElement((IRElement)irMethodCallExpression), (IRElement)irMethodCallExpression);
        }
        this.verifyIRExpression(irMethodCallExpression.getRoot());
        for (IRExpression arg : irMethodCallExpression.getArgs()) {
            this.verifyIRExpression(arg);
        }
    }

    private void verifyIRNullLiteral(IRNullLiteral irNullLiteral) {
    }

    private void verifyIRPrimitiveTypeConversion(IRPrimitiveTypeConversion irPrimitiveTypeConversion) {
        this.verifyIRExpression(irPrimitiveTypeConversion.getRoot());
    }

    private void verifyIRTernaryExpression(IRTernaryExpression irTernaryExpression) {
        if (!irTernaryExpression.getTest().getType().equals(IRTypeConstants.pBOOLEAN())) {
            this.error("Type mismatch for ternary test.  Must be of type boolean, but was of type " + irTernaryExpression.getTest().getType().getName(), (IRElement)irTernaryExpression);
        }
        if (!this.verifyExpressionIsOfType(irTernaryExpression.getType(), irTernaryExpression.getTrueValue())) {
            this.error("Type mismatch in ternary expression.  Overall expression is of type " + irTernaryExpression.getType().getName() + " but true expression is of type " + irTernaryExpression.getTrueValue().getType().getName(), (IRElement)irTernaryExpression);
        }
        if (!this.verifyExpressionIsOfType(irTernaryExpression.getType(), irTernaryExpression.getFalseValue())) {
            this.error("Type mismatch in ternary expression.  Overall expression is of type " + irTernaryExpression.getType().getName() + " but false expression is of type " + irTernaryExpression.getTrueValue().getType().getName(), (IRElement)irTernaryExpression);
        }
        this.verifyIRExpression(irTernaryExpression.getTest());
        this.verifyIRExpression(irTernaryExpression.getTrueValue());
        this.verifyIRExpression(irTernaryExpression.getFalseValue());
    }

    private void verifyIRFieldDecl(IRFieldDecl fieldDecl) {
    }

    private void verifyIRMethodStatement(IRMethodStatement methodStatement) {
        this._enclosingMethodStatement = methodStatement;
        try {
            this.verifyIRStatement(methodStatement.getMethodBody());
        }
        finally {
            this._enclosingMethodStatement = null;
        }
    }

    private String printElement(IRElement element) {
        IRTreeCompiler compiler = new IRTreeCompiler();
        compiler.compileIRElement(element, 0);
        return compiler.getOutput().toString();
    }

    private void error(String message, IRElement element) {
        String enclosingStatement = this.getEnclosingStatement(element);
        if (enclosingStatement != null) {
            message = "Error found near " + enclosingStatement + "\n" + (String)message;
        } else if (this._enclosingMethodStatement != null) {
            message = "Error found in " + this._enclosingClass.getName() + "." + this._enclosingMethodStatement.getName() + "\n" + (String)message;
        } else if (this._enclosingClass != null) {
            message = "Error found in " + this._enclosingClass.getName() + "\n" + (String)message;
        }
        this._errors.add((String)message);
    }

    private void verifyTypeAgreement(List<IRType> parameterTypes, List<IRExpression> arguments, IRElement element) {
        if (parameterTypes.size() != arguments.size()) {
            this.error("Argument number mismatch in " + this.printElement(element), element);
        } else {
            for (int i = 0; i < parameterTypes.size(); ++i) {
                IRExpression argument;
                IRType paramType = parameterTypes.get(i);
                if (this.verifyExpressionIsOfType(paramType, argument = arguments.get(i))) continue;
                this.error("Argument type mismatch.  Parameter is of type " + paramType.getName() + " but argument is of type " + argument.getType().getName() + ".  Error is in " + this.printElement(element), element);
            }
        }
    }

    private void verifyParentIsSet(IRElement element) {
        if (element.getParent() == null) {
            this.error("Null parent for element " + this.printElement(element), element);
        }
    }

    private boolean verifyExpressionIsOfType(IRType type, IRExpression expression) {
        boolean match;
        boolean bl = match = expression instanceof IRNullLiteral && !type.isPrimitive() || type.isAssignableFrom(expression.getType()) || this.isIntType(type) && this.isIntType(expression.getType());
        if (!match && expression instanceof IRCastExpression) {
            return this.verifyExpressionIsOfType(type, ((IRCastExpression)expression).getRoot());
        }
        return match;
    }

    private boolean isIntType(IRType type) {
        return type.isShort() || type.isChar() || type.isInt() || type.isByte();
    }

    private String getEnclosingStatement(IRElement originalElement) {
        for (IRElement element = originalElement; element != null; element = element.getParent()) {
            IRStatement statement;
            if (!(element instanceof IRStatement) || (statement = (IRStatement)element).getLineNumber() == -1 || statement.getOriginalSourceStatement() == null) continue;
            return statement.getOriginalSourceStatement();
        }
        return null;
    }
}

