/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.internal.gosu.ir.transform.AbstractElementTransformer;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.util.IRTypeResolver;
import gw.internal.gosu.parser.expressions.CollectionInitializerExpression;
import gw.internal.gosu.parser.expressions.NewExpression;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.parser.IExpression;
import gw.lang.parser.IParsedElement;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.JavaTypes;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CollectionInitializerExpressionTransformer
extends AbstractElementTransformer<CollectionInitializerExpression> {
    public static List<IRStatement> compile(TopLevelTransformationContext cc, CollectionInitializerExpression expr, IRExpression root) {
        CollectionInitializerExpressionTransformer gen = new CollectionInitializerExpressionTransformer(cc, expr);
        return gen.compile(root);
    }

    private CollectionInitializerExpressionTransformer(TopLevelTransformationContext cc, CollectionInitializerExpression expr) {
        super(cc, expr);
    }

    private List<IRStatement> compile(IRExpression root) {
        ArrayList<IRStatement> statements = new ArrayList<IRStatement>();
        Class collectionType = this.getCollectionType();
        for (IExpression e : ((CollectionInitializerExpression)this.getParsedElement()).getValues()) {
            IRExpression value = ExpressionTransformer.compile(e, this._cc());
            statements.add((IRStatement)this.buildMethodCall(this.callMethod(collectionType, "add", new Class[]{Object.class}, root, CollectionInitializerExpressionTransformer.exprList(value))));
        }
        return statements;
    }

    private Class getCollectionType() {
        Class<AbstractCollection> collectionType = Collection.class;
        IParsedElement parent = ((CollectionInitializerExpression)this.getParsedElement()).getParent();
        if (parent instanceof NewExpression) {
            Class<AbstractCollection> javaBackedClass;
            IType newType = ((NewExpression)parent).getType();
            IJavaClassInfo classInfo = IRTypeResolver.getJavaBackedClass(newType);
            Class<AbstractCollection> clazz = javaBackedClass = classInfo != null ? classInfo.getBackingClass() : null;
            if (classInfo != null && javaBackedClass != null) {
                collectionType = javaBackedClass;
            } else if (JavaTypes.getJreType(AbstractCollection.class).isAssignableFrom(newType)) {
                collectionType = AbstractCollection.class;
            }
        }
        return collectionType;
    }
}

