/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.internal.gosu.ir.nodes.IRTypeFactory;
import gw.internal.gosu.ir.nodes.JavaClassIRType;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.AbstractExpressionTransformer;
import gw.internal.gosu.parser.BeanAccess;
import gw.internal.gosu.parser.ErrorType;
import gw.internal.gosu.parser.ParserBase;
import gw.internal.gosu.parser.expressions.ConditionalExpression;
import gw.internal.gosu.parser.expressions.EqualityExpression;
import gw.internal.gosu.parser.expressions.NullExpression;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.ir.expression.IRCompositeExpression;
import gw.lang.ir.expression.IRConditionalAndExpression;
import gw.lang.ir.expression.IRConditionalOrExpression;
import gw.lang.ir.expression.IREqualityExpression;
import gw.lang.ir.expression.IRMethodCallExpression;
import gw.lang.ir.expression.IRNotExpression;
import gw.lang.ir.statement.IRAssignmentStatement;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.JavaTypes;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class EqualityExpressionTransformer
extends AbstractExpressionTransformer<EqualityExpression> {
    public static IRExpression compile(TopLevelTransformationContext cc, EqualityExpression expr) {
        EqualityExpressionTransformer gen = new EqualityExpressionTransformer(cc, expr);
        return gen.compile();
    }

    private EqualityExpressionTransformer(TopLevelTransformationContext cc, EqualityExpression expr) {
        super(cc, expr);
    }

    @Override
    protected IRExpression compile_impl() {
        IType lhsType = ((EqualityExpression)this._expr()).getLHS().getType();
        IType rhsType = ((EqualityExpression)this._expr()).getRHS().getType();
        if (((EqualityExpression)this._expr()).getLHS() instanceof NullExpression || ((EqualityExpression)this._expr()).getRHS() instanceof NullExpression) {
            return this.compareToNull();
        }
        if (lhsType.isPrimitive() && rhsType.isPrimitive()) {
            return this.comparePrimitives();
        }
        if (lhsType.isAssignableFrom(rhsType) && !lhsType.isDynamic() && !rhsType.isDynamic()) {
            if (lhsType.isArray()) {
                return this.compareArrays();
            }
            if ((JavaTypes.NUMBER().isAssignableFrom(lhsType) || JavaTypes.IDIMENSION().isAssignableFrom(lhsType)) && JavaTypes.COMPARABLE().isAssignableFrom(lhsType)) {
                return this.compareWithCompareTo();
            }
            return this.compareWithEquals();
        }
        IType type = ParserBase.resolveType(lhsType, 62, rhsType);
        if (!(type instanceof ErrorType) && (EqualityExpressionTransformer.isNumberType(type) || EqualityExpressionTransformer.isBigType(type))) {
            return this.compareNumbers(type);
        }
        return this.compareDynamically();
    }

    private IRExpression compareNumbers(IType type) {
        if (EqualityExpressionTransformer.isBigType(type)) {
            return this.compareNumbersAsBig(type);
        }
        type = type.isPrimitive() ? type : TypeSystem.getPrimitiveType((IType)type);
        return this.compareNumbersAsPrimitive(type);
    }

    private IRExpression compareNumbersAsPrimitive(IType type) {
        IRCompositeExpression nullCheckRhs;
        IRSymbol tempLhs = this._cc().makeAndIndexTempSymbol(EqualityExpressionTransformer.getDescriptor(((EqualityExpression)this._expr()).getLHS().getType()));
        IRAssignmentStatement tempLhsAssn = this.buildAssignment(tempLhs, ExpressionTransformer.compile(((EqualityExpression)this._expr()).getLHS(), this._cc()));
        IRSymbol tempRhs = this._cc().makeAndIndexTempSymbol(EqualityExpressionTransformer.getDescriptor(((EqualityExpression)this._expr()).getRHS().getType()));
        IRAssignmentStatement tempRhsAssn = this.buildAssignment(tempRhs, ExpressionTransformer.compile(((EqualityExpression)this._expr()).getRHS(), this._cc()));
        IRSymbol tempLhsRet = this._cc().makeAndIndexTempSymbol(EqualityExpressionTransformer.getDescriptor(type));
        IRAssignmentStatement lhsConversionAssn = this.convertOperandToPrimitive(type, ((EqualityExpression)this._expr()).getLHS().getType(), (IRExpression)this.identifier(tempLhs), tempLhsRet);
        IRSymbol tempRhsRet = this._cc().makeAndIndexTempSymbol(EqualityExpressionTransformer.getDescriptor(type));
        IRAssignmentStatement rhsConversionAssn = this.convertOperandToPrimitive(type, ((EqualityExpression)this._expr()).getRHS().getType(), (IRExpression)this.identifier(tempRhs), tempRhsRet);
        IRCompositeExpression compareExpr = this.buildComposite(new IRElement[]{lhsConversionAssn, rhsConversionAssn, new IREqualityExpression((IRExpression)this.identifier(tempLhsRet), (IRExpression)this.identifier(tempRhsRet), ((EqualityExpression)this._expr()).isEquals())});
        IRCompositeExpression iRCompositeExpression = ((EqualityExpression)this._expr()).getRHS().getType().isPrimitive() ? compareExpr : (nullCheckRhs = this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(tempRhs), this.nullLiteral()), (IRExpression)(((EqualityExpression)this._expr()).isEquals() ? (((EqualityExpression)this._expr()).getLHS().getType().isPrimitive() ? this.booleanLiteral(false) : this.buildEquals((IRExpression)this.identifier(tempLhs), this.nullLiteral())) : (((EqualityExpression)this._expr()).getLHS().getType().isPrimitive() ? this.booleanLiteral(true) : this.buildNotEquals((IRExpression)this.identifier(tempLhs), this.nullLiteral()))), (IRExpression)compareExpr, EqualityExpressionTransformer.getDescriptor(Boolean.TYPE)));
        IRCompositeExpression expr = ((EqualityExpression)this._expr()).getLHS().getType().isPrimitive() ? nullCheckRhs : this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(tempLhs), this.nullLiteral()), (IRExpression)(((EqualityExpression)this._expr()).isEquals() ? (((EqualityExpression)this._expr()).getRHS().getType().isPrimitive() ? this.booleanLiteral(false) : this.buildEquals((IRExpression)this.identifier(tempRhs), this.nullLiteral())) : (((EqualityExpression)this._expr()).getRHS().getType().isPrimitive() ? this.booleanLiteral(true) : this.buildNotEquals((IRExpression)this.identifier(tempRhs), this.nullLiteral()))), (IRExpression)nullCheckRhs, EqualityExpressionTransformer.getDescriptor(Boolean.TYPE));
        return this.buildComposite(new IRElement[]{tempLhsAssn, tempRhsAssn, expr});
    }

    private IRExpression compareNumbersAsBig(IType type) {
        Class bigClass = type == JavaTypes.BIG_DECIMAL() ? BigDecimal.class : BigInteger.class;
        IRSymbol tempLhs = this._cc().makeAndIndexTempSymbol(EqualityExpressionTransformer.getDescriptor(((EqualityExpression)this._expr()).getLHS().getType()));
        IRAssignmentStatement tempLhsAssn = this.buildAssignment(tempLhs, ExpressionTransformer.compile(((EqualityExpression)this._expr()).getLHS(), this._cc()));
        IRSymbol tempRhs = this._cc().makeAndIndexTempSymbol(EqualityExpressionTransformer.getDescriptor(((EqualityExpression)this._expr()).getRHS().getType()));
        IRAssignmentStatement tempRhsAssn = this.buildAssignment(tempRhs, ExpressionTransformer.compile(((EqualityExpression)this._expr()).getRHS(), this._cc()));
        IRSymbol tempLhsRet = this._cc().makeAndIndexTempSymbol(EqualityExpressionTransformer.getDescriptor(type));
        IRAssignmentStatement lhsConversionAssn = this.convertOperandToBig(type, bigClass, ((EqualityExpression)this._expr()).getLHS().getType(), (IRExpression)this.identifier(tempLhs), tempLhsRet);
        IRSymbol tempRhsRet = this._cc().makeAndIndexTempSymbol(EqualityExpressionTransformer.getDescriptor(type));
        IRAssignmentStatement rhsConversionAssn = this.convertOperandToBig(type, bigClass, ((EqualityExpression)this._expr()).getRHS().getType(), (IRExpression)this.identifier(tempRhs), tempRhsRet);
        IRCompositeExpression compareExpr = this.buildComposite(new IRElement[]{lhsConversionAssn, rhsConversionAssn, new IREqualityExpression(this.callMethod(bigClass, "compareTo", new Class[]{bigClass}, (IRExpression)this.identifier(tempLhsRet), Collections.singletonList(this.identifier(tempRhsRet))), this.pushConstant(0), ((EqualityExpression)this._expr()).isEquals())});
        IRCompositeExpression nullCheckRhs = ((EqualityExpression)this._expr()).getRHS().getType().isPrimitive() ? compareExpr : this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(tempRhs), this.nullLiteral()), this.booleanLiteral(false), (IRExpression)compareExpr, EqualityExpressionTransformer.getDescriptor(Boolean.TYPE));
        IRCompositeExpression expr = ((EqualityExpression)this._expr()).getLHS().getType().isPrimitive() ? nullCheckRhs : this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(tempLhs), this.nullLiteral()), this.booleanLiteral(false), (IRExpression)nullCheckRhs, EqualityExpressionTransformer.getDescriptor(Boolean.TYPE));
        return this.buildComposite(new IRElement[]{tempLhsAssn, tempRhsAssn, expr});
    }

    private IRExpression compareArrays() {
        IRExpression lhs = ExpressionTransformer.compile(((EqualityExpression)this._expr()).getLHS(), this._cc());
        IRExpression rhs = ExpressionTransformer.compile(((EqualityExpression)this._expr()).getRHS(), this._cc());
        IType lhsType = ((EqualityExpression)this._expr()).getLHS().getType();
        if (EqualityExpressionTransformer.isBytecodeType(lhsType)) {
            IRType arrayType = lhsType.getComponentType().isPrimitive() ? IRTypeFactory.get(lhsType) : JavaClassIRType.get(Object.class).getArrayType();
            IRMethodCallExpression equalsCall = this.buildMethodCall(JavaClassIRType.get(Arrays.class), "equals", false, JavaClassIRType.get(Boolean.TYPE), Arrays.asList(arrayType, arrayType), null, Arrays.asList(lhs, rhs));
            return ((EqualityExpression)this._expr()).isEquals() ? equalsCall : new IRNotExpression((IRExpression)equalsCall);
        }
        return this.compareDynamically();
    }

    private IRExpression comparePrimitives() {
        IRExpression lhs = ExpressionTransformer.compile(((EqualityExpression)this._expr()).getLHS(), this._cc());
        IRExpression rhs = ExpressionTransformer.compile(((EqualityExpression)this._expr()).getRHS(), this._cc());
        IType lhsType = ((EqualityExpression)this._expr()).getLHS().getType();
        IType rhsType = ((EqualityExpression)this._expr()).getRHS().getType();
        if (lhsType != JavaTypes.pBOOLEAN() && rhsType != JavaTypes.pBOOLEAN()) {
            IType type = ParserBase.resolveType(lhsType, 62, rhsType);
            lhs = this.numberConvert(((EqualityExpression)this._expr()).getLHS().getType(), type, lhs);
            rhs = this.numberConvert(((EqualityExpression)this._expr()).getRHS().getType(), type, rhs);
        }
        return new IREqualityExpression(lhs, rhs, ((EqualityExpression)this._expr()).isEquals());
    }

    private IRExpression compareToNull() {
        IRExpression lhs = ExpressionTransformer.compile(((EqualityExpression)this._expr()).getLHS(), this._cc());
        if (!(((EqualityExpression)this._expr()).getLHS() instanceof NullExpression)) {
            lhs = this.boxValue(((EqualityExpression)this._expr()).getLHS().getType(), lhs);
        }
        IRExpression rhs = ExpressionTransformer.compile(((EqualityExpression)this._expr()).getRHS(), this._cc());
        if (!(((EqualityExpression)this._expr()).getRHS() instanceof NullExpression)) {
            rhs = this.boxValue(((EqualityExpression)this._expr()).getRHS().getType(), rhs);
        }
        return new IREqualityExpression(lhs, rhs, ((EqualityExpression)this._expr()).isEquals());
    }

    private IRExpression compareWithEquals() {
        IRSymbol lhsTemp = this._cc().makeAndIndexTempSymbol(EqualityExpressionTransformer.getDescriptor((IType)JavaTypes.OBJECT()));
        IRAssignmentStatement tempLhsAssignment = this.buildAssignment(lhsTemp, ExpressionTransformer.compile(((EqualityExpression)this._expr()).getLHS(), this._cc()));
        IRSymbol rhsTemp = this._cc().makeAndIndexTempSymbol(EqualityExpressionTransformer.getDescriptor((IType)JavaTypes.OBJECT()));
        IRAssignmentStatement tempRhsAssignment = this.buildAssignment(rhsTemp, ExpressionTransformer.compile(((EqualityExpression)this._expr()).getRHS(), this._cc()));
        IRExpression callEquals = this.callMethod(Object.class, "equals", new Class[]{Object.class}, (IRExpression)this.identifier(lhsTemp), Collections.singletonList(this.identifier(rhsTemp)));
        IRConditionalOrExpression theExpr = new IRConditionalOrExpression((IRExpression)this.buildEquals((IRExpression)this.identifier(lhsTemp), (IRExpression)this.identifier(rhsTemp)), (IRExpression)new IRConditionalAndExpression((IRExpression)this.buildNotEquals((IRExpression)this.identifier(lhsTemp), this.nullLiteral()), (IRExpression)new IRConditionalAndExpression((IRExpression)this.buildNotEquals((IRExpression)this.identifier(rhsTemp), this.nullLiteral()), callEquals)));
        return this.buildComposite(new IRElement[]{tempLhsAssignment, tempRhsAssignment, ((EqualityExpression)this._expr()).isEquals() ? theExpr : new IRNotExpression((IRExpression)theExpr)});
    }

    private IRExpression compareWithCompareTo() {
        IType lhsType = ((EqualityExpression)this._expr()).getLHS().getType();
        IRType lhsIrType = EqualityExpressionTransformer.getDescriptor(lhsType);
        IRSymbol lhsTemp = this._cc().makeAndIndexTempSymbol(lhsIrType);
        IRAssignmentStatement tempLhsAssignment = this.buildAssignment(lhsTemp, ExpressionTransformer.compile(((EqualityExpression)this._expr()).getLHS(), this._cc()));
        IRSymbol rhsTemp = this._cc().makeAndIndexTempSymbol(EqualityExpressionTransformer.getDescriptor(((EqualityExpression)this._expr()).getRHS().getType()));
        IRAssignmentStatement tempRhsAssignment = this.buildAssignment(rhsTemp, ExpressionTransformer.compile(((EqualityExpression)this._expr()).getRHS(), this._cc()));
        IRMethodCallExpression callCompareTo = this.buildMethodCall(lhsIrType, "compareTo", lhsType.isInterface(), EqualityExpressionTransformer.getDescriptor(Integer.TYPE), Collections.singletonList(EqualityExpressionTransformer.getDescriptor(Object.class)), (IRExpression)this.identifier(lhsTemp), Collections.singletonList(this.identifier(rhsTemp)));
        IRConditionalOrExpression theExpr = new IRConditionalOrExpression((IRExpression)this.buildEquals((IRExpression)this.identifier(lhsTemp), (IRExpression)this.identifier(rhsTemp)), (IRExpression)new IRConditionalAndExpression((IRExpression)this.buildNotEquals((IRExpression)this.identifier(lhsTemp), this.nullLiteral()), (IRExpression)new IRConditionalAndExpression((IRExpression)this.buildNotEquals((IRExpression)this.identifier(rhsTemp), this.nullLiteral()), (IRExpression)this.buildEquals((IRExpression)callCompareTo, this.pushConstant(0)))));
        return this.buildComposite(new IRElement[]{tempLhsAssignment, tempRhsAssignment, ((EqualityExpression)this._expr()).isEquals() ? theExpr : new IRNotExpression((IRExpression)theExpr)});
    }

    private IRExpression compareDynamically() {
        IRSymbol lhsTemp = this._cc().makeAndIndexTempSymbol(EqualityExpressionTransformer.getDescriptor(Object.class));
        IRAssignmentStatement tempLhsAssignment = this.buildAssignment(lhsTemp, this.boxValue(((EqualityExpression)this._expr()).getLHS().getType(), ExpressionTransformer.compile(((EqualityExpression)this._expr()).getLHS(), this._cc())));
        IRSymbol rhsTemp = this._cc().makeAndIndexTempSymbol(EqualityExpressionTransformer.getDescriptor(Object.class));
        IRAssignmentStatement tempRhsAssignment = this.buildAssignment(rhsTemp, this.boxValue(((EqualityExpression)this._expr()).getRHS().getType(), ExpressionTransformer.compile(((EqualityExpression)this._expr()).getRHS(), this._cc())));
        ArrayList<IRExpression> args = new ArrayList<IRExpression>();
        args.add((IRExpression)this.identifier(lhsTemp));
        args.add(this.pushConstant(((EqualityExpression)this._expr()).isEquals()));
        args.add((IRExpression)this.identifier(rhsTemp));
        return this.buildComposite(new IRElement[]{tempLhsAssignment, tempRhsAssignment, this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(lhsTemp), (IRExpression)this.identifier(rhsTemp)), this.booleanLiteral(((EqualityExpression)this._expr()).isEquals()), this.callStaticMethod(EqualityExpressionTransformer.class, "evaluate", new Class[]{Object.class, Boolean.TYPE, Object.class}, args), EqualityExpressionTransformer.getDescriptor(Boolean.TYPE))});
    }

    public static boolean evaluate(Object lhsValue, boolean bEquals, Object rhsValue) {
        if (lhsValue == null && rhsValue == null) {
            return bEquals;
        }
        if (lhsValue == null || rhsValue == null) {
            return !bEquals;
        }
        IType lhsType = TypeSystem.getFromObject((Object)lhsValue);
        IType rhsType = TypeSystem.getFromObject((Object)rhsValue);
        boolean bValue = lhsValue != null && rhsValue != null && BeanAccess.isNumericType(lhsType) ? (ConditionalExpression.compareNumbers(lhsValue, rhsValue, lhsType, rhsType) == 0 ? Boolean.TRUE : Boolean.FALSE) : BeanAccess.areValuesEqual(lhsValue, rhsValue);
        return bEquals == bValue;
    }
}

