/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.ClassAnnotationInfo;
import gw.internal.gosu.parser.JavaMethodInfo;
import gw.internal.gosu.parser.TypeJavaClassType;
import gw.internal.gosu.parser.java.classinfo.JavaSourceUtil;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.java.IJavaAnnotatedElement;
import gw.lang.reflect.java.IJavaClassBytecodeConstructor;
import gw.lang.reflect.java.IJavaClassConstructor;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassType;
import gw.lang.reflect.java.Parameter;
import gw.lang.reflect.module.IModule;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConstructorJavaClassConstructor
implements IJavaClassConstructor,
IJavaClassBytecodeConstructor {
    private Constructor _ctor;
    private IModule _module;

    public ConstructorJavaClassConstructor(Constructor ctor, IModule module) {
        this._ctor = ctor;
        this._module = module;
    }

    public void setAccessible(boolean accessible) {
        this._ctor.setAccessible(accessible);
    }

    public Class getDeclaringJavaClass() {
        return this._ctor.getDeclaringClass();
    }

    public IJavaClassInfo[] getExceptionTypes() {
        Class<?>[] rawTypes = this._ctor.getExceptionTypes();
        IJavaClassInfo[] types = new IJavaClassInfo[rawTypes.length];
        for (int i = 0; i < rawTypes.length; ++i) {
            types[i] = JavaSourceUtil.getClassInfo(rawTypes[i], this._module);
        }
        return types;
    }

    public List<Parameter> getParameterInfos() {
        java.lang.reflect.Parameter[] params = this._ctor.getParameters();
        if (params != null) {
            ArrayList<Parameter> paramInfos = new ArrayList<Parameter>();
            for (int i = 0; i < params.length; ++i) {
                if (i == 0 && this.isNonstaticInnerClass()) continue;
                java.lang.reflect.Parameter p = params[i];
                paramInfos.add(new Parameter(p.isNamePresent() ? p.getName() : null, p.getModifiers()));
            }
            return paramInfos;
        }
        return Collections.emptyList();
    }

    public int getModifiers() {
        return this._ctor.getModifiers();
    }

    public boolean isSynthetic() {
        return this._ctor.isSynthetic();
    }

    public IParameterInfo[] convertGenericParameterTypes(IFeatureInfo container, TypeVarToTypeMap actualParamByVarName) {
        return JavaMethodInfo.convertGenericParameterTypes(container, actualParamByVarName, this.getGenericParameterTypes(), this.getEnclosingClass(), this.getParameterInfos());
    }

    private IJavaClassType[] getGenericParameterTypes() {
        Type[] rawTypes = this._ctor.getGenericParameterTypes();
        ArrayList<IJavaClassType> types = new ArrayList<IJavaClassType>();
        for (int i = 0; i < rawTypes.length; ++i) {
            if (i == 0 && this.isNonstaticInnerClass()) continue;
            types.add(TypeJavaClassType.createType(rawTypes[i], this._module));
        }
        return types.toArray(new IJavaClassType[0]);
    }

    private boolean isNonstaticInnerClass() {
        return this._ctor.getDeclaringClass().getEnclosingClass() != null && !Modifier.isStatic((int)this._ctor.getDeclaringClass().getModifiers());
    }

    public IJavaClassInfo[] getParameterTypes() {
        Class[] rawParamTypes = this.getJavaParameterTypes();
        IJavaClassInfo[] paramTypes = new IJavaClassInfo[rawParamTypes.length];
        for (int i = 0; i < rawParamTypes.length; ++i) {
            paramTypes[i] = JavaSourceUtil.getClassInfo(rawParamTypes[i], this._module);
        }
        return paramTypes;
    }

    public Class[] getJavaParameterTypes() {
        Class[] types = this._ctor.getParameterTypes();
        if (this.isNonstaticInnerClass()) {
            Class[] innerTypes = new Class[types.length - 1];
            System.arraycopy(types, 1, innerTypes, 0, innerTypes.length);
            types = innerTypes;
        }
        return types;
    }

    public Object newInstance(Object[] objects) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        return this._ctor.newInstance(objects);
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this._ctor.isAnnotationPresent(annotationClass);
    }

    public IAnnotationInfo getAnnotation(Class annotationClass) {
        Object annotation = this._ctor.getAnnotation(annotationClass);
        return annotation != null ? new ClassAnnotationInfo((Annotation)annotation, (IJavaAnnotatedElement)this) : null;
    }

    public IAnnotationInfo[] getDeclaredAnnotations() {
        Annotation[] annotations = this._ctor.getDeclaredAnnotations();
        IAnnotationInfo[] declaredAnnotations = new IAnnotationInfo[annotations.length];
        for (int i = 0; i < declaredAnnotations.length; ++i) {
            declaredAnnotations[i] = new ClassAnnotationInfo(annotations[i], (IJavaAnnotatedElement)this);
        }
        return declaredAnnotations;
    }

    public Constructor getJavaConstructor() {
        return this._ctor;
    }

    public IJavaClassInfo getEnclosingClass() {
        return JavaSourceUtil.getClassInfo(this._ctor.getDeclaringClass(), this._module);
    }
}

