/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.ExecutionMode;
import gw.internal.ext.org.objectweb.asm.ClassReader;
import gw.internal.ext.org.objectweb.asm.ClassVisitor;
import gw.internal.ext.org.objectweb.asm.ClassWriter;
import gw.internal.ext.org.objectweb.asm.Label;
import gw.internal.ext.org.objectweb.asm.MethodVisitor;
import gw.internal.ext.org.objectweb.asm.Type;
import gw.internal.ext.org.objectweb.asm.util.CheckClassAdapter;
import gw.internal.ext.org.objectweb.asm.util.TraceClassVisitor;
import gw.internal.gosu.parser.AbstractTypeRef;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.TypeRefException;
import gw.lang.GosuShop;
import gw.lang.reflect.IInjectableClassLoader;
import gw.lang.reflect.INonLoadableType;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeRef;
import gw.lang.reflect.ITypeRefFactory;
import gw.lang.reflect.RefreshKind;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuObject;
import gw.lang.reflect.java.IJavaBackedType;
import gw.util.Predicate;
import gw.util.cache.FqnCacheNode;
import gw.util.cache.WeakFqnCache;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TypeRefFactory
implements ITypeRefFactory {
    private static boolean TRACE = false;
    private static boolean VERIFY = false;
    private static boolean ASM_CHECKER = false;
    private static final int JAVA_VER = 49;
    private static final Map<Class<? extends IType>, Class<? extends AbstractTypeRef>> ITYPE_PROXY_CLASS_BY_ITYPE_CLASS = new HashMap<Class<? extends IType>, Class<? extends AbstractTypeRef>>();
    private final WeakFqnCache<AbstractTypeRef> _refByName = new WeakFqnCache();
    private boolean _bClearing;

    public ITypeRef create(IType type) {
        if (type instanceof ITypeRef) {
            return (ITypeRef)type;
        }
        if (type instanceof INonLoadableType) {
            throw new UnsupportedOperationException("Type references are not supported for nonloadable types: " + type.getName());
        }
        String strTypeName = TypeLord.getNameWithQualifiedTypeVariables(type, true);
        if (strTypeName == null || strTypeName.length() == 0) {
            throw new IllegalStateException("Type has no name");
        }
        ITypeRef ref = ExecutionMode.isRuntime() ? this.getRefTheFastWay(type, strTypeName) : this.getRefTheSafeWay(type, strTypeName);
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITypeRef getRefTheFastWay(IType type, String strTypeName) {
        AbstractTypeRef ref = this.getRef(this._refByName, strTypeName, type);
        if (ref == null) {
            TypeSystem.lock();
            try {
                ref = this.getRef(this._refByName, strTypeName, type);
                if (ref == null) {
                    ref = this.createTypeRefProxy(type);
                    TypeRefFactory.putRef(this._refByName, strTypeName, ref);
                    AbstractTypeRef abstractTypeRef = ref;
                    return abstractTypeRef;
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
        if (!type.isDiscarded()) {
            ref._setType(type);
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITypeRef getRefTheSafeWay(IType type, String strTypeName) {
        TypeSystem.lock();
        try {
            AbstractTypeRef ref = this.getRef(this._refByName, strTypeName, type);
            if (ref == null) {
                ref = this.createTypeRefProxy(type);
                TypeRefFactory.putRef(this._refByName, strTypeName, ref);
                AbstractTypeRef abstractTypeRef = ref;
                return abstractTypeRef;
            }
            if (!type.isDiscarded()) {
                ref._setType(type);
            }
            AbstractTypeRef abstractTypeRef = ref;
            return abstractTypeRef;
        }
        finally {
            TypeSystem.unlock();
        }
    }

    private AbstractTypeRef createTypeRefProxy(IType type) {
        Class<?> typeClass = type.getClass();
        try {
            Class<? extends AbstractTypeRef> proxyClass = this.getOrCreateTypeProxy(typeClass);
            AbstractTypeRef typeRef = proxyClass.newInstance();
            typeRef._setType(type);
            return typeRef;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Class<? extends AbstractTypeRef> getOrCreateTypeProxy(Class<? extends IType> typeClass) {
        Class<? extends AbstractTypeRef> proxyClass = ITYPE_PROXY_CLASS_BY_ITYPE_CLASS.get(typeClass);
        try {
            if (proxyClass == null) {
                proxyClass = this.generateProxyClass(typeClass);
                ITYPE_PROXY_CLASS_BY_ITYPE_CLASS.put(typeClass, proxyClass);
            }
            return proxyClass;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Class<? extends AbstractTypeRef> generateProxyClass(Class<? extends IType> typeClass) {
        ClassWriter writer;
        ClassWriter cv = writer = new ClassWriter(1);
        StringWriter trace = null;
        if (TRACE) {
            trace = new StringWriter();
            cv = new TraceClassVisitor((ClassVisitor)cv, new PrintWriter(trace));
            if (ASM_CHECKER) {
                cv = new CheckClassAdapter((ClassVisitor)cv);
            }
        }
        ArrayList<Class> interfaces = new ArrayList<Class>();
        this.getInterfacesFrom(typeClass, interfaces);
        String strProxyClassName = typeClass.getName() + "_Proxy";
        this.compileHeader((ClassVisitor)cv, strProxyClassName, interfaces);
        cv.visitSource(strProxyClassName, null);
        this.addDefaultConstructor((ClassVisitor)cv);
        this.compileInterfaceMembers((ClassVisitor)cv, typeClass);
        cv.visitEnd();
        if (TRACE) {
            System.out.println("========================================================================");
            System.out.println(strProxyClassName);
            System.out.println("========================================================================");
            System.out.println(trace);
        }
        byte[] bytes = writer.toByteArray();
        TypeRefFactory.verify(bytes);
        ClassLoader classLoader = typeClass.getClassLoader();
        if (classLoader instanceof IInjectableClassLoader) {
            return ((IInjectableClassLoader)classLoader).defineClass(strProxyClassName, bytes);
        }
        try {
            Method method = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
            return (Class)method.invoke((Object)classLoader, strProxyClassName, bytes, 0, bytes.length);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void compileHeader(ClassVisitor cv, String name, List<Class> interfaces) {
        cv.visit(49, 1, name.replace('.', '/'), null, this.getSlashName(AbstractTypeRef.class), this.getInterfaceNames(interfaces));
    }

    private String[] getInterfaceNames(List<Class> interfaces) {
        String[] interfaceNames = new String[interfaces.size()];
        for (int i = 0; i < interfaces.size(); ++i) {
            interfaceNames[i] = this.getSlashName(interfaces.get(i));
        }
        return interfaceNames;
    }

    private void addDefaultConstructor(ClassVisitor cv) {
        MethodVisitor mv = cv.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, this.getSlashName(AbstractTypeRef.class), "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
    }

    private void compileInterfaceMembers(ClassVisitor cv, Class typeClass) {
        for (Method rawMethod : typeClass.getMethods()) {
            Method ifaceMethod = this.getInterfaceMethod(rawMethod);
            if (ifaceMethod == rawMethod) continue;
            int nParameters = rawMethod.getParameterTypes().length;
            if (rawMethod.getName().equals("unloadTypeInfo") && nParameters == 0 || rawMethod.getName().equals("isStale") && nParameters == 0 || rawMethod.getName().equals("readResolve") && nParameters == 0) continue;
            this.genMethod_DevMode(cv, ifaceMethod, rawMethod);
        }
    }

    private void genMethod_DevMode(ClassVisitor cv, Method ifaceMethod, Method proxyMethod) {
        int modifiers = proxyMethod.getModifiers();
        if (proxyMethod.isSynthetic() || proxyMethod.isBridge()) {
            modifiers |= 0x40;
        }
        MethodVisitor mv = cv.visitMethod(modifiers, proxyMethod.getName(), this.getMethodDescriptor(proxyMethod), null, this.getMethodExceptions(proxyMethod));
        mv.visitCode();
        if (ifaceMethod.getName().equals("getName")) {
            this.insertGetNameStart(mv);
        }
        this.genBody_SupportRefresh(ifaceMethod, proxyMethod, mv);
        if (ifaceMethod.getReturnType().getName().equals(Void.TYPE.getSimpleName())) {
            mv.visitInsn(177);
        } else {
            mv.visitInsn(this.getIns(172, ifaceMethod.getReturnType().getName()));
        }
        mv.visitMaxs(0, 0);
    }

    private void genBody_NoRefreshSupport(Method ifaceMethod, Method proxyMethod, MethodVisitor mv) {
        int iLastParamIndex = ifaceMethod.getParameterTypes().length + 1;
        int typeIndex = iLastParamIndex + 1;
        this.assignType_FromField(ifaceMethod, mv, typeIndex);
        this.delegateMethodCall(ifaceMethod, proxyMethod, mv, typeIndex);
    }

    private void genBody_SupportRefresh(Method ifaceMethod, Method proxyMethod, MethodVisitor mv) {
        int iLastParamIndex = ifaceMethod.getParameterTypes().length + 1;
        int typeIndex = iLastParamIndex + 1;
        int classCastExceptionIndex = iLastParamIndex + 2;
        Label tryLabel = new Label();
        Label catchLabel = new Label();
        Label tryEndLabel = new Label();
        Label endLabel = new Label();
        mv.visitTryCatchBlock(tryLabel, tryEndLabel, catchLabel, this.getSlashName(ClassCastException.class));
        this.visitDebugLineNumber(1, mv);
        mv.visitLabel(tryLabel);
        this.assignType(ifaceMethod, mv, typeIndex);
        mv.visitLabel(tryEndLabel);
        mv.visitJumpInsn(167, endLabel);
        mv.visitLabel(catchLabel);
        this.constructRuntimeException(mv, classCastExceptionIndex);
        mv.visitInsn(191);
        mv.visitLabel(endLabel);
        this.visitDebugLineNumber(2, mv);
        this.delegateMethodCall(ifaceMethod, proxyMethod, mv, typeIndex);
        this.visitDebugLineNumber(3, mv);
    }

    private void visitDebugLineNumber(int iLine, MethodVisitor mv) {
        Label dbgLabel = new Label();
        mv.visitLabel(dbgLabel);
        mv.visitLineNumber(iLine, dbgLabel);
    }

    private void insertGetNameStart(MethodVisitor mv) {
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.getSlashName(AbstractTypeRef.class), "_getTypeNameInternal", "()Ljava/lang/String;");
        Label afterIf = new Label();
        mv.visitJumpInsn(198, afterIf);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.getSlashName(AbstractTypeRef.class), "_getTypeNameInternal", "()Ljava/lang/String;");
        mv.visitInsn(this.getIns(172, String.class));
        mv.visitLabel(afterIf);
    }

    private void call_reload(MethodVisitor mv) {
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.getSlashName(AbstractTypeRef.class), "_reload", "()V");
    }

    private void assignType(Method ifaceMethod, MethodVisitor mv, int typeIndex) {
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.getSlashName(AbstractTypeRef.class), "_getType", "()Lgw/lang/reflect/IType;");
        mv.visitTypeInsn(192, this.getSlashName(ifaceMethod.getDeclaringClass()));
        mv.visitVarInsn(58, typeIndex);
    }

    private void assignType_FromField(Method ifaceMethod, MethodVisitor mv, int typeIndex) {
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.getSlashName(AbstractTypeRef.class), "_type", "Lgw/lang/reflect/IType;");
        mv.visitTypeInsn(192, this.getSlashName(ifaceMethod.getDeclaringClass()));
        mv.visitVarInsn(58, typeIndex);
    }

    private void constructRuntimeException(MethodVisitor mv, int exceptionIndex) {
        mv.visitVarInsn(58, exceptionIndex);
        mv.visitTypeInsn(187, this.getSlashName(TypeRefException.class));
        mv.visitInsn(89);
        mv.visitTypeInsn(187, this.getSlashName(StringBuilder.class));
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)"Type interface changed.  Expected gw.internal.gosu.parser.IGosuClassInternal for ");
        mv.visitMethodInsn(183, this.getSlashName(StringBuilder.class), "<init>", "(Ljava/lang/String;)V");
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.getSlashName(AbstractTypeRef.class), "_getTypeNameInternal", "()Ljava/lang/String;");
        mv.visitMethodInsn(182, this.getSlashName(StringBuilder.class), "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        mv.visitMethodInsn(182, this.getSlashName(StringBuilder.class), "toString", "()Ljava/lang/String;");
        mv.visitVarInsn(25, exceptionIndex);
        mv.visitMethodInsn(183, this.getSlashName(TypeRefException.class), "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V");
    }

    private void delegateMethodCall(Method ifaceMethod, Method proxyMethod, MethodVisitor mv, int typeIndex) {
        mv.visitVarInsn(25, typeIndex);
        for (int i = 0; i < ifaceMethod.getParameterTypes().length; ++i) {
            mv.visitVarInsn(this.getIns(21, ifaceMethod.getParameterTypes()[i].getName()), i + 1);
        }
        this.callMethod(mv, ifaceMethod);
        if (!ifaceMethod.getReturnType().isPrimitive()) {
            mv.visitTypeInsn(192, this.getSlashName(proxyMethod.getReturnType().getName()));
        }
    }

    private boolean isTypeGosuClassInstance(Class<?> declaringClass) {
        return IGosuObject.class.isAssignableFrom(declaringClass) && TypeSystem.getByFullNameIfValid((String)declaringClass.getName().replace('$', '.')) instanceof IGosuClass;
    }

    private Method getInterfaceMethod(Method method) {
        Class declaringClass = method.getDeclaringClass();
        do {
            if (this.isTypeGosuClassInstance(declaringClass)) {
                String gosuClassName = IGosuClass.ProxyUtil.getNameSansProxy((String)declaringClass.getName());
                IGosuClassInternal gosuClass = (IGosuClassInternal)TypeSystem.getByFullNameIfValid((String)gosuClassName);
                if (gosuClass == null) {
                    return method;
                }
                for (IType iface : gosuClass.getInterfaces()) {
                    Class ifaceClass = this.getJavaClass(iface);
                    if (ifaceClass == null) continue;
                    try {
                        method = ifaceClass.getMethod(method.getName(), method.getParameterTypes());
                        return this.getInterfaceMethod(method);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                IType supertype = gosuClass.getSupertype();
                declaringClass = this.getJavaClass(supertype);
                continue;
            }
            for (Class<?> iface : declaringClass.getInterfaces()) {
                try {
                    method = iface.getMethod(method.getName(), method.getParameterTypes());
                    return this.getInterfaceMethod(method);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
            declaringClass = declaringClass.getSuperclass();
        } while (declaringClass != null);
        return method;
    }

    public ITypeRef get(IType type) {
        if (type instanceof ITypeRef) {
            return (ITypeRef)type;
        }
        if (type instanceof INonLoadableType) {
            throw new UnsupportedOperationException("Type references are not supported for nonloadable types: " + type.getName());
        }
        String strTypeName = TypeLord.getNameWithQualifiedTypeVariables(type, true);
        if (strTypeName == null || strTypeName.length() == 0) {
            throw new IllegalStateException("Type has no name");
        }
        return this.getRef(this._refByName, strTypeName, type);
    }

    public ITypeRef get(String strTypeName) {
        return this.getRef(this._refByName, strTypeName, null);
    }

    public void clearCaches() {
        this.setClearing(true);
        TypeSystem.lock();
        try {
            this._refByName.visitDepthFirst((Predicate)new Predicate<AbstractTypeRef>(){

                public boolean evaluate(AbstractTypeRef typeRef) {
                    if (typeRef != null) {
                        typeRef._setStale(RefreshKind.MODIFICATION);
                    }
                    return true;
                }
            });
            this._refByName.visitNodeDepthFirst((Predicate)new Predicate<FqnCacheNode>(){

                public boolean evaluate(FqnCacheNode node) {
                    AbstractTypeRef typeRef;
                    Reference ref = (Reference)node.getUserData();
                    if (ref != null && (typeRef = (AbstractTypeRef)ref.get()) == null) {
                        node.delete();
                    }
                    return true;
                }
            });
        }
        finally {
            TypeSystem.unlock();
            this.setClearing(false);
        }
    }

    private int computeSortIndex(Map.Entry<String, Reference<AbstractTypeRef>> entry) {
        AbstractTypeRef ref = entry.getValue().get();
        return ref != null ? ref._getIndexForSortingFast(entry.getKey()) : 10000;
    }

    private void setClearing(boolean bClearing) {
        this._bClearing = bClearing;
    }

    public boolean isClearing() {
        return this._bClearing;
    }

    private void getInterfacesFrom(Class<? extends IType> classOfType, List<Class> interfaces) {
        if (this.isTypeGosuClassInstance(classOfType)) {
            Class ifaceClass;
            String gosuClassName = IGosuClass.ProxyUtil.getNameSansProxy((String)classOfType.getName());
            IGosuClassInternal gosuClass = (IGosuClassInternal)TypeSystem.getByFullName((String)gosuClassName);
            for (IType iface : gosuClass.getInterfaces()) {
                Class ifaceClass2 = this.getJavaClass(iface);
                if (ifaceClass2 == null || interfaces.contains(ifaceClass2)) continue;
                interfaces.add(ifaceClass2);
            }
            IType supertype = gosuClass.getSupertype();
            if (supertype != null && (ifaceClass = this.getJavaClass(supertype)) != null) {
                this.getInterfacesFrom(ifaceClass, interfaces);
            }
        } else {
            for (Class<?> iface : classOfType.getInterfaces()) {
                if (interfaces.contains(iface)) continue;
                interfaces.add(iface);
            }
            Class<? extends IType> superClass = classOfType.getSuperclass();
            if (superClass != null) {
                this.getInterfacesFrom(superClass, interfaces);
            }
        }
    }

    private Class getJavaClass(IType iface) {
        Class ifaceClass = null;
        if (iface instanceof IGosuClass) {
            ifaceClass = ((IGosuClass)iface).getBackingClass();
        } else if (iface instanceof IJavaBackedType) {
            ifaceClass = ((IJavaBackedType)iface).getBackingClass();
        }
        return ifaceClass;
    }

    private static void putRef(WeakFqnCache<AbstractTypeRef> map, String key, AbstractTypeRef value) {
        map.add(key, (Object)value);
    }

    private AbstractTypeRef getRef(WeakFqnCache<AbstractTypeRef> map, String key, IType type) {
        AbstractTypeRef typeRef = (AbstractTypeRef)map.get(key);
        if (typeRef == null) {
            return null;
        }
        if (type != null && !typeRef.getClass().getName().startsWith(type.getClass().getName())) {
            return null;
        }
        return typeRef;
    }

    private int getIns(int opcode, Class type) {
        if (opcode == 89) {
            return this.isWide(type) ? 92 : opcode;
        }
        if (opcode == 87) {
            return this.isWide(type) ? 88 : opcode;
        }
        switch (opcode) {
            case 21: 
            case 46: 
            case 54: 
            case 79: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 116: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 172: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Opcode: " + Integer.toHexString(opcode) + " is not handled");
            }
        }
        if (type == Byte.TYPE) {
            return Type.BYTE_TYPE.getOpcode(opcode);
        }
        if (type == Character.TYPE) {
            return Type.CHAR_TYPE.getOpcode(opcode);
        }
        if (type == Short.TYPE) {
            return Type.SHORT_TYPE.getOpcode(opcode);
        }
        if (type == Boolean.TYPE) {
            return Type.BOOLEAN_TYPE.getOpcode(opcode);
        }
        if (type == Integer.TYPE) {
            return Type.INT_TYPE.getOpcode(opcode);
        }
        if (type == Long.TYPE) {
            return Type.LONG_TYPE.getOpcode(opcode);
        }
        if (type == Float.TYPE) {
            return Type.FLOAT_TYPE.getOpcode(opcode);
        }
        if (type == Double.TYPE) {
            return Type.DOUBLE_TYPE.getOpcode(opcode);
        }
        return Type.getType(Object.class).getOpcode(opcode);
    }

    private int getIns(int opcode, String typeName) {
        if (opcode == 89) {
            return this.isWide(typeName) ? 92 : opcode;
        }
        if (opcode == 87) {
            return this.isWide(typeName) ? 88 : opcode;
        }
        switch (opcode) {
            case 21: 
            case 46: 
            case 54: 
            case 79: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 116: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 172: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Opcode: " + Integer.toHexString(opcode) + " is not handled");
            }
        }
        if (typeName.equals("byte")) {
            return Type.BYTE_TYPE.getOpcode(opcode);
        }
        if (typeName.equals("char")) {
            return Type.CHAR_TYPE.getOpcode(opcode);
        }
        if (typeName.equals("short")) {
            return Type.SHORT_TYPE.getOpcode(opcode);
        }
        if (typeName.equals("boolean")) {
            return Type.BOOLEAN_TYPE.getOpcode(opcode);
        }
        if (typeName.equals("int")) {
            return Type.INT_TYPE.getOpcode(opcode);
        }
        if (typeName.equals("long")) {
            return Type.LONG_TYPE.getOpcode(opcode);
        }
        if (typeName.equals("float")) {
            return Type.FLOAT_TYPE.getOpcode(opcode);
        }
        if (typeName.equals("double")) {
            return Type.DOUBLE_TYPE.getOpcode(opcode);
        }
        return Type.getType(Object.class).getOpcode(opcode);
    }

    private boolean isWide(Class type) {
        return type == Long.TYPE || type == Double.TYPE;
    }

    private boolean isWide(String typeName) {
        return typeName.equals("long") || typeName.equals("double");
    }

    private String getSlashName(Class type) {
        return this.getSlashName(type.getName());
    }

    private String getSlashName(String typeName) {
        return typeName.replace('.', '/');
    }

    private String[] getParameterTypeDescriptors(Method _method) {
        Class<?>[] paramTypes = _method.getParameterTypes();
        String[] paramDescriptors = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramDescriptors[i] = this.getDescriptor(paramTypes[i]);
        }
        return paramDescriptors;
    }

    private String getReturnTypeDescriptor(Method _method) {
        Class<?> returnType = _method.getReturnType();
        return this.getDescriptor(returnType);
    }

    private String getDescriptor(Class<?> returnType) {
        String name = returnType.getName();
        if (!name.startsWith("[")) {
            name = GosuShop.toSignature((String)name);
        }
        name = name.replace('.', '/');
        return name;
    }

    private String getMethodDescriptor(Method m) {
        return this.getMethodDescriptor(this.getParameterTypeDescriptors(m), this.getReturnTypeDescriptor(m));
    }

    private String getMethodDescriptor(String[] paramTypeDescriptors, String returnTypeDescriptor) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (String paramTypeDescriptor : paramTypeDescriptors) {
            sb.append(paramTypeDescriptor);
        }
        sb.append(')').append(returnTypeDescriptor);
        return sb.toString();
    }

    private String[] getMethodExceptions(Method method) {
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        if (exceptionTypes == null || exceptionTypes.length == 0) {
            return null;
        }
        String[] exceptionTypeNames = new String[exceptionTypes.length];
        for (int i = 0; i < exceptionTypes.length; ++i) {
            exceptionTypeNames[i] = this.getSlashName(exceptionTypes[i]);
        }
        return exceptionTypeNames;
    }

    private void callMethod(MethodVisitor mv, Method method) {
        int opCode = Modifier.isStatic(method.getModifiers()) ? 184 : (method.getDeclaringClass().isInterface() ? 185 : 182);
        mv.visitMethodInsn(opCode, this.getSlashName(method.getDeclaringClass()), method.getName(), this.getMethodDescriptor(method));
    }

    private static void verify(byte[] bytes) {
        if (VERIFY) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            CheckClassAdapter.verify((ClassReader)new ClassReader(bytes), (boolean)false, (PrintWriter)pw);
            String out = sw.toString();
            if (out.length() > 0) {
                System.out.println(out);
            }
        }
    }

    public List<ITypeRef> getSubordinateRefs(String topLevelTypeName) {
        FqnCacheNode node = this._refByName.getNode(topLevelTypeName);
        final ArrayList<ITypeRef> types = new ArrayList<ITypeRef>();
        if (node != null) {
            node.visitNodeDepthFirst((Predicate)new Predicate<FqnCacheNode>(){

                public boolean evaluate(FqnCacheNode node) {
                    AbstractTypeRef typeRef;
                    Reference ref = (Reference)node.getUserData();
                    if (ref != null && (typeRef = (AbstractTypeRef)ref.get()) != null) {
                        types.add(typeRef);
                    }
                    return true;
                }
            });
        }
        return types;
    }

    public List<String> getTypesWithPrefix(String namespace, final String prefix) {
        FqnCacheNode node = this._refByName.getNode(namespace);
        final ArrayList<String> types = new ArrayList<String>();
        if (node != null) {
            node.visitNodeDepthFirst((Predicate)new Predicate<FqnCacheNode>(){

                public boolean evaluate(FqnCacheNode node) {
                    AbstractTypeRef typeRef;
                    Reference ref;
                    if (node.getName().startsWith(prefix) && (ref = (Reference)node.getUserData()) != null && (typeRef = (AbstractTypeRef)ref.get()) != null) {
                        types.add(node.getFqn());
                    }
                    return true;
                }
            });
        }
        return types;
    }
}

