/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.compiler.protocols.gosuclass;

import gw.fs.IFile;
import gw.internal.gosu.compiler.GosuClassLoader;
import gw.internal.gosu.compiler.SingleServingGosuClassLoader;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.java.compiler.JavaParser;
import gw.lang.javac.ClassJavaFileObject;
import gw.lang.javac.JavaCompileIssuesException;
import gw.lang.parser.ILanguageLevel;
import gw.lang.reflect.IHasJavaClass;
import gw.lang.reflect.IInjectableClassLoader;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.GosuClassPathThing;
import gw.lang.reflect.gs.ICompilableType;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.java.IJavaBackedType;
import gw.lang.reflect.module.IModule;
import gw.lang.reflect.module.TypeSystemLockHelper;
import gw.util.GosuExceptionUtil;
import gw.util.Pair;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Arrays;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;

public class GosuClassesUrlConnection
extends URLConnection {
    private static final String[] JAVA_NAMESPACES_TO_IGNORE = new String[]{"java/", "javax/", "sun/"};
    private static final String META_INF_MANIFEST_MF = "META-INF/MANIFEST.MF";
    private ICompilableType _type;
    private JavaFileObject _javaSrcFile;
    private String _javaFqn;
    private ClassLoader _loader;
    private boolean _bDirectory;
    private boolean _bInvalid;
    private static Method _findResource = null;

    public GosuClassesUrlConnection(URL url) {
        super(url);
    }

    @Override
    public void connect() throws IOException {
        if (this._bInvalid) {
            throw new IOException();
        }
        this.connectImpl();
        if (this._bInvalid) {
            throw new IOException();
        }
    }

    private boolean connectImpl() {
        if (this._bInvalid) {
            return false;
        }
        if (this._type == null && this._javaSrcFile == null && !this._bDirectory) {
            String strPath = URLDecoder.decode(this.getURL().getPath());
            String strClass = strPath.substring(1);
            if (this.isManifest(strClass)) {
                return true;
            }
            if (!this.ignoreJavaClass(strClass)) {
                String strType = strClass.replace('/', '.');
                int iIndexClass = strType.lastIndexOf(".class");
                if (iIndexClass > 0) {
                    strType = strType.substring(0, iIndexClass).replace('$', '.');
                    this.maybeAssignGosuType(this.findClassLoader(this.getURL().getHost()), strType);
                } else if (strPath.endsWith("/")) {
                    this._bDirectory = true;
                }
            }
            this._bInvalid = this._type == null && this._javaSrcFile == null && !this._bDirectory;
        }
        return !this._bInvalid;
    }

    private boolean isManifest(String strClass) {
        return strClass.equalsIgnoreCase(META_INF_MANIFEST_MF);
    }

    private ClassLoader findClassLoader(String host) {
        int identityHash = Integer.parseInt(host);
        for (ClassLoader loader = TypeSystem.getGosuClassLoader().getActualLoader(); loader != null; loader = loader.getParent()) {
            if (System.identityHashCode(loader) != identityHash) continue;
            return loader;
        }
        throw new IllegalStateException("Can't find ClassLoader with identity hash: " + identityHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeAssignGosuType(ClassLoader loader, String strType) {
        if (strType.contains("__Program__eval_")) {
            return;
        }
        TypeSystemLockHelper.getTypeSystemLockWithMonitor((Object)loader);
        try {
            IType type;
            IModule global = TypeSystem.getGlobalModule();
            TypeSystem.pushModule((IModule)global);
            try {
                Pair<JavaFileObject, String> pair;
                type = TypeSystem.getByFullNameIfValidNoJava((String)strType);
                if (type == null && ILanguageLevel.Util.STANDARD_GOSU() && (pair = JavaParser.instance().findJavaSource(strType)) != null) {
                    this._javaSrcFile = (JavaFileObject)pair.getFirst();
                    this._javaFqn = strType;
                    this._loader = loader;
                }
            }
            finally {
                TypeSystem.popModule((IModule)global);
            }
            if (type instanceof ICompilableType && !this.isInSingleServingLoader(type.getEnclosingType())) {
                if (!GosuClassPathThing.canWrapChain()) {
                    if (!this.hasClassFileOnDiskInParentLoaderPath(loader, type)) {
                        this._type = (ICompilableType)type;
                        this._loader = loader;
                    }
                } else {
                    this.handleChainedLoading(loader, (ICompilableType)type);
                }
            }
        }
        catch (Exception e) {
            throw GosuExceptionUtil.forceThrow((Throwable)e, (String)("Type: " + strType));
        }
        finally {
            TypeSystem.unlock();
        }
    }

    private boolean hasClassFileOnDiskInParentLoaderPath(ClassLoader loader, IType type) {
        if (!(loader instanceof IInjectableClassLoader)) {
            return false;
        }
        ClassLoader parent = loader.getParent();
        while (parent instanceof IInjectableClassLoader) {
            parent = parent.getParent();
        }
        IType outer = TypeLord.getOuterMostEnclosingClass(type);
        try {
            parent.loadClass(outer.getName());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void handleChainedLoading(ClassLoader loader, ICompilableType type) {
        String ext = this.getFileExt(type);
        if (ext == null) {
            if (loader == TypeSystem.getGosuClassLoader().getActualLoader() || type.getSourceFileHandle().isIncludeModulePath()) {
                this._type = type;
                this._loader = loader;
            }
        } else if (this.isResourceInLoader(loader, ext)) {
            this._type = type;
            this._loader = loader;
        }
    }

    private String loaderChain(ClassLoader loader) {
        if (loader == null) {
            return "<null>";
        }
        return loader.getClass().getName() + " -> " + this.loaderChain(loader.getParent());
    }

    private String getFileExt(ICompilableType type) {
        while (type instanceof ICompilableType) {
            ISourceFileHandle sfh = type.getSourceFileHandle();
            IFile file = sfh.getFile();
            if (file != null) {
                if (!sfh.isStandardPath()) {
                    return null;
                }
                return '.' + file.getExtension();
            }
            type = type.getEnclosingType();
        }
        return null;
    }

    private boolean isResourceInLoader(ClassLoader loader, String ext) {
        String strPath = URLDecoder.decode(this.getURL().getPath());
        int iIndex = (strPath = strPath.substring(1)).indexOf("$");
        int n = iIndex = iIndex < 0 ? strPath.lastIndexOf(".class") : iIndex;
        if (iIndex > 0) {
            strPath = strPath.substring(0, iIndex) + ext;
        }
        if (loader instanceof URLClassLoader) {
            return ((URLClassLoader)loader).findResource(strPath) != null;
        }
        try {
            if (_findResource == null) {
                _findResource = ClassLoader.class.getDeclaredMethod("findResource", String.class);
            }
            return _findResource.invoke((Object)loader, strPath) != null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isInSingleServingLoader(IType type) {
        if (type instanceof IJavaBackedType) {
            return ((IJavaBackedType)type).getBackingClass().getClassLoader() instanceof SingleServingGosuClassLoader;
        }
        if (type instanceof IHasJavaClass) {
            return ((IHasJavaClass)type).getBackingClass().getClassLoader() instanceof SingleServingGosuClassLoader;
        }
        return false;
    }

    private boolean ignoreJavaClass(String strClass) {
        for (String namespace : JAVA_NAMESPACES_TO_IGNORE) {
            if (!strClass.startsWith(namespace)) continue;
            return true;
        }
        return false;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this._type != null || this._javaSrcFile != null) {
            return new LazyByteArrayInputStream();
        }
        if (this._bDirectory) {
            return new ByteArrayInputStream(new byte[0]);
        }
        if (this.getURL().getPath().toUpperCase().endsWith(META_INF_MANIFEST_MF)) {
            return new ByteArrayInputStream(new byte[0]);
        }
        throw new IOException("Invalid or missing Gosu class for: " + this.url.toString());
    }

    public boolean isValid() {
        return this.connectImpl();
    }

    class LazyByteArrayInputStream
    extends InputStream {
        protected byte[] _buf;
        protected int _pos;
        protected int _mark;
        protected int _count;

        LazyByteArrayInputStream() {
        }

        private void init() {
            if (this._buf == null) {
                TypeSystemLockHelper.getTypeSystemLockWithMonitor((Object)GosuClassesUrlConnection.this._loader);
                try {
                    if (GosuClassesUrlConnection.this._type != null) {
                        this._buf = GosuClassLoader.instance().getBytes(GosuClassesUrlConnection.this._type);
                    } else if (GosuClassesUrlConnection.this._javaSrcFile != null) {
                        this._buf = this.compileJavaClass();
                    }
                    this._pos = 0;
                    this._count = this._buf.length;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    throw GosuExceptionUtil.forceThrow((Throwable)e);
                }
                finally {
                    TypeSystem.unlock();
                }
            }
        }

        private byte[] compileJavaClass() {
            DiagnosticCollector<JavaFileObject> errorHandler = new DiagnosticCollector<JavaFileObject>();
            ClassJavaFileObject cls = JavaParser.instance().compile(GosuClassesUrlConnection.this._javaFqn, Arrays.asList("-nowarn", "-Xlint:none", "-proc:none", "-parameters"), errorHandler);
            if (cls != null) {
                return cls.getBytes();
            }
            throw new JavaCompileIssuesException(errorHandler);
        }

        @Override
        public int read() {
            this.init();
            return this._pos < this._count ? this._buf[this._pos++] & 0xFF : -1;
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.init();
            return super.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) {
            this.init();
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (this._pos >= this._count) {
                return -1;
            }
            if (this._pos + len > this._count) {
                len = this._count - this._pos;
            }
            if (len <= 0) {
                return 0;
            }
            System.arraycopy(this._buf, this._pos, b, off, len);
            this._pos += len;
            return len;
        }

        @Override
        public long skip(long n) {
            if ((long)this._pos + n > (long)this._count) {
                n = this._count - this._pos;
            }
            if (n < 0L) {
                return 0L;
            }
            this._pos = (int)((long)this._pos + n);
            return n;
        }

        @Override
        public int available() {
            this.init();
            return this._count - this._pos;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readAheadLimit) {
            this._mark = this._pos;
        }

        @Override
        public void reset() {
            this._pos = this._mark;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

