/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.nodes;

import gw.internal.gosu.ir.transform.AbstractElementTransformer;
import gw.internal.gosu.ir.transform.util.IRTypeResolver;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.IGosuTemplateInternal;
import gw.internal.gosu.parser.JavaFieldPropertyInfo;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.statements.VarStatement;
import gw.lang.ir.IRType;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.LazyTypeResolver;
import gw.lang.reflect.gs.IExternalSymbolMap;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.java.IJavaFieldPropertyInfo;
import gw.lang.reflect.java.IJavaType;
import java.util.ArrayList;
import java.util.List;

public class IRFeatureBase {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IRType maybeReifyFieldType(IType owner, String name, IType originalType) {
        if (!owner.isParameterizedType()) return IRTypeResolver.getDescriptor(originalType);
        if (owner instanceof IGosuClassInternal) {
            IType reifiedOwner = TypeLord.getDefaultParameterizedType(owner.getGenericType());
            if (IGosuClass.ProxyUtil.isProxy((IType)reifiedOwner)) {
                return this.getBoundedFieldTypeFromProxiedClass((IGosuClass)reifiedOwner, name);
            }
            VarStatement field = ((IGosuClassInternal)reifiedOwner).getMemberField(name);
            if (field != null) return IRTypeResolver.getDescriptor(field.getType());
            field = ((IGosuClassInternal)reifiedOwner).getStaticField(name);
            return IRTypeResolver.getDescriptor(field.getType());
        }
        if (!(owner instanceof IJavaType)) throw new IllegalArgumentException("Cannot reify field for type " + owner.getName() + " whose metatype is " + owner.getClass());
        IJavaType javaType = (IJavaType)owner;
        return this.getFieldType(name, javaType);
    }

    private IRType getBoundedFieldTypeFromProxiedClass(IGosuClass gsClass, String name) {
        IJavaType javaType = (IJavaType)IGosuClass.ProxyUtil.getProxiedType((IType)gsClass);
        return this.getFieldType(name, javaType);
    }

    private IRType getFieldType(String name, IJavaType javaType) {
        JavaFieldPropertyInfo jpi;
        if ((javaType = (IJavaType)TypeLord.getDefaultParameterizedType((IType)javaType)) != (jpi = (JavaFieldPropertyInfo)((IRelativeTypeInfo)javaType.getTypeInfo()).getProperty((IType)javaType, (CharSequence)name)).getOwnersType()) {
            return this.getFieldType(name, (IJavaType)jpi.getOwnersType());
        }
        return IRTypeResolver.getDescriptor(jpi.getFeatureType());
    }

    protected String resolveFieldName(IType owner, String name) {
        IPropertyInfo property;
        if (IGosuClass.ProxyUtil.isProxy((IType)owner)) {
            owner = IGosuClass.ProxyUtil.getProxiedType((IType)owner);
        }
        if (owner instanceof IJavaType && (property = owner.getTypeInfo().getProperty((CharSequence)name)) instanceof IJavaFieldPropertyInfo) {
            return ((IJavaFieldPropertyInfo)property).getField().getName();
        }
        return name;
    }

    protected void addImplicitParameters(IType owner, IFunctionType functionType, boolean bStatic, List<IRType> params) {
        this.addImplicitEnhancementParams(owner, bStatic, params);
        this.addFunctionTypeParams(functionType, params);
        this.addImplicitExternalSymbolMapParam(functionType, owner, bStatic, params);
    }

    private void addImplicitEnhancementParams(IType owner, boolean bStatic, List<IRType> params) {
        if (owner instanceof IGosuEnhancement && !bStatic) {
            params.add(IRTypeResolver.getDescriptor(((IGosuEnhancement)owner).getEnhancedType()));
            if (owner.isParameterizedType()) {
                this.addTypeVariableParameters(params, owner.getTypeParameters().length);
            } else if (owner.isGenericType()) {
                this.addTypeVariableParameters(params, owner.getGenericTypeVariables().length);
            }
        }
    }

    private void addImplicitExternalSymbolMapParam(IFunctionType functionType, IType owner, boolean bStatic, List<IRType> params) {
        if (!this.isImplicitMethod()) {
            if (owner instanceof IGosuProgram && !(owner instanceof IGosuTemplateInternal) && !AbstractElementTransformer.isExecuteMethod(functionType.getDisplayName())) {
                params.add(IRTypeResolver.getDescriptor(IExternalSymbolMap.class));
            } else if (owner != null && bStatic) {
                this.addImplicitExternalSymbolMapParam(functionType, owner.getEnclosingType(), bStatic, params);
            }
        }
    }

    protected boolean isImplicitMethod() {
        return false;
    }

    private void addFunctionTypeParams(IFunctionType functionType, List<IRType> params) {
        if (functionType == null) {
            return;
        }
        if (functionType.isParameterizedType()) {
            this.addTypeVariableParameters(params, functionType.getTypeParameters().length);
        } else if (functionType.isGenericType()) {
            this.addTypeVariableParameters(params, functionType.getGenericTypeVariables().length);
        }
    }

    protected void addTypeVariableParameters(List<IRType> params, int number) {
        for (int i = 0; i < number; ++i) {
            params.add(IRTypeResolver.getDescriptor(LazyTypeResolver.class));
        }
    }

    protected List<IRType> getTypeDescriptors(IParameterInfo[] parameters) {
        ArrayList<IRType> paramTypes = new ArrayList<IRType>(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            paramTypes.add(IRTypeResolver.getDescriptor(parameters[i].getFeatureType()));
        }
        return paramTypes;
    }
}

