/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.internal.gosu.ir.nodes.IRTypeFactory;
import gw.internal.gosu.ir.nodes.JavaClassIRType;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.AbstractExpressionTransformer;
import gw.internal.gosu.parser.expressions.FeatureLiteral;
import gw.internal.gosu.parser.expressions.TypeLiteral;
import gw.lang.ir.IRExpression;
import gw.lang.ir.expression.IRNewExpression;
import gw.lang.parser.IExpression;
import gw.lang.reflect.IType;
import gw.lang.reflect.features.BoundMethodReference;
import gw.lang.reflect.features.BoundPropertyChainReference;
import gw.lang.reflect.features.BoundPropertyReference;
import gw.lang.reflect.features.ConstructorReference;
import gw.lang.reflect.features.FeatureReference;
import gw.lang.reflect.features.MethodReference;
import gw.lang.reflect.features.PropertyChainReference;
import gw.lang.reflect.features.PropertyReference;
import java.util.ArrayList;
import java.util.List;

public class FeatureLiteralTransformer
extends AbstractExpressionTransformer<FeatureLiteral> {
    public static IRExpression compile(TopLevelTransformationContext cc, FeatureLiteral expr) {
        FeatureLiteralTransformer compiler = new FeatureLiteralTransformer(cc, expr);
        return compiler.compile();
    }

    private FeatureLiteralTransformer(TopLevelTransformationContext cc, FeatureLiteral expr) {
        super(cc, expr);
    }

    @Override
    protected IRExpression compile_impl() {
        if (((FeatureLiteral)this._expr()).isPropertyLiteral()) {
            IExpression root = ((FeatureLiteral)this._expr()).getRoot();
            if (root instanceof TypeLiteral) {
                return this.buildNewExpression(PropertyReference.class, new Class[]{IType.class, String.class}, FeatureLiteralTransformer.exprList(this.pushType(((FeatureLiteral)this._expr()).getRootType()), this.stringLiteral(((FeatureLiteral)this._expr()).getPropertyName())));
            }
            if (root instanceof FeatureLiteral) {
                IRNewExpression expression = (IRNewExpression)ExpressionTransformer.compile(root, this._cc());
                if (JavaClassIRType.get(PropertyChainReference.class).isAssignableFrom(IRTypeFactory.get(((FeatureLiteral)this._expr()).getType()))) {
                    return this.buildNewExpression(PropertyChainReference.class, new Class[]{IType.class, FeatureReference.class, String.class}, FeatureLiteralTransformer.exprList(new IRExpression[]{this.pushType(((FeatureLiteral)this._expr()).getRootType()), expression, this.stringLiteral(((FeatureLiteral)this._expr()).getPropertyName())}));
                }
                return this.buildNewExpression(BoundPropertyChainReference.class, new Class[]{IType.class, FeatureReference.class, String.class}, FeatureLiteralTransformer.exprList(new IRExpression[]{this.pushType(((FeatureLiteral)this._expr()).getRootType()), expression, this.stringLiteral(((FeatureLiteral)this._expr()).getPropertyName())}));
            }
            return this.buildNewExpression(BoundPropertyReference.class, new Class[]{IType.class, Object.class, String.class}, FeatureLiteralTransformer.exprList(this.pushType(((FeatureLiteral)this._expr()).getRootType()), ExpressionTransformer.compile(root, this._cc()), this.stringLiteral(((FeatureLiteral)this._expr()).getPropertyName())));
        }
        if (((FeatureLiteral)this._expr()).isMethodLiteral()) {
            IExpression root = ((FeatureLiteral)this._expr()).getRoot();
            if (root instanceof TypeLiteral) {
                return this.buildNewExpression(MethodReference.class, new Class[]{IType.class, String.class, IType[].class, Object[].class}, FeatureLiteralTransformer.exprList(this.pushType(((FeatureLiteral)this._expr()).getRootType()), this.stringLiteral(((FeatureLiteral)this._expr()).getMethodName()), this.pushArrayOfTypes(((FeatureLiteral)this._expr()).getParameterTypes()), this.getBoundValues()));
            }
            return this.buildNewExpression(BoundMethodReference.class, new Class[]{IType.class, Object.class, String.class, IType[].class, Object[].class}, FeatureLiteralTransformer.exprList(this.pushType(((FeatureLiteral)this._expr()).getRootType()), ExpressionTransformer.compile(root, this._cc()), this.stringLiteral(((FeatureLiteral)this._expr()).getMethodName()), this.pushArrayOfTypes(((FeatureLiteral)this._expr()).getParameterTypes()), this.getBoundValues()));
        }
        if (((FeatureLiteral)this._expr()).isConstructorLiteral()) {
            return this.buildNewExpression(ConstructorReference.class, new Class[]{IType.class, IType[].class, Object[].class}, FeatureLiteralTransformer.exprList(this.pushType(((FeatureLiteral)this._expr()).getRootType()), this.pushArrayOfTypes(((FeatureLiteral)this._expr()).getParameterTypes()), this.getBoundValues()));
        }
        throw new IllegalStateException("Unable to convert reference of type " + ((FeatureLiteral)this._expr()).toString());
    }

    private IRExpression getBoundValues() {
        IRExpression boundArgs;
        List<IExpression> args = ((FeatureLiteral)this._expr()).getBoundArgs();
        if (args == null) {
            boundArgs = this.pushNull();
        } else {
            ArrayList<IRExpression> values = new ArrayList<IRExpression>();
            for (IExpression arg : args) {
                values.add(ExpressionTransformer.compile(arg, this._cc()));
            }
            boundArgs = this.collectArgsIntoObjArray(values);
        }
        return boundArgs;
    }
}

