/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.config.CommonServices;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.AbstractExpressionTransformer;
import gw.internal.gosu.parser.expressions.MapAccess;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRSymbol;
import gw.lang.reflect.java.JavaTypes;
import java.util.AbstractMap;
import java.util.Map;

public class MapAccessTransformer
extends AbstractExpressionTransformer<MapAccess> {
    public static IRExpression compile(TopLevelTransformationContext cc, MapAccess expr) {
        MapAccessTransformer compiler = new MapAccessTransformer(cc, expr);
        return compiler.compile();
    }

    private MapAccessTransformer(TopLevelTransformationContext cc, MapAccess expr) {
        super(cc, expr);
    }

    @Override
    protected IRExpression compile_impl() {
        boolean bStandardGosu = CommonServices.getEntityAccess().getLanguageLevel().isStandard();
        boolean bNullSafe = ((MapAccess)this._expr()).isNullSafe() || !bStandardGosu;
        IRExpression root = ExpressionTransformer.compile(((MapAccess)this._expr()).getRootExpression(), this._cc());
        IRSymbol temp = bNullSafe ? this._cc().makeAndIndexTempSymbol(root.getType()) : null;
        IRExpression key = ExpressionTransformer.compile(((MapAccess)this._expr()).getKeyExpression(), this._cc());
        Class clsMap = this.getMapType();
        IRExpression getCall = this.callMethod(clsMap, "get", new Class[]{Object.class}, (IRExpression)(bNullSafe ? this.identifier(temp) : root), MapAccessTransformer.exprList(key));
        if (bNullSafe) {
            return this.buildComposite(new IRElement[]{this.buildAssignment(temp, root), this.buildNullCheckTernary((IRExpression)this.identifier(temp), this.checkCast(((MapAccess)this._expr()).getType(), this.nullLiteral()), this.checkCast(((MapAccess)this._expr()).getType(), getCall))});
        }
        return this.checkCast(((MapAccess)this._expr()).getType(), getCall);
    }

    private Class getMapType() {
        Class clsMap = JavaTypes.getJreType(AbstractMap.class).isAssignableFrom(((MapAccess)this._expr()).getRootExpression().getType()) ? AbstractMap.class : Map.class;
        return clsMap;
    }
}

