/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.AsmGenericArrayTypeJavaClassGenericArrayType;
import gw.internal.gosu.parser.AsmParameterizedTypeJavaClassParameterizedType;
import gw.internal.gosu.parser.AsmTypeVariableJavaClassTypeVariable;
import gw.internal.gosu.parser.AsmWildcardTypeJavaClassWildcardType;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.java.classinfo.JavaArrayClassInfo;
import gw.internal.gosu.parser.java.classinfo.JavaSourceUtil;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassType;
import gw.lang.reflect.java.JavaSourceElement;
import gw.lang.reflect.java.asm.AsmClass;
import gw.lang.reflect.java.asm.AsmType;
import gw.lang.reflect.java.asm.AsmWildcardType;
import gw.lang.reflect.java.asm.IAsmType;
import gw.lang.reflect.module.IModule;
import java.util.LinkedHashSet;

public abstract class AsmTypeJavaClassType
extends JavaSourceElement
implements IJavaClassType {
    private IAsmType _type;
    protected IModule _module;

    public AsmTypeJavaClassType(IAsmType type, IModule module) {
        this._type = type;
        this._module = module;
    }

    protected IAsmType getType() {
        return this._type;
    }

    public IType getActualType(TypeVarToTypeMap typeMap) {
        return TypeLord.getActualType(this._type, typeMap);
    }

    public IType getActualType(TypeVarToTypeMap typeMap, boolean bKeepTypeVars) {
        return TypeLord.getActualType(this._type, typeMap, bKeepTypeVars, new LinkedHashSet<IAsmType>());
    }

    public static IJavaClassType createType(IAsmType rawType, IModule module) {
        return AsmTypeJavaClassType.createType(null, rawType, module);
    }

    public static IJavaClassType createType(IAsmType genType, IAsmType rawType, IModule module) {
        Object type = null;
        if (rawType.isArray() && (rawType.isTypeVariable() || rawType.isParameterized())) {
            type = new AsmGenericArrayTypeJavaClassGenericArrayType(rawType, module);
        } else if (rawType.isTypeVariable()) {
            type = new AsmTypeVariableJavaClassTypeVariable(rawType, module);
        } else if (rawType.isParameterized()) {
            type = new AsmParameterizedTypeJavaClassParameterizedType(rawType, module);
        } else if (rawType instanceof AsmWildcardType) {
            type = new AsmWildcardTypeJavaClassWildcardType(genType, (AsmWildcardType)rawType, module);
        } else if (rawType instanceof AsmClass) {
            type = JavaSourceUtil.getClassInfo((AsmClass)rawType, module);
        } else if (rawType instanceof AsmType) {
            type = JavaSourceUtil.getClassInfo(rawType.getName(), module);
            while (rawType.getComponentType() != null) {
                type = new JavaArrayClassInfo((IJavaClassInfo)type);
                rawType = rawType.getComponentType();
            }
        }
        return type;
    }

    public String getName() {
        return this._type.toString();
    }

    public IModule getModule() {
        return this._module;
    }

    public String getNamespace() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AsmTypeJavaClassType)) {
            return false;
        }
        AsmTypeJavaClassType that = (AsmTypeJavaClassType)((Object)o);
        if (this._module != null ? !this._module.equals(that._module) : that._module != null) {
            return false;
        }
        return this._type.equals(that._type);
    }

    public int hashCode() {
        int result = this._type.hashCode();
        result = 31 * result + (this._module != null ? this._module.hashCode() : 0);
        return result;
    }
}

