/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.internal.gosu.compiler.SingleServingGosuClassLoader;
import gw.internal.gosu.ir.transform.expression.EvalExpressionTransformer;
import gw.internal.gosu.parser.GosuProgramParser;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.IGosuEnhancementInternal;
import gw.internal.gosu.parser.IGosuProgramInternal;
import gw.internal.gosu.parser.Symbol;
import gw.internal.gosu.parser.ThisSymbol;
import gw.internal.gosu.parser.TypeLord;
import gw.lang.parser.ExternalSymbolMapForMap;
import gw.lang.parser.GosuParserFactory;
import gw.lang.parser.IDynamicFunctionSymbol;
import gw.lang.parser.IGosuProgramParser;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IParsedElementWithAtLeastOneDeclaration;
import gw.lang.parser.IProgramClassFunctionSymbol;
import gw.lang.parser.IStatement;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.ParseResult;
import gw.lang.parser.StandardSymbolTable;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.parser.expressions.ILocalVarDeclaration;
import gw.lang.parser.expressions.IParameterDeclaration;
import gw.lang.parser.expressions.IVarStatement;
import gw.lang.parser.statements.IFunctionStatement;
import gw.lang.parser.statements.IStatementList;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IExternalSymbolMap;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.gs.IProgramInstance;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.module.IModule;
import gw.util.GosuExceptionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ContextSensitiveCodeRunner {
    private static ConcurrentHashMap<String, IGosuProgramInternal> _cacheProgramByFingerprint = new ConcurrentHashMap();
    private static int _refreshChecksum;

    static void ensureLoadedForDebuggerEval() {
        System.out.println("~~~~~LOADED");
    }

    public static Object runMeSomeCode(Object enclosingInstance, ClassLoader cl, Object[] extSyms, String strText, String strClassContext, String strContextElementClass, int iSourcePosition) {
        try {
            Class cls;
            try {
                cls = Class.forName(ContextSensitiveCodeRunner.class.getName(), false, cl);
            }
            catch (Exception e) {
                cls = ContextSensitiveCodeRunner.class;
            }
            Method m = cls.getDeclaredMethod("_runMeSomeCode", Object.class, Object[].class, String.class, String.class, String.class, Integer.TYPE);
            m.setAccessible(true);
            return m.invoke(null, enclosingInstance, extSyms, strText, strClassContext, strContextElementClass, iSourcePosition);
        }
        catch (Exception e) {
            List parseExceptions;
            e.printStackTrace();
            Throwable cause = GosuExceptionUtil.findExceptionCause((Throwable)e);
            if (cause instanceof ParseResultsException && (parseExceptions = ((ParseResultsException)cause).getParseExceptions()) != null && parseExceptions.size() >= 0) {
                throw GosuExceptionUtil.forceThrow((Throwable)((Throwable)parseExceptions.get(0)));
            }
            throw GosuExceptionUtil.forceThrow((Throwable)cause);
        }
    }

    private static Object _runMeSomeCode(Object enclosingInstance, Object[] extSyms, String strText, String strClassContext, String strContextElementClass, int iSourcePosition) {
        IType type = TypeSystem.getByFullName((String)strClassContext, (IModule)TypeSystem.getGlobalModule());
        if (type instanceof IGosuClassInternal) {
            IGosuClassInternal gsClass = (IGosuClassInternal)type;
            gsClass.isValid();
            IGosuClassInternal gsImmediateClass = (IGosuClassInternal)TypeSystem.getByFullName((String)strContextElementClass);
            return ContextSensitiveCodeRunner.compileAndRunMeSomeCode(strText, gsClass, enclosingInstance, (IType)gsImmediateClass, extSyms, iSourcePosition);
        }
        IType gsImmediateClass = TypeSystem.getByFullName((String)strContextElementClass);
        return ContextSensitiveCodeRunner.compileAndRunMeSomeCode(strText, null, enclosingInstance, gsImmediateClass, extSyms, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object compileAndRunMeSomeCode(Object source, IGosuClass ctxClass, Object outer, IType enclosingClass, Object[] extSyms, int offset) {
        Constructor ctor;
        Class<?>[] parameterTypes;
        IGosuProgram gp;
        ParseResult res;
        String typeName = GosuProgramParser.makeEvalKey(source.toString(), enclosingClass, offset);
        IGosuProgramInternal program = ContextSensitiveCodeRunner.getCachedProgram(typeName);
        if (program != null) {
            program.isValid();
            res = new ParseResult((IGosuProgram)program);
        } else {
            StandardSymbolTable compileTimeLocalContextSymbols = ctxClass == null ? new StandardSymbolTable(true) : ContextSensitiveCodeRunner.findCompileTimeSymbols((IGosuClassInternal)ctxClass, offset);
            String strSource = CommonServices.getCoercionManager().makeStringFrom(source);
            IGosuProgramParser parser = GosuParserFactory.createProgramParser();
            while (enclosingClass.getEnclosingType() != null && enclosingClass instanceof IGosuClassInternal && ((IGosuClassInternal)enclosingClass).getClassStatement().getLocation() == null) {
                enclosingClass = enclosingClass.getEnclosingType();
                try {
                    Field f = outer.getClass().getDeclaredField("this$0");
                    f.setAccessible(true);
                    outer = f.get(outer);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            TypeSystem.pushIncludeAll();
            try {
                IParseTree ctxElem = null;
                if (enclosingClass instanceof IGosuClassInternal) {
                    ctxElem = ((IGosuClassInternal)enclosingClass).getClassStatement().getLocation().getDeepestLocation(offset, false);
                }
                res = parser.parseRuntimeExpr(typeName, strSource, enclosingClass, (ISymbolTable)compileTimeLocalContextSymbols, ctxElem);
            }
            finally {
                TypeSystem.popIncludeAll();
            }
            ContextSensitiveCodeRunner.cacheProgram(typeName, (IGosuProgramInternal)res.getProgram());
        }
        IExternalSymbolMap runtimeLocalSymbolValues = ContextSensitiveCodeRunner.makeRuntimeNamesAndValues(extSyms);
        TypeSystem.pushIncludeAll();
        try {
            gp = res.getProgram();
            if (!gp.isValid()) {
                System.out.println((Object)gp.getParseResultsException());
                throw GosuExceptionUtil.forceThrow((Throwable)gp.getParseResultsException());
            }
        }
        finally {
            TypeSystem.popIncludeAll();
        }
        Class javaClass = gp.getBackingClass();
        ClassLoader classLoader = javaClass.getClassLoader();
        assert (classLoader instanceof SingleServingGosuClassLoader);
        ArrayList<Object> args = new ArrayList<Object>();
        if (!gp.isStatic()) {
            args.add(outer);
        }
        if ((parameterTypes = (ctor = ((EvalExpressionTransformer.DeclaredConstructorsAccessor)EvalExpressionTransformer._ctorAccessor.get()).getConstructor(javaClass)).getParameterTypes()).length != args.size()) {
            if (parameterTypes.length > args.size() && parameterTypes[parameterTypes.length - 1].getName().equals(IExternalSymbolMap.class.getName())) {
                args.add(runtimeLocalSymbolValues);
            } else {
                throw new IllegalStateException("Runtime expr constructor param count is not " + args.size() + "\nPassed in args " + ContextSensitiveCodeRunner.printArgs(args) + "\nActual args: " + ContextSensitiveCodeRunner.printArgs(ctor.getParameterTypes()));
            }
        }
        try {
            IProgramInstance evalInstance = (IProgramInstance)ctor.newInstance(args.toArray());
            return evalInstance.evaluate(runtimeLocalSymbolValues);
        }
        catch (Exception e) {
            throw GosuExceptionUtil.forceThrow((Throwable)e);
        }
    }

    public static void cacheProgram(String strTypeName, IGosuProgramInternal program) {
        ContextSensitiveCodeRunner.clearCacheOnChecksumChange();
        _cacheProgramByFingerprint.put(strTypeName, program);
    }

    public static IGosuProgramInternal getCachedProgram(String strTypeName) {
        ContextSensitiveCodeRunner.clearCacheOnChecksumChange();
        return _cacheProgramByFingerprint.get(strTypeName);
    }

    private static void clearCacheOnChecksumChange() {
        if (_refreshChecksum != TypeSystem.getRefreshChecksum()) {
            _cacheProgramByFingerprint.clear();
            _refreshChecksum = TypeSystem.getRefreshChecksum();
        }
    }

    private static String printArgs(Class[] parameterTypes) {
        String str = "";
        for (Class c : parameterTypes) {
            str = str + c.getName() + ", ";
        }
        return str;
    }

    private static String printArgs(List<Object> args) {
        String str = "";
        for (Object a : args) {
            str = str + a + ", ";
        }
        return str;
    }

    private static IExternalSymbolMap makeRuntimeNamesAndValues(Object[] extSyms) {
        HashMap<String, Symbol> map = new HashMap<String, Symbol>();
        for (int i = 0; i < extSyms.length; ++i) {
            String name = (String)extSyms[i];
            Object value = extSyms[++i];
            map.put(name, new Symbol(name, (IType)JavaTypes.OBJECT(), value));
        }
        return new ExternalSymbolMapForMap(map);
    }

    private static IParsedElement findElemAt(IGosuClassInternal gsClass, int iContextLocation) {
        IParseTree elem = ((IGosuClass)TypeLord.getOuterMostEnclosingClass((IType)gsClass)).getClassStatement().getClassFileStatement().getLocation().getDeepestLocation(iContextLocation, false);
        return elem == null ? gsClass.getClassStatement().getClassFileStatement() : elem.getParsedElement();
    }

    private static ISymbolTable findCompileTimeSymbols(IGosuClassInternal enclosingClass, int iLocation) {
        StandardSymbolTable symTable = new StandardSymbolTable(false);
        IParseTree deepestLocation = enclosingClass.getClassStatement().getClassFileStatement().getLocation().getDeepestLocation(iLocation, false);
        ContextSensitiveCodeRunner.collectLocalSymbols((IType)enclosingClass, (ISymbolTable)symTable, deepestLocation.getParsedElement(), iLocation);
        return symTable;
    }

    public static void collectLocalSymbols(IType enclosingType, ISymbolTable symTable, IParsedElement parsedElement, int iOffset) {
        IParsedElement parent;
        IFunctionStatement declStmt;
        if (parsedElement == null) {
            return;
        }
        if (parsedElement instanceof IFunctionStatement) {
            declStmt = (IFunctionStatement)parsedElement;
            if (!declStmt.getDynamicFunctionSymbol().isStatic()) {
                ContextSensitiveCodeRunner.addThisSymbolForEnhancement(enclosingType, symTable);
            }
            for (IParameterDeclaration localVar : declStmt.getParameters()) {
                if (localVar == null || localVar.getLocation().getOffset() >= iOffset) continue;
                ISymbol symbol = localVar.getSymbol();
                symTable.putSymbol(symbol);
            }
        } else if (parsedElement instanceof IParsedElementWithAtLeastOneDeclaration) {
            declStmt = (IParsedElementWithAtLeastOneDeclaration)parsedElement;
            for (String strVar : declStmt.getDeclarations()) {
                ILocalVarDeclaration localVar = ContextSensitiveCodeRunner.findLocalVarSymbol(strVar, (IParsedElement)declStmt);
                if (localVar == null || localVar.getLocation().getOffset() >= iOffset) continue;
                ISymbol symbol = localVar.getSymbol();
                symTable.putSymbol(symbol);
            }
        } else if (parsedElement instanceof IStatementList) {
            IStatementList stmtList = (IStatementList)parsedElement;
            for (IStatement stmt : stmtList.getStatements()) {
                if (!(stmt instanceof IVarStatement) || ((IVarStatement)stmt).isFieldDeclaration() || stmt.getLocation().getOffset() >= iOffset) continue;
                ISymbol symbol = ((IVarStatement)stmt).getSymbol();
                if (ContextSensitiveCodeRunner.isProgramFieldVar(stmt)) continue;
                symTable.putSymbol(symbol);
            }
        }
        if ((parent = parsedElement.getParent()) != parsedElement) {
            ContextSensitiveCodeRunner.collectLocalSymbols(enclosingType, symTable, parent, iOffset);
        }
    }

    private static void addThisSymbolForEnhancement(IType enclosingType, ISymbolTable symTable) {
        IType thisType;
        if (enclosingType instanceof IGosuEnhancementInternal && (thisType = ((IGosuEnhancementInternal)enclosingType).getEnhancedType()) != null) {
            thisType = TypeLord.getConcreteType(thisType);
            symTable.putSymbol((ISymbol)new ThisSymbol(thisType, symTable));
        }
    }

    private static boolean isProgramFieldVar(IStatement stmt) {
        IDynamicFunctionSymbol dfs;
        IParsedElement parent;
        return stmt.getParent() != null && (parent = stmt.getParent().getParent()) instanceof IFunctionStatement && (dfs = ((IFunctionStatement)parent).getDynamicFunctionSymbol()) instanceof IProgramClassFunctionSymbol;
    }

    private static ILocalVarDeclaration findLocalVarSymbol(String strVar, IParsedElement pe) {
        if (pe instanceof ILocalVarDeclaration) {
            ISymbol symbol = ((ILocalVarDeclaration)pe).getSymbol();
            if (symbol != null && symbol.getName().equals(strVar)) {
                return (ILocalVarDeclaration)pe;
            }
            return null;
        }
        if (pe == null) {
            return null;
        }
        for (IParseTree child : pe.getLocation().getChildren()) {
            ILocalVarDeclaration localVar = ContextSensitiveCodeRunner.findLocalVarSymbol(strVar, child.getParsedElement());
            if (localVar == null) continue;
            return localVar;
        }
        return null;
    }
}

