/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.lang.reflect.IType;
import gw.lang.reflect.java.JavaTypes;

public class ContextType {
    public static final ContextType EMPTY = new ContextType(null, false);
    public static final ContextType OBJECT_FALSE = new CommonContextType(CommonType.OBJECT, false);
    public static final ContextType pBOOLEAN_FALSE = new CommonContextType(CommonType.pBOOLEAN, false);
    public static final ContextType pINT_FALSE = new CommonContextType(CommonType.pINT, false);
    private IType _type;
    private IType _unboundType;
    private boolean _bMethodScoring;
    private final boolean _bCompileTimeConstant;

    private ContextType(boolean bScoring) {
        this._bMethodScoring = bScoring;
        this._bCompileTimeConstant = false;
    }

    public ContextType(IType type) {
        this(type, false);
    }

    public ContextType(IType type, boolean bScoring) {
        this(type, bScoring, false);
    }

    public ContextType(IType type, IType unboundType, boolean bScoring) {
        this(type, unboundType, bScoring, false);
    }

    public ContextType(IType type, boolean bScoring, boolean bCompileTimeConstant) {
        this(type, null, bScoring, bCompileTimeConstant);
    }

    public ContextType(IType type, IType unboundType, boolean bScoring, boolean bCompileTimeConstant) {
        this._type = type;
        this._unboundType = unboundType;
        this._bMethodScoring = bScoring;
        this._bCompileTimeConstant = bCompileTimeConstant;
    }

    public boolean isMethodScoring() {
        return this._bMethodScoring;
    }

    public boolean isCompileTimeConstant() {
        return this._bCompileTimeConstant;
    }

    public IType getType() {
        return this._type;
    }

    public IType getUnboundType() {
        return this._unboundType;
    }

    public IType getAlternateType() {
        return null;
    }

    public static ContextType makeBlockContexType(IType ctxType, IType ctxTypeWithTypeVars, boolean bScoring) {
        return new BlockContextType(ctxType, ctxTypeWithTypeVars, bScoring);
    }

    private static class BlockContextType
    extends ContextType {
        private IType _ctxTypeWithTypeVars;

        private BlockContextType(IType ctxType, IType ctxTypeWithTypeVars, boolean bScoring) {
            super(ctxType, bScoring);
            this._ctxTypeWithTypeVars = ctxTypeWithTypeVars;
        }

        @Override
        public IType getAlternateType() {
            return this._ctxTypeWithTypeVars;
        }
    }

    private static class CommonContextType
    extends ContextType {
        private CommonType _ctype;

        private CommonContextType(CommonType ctype, boolean bScoring) {
            super(bScoring);
            this._ctype = ctype;
        }

        @Override
        public IType getType() {
            switch (this._ctype) {
                case OBJECT: {
                    return JavaTypes.OBJECT();
                }
                case pBOOLEAN: {
                    return JavaTypes.pBOOLEAN();
                }
                case pINT: {
                    return JavaTypes.pINT();
                }
            }
            throw new IllegalStateException();
        }
    }

    private static enum CommonType {
        OBJECT,
        pBOOLEAN,
        pINT;

    }
}

