/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.GosuClassTypeInfo;
import gw.internal.gosu.parser.GosuMethodInfo;
import gw.internal.gosu.parser.IGosuEnhancementInternal;
import gw.internal.gosu.parser.JavaFieldPropertyInfo;
import gw.internal.gosu.parser.SourceCodeTokenizer;
import gw.internal.gosu.parser.TypeLoaderAccess;
import gw.internal.gosu.parser.TypeLord;
import gw.lang.parser.CICS;
import gw.lang.parser.ISource;
import gw.lang.parser.ISourceCodeTokenizer;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.reflect.IErrorType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeRef;
import gw.lang.reflect.ITypeVariableType;
import gw.lang.reflect.RefreshKind;
import gw.lang.reflect.RefreshRequest;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.GosuClassTypeLoader;
import gw.lang.reflect.gs.IEnhancementIndex;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.module.IModule;
import gw.util.GosuObjectUtil;
import gw.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class EnhancementIndex
implements IEnhancementIndex {
    private GosuClassTypeLoader _loader;
    private Map<String, ArrayList<String>> _typeToEnhancementsMap;
    private ArrayList<String> _arrayEnhancements;
    private boolean _loadingIndex;
    private String _currentEnhName;
    private Set<IType> _currentlyEnhancing = new HashSet<IType>();

    EnhancementIndex(GosuClassTypeLoader loader) {
        this._loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEnhancementMethods(IType typeToEnhance, Collection<IMethodInfo> methodsToAddTo) {
        this.maybeLoadEnhancementIndex();
        this.checkNotIndexing(typeToEnhance);
        if (!(typeToEnhance instanceof IGosuEnhancementInternal)) {
            TypeSystem.lock();
            try {
                this.checkAndPushEnhancing(typeToEnhance);
                try {
                    EnhancementManager enhancementManager = new EnhancementManager(methodsToAddTo);
                    enhancementManager.addAllEnhancementMethodsForType(typeToEnhance);
                }
                finally {
                    this.popEnhancing(typeToEnhance);
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEnhancementProperties(IType typeToEnhance, Map<CharSequence, IPropertyInfo> propertyInfosToAddTo, boolean caseSensitive) {
        this.maybeLoadEnhancementIndex();
        this.checkNotIndexing(typeToEnhance);
        if (!(typeToEnhance instanceof IGosuEnhancementInternal)) {
            TypeSystem.lock();
            try {
                this.checkAndPushEnhancing(typeToEnhance);
                try {
                    EnhancementManager enhancementManager = new EnhancementManager(propertyInfosToAddTo);
                    enhancementManager.addAllEnhancementPropsForType(typeToEnhance, caseSensitive);
                }
                finally {
                    this.popEnhancing(typeToEnhance);
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
    }

    private void popEnhancing(IType typeToEnhance) {
        this._currentlyEnhancing.remove(typeToEnhance);
    }

    private void checkAndPushEnhancing(IType typeToEnhance) {
        if (this._currentlyEnhancing.contains(typeToEnhance)) {
            throw new IllegalStateException("A recursive loop was found in enhancement definition.  The type " + typeToEnhance + " attempted to load its enhancements again while loading its enhancments initially.  This usually indicates a logical error in the Gosu runtime.");
        }
        this._currentlyEnhancing.add(typeToEnhance);
    }

    private void checkNotIndexing(IType typeToEnhance) {
        if (this._loadingIndex) {
            throw new IllegalStateException("There is a circular type reference.  When loading the enhancement defined in " + this._currentEnhName + ", enhancements for " + typeToEnhance.getName() + " were requested.  This usual occurs when the typeloader of the type enhanced in " + this._currentEnhName + " compiles  code.  We do not support enhancements on types that have this behavior.");
        }
    }

    public void maybeLoadEnhancementIndex() {
        if (this._typeToEnhancementsMap != null) {
            return;
        }
        try {
            this._loadingIndex = true;
            this._typeToEnhancementsMap = new HashMap<String, ArrayList<String>>();
            this._arrayEnhancements = new ArrayList();
            Set allEnhancements = this._loader.getRepository().getAllTypeNames(new String[]{".gsx"});
            this.indexEnhancements(allEnhancements.toArray(new String[allEnhancements.size()]));
        }
        finally {
            this._loadingIndex = false;
            this._currentEnhName = null;
        }
    }

    private Set<String> indexEnhancements(String[] enhancementNames) {
        HashSet<String> enhancedTypes = new HashSet<String>();
        String[] stringArray = enhancementNames;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            ArrayList<String> enhancements;
            String enhancedTypeName;
            String enhancementName;
            this._currentEnhName = enhancementName = stringArray[i];
            IType enh = TypeSystem.getByFullNameIfValidNoJava((String)enhancementName);
            if (!(enh instanceof IGosuEnhancement) || (enhancedTypeName = EnhancementIndex.parseEnhancedTypeName(((IGosuEnhancement)enh).getSourceFileHandle())) == null || "ErrorType".equals(enhancedTypeName) || (enhancements = this.getEnhancementIndexForType(enhancedTypeName)).contains(enhancementName)) continue;
            enhancements.add(enhancementName);
            enhancedTypes.add(enhancedTypeName);
        }
        return enhancedTypes;
    }

    private Set<String> indexEnhancements(RefreshRequest request) {
        HashSet<String> enhancedTypes = new HashSet<String>();
        if (request.file != null && request.file.getExtension().equals("gsx") && request.file.getBaseName().equals(this.getSimpleName(request.types[0]))) {
            ArrayList<String> enhancements;
            String enhancedTypeName;
            String enhancementName;
            this._currentEnhName = enhancementName = request.types[0];
            IType enh = TypeSystem.getByFullNameIfValidNoJava((String)enhancementName);
            if (enh instanceof IGosuEnhancement && (enhancedTypeName = EnhancementIndex.parseEnhancedTypeName(((IGosuEnhancement)enh).getSourceFileHandle())) != null && !"ErrorType".equals(enhancedTypeName) && !(enhancements = this.getEnhancementIndexForType(enhancedTypeName)).contains(enhancementName)) {
                enhancements.add(enhancementName);
                enhancedTypes.add(enhancedTypeName);
            }
        }
        return enhancedTypes;
    }

    private String getSimpleName(String type) {
        int iDot = type.lastIndexOf(46);
        if (iDot >= 0) {
            return type.substring(iDot + 1);
        }
        return type;
    }

    public static String parseEnhancedTypeName(ISourceFileHandle sfh) {
        String ret;
        SourceCodeTokenizer tokenizer = EnhancementIndex.initializeTokenizer(sfh);
        StringBuilder name = new StringBuilder();
        boolean mark = false;
        boolean enhancementFound = false;
        tokenizer.nextToken();
        String currentToken = tokenizer.getCurrentToken().getText();
        while (!tokenizer.isEOF() && !currentToken.equals("{")) {
            if (mark) {
                if (currentToken.equals("<")) break;
                name.append(currentToken);
            }
            if (currentToken.equals("enhancement")) {
                enhancementFound = true;
            }
            if (currentToken.equals(":") && enhancementFound) {
                mark = true;
            }
            tokenizer.nextToken();
            currentToken = tokenizer.getCurrentToken().getText();
        }
        if ((ret = name.toString()).isEmpty() || !mark) {
            ret = "ErrorType";
        }
        return ret;
    }

    private static SourceCodeTokenizer initializeTokenizer(ISourceFileHandle sfh) {
        ISource source = sfh.getSource();
        SourceCodeTokenizer tokenizer = (SourceCodeTokenizer)source.getTokenizer();
        if (tokenizer == null) {
            tokenizer = new SourceCodeTokenizer(source.getSource());
            tokenizer.wordChars(95, 95);
            source.setTokenizer((ISourceCodeTokenizer)tokenizer);
        }
        return tokenizer;
    }

    private ArrayList<String> getEnhancementIndexForType(String strEnhancedTypeName) {
        this.maybeLoadEnhancementIndex();
        if (strEnhancedTypeName.contains("[")) {
            return this._arrayEnhancements;
        }
        ArrayList<String> enhancements = this._typeToEnhancementsMap.get(strEnhancedTypeName);
        if (enhancements == null) {
            enhancements = new ArrayList();
            this._typeToEnhancementsMap.put(strEnhancedTypeName, enhancements);
        }
        return enhancements;
    }

    public List<IGosuEnhancementInternal> getEnhancementsForType(IType typeToEnhance) {
        this.maybeLoadEnhancementIndex();
        ArrayList<IGosuEnhancementInternal> enhancements = new ArrayList<IGosuEnhancementInternal>();
        IType genericEnhancedType = TypeLord.getPureGenericType(typeToEnhance);
        if (genericEnhancedType == null) {
            return enhancements;
        }
        Set<String> possibleEnhancementNames = this.getPossibleEnhancementsForTypeFromIndex(genericEnhancedType);
        for (String possibleEnhancementTypeName : possibleEnhancementNames) {
            try {
                IType enhancementType = TypeLoaderAccess.instance().getIntrinsicTypeByFullName(possibleEnhancementTypeName);
                if (!(enhancementType instanceof IGosuEnhancementInternal)) continue;
                IGosuEnhancementInternal possibleEnhancement = (IGosuEnhancementInternal)enhancementType;
                if (!possibleEnhancement.isCompilingHeader()) {
                    IType typeEnhanced = possibleEnhancement.getEnhancedType();
                    TypeVarToTypeMap actualParamByVarName = TypeLord.mapTypeByVarName((IType)possibleEnhancement, (IType)possibleEnhancement);
                    if (!this.enhancementApplies(typeEnhanced = typeEnhanced == null ? null : TypeLord.getActualType(typeEnhanced, actualParamByVarName, false), typeToEnhance, true)) continue;
                    enhancements.add(possibleEnhancement);
                    continue;
                }
                throw new RuntimeException("Theoretically, should not be able to get here....so much for theory ");
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return enhancements;
    }

    public void refreshedTypes(RefreshRequest request) {
        if (request.kind == RefreshKind.CREATION) {
            Set<String> enhancedTypes = this.indexEnhancements(request.types);
            for (String enhancedType : enhancedTypes) {
                IType type = TypeSystem.getByFullNameIfValid((String)enhancedType, (IModule)this._loader.getModule());
                if (type == null) continue;
                TypeSystem.refresh((ITypeRef)((ITypeRef)type));
            }
        } else if (request.kind == RefreshKind.DELETION) {
            for (String enhancementName : request.types) {
                this.removeEnhancement(enhancementName);
            }
        } else if (request.kind == RefreshKind.MODIFICATION) {
            this.indexEnhancements(request);
        }
    }

    public String getOrphanedEnhancement(String typeName) {
        String name = typeName.substring(typeName.lastIndexOf(46) + 1);
        ArrayList<String> enhancementNames = this.getEnhancementIndexForType(name);
        Iterator<String> iterator = enhancementNames.iterator();
        if (iterator.hasNext()) {
            String enhancement = iterator.next();
            return enhancement;
        }
        return null;
    }

    private boolean enhancementApplies(IType typeEnhanced, IType typeToEnhance, boolean exact) {
        if (typeEnhanced == null) {
            return false;
        }
        if (typeEnhanced instanceof IGosuEnhancementInternal) {
            return false;
        }
        if (this.hasErrorTypeComponent(typeEnhanced)) {
            return false;
        }
        if (typeEnhanced.isArray() && typeToEnhance.isArray()) {
            IType enhancementComponent = typeEnhanced.getComponentType();
            IType enhancedComponent = typeToEnhance.getComponentType();
            return enhancedComponent.isPrimitive() == enhancementComponent.isPrimitive() && this.enhancementApplies(enhancementComponent, enhancedComponent, exact);
        }
        if (exact) {
            return typeEnhanced.isAssignableFrom(typeToEnhance);
        }
        return TypeLord.getPureGenericType(typeEnhanced).isAssignableFrom(TypeLord.getPureGenericType(typeToEnhance));
    }

    private boolean hasErrorTypeComponent(IType enhancedType) {
        if (enhancedType instanceof IErrorType) {
            return true;
        }
        if (enhancedType.isParameterizedType()) {
            IType[] typeParam;
            for (IType parameter : typeParam = enhancedType.getTypeParameters()) {
                if (!this.hasErrorTypeComponent(parameter)) continue;
                return true;
            }
        }
        if (enhancedType.isArray()) {
            return this.hasErrorTypeComponent(enhancedType.getComponentType());
        }
        return false;
    }

    Set<String> getPossibleEnhancementsForTypeFromIndex(IType typeToGetEnhancementsFor) {
        String typeToEnhanceName = typeToGetEnhancementsFor.getName();
        StringBuilder possibleName = new StringBuilder();
        TreeSet<String> enhancements = new TreeSet<String>();
        int currPos = typeToEnhanceName.length();
        do {
            int nextDot;
            String string = typeToEnhanceName.substring((nextDot = typeToEnhanceName.lastIndexOf(46, currPos - 1)) == -1 ? 0 : nextDot + 1, currPos);
            currPos = nextDot;
            possibleName.insert(0, string);
            ArrayList<String> enhancementTypes = typeToGetEnhancementsFor.isArray() ? this._arrayEnhancements : this._typeToEnhancementsMap.get(possibleName.toString());
            if (enhancementTypes != null) {
                enhancements.addAll(enhancementTypes);
            }
            possibleName.insert(0, ".");
        } while (currPos != -1);
        return enhancements;
    }

    public void removeEntry(IGosuEnhancement enhancement) {
        this.removeEnhancement(enhancement.getName());
    }

    public void removeEnhancement(String enhancementName) {
        block1: {
            Map.Entry<String, ArrayList<String>> entry;
            ArrayList<String> value;
            if (this._typeToEnhancementsMap == null) break block1;
            Iterator<Map.Entry<String, ArrayList<String>>> iterator = this._typeToEnhancementsMap.entrySet().iterator();
            while (iterator.hasNext() && !(value = (entry = iterator.next()).getValue()).remove(enhancementName)) {
            }
        }
    }

    public void addEntry(IType enhancedType, IGosuEnhancement enhancement) {
        ArrayList<String> enhancementIndexForType = this.getEnhancementIndexForType(enhancedType.getName());
        if (!enhancementIndexForType.contains(enhancement.getName())) {
            enhancementIndexForType.add(enhancement.getName());
        }
    }

    private static CharSequence convertCharSequenceToCorrectSensitivity(CharSequence cs, boolean caseSensitive) {
        return caseSensitive ? cs.toString() : CICS.get((CharSequence)cs);
    }

    public String toString() {
        return "Enhancements Index for " + this._loader.toString();
    }

    private class EnhancementManager {
        private Collection<IMethodInfo> _methodsToAddTo;
        private Map<CharSequence, IPropertyInfo> _propertyInfosToAddTo;
        private Map<String, List<IMethodInfo>> _methodNamesToMethods;

        public EnhancementManager(Collection<IMethodInfo> methodsToAddTo) {
            this._methodsToAddTo = methodsToAddTo;
        }

        public EnhancementManager(Map<CharSequence, IPropertyInfo> propertyInfosToAddTo) {
            this._propertyInfosToAddTo = propertyInfosToAddTo;
        }

        public void addAllEnhancementMethodsForType(IType typeToGetEnhancementsFor) {
            IType[] interfaces;
            List<IGosuEnhancementInternal> enhancements = EnhancementIndex.this.getEnhancementsForType(typeToGetEnhancementsFor);
            for (IGosuEnhancementInternal type : enhancements) {
                GosuClassTypeInfo typeInfo = this.getTypeInfoForType(typeToGetEnhancementsFor, type);
                List<? extends IMethodInfo> extensionMethods = typeInfo.getDeclaredMethods();
                for (IMethodInfo iMethodInfo : extensionMethods) {
                    GosuMethodInfo extensionMethodInfo = (GosuMethodInfo)iMethodInfo;
                    if (!this.shouldAddMethod((IMethodInfo)extensionMethodInfo, type, typeToGetEnhancementsFor)) continue;
                    this._methodsToAddTo.add((IMethodInfo)extensionMethodInfo);
                }
            }
            for (IType interfaceType : interfaces = typeToGetEnhancementsFor.getInterfaces()) {
                this.addAllEnhancementMethodsForType(interfaceType);
            }
        }

        public void addAllEnhancementPropsForType(IType typeToGetEnhancementsFor, boolean caseSensitive) {
            IType[] interfaces;
            List<IGosuEnhancementInternal> enhancements = EnhancementIndex.this.getEnhancementsForType(typeToGetEnhancementsFor);
            for (IGosuEnhancementInternal type : enhancements) {
                GosuClassTypeInfo typeInfo = this.getTypeInfoForType(typeToGetEnhancementsFor, type);
                List<? extends IPropertyInfo> props = typeInfo.getDeclaredProperties();
                for (IPropertyInfo iPropertyInfo : props) {
                    IPropertyInfo existingPropInfo;
                    if (!typeToGetEnhancementsFor.isArray() && (iPropertyInfo.isPrivate() || iPropertyInfo.isInternal() && !type.getNamespace().equals(typeToGetEnhancementsFor.getNamespace())) || (existingPropInfo = this._propertyInfosToAddTo.get(EnhancementIndex.convertCharSequenceToCorrectSensitivity(iPropertyInfo.getName(), caseSensitive))) != null && !GosuObjectUtil.equals((Object)existingPropInfo.getContainer(), (Object)iPropertyInfo.getContainer()) && this.notAnInternalOrPrivateField(existingPropInfo)) continue;
                    this._propertyInfosToAddTo.put(EnhancementIndex.convertCharSequenceToCorrectSensitivity(iPropertyInfo.getName(), caseSensitive), iPropertyInfo);
                }
            }
            for (IType interfaceType : interfaces = typeToGetEnhancementsFor.getInterfaces()) {
                this.addAllEnhancementPropsForType(interfaceType, caseSensitive);
            }
        }

        private boolean notAnInternalOrPrivateField(IPropertyInfo existingPropInfo) {
            return !(existingPropInfo instanceof JavaFieldPropertyInfo) || existingPropInfo.isPublic() || existingPropInfo.isProtected();
        }

        private GosuClassTypeInfo getTypeInfoForType(IType typeToGetEnhancementsFor, IGosuEnhancementInternal enhancementType) {
            if (enhancementType.isGenericType() && typeToGetEnhancementsFor.isParameterizedType() || typeToGetEnhancementsFor.isArray()) {
                enhancementType = this.parameterizeEnhancement(enhancementType, typeToGetEnhancementsFor);
            } else if (enhancementType.isGenericType() && typeToGetEnhancementsFor.isArray()) {
                enhancementType = (IGosuEnhancementInternal)enhancementType.getParameterizedType(new IType[]{typeToGetEnhancementsFor.getComponentType()});
            }
            return (GosuClassTypeInfo)enhancementType.getTypeInfo();
        }

        private IGosuEnhancementInternal parameterizeEnhancement(IGosuEnhancementInternal enhancementType, IType typeToGetEnhancementsFor) {
            if (typeToGetEnhancementsFor.isArray()) {
                typeToGetEnhancementsFor = typeToGetEnhancementsFor.getComponentType().isPrimitive() ? TypeLord.getBoxedTypeFromPrimitiveType(typeToGetEnhancementsFor.getComponentType()).getArrayType() : typeToGetEnhancementsFor;
                IType genericEnhancedType = TypeLord.getPureGenericType(enhancementType.getEnhancedType());
                TypeVarToTypeMap typeVars = new TypeVarToTypeMap();
                TypeLord.inferTypeVariableTypesFromGenParamTypeAndConcreteType(genericEnhancedType, typeToGetEnhancementsFor, typeVars);
                if (typeVars.size() > 0) {
                    return (IGosuEnhancementInternal)enhancementType.getParameterizedType((IType[])typeVars.values().stream().map(Pair::getFirst).toArray(IType[]::new));
                }
                return enhancementType;
            }
            IType genericEnhancedType = TypeLord.getPureGenericType(enhancementType.getEnhancedType());
            IType parameterizedEnhancedType = TypeLord.findParameterizedType(typeToGetEnhancementsFor, genericEnhancedType);
            TypeVarToTypeMap map = new TypeVarToTypeMap();
            for (IGenericTypeVariable gtv : enhancementType.getGenericTypeVariables()) {
                map.put(gtv.getTypeVariableDefinition().getType(), null);
            }
            IGenericTypeVariable[] gtvs = enhancementType.getEnhancedType().getGenericTypeVariables();
            if (gtvs != null) {
                for (int i = 0; i < gtvs.length; ++i) {
                    IGenericTypeVariable gtv = gtvs[i];
                    TypeLord.inferTypeVariableTypesFromGenParamTypeAndConcreteType((IType)gtv.getTypeVariableDefinition().getType(), parameterizedEnhancedType.getTypeParameters()[i], map);
                }
            }
            block2: for (ITypeVariableType key : new ArrayList(map.keySet())) {
                if (map.get(key) != null) continue;
                for (IGenericTypeVariable gtv : enhancementType.getGenericTypeVariables()) {
                    if (!gtv.getTypeVariableDefinition().getType().equals(key)) continue;
                    map.put(gtv.getTypeVariableDefinition().getType(), gtv.getBoundingType());
                    continue block2;
                }
            }
            if (map.size() > 0) {
                List<IType> typeParamList = this.makeOrderedTypeParams(map, enhancementType);
                return (IGosuEnhancementInternal)enhancementType.getParameterizedType(typeParamList.toArray(new IType[typeParamList.size()]));
            }
            return enhancementType;
        }

        private List<IType> makeOrderedTypeParams(TypeVarToTypeMap map, IGosuEnhancementInternal enhancementType) {
            ArrayList<IType> typeParams = new ArrayList<IType>();
            for (IGenericTypeVariable gtv : enhancementType.getGenericTypeVariables()) {
                typeParams.add(map.get(gtv.getTypeVariableDefinition().getType()));
            }
            return typeParams;
        }

        private Map<String, List<IMethodInfo>> createMethodMap(Collection<IMethodInfo> methodsToAddTo) {
            HashMap<String, List<IMethodInfo>> returnMap = new HashMap<String, List<IMethodInfo>>();
            for (IMethodInfo methodInfo : methodsToAddTo) {
                ArrayList<IMethodInfo> list = (ArrayList<IMethodInfo>)returnMap.get(methodInfo.getDisplayName());
                if (list == null) {
                    list = new ArrayList<IMethodInfo>();
                    returnMap.put(methodInfo.getDisplayName(), list);
                }
                list.add(methodInfo);
            }
            return returnMap;
        }

        private boolean shouldAddMethod(IMethodInfo enhancementMethodInfo, IGosuEnhancement enhancementType, IType typeToGetEnhancementsFor) {
            if (this._methodNamesToMethods == null) {
                this._methodNamesToMethods = this.createMethodMap(this._methodsToAddTo);
            }
            IParameterInfo[] extensionParams = enhancementMethodInfo.getParameters();
            List<IMethodInfo> matchingMethods = this._methodNamesToMethods.get(enhancementMethodInfo.getDisplayName());
            if (!typeToGetEnhancementsFor.isArray() && (enhancementMethodInfo.isPrivate() || enhancementMethodInfo.isInternal() && !enhancementType.getNamespace().equals(typeToGetEnhancementsFor.getNamespace()))) {
                return false;
            }
            if (matchingMethods != null) {
                for (IMethodInfo methodInfo : matchingMethods) {
                    IParameterInfo[] methodParams = methodInfo.getParameters();
                    if (methodParams.length != extensionParams.length || !this.paramTypesEqual(methodParams, extensionParams)) continue;
                    return false;
                }
            }
            return true;
        }

        private boolean paramTypesEqual(IParameterInfo[] methodParams, IParameterInfo[] extensionParams) {
            for (int i = 0; i < methodParams.length; ++i) {
                if (GosuObjectUtil.equals((Object)methodParams[i].getFeatureType(), (Object)extensionParams[i].getFeatureType())) continue;
                return false;
            }
            return true;
        }
    }
}

