/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.CompoundType;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.TypeVariableType;
import gw.internal.gosu.parser.expressions.TypeVariableDefinition;
import gw.internal.gosu.parser.expressions.TypeVariableDefinitionImpl;
import gw.lang.parser.Keyword;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.parser.expressions.ITypeVariableDefinition;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeVariableType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.java.IJavaClassType;
import gw.lang.reflect.java.IJavaClassTypeVariable;
import gw.lang.reflect.java.JavaTypes;

public class GenericTypeVariable
implements IGenericTypeVariable {
    public static final GenericTypeVariable[] EMPTY_TYPEVARS = new GenericTypeVariable[0];
    private String _strName;
    private TypeVariableDefinitionImpl _typeVariableDefinition;
    private IType _boundingType;

    public GenericTypeVariable(String strName, IType boundingType) {
        this._strName = strName;
        this._typeVariableDefinition = null;
        this.setBoundingType(boundingType);
        if (boundingType == null) {
            throw new IllegalArgumentException("bounding type is null");
        }
    }

    public GenericTypeVariable(TypeVariableDefinitionImpl typeVariableDefinition, IType boundingType) {
        this._strName = typeVariableDefinition.getName();
        this._typeVariableDefinition = typeVariableDefinition;
        this.setBoundingType(boundingType);
        if (boundingType == null) {
            throw new IllegalArgumentException("bounding type is null");
        }
    }

    public GenericTypeVariable(IType enclosingType, IJavaClassTypeVariable typeVar, TypeVarToTypeMap actualParamByVarName) {
        this._strName = typeVar.getName();
        IJavaClassType[] fromBounds = typeVar.getBounds();
        IType[] boundingTypes = new IType[fromBounds.length];
        TypeVariableDefinitionImpl typeVarDef = new TypeVariableDefinitionImpl(null, this._strName, enclosingType, null, this, typeVar.getVariance());
        TypeVariableType typeVarType = new TypeVariableType(typeVarDef, enclosingType instanceof IFunctionType);
        actualParamByVarName.put((ITypeVariableType)typeVarType, (IType)typeVarType);
        for (int j = 0; j < fromBounds.length; ++j) {
            boundingTypes[j] = fromBounds[j] != null ? fromBounds[j].getActualType(actualParamByVarName, true) : TypeSystem.getErrorType();
            if (boundingTypes[j] == null) {
                throw new IllegalArgumentException("bounding type [" + j + "] is null");
            }
            if (!boundingTypes[j].isPrimitive()) continue;
            boundingTypes[j] = TypeSystem.getBoxType((IType)boundingTypes[j]);
        }
        this.setBoundingType(boundingTypes.length == 1 ? boundingTypes[0] : CompoundType.get(boundingTypes));
        if (enclosingType != null) {
            TypeVariableDefinition typeVariableDefinition = typeVarType != null ? new TypeVariableDefinition(enclosingType, this, (TypeVariableDefinitionImpl)typeVarType.getTypeVarDef(), typeVarType) : new TypeVariableDefinition(enclosingType, this);
            this._typeVariableDefinition = (TypeVariableDefinitionImpl)typeVariableDefinition.getTypeVarDef();
        }
    }

    private GenericTypeVariable(String strName, TypeVariableDefinitionImpl typeVariableDefinition, IType boundingType) {
        this._strName = strName;
        this._typeVariableDefinition = typeVariableDefinition;
        this._typeVariableDefinition.setTypeVar(this);
        this._boundingType = boundingType;
    }

    public GenericTypeVariable(GenericTypeVariable source) {
        this._strName = source._strName;
        this._boundingType = source._boundingType;
        this._typeVariableDefinition = source._typeVariableDefinition;
    }

    public String getName() {
        return this._strName;
    }

    public void setName(String strName) {
        this._strName = strName;
    }

    public String getNameWithBounds(boolean bRelative) {
        return this._boundingType == JavaTypes.OBJECT() ? this.getName() : this.getName() + " " + Keyword.KW_extends + " " + (bRelative ? this._boundingType.getRelativeName() : this._boundingType.getName());
    }

    public ITypeVariableDefinition getTypeVariableDefinition() {
        return this._typeVariableDefinition;
    }

    public IType getBoundingType() {
        return this._boundingType;
    }

    private void setBoundingType(IType type) {
        if (type != null && type.isPrimitive()) {
            type = TypeSystem.getBoxType((IType)type);
        }
        this._boundingType = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericTypeVariable that = (GenericTypeVariable)o;
        return this._boundingType.equals(that._boundingType) && this._strName.equals(that._strName);
    }

    public int hashCode() {
        return this._strName.hashCode();
    }

    public static GenericTypeVariable[] convertTypeVars(IType enclosingType, IType classType, IJavaClassTypeVariable[] fromVars) {
        TypeVarToTypeMap paramByVarNameIncludingMethod = new TypeVarToTypeMap();
        GenericTypeVariable[] toVars = new GenericTypeVariable[fromVars.length];
        for (int i = 0; i < toVars.length; ++i) {
            TypeVarToTypeMap classTypeVars;
            TypeVarToTypeMap typeVarToTypeMap = classTypeVars = classType == null ? new TypeVarToTypeMap() : TypeLord.mapTypeByVarName(classType, classType);
            if (classTypeVars == TypeVarToTypeMap.EMPTY_MAP) {
                classTypeVars = new TypeVarToTypeMap();
            }
            toVars[i] = new GenericTypeVariable(enclosingType, fromVars[i], classTypeVars);
            paramByVarNameIncludingMethod.put(toVars[i].getTypeVariableDefinition().getType(), (IType)toVars[i].getTypeVariableDefinition().getType());
        }
        return toVars.length == 0 ? EMPTY_TYPEVARS : toVars;
    }

    public IGenericTypeVariable copy() {
        return new GenericTypeVariable(this._strName, this._typeVariableDefinition.clone(), this._boundingType);
    }

    public IGenericTypeVariable copy(IType boundingType) {
        TypeVariableDefinitionImpl tvd = this._typeVariableDefinition.cloneShallow(boundingType);
        return new GenericTypeVariable(this._strName, tvd, boundingType);
    }

    public IGenericTypeVariable remapBounds(TypeVarToTypeMap actualParamByVarName) {
        IType boundingType = TypeLord.getActualType(this._boundingType, actualParamByVarName, true);
        if (boundingType == this._boundingType) {
            return this;
        }
        return this.copy(boundingType);
    }

    public void createTypeVariableDefinition(IType enclosingType) {
        this._typeVariableDefinition = (TypeVariableDefinitionImpl)new TypeVariableDefinition(enclosingType, this).getTypeVarDef();
    }
}

