/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.ir.transform.util.IRTypeResolver;
import gw.internal.gosu.parser.CapturedSymbol;
import gw.internal.gosu.parser.ClassScopeCache;
import gw.internal.gosu.parser.CompilationState;
import gw.internal.gosu.parser.CompileTimeAnnotationHandler;
import gw.internal.gosu.parser.CompiledGosuClassSymbolTable;
import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.internal.gosu.parser.DynamicPropertySymbol;
import gw.internal.gosu.parser.DynamicSymbol;
import gw.internal.gosu.parser.EnumAllValuesPropertySymbol;
import gw.internal.gosu.parser.EnumCodePropertySymbol;
import gw.internal.gosu.parser.EnumDisplayNamePropertySymbol;
import gw.internal.gosu.parser.EnumNamePropertySymbol;
import gw.internal.gosu.parser.EnumOrdinalPropertySymbol;
import gw.internal.gosu.parser.EnumValueOfFunctionSymbol;
import gw.internal.gosu.parser.EnumValuePropertySymbol;
import gw.internal.gosu.parser.EnumValuesFunctionSymbol;
import gw.internal.gosu.parser.ErrorType;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.GosuAnnotation;
import gw.internal.gosu.parser.GosuClass;
import gw.internal.gosu.parser.GosuClassCompilingStack;
import gw.internal.gosu.parser.GosuClassParseInfo;
import gw.internal.gosu.parser.GosuClassProxyFactory;
import gw.internal.gosu.parser.GosuClassTransparentActivationContext;
import gw.internal.gosu.parser.GosuConstructorInfo;
import gw.internal.gosu.parser.GosuMethodInfo;
import gw.internal.gosu.parser.GosuParser;
import gw.internal.gosu.parser.GosuPropertyInfo;
import gw.internal.gosu.parser.GosuVarPropertyInfo;
import gw.internal.gosu.parser.ICompilableTypeInternal;
import gw.internal.gosu.parser.IGosuAnnotation;
import gw.internal.gosu.parser.IGosuClassFragment;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.IGosuEnhancementInternal;
import gw.internal.gosu.parser.IGosuProgramInternal;
import gw.internal.gosu.parser.IGosuTemplateInternal;
import gw.internal.gosu.parser.InitConstructorFunctionSymbol;
import gw.internal.gosu.parser.InnerClassFileSystemSourceFileHandle;
import gw.internal.gosu.parser.InnerClassNotFoundException;
import gw.internal.gosu.parser.LazyLightweightParserState;
import gw.internal.gosu.parser.ModifierInfo;
import gw.internal.gosu.parser.OuterFunctionSymbol;
import gw.internal.gosu.parser.ParseTree;
import gw.internal.gosu.parser.ParsedElement;
import gw.internal.gosu.parser.ParserBase;
import gw.internal.gosu.parser.ReducedDynamicPropertySymbol;
import gw.internal.gosu.parser.SourceCodeTokenizer;
import gw.internal.gosu.parser.Statement;
import gw.internal.gosu.parser.SuperConstructorFunctionSymbol;
import gw.internal.gosu.parser.Symbol;
import gw.internal.gosu.parser.ThisConstructorFunctionSymbol;
import gw.internal.gosu.parser.Token;
import gw.internal.gosu.parser.TypeLoaderAccess;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.VarPropertyGetFunctionSymbol;
import gw.internal.gosu.parser.VarPropertySetFunctionSymbol;
import gw.internal.gosu.parser.expressions.BlockExpression;
import gw.internal.gosu.parser.expressions.ClassDeclaration;
import gw.internal.gosu.parser.expressions.InterfacesClause;
import gw.internal.gosu.parser.expressions.MethodCallExpression;
import gw.internal.gosu.parser.expressions.NameInDeclaration;
import gw.internal.gosu.parser.expressions.NullExpression;
import gw.internal.gosu.parser.expressions.ParameterListClause;
import gw.internal.gosu.parser.expressions.SuperTypeClause;
import gw.internal.gosu.parser.expressions.TypeLiteral;
import gw.internal.gosu.parser.expressions.TypeVariableDefinitionImpl;
import gw.internal.gosu.parser.statements.ClassStatement;
import gw.internal.gosu.parser.statements.ConstructorStatement;
import gw.internal.gosu.parser.statements.DelegateStatement;
import gw.internal.gosu.parser.statements.FunctionStatement;
import gw.internal.gosu.parser.statements.MethodCallStatement;
import gw.internal.gosu.parser.statements.NamespaceStatement;
import gw.internal.gosu.parser.statements.NoOpStatement;
import gw.internal.gosu.parser.statements.NotAStatement;
import gw.internal.gosu.parser.statements.PropertyStatement;
import gw.internal.gosu.parser.statements.ReturnStatement;
import gw.internal.gosu.parser.statements.StatementList;
import gw.internal.gosu.parser.statements.UsesStatement;
import gw.internal.gosu.parser.statements.VarInitializationVerifier;
import gw.internal.gosu.parser.statements.VarStatement;
import gw.lang.annotation.UsageTarget;
import gw.lang.ir.IRType;
import gw.lang.parser.AnnotationUseSiteTarget;
import gw.lang.parser.GosuParserTypes;
import gw.lang.parser.IActivationContext;
import gw.lang.parser.IBlockClass;
import gw.lang.parser.IDynamicFunctionSymbol;
import gw.lang.parser.IFunctionSymbol;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IParsedElementWithAtLeastOneDeclaration;
import gw.lang.parser.IParserState;
import gw.lang.parser.IReducedDynamicFunctionSymbol;
import gw.lang.parser.IScope;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.IStackProvider;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.IToken;
import gw.lang.parser.ITokenizerOffsetMarker;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.parser.Keyword;
import gw.lang.parser.ScriptPartId;
import gw.lang.parser.exceptions.NotImplementedParseException;
import gw.lang.parser.exceptions.ObsoleteConstructorWarning;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.parser.exceptions.ParseIssue;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.parser.expressions.IMemberAccessExpression;
import gw.lang.parser.expressions.IModifierListClause;
import gw.lang.parser.expressions.IParameterDeclaration;
import gw.lang.parser.expressions.IProgram;
import gw.lang.parser.expressions.ITypeVariableDefinition;
import gw.lang.parser.expressions.ITypeVariableDefinitionExpression;
import gw.lang.parser.expressions.Variance;
import gw.lang.parser.resources.Res;
import gw.lang.parser.resources.ResourceKey;
import gw.lang.parser.statements.IClassStatement;
import gw.lang.parser.statements.IFunctionStatement;
import gw.lang.parser.statements.ITerminalStatement;
import gw.lang.parser.statements.IUsesStatementList;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IEnhanceableType;
import gw.lang.reflect.IErrorType;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IInvocableType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.ITypeVariableType;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ClassType;
import gw.lang.reflect.gs.ICompilableType;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuClassParser;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.gs.IGosuMethodInfo;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.gs.StringSourceFileHandle;
import gw.lang.reflect.java.GosuTypes;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.util.DynamicArray;
import gw.util.GosuExceptionUtil;
import gw.util.GosuObjectUtil;
import gw.util.GosuStringUtil;
import gw.util.Stack;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GosuClassParser
extends ParserBase
implements IGosuClassParser,
ITokenizerOffsetMarker {
    private int _iClassOffset;
    private int _iClassLineNum;
    private int _iClassColumn;
    private ClassStatement _classStmt;
    private Stack<IGosuClassInternal> _innerClasses;
    private int _innerClassOffset;

    public GosuClassParser(GosuParser owner) {
        super(owner);
        this._innerClasses = new Stack();
    }

    private GosuClassParser(GosuParser owner, IGosuClassInternal innerClass) {
        super(owner);
        int mark = ((InnerClassFileSystemSourceFileHandle)innerClass.getSourceFileHandle()).getMark();
        if (mark >= 0) {
            this.getTokenizer().restoreToMark(mark);
        } else {
            this.goToPosition(innerClass.getSourceFileHandle().getOffset());
        }
        this._innerClassOffset = this.getTokenizer().mark();
        this._innerClasses = new Stack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseAnonymousInnerClass(GosuParser gosuParser, IGosuClassInternal innerGsClass) {
        Stack enclosingBlocks = gosuParser._blocks;
        gosuParser.setBlocks(null);
        Map<String, List<IFunctionSymbol>> restoreDfsDecls = GosuClassParser.copyDFSDecls(gosuParser);
        try {
            new GosuClassParser(gosuParser, innerGsClass).parseHeader(innerGsClass, false, true, true);
            new GosuClassParser(gosuParser, innerGsClass).parseDeclarations(innerGsClass);
            if (!gosuParser.getContextType().isMethodScoring()) {
                new GosuClassParser(gosuParser, innerGsClass).parseDefinitions(innerGsClass);
            }
        }
        finally {
            gosuParser.setDfsDeclInSetByName(restoreDfsDecls);
            gosuParser.setBlocks((Stack<BlockExpression>)enclosingBlocks);
        }
    }

    @Override
    protected String getScript() {
        return this.getOwner().getScript();
    }

    @Override
    public int getLineNumShift() {
        return this.getOwner().getLineNumShift();
    }

    @Override
    public int getOffsetShift() {
        return this.getOwner().getOffsetShift();
    }

    public int getOffsetMark() {
        if (this.isInnerClass(this.getGosuClass())) {
            return this._innerClassOffset;
        }
        return -1;
    }

    @Override
    public ClassStatement getClassStatement() {
        return this._classStmt;
    }

    private void setClassStatement(ClassStatement classStmt) {
        if (classStmt == null) {
            throw new IllegalArgumentException("Class stmt is null");
        }
        this._classStmt = classStmt;
    }

    private IGosuClassInternal getCurrentInnerClass() {
        return this._innerClasses.isEmpty() ? null : (IGosuClassInternal)this._innerClasses.peek();
    }

    private void pushInnerClass(IGosuClassInternal gsInnerClass) {
        this._innerClasses.push((Object)gsInnerClass);
    }

    private IGosuClassInternal popInnerClass(IGosuClassInternal gsInnerClass) {
        IGosuClassInternal top = (IGosuClassInternal)this._innerClasses.pop();
        if (top != gsInnerClass) {
            throw new IllegalStateException("Unbalanced push/pop for inner classes");
        }
        return top;
    }

    private boolean isInnerClassesEmpty() {
        return this._innerClasses.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseDeclarations(IGosuClass gsCls) {
        IGosuClassInternal gsClass = (IGosuClassInternal)gsCls;
        if (gsClass.isDeclarationsCompiled()) {
            if (!gsClass.isInnerDeclarationsCompiled() && this.parseDeclarationsOfLeftOverInnerClasses(gsClass)) {
                gsClass.setInnerDeclarationsCompiled();
            }
            return;
        }
        boolean bPushedScope = this.pushScopeIfNeeded(gsClass);
        this.getTokenizer().pushOffsetMarker(this);
        ScriptPartId scriptPartId = new ScriptPartId((IType)gsClass, null);
        this.getOwner().pushScriptPart((IScriptPartId)scriptPartId);
        GosuClassCompilingStack.pushCompilingType((IType)gsClass);
        gsClass.setCompilingDeclarations(true);
        try {
            ClassStatement classStmt = (ClassStatement)gsClass.getClassStatement();
            try {
                this.setClassStatement(classStmt);
            }
            catch (Exception e) {
                throw GosuExceptionUtil.forceThrow((Throwable)e, (String)gsClass.getName());
            }
            if (this.isTopLevelClass(gsClass) || TypeLord.isEvalProgram((IType)gsClass)) {
                classStmt.getClassFileStatement().clearParseTreeInformation();
            }
            this.getSymbolTable().pushScope();
            try {
                String strClassName = this.parseHeader(gsClass, false, false, true);
                if (gsClass instanceof IGosuEnhancementInternal) {
                    this.parseEnhancementBodyDecl(gsClass);
                } else {
                    this.parseClassBodyDecl(strClassName, gsClass);
                }
            }
            finally {
                this.getSymbolTable().popScope();
                this.pushStatement(classStmt);
                this.setLocation(this._iClassOffset, this._iClassLineNum, this._iClassColumn, true);
                this.popStatement();
                if (this.isTopLevelClass(gsClass) || TypeLord.isEvalProgram((IType)gsClass)) {
                    this.pushStatement(classStmt.getClassFileStatement());
                    this.setLocation(0, 1, this._iClassColumn, true);
                    this.popStatement();
                }
            }
            classStmt.compactParseTree();
        }
        finally {
            gsClass.setCompilingDeclarations(false);
            GosuClassCompilingStack.popCompilingType();
            this.getOwner().popScriptPart((IScriptPartId)scriptPartId);
            this.popScopeIfNeeded(bPushedScope, gsClass);
            this.getTokenizer().popOffsetMarker(this);
            this.removeTypeVarsFromParserMap(gsClass);
        }
    }

    private boolean isTopLevelClass(IGosuClassInternal gsClass) {
        return gsClass.getEnclosingType() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseDefinitions(IGosuClass gsCls) {
        IGosuClassInternal gsClass = (IGosuClassInternal)gsCls;
        this.getTokenizer().pushOffsetMarker(this);
        boolean bPushedScope = this.pushScopeIfNeeded(gsClass);
        gsClass.setCompilingDefinitions(true);
        GosuClassParseInfo parseInfo = gsClass.getParseInfo();
        ClassStatement classStmt = parseInfo.getClassStatement();
        this.setClassStatement(classStmt);
        this.clearParseTree(gsClass);
        ScriptPartId scriptPartId = new ScriptPartId((IType)gsClass, null);
        this.getOwner().pushScriptPart((IScriptPartId)scriptPartId);
        GosuClassCompilingStack.pushCompilingType((IType)gsClass);
        ++this.getOwner()._iReturnOk;
        if (this.isDeprecated((ModifierInfo)gsCls.getModifierInfo())) {
            this.getOwner().pushIgnoreTypeDeprecation();
        }
        try {
            try {
                if (!gsClass.isDefinitionsCompiled()) {
                    boolean b;
                    block34: {
                        this.getSymbolTable().pushScope();
                        try {
                            this.getTokenizer().reset();
                            if (this.isTopLevelClass(gsClass) || TypeLord.isEvalProgram((IType)gsClass)) {
                                this.getLocationsList().clear();
                            } else {
                                this.removeInnerClassDelcarationsFromLocationsList(gsClass);
                            }
                            this.parseHeader(gsClass, false, false, true);
                            if (gsClass instanceof IGosuEnhancementInternal) {
                                this.parseClassStatementAsEnhancement(gsClass);
                                break block34;
                            }
                            this.parseClassStatement();
                        }
                        catch (Throwable throwable) {
                            boolean b2;
                            this.getSymbolTable().popScope();
                            if (gsClass instanceof IGosuProgramInternal) {
                                ((IGosuProgramInternal)gsClass).setParsingExecutableProgramStatements(true);
                                try {
                                    FunctionStatement fs = this.parseExecutableProgramStatements((IGosuProgramInternal)gsClass);
                                    this.makeExprRootFunction((IGosuProgramInternal)gsClass, fs);
                                }
                                finally {
                                    ((IGosuProgramInternal)gsClass).setParsingExecutableProgramStatements(false);
                                }
                            }
                            boolean bl = b2 = this.isInnerClass(gsClass) || this.match(null, -1);
                            if (!this.verify((ParsedElement)classStmt, b2, Res.MSG_END_OF_STMT, new String[0])) {
                                this.consumeTrailingTokens();
                            }
                            gsClass.setDefinitionsCompiled();
                            throw throwable;
                        }
                    }
                    this.getSymbolTable().popScope();
                    if (gsClass instanceof IGosuProgramInternal) {
                        ((IGosuProgramInternal)gsClass).setParsingExecutableProgramStatements(true);
                        try {
                            FunctionStatement fs = this.parseExecutableProgramStatements((IGosuProgramInternal)gsClass);
                            this.makeExprRootFunction((IGosuProgramInternal)gsClass, fs);
                        }
                        finally {
                            ((IGosuProgramInternal)gsClass).setParsingExecutableProgramStatements(false);
                        }
                    }
                    boolean bl = b = this.isInnerClass(gsClass) || this.match(null, -1);
                    if (!this.verify((ParsedElement)classStmt, b, Res.MSG_END_OF_STMT, new String[0])) {
                        this.consumeTrailingTokens();
                    }
                    gsClass.setDefinitionsCompiled();
                }
                if (this.isTopLevelClass(gsClass) || TypeLord.isEvalProgram((IType)gsClass)) {
                    this.getOwner().setParsed(true);
                }
            }
            finally {
                this.pushStatement(classStmt);
                this.setLocation(this._iClassOffset, this._iClassLineNum, this._iClassColumn, true);
                if (this.isTopLevelClass(gsClass) || TypeLord.isEvalProgram((IType)gsClass)) {
                    this.popStatement();
                    this.pushStatement(classStmt.getClassFileStatement());
                    this.setLocation(0, 1, this._iClassColumn, true);
                    this.popStatement();
                }
                this.assignTokens(classStmt);
            }
            try {
                this.verifyParsedElement(this.isInnerClass(gsClass) && !TypeLord.isEvalProgram((IType)gsClass) ? classStmt : classStmt.getClassFileStatement());
            }
            catch (ParseResultsException pre) {
                gsClass.setParseResultsException(pre);
            }
        }
        finally {
            try {
                gsClass.setCompilingDefinitions(false);
                gsClass.setDefinitionsCompiled();
                this.getOwner().popScriptPart((IScriptPartId)scriptPartId);
            }
            finally {
                GosuClassCompilingStack.popCompilingType();
            }
            this.popScopeIfNeeded(bPushedScope, gsClass);
            this.getTokenizer().popOffsetMarker(this);
            this.removeTypeVarsFromParserMap(gsClass);
            --this.getOwner()._iReturnOk;
            this.pushStatement(this._classStmt.getClassFileStatement());
            this.setLocation(0, 1, this._iClassColumn, true);
            this.popStatement();
            if (this.isDeprecated((ModifierInfo)gsCls.getModifierInfo())) {
                this.getOwner().popIgnoreTypeDeprecation();
            }
            gsClass.syncGenericAndParameterizedClasses();
            this.getOwner().clearDfsStack();
            this._classStmt = null;
            VarInitializationVerifier.verifyFinalFields(gsClass);
            VarInitializationVerifier.verifyLocalVars(gsClass, true);
            if (this.isTopLevelClass(gsClass)) {
                this.postDefinitionVerify(classStmt);
            }
        }
    }

    private void postDefinitionVerify(IClassStatement classStmt) {
        if (classStmt == null) {
            return;
        }
        IGosuClass gsClass = classStmt.getGosuClass();
        if (gsClass.isAnonymous() || gsClass instanceof IBlockClass) {
            return;
        }
        CompileTimeAnnotationHandler.postDefinitionVerification((IParsedElement)classStmt);
        for (IGosuClass innerClass : classStmt.getGosuClass().getInnerClasses()) {
            this.postDefinitionVerify(innerClass.getClassStatement());
        }
    }

    private void removeInnerClassDelcarationsFromLocationsList(IGosuClassInternal gsClass) {
        ParseTree csr;
        List<ParseTree> locations = this.getLocationsList();
        for (int i = locations.size() - 1; i >= 0 && (csr = locations.get(i)).getScriptPartId().getContainingType() == gsClass; --i) {
            IParseTree parent = csr.getParent();
            if (parent != null) {
                parent.removeChild((IParseTree)csr);
            }
            locations.remove(csr);
        }
    }

    private void consumeTrailingTokens() {
        while (!this.match(null, -1)) {
            this.getTokenizer().nextToken();
        }
    }

    private void assignTokens(ClassStatement classStmt) {
        if (!this.getOwner().isEditorParser()) {
            return;
        }
        if (!this.isTopLevelClass(classStmt.getGosuClass())) {
            return;
        }
        List tokens = this.getOwner().getTokenizer().getTokens().toList();
        classStmt.getClassFileStatement().assignTokens(tokens);
        Iterator iterator = tokens.iterator();
        if (iterator.hasNext()) {
            IToken token = (IToken)iterator.next();
            throw new IllegalStateException("One or more tokens were not assigned: " + token);
        }
    }

    private String buildInconsistentParseErrorMessage(String strSource, String strTextFromParseTree, int[] diff) {
        return "Parsed class, " + this.getGosuClass().getName() + ", inconsistent with source.\nLine: " + diff[1] + "  Offset: " + diff[0] + "\n*** Parsed Version ***\n" + ParseIssue.makeContextString((int)diff[1], (String)strTextFromParseTree, (int)diff[2]) + "\n*** Source Version ***\n" + ParseIssue.makeContextString((int)diff[1], (String)strSource, (int)diff[2]) + "\n";
    }

    private int[] getDiffOffset(String strSource, String strTextFromParseTree) {
        int i;
        if (strSource == null || strTextFromParseTree == null) {
            return null;
        }
        int iLineOffset = 0;
        int iLine = 0;
        for (i = 0; i < strSource.length(); ++i) {
            char parserChar;
            if (i >= strTextFromParseTree.length()) {
                return new int[]{i, iLine, iLineOffset};
            }
            char sourceChar = strSource.charAt(i);
            if (sourceChar != (parserChar = strTextFromParseTree.charAt(i))) {
                return new int[]{i, iLine, iLineOffset};
            }
            if (parserChar != '\n') continue;
            ++iLine;
            iLineOffset = i;
        }
        return new int[]{i, iLine, iLineOffset};
    }

    private void clearParseTree(IGosuClassInternal gsClass) {
        if (!(gsClass instanceof IGosuProgram) && this.isTopLevelClass(gsClass) || TypeLord.isEvalProgram((IType)gsClass)) {
            gsClass.getClassStatement().getClassFileStatement().clearParseTreeInformation();
        } else {
            ParseTree last;
            gsClass.getClassStatement().clearParseTreeInformation();
            if (gsClass.isAnonymous() && !this.getLocationsList().isEmpty() && (last = this.getLocationsList().get(this.getLocationsList().size() - 1)).getParsedElement() == null) {
                this.getLocationsList().remove(last);
            }
        }
    }

    private boolean isInnerClass(IGosuClassInternal gsClass) {
        return gsClass.getEnclosingType() != null;
    }

    private FunctionStatement parseExecutableProgramStatements(IGosuProgramInternal gsClass) {
        List<IParseTree> savedLocations = this.getOwner().getLocations();
        this.getTokenizer().resetButKeepTokens();
        this.getLocationsList().clear();
        this.getOwner().setLocationsFromProgramClassParser(savedLocations);
        this.parseHeader(gsClass, false, false, true);
        gsClass.addCapturedProgramSymbols(this.getSymbolTable());
        FunctionStatement fs = this.parseProgramAsFunctionStatement(gsClass);
        List<IParseTree> newLocations = this.getOwner().getLocations();
        this.removeRedundantUsesStatementList(newLocations);
        this.getOwner().getLocationsList().clear();
        this.getOwner().setLocationsFromProgramClassParser(null);
        this.getOwner().getLocationsList().addAll(savedLocations);
        this.getOwner().getLocationsList().addAll(newLocations);
        return fs;
    }

    private void removeRedundantUsesStatementList(List newLocations) {
        for (int i = 0; i < newLocations.size(); ++i) {
            IParseTree pt = (IParseTree)newLocations.get(i);
            if (!(pt.getParsedElement() instanceof IUsesStatementList)) continue;
            newLocations.remove(i--);
        }
    }

    private void makeExprRootFunction(IGosuProgramInternal gsClass, FunctionStatement callableStmt) {
        DynamicFunctionSymbol dfsDecl = this.getProgramRootExprValueDfs();
        if (dfsDecl != null) {
            this.getOwner().putDfsDeclInSetByName(dfsDecl);
            StatementList stmtList = this.makeReturnStatementWithExprRoot(gsClass, callableStmt);
            if (stmtList != null) {
                FunctionStatement fs = new FunctionStatement();
                fs.setDynamicFunctionSymbol(dfsDecl);
                dfsDecl.setValueDirectly(stmtList);
                this.getOwner().pushDynamicFunctionSymbol(dfsDecl);
                fs.setDynamicFunctionSymbol(dfsDecl);
                dfsDecl.setClassMember(true);
                gsClass.getParseInfo().addMemberFunction(dfsDecl);
            }
        }
    }

    private StatementList makeReturnStatementWithExprRoot(IGosuProgramInternal gsClass, FunctionStatement callableStmt) {
        Statement statement = (Statement)callableStmt.getDynamicFunctionSymbol().getValueDirectly();
        if (statement != null) {
            ReturnStatement rs;
            Expression expr;
            boolean[] bAbsolute = new boolean[]{false};
            ITerminalStatement significantTerminalStatement = statement.getLeastSignificantTerminalStatement(bAbsolute);
            if (gsClass.isGenRootExprAccess() && bAbsolute[0] && significantTerminalStatement instanceof ReturnStatement && significantTerminalStatement.getParent() != null && significantTerminalStatement.getParent().getParent() == callableStmt && (expr = (rs = (ReturnStatement)significantTerminalStatement).getValue()) instanceof IMemberAccessExpression) {
                Expression rootExpr = (Expression)((IMemberAccessExpression)expr).getRootExpression();
                ReturnStatement defaultReturnStmt = new ReturnStatement();
                defaultReturnStmt.setValue(rootExpr);
                ArrayList<Statement> stmts = new ArrayList<Statement>(2);
                stmts.add(defaultReturnStmt);
                StatementList stmtList = new StatementList((IStackProvider)this.getSymbolTable());
                stmtList.setStatements(stmts);
                return stmtList;
            }
        }
        ReturnStatement defaultReturnStmt = new ReturnStatement();
        NullExpression nullExpr = new NullExpression();
        nullExpr.setType((IType)JavaTypes.OBJECT());
        defaultReturnStmt.setValue(nullExpr);
        ArrayList<Statement> stmts = new ArrayList<Statement>(2);
        stmts.add(defaultReturnStmt);
        StatementList stmtList = new StatementList((IStackProvider)this.getSymbolTable());
        stmtList.setStatements(stmts);
        return stmtList;
    }

    private DynamicFunctionSymbol getProgramRootExprValueDfs() {
        for (IDynamicFunctionSymbol dfs : this.getGosuClass().getMemberFunctions()) {
            if (!dfs.getName().contains("evaluateRootExpr")) continue;
            return (DynamicFunctionSymbol)dfs;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FunctionStatement parseProgramAsFunctionStatement(IGosuClassInternal gsClass) {
        FunctionStatement functionStmt;
        IScope nonstaticScope;
        Map<String, List<IFunctionSymbol>> nonstaticDfsMap;
        this.getSymbolTable().pushScope();
        try {
            this.getOwner().newDfsDeclInSetByName();
            gsClass.putClassMembers(this.getOwner(), this.getSymbolTable(), this.getGosuClass(), false);
            GosuClassParser.putTypeUsesMapFeatures(this.getOwner(), this.getSymbolTable(), this.getGosuClass());
            nonstaticDfsMap = this.getOwner().getDfsDecls();
            this.getOwner().newDfsDeclInSetByName();
        }
        finally {
            nonstaticScope = this.getSymbolTable().popScope();
        }
        this.getSymbolTable().pushScope();
        this.getOwner().newDfsDeclInSetByName();
        int iOffset = this.getTokenizer().getTokenStart();
        int iLineNum = this.getTokenizer().getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        try {
            DynamicFunctionSymbol dfs;
            this.getOwner().setDfsDeclInSetByName(nonstaticDfsMap);
            this.getOwner().putDfsDeclsInTable(((IGosuProgramInternal)this.getGosuClass()).getSymbolTable());
            this.getSymbolTable().pushScope(nonstaticScope);
            this.getOwner().pushParsingStaticMember(false);
            try {
                functionStmt = this.getOwner().parseProgramEntryPointBody();
            }
            finally {
                this.getSymbolTable().popScope();
                this.getOwner().popParsingStaticMember();
            }
            DynamicFunctionSymbol dynamicFunctionSymbol = dfs = functionStmt == null ? null : functionStmt.getDynamicFunctionSymbol();
            if (dfs != null) {
                dfs.setClassMember(true);
                if (dfs.getDisplayName().equals(gsClass.getRelativeName())) {
                    gsClass.getParseInfo().addConstructorFunction(dfs);
                } else {
                    gsClass.getParseInfo().addMemberFunction(dfs);
                }
            }
        }
        finally {
            this.getOwner().newDfsDeclInSetByName();
            this.getSymbolTable().popScope();
        }
        this.setLocation(iOffset, iLineNum, iColumn, true);
        if (this.getTokenizer().getTokenStart() == iOffset) {
            this.getLocationsList().remove(this.getLocationsList().size() - 1);
        }
        functionStmt = (FunctionStatement)this.popStatement();
        return functionStmt;
    }

    private void parseClassBodyDecl(String strClassName, IGosuClassInternal gsClass) {
        try {
            if (strClassName != null) {
                IType type = TypeLoaderAccess.instance().getIntrinsicTypeByFullName(strClassName);
                if (TypeSystem.getOrCreateTypeReference((IType)gsClass) != type && !(gsClass instanceof IGosuClassFragment)) {
                    this.getClassStatement().addParseException((IParseIssue)new ParseException((IParserState)this.makeFullParserState(), Res.MSG_DUPLICATE_CLASS_FOUND, new Object[]{type.getName()}));
                }
            }
        }
        catch (ClassNotFoundException type) {
            // empty catch block
        }
        this.maybeForceRecursiveTypeToAssignSuperTypes(gsClass);
        this.verify((ParsedElement)this.getClassStatement(), gsClass instanceof IGosuProgram || this.match(null, 123), Res.MSG_EXPECTING_OPEN_BRACE_FOR_CLASS_DEF, new String[0]);
        if (!this.putClassMembersOfSuperAndInterfaces(gsClass)) {
            gsClass.setDeclarationsBypassed();
            return;
        }
        if (this.isInnerClass(gsClass) && !gsClass.isStatic()) {
            this.addOuterMember(gsClass);
        }
        this.addAutomaticEnumMethodsAndProperties(gsClass);
        this.processEnumConstants(gsClass);
        Object member = this.parseFunctionOrConstructorOrFieldDeclaration(gsClass);
        while (member != null) {
            this.popStatement();
            if (member instanceof DynamicFunctionSymbol) {
                this.processFunctionSymbol((DynamicFunctionSymbol)member, gsClass);
            } else if (member instanceof DynamicPropertySymbol) {
                this.processPropertySymbol((DynamicPropertySymbol)member, gsClass);
            } else {
                this.processVarStmt(gsClass, (VarStatement)member);
            }
            member = this.parseFunctionOrConstructorOrFieldDeclaration(gsClass);
        }
        if (!gsClass.isInterface() && !gsClass.ensureDefaultConstructor(this.getSymbolTable(), this.getOwner())) {
            this.getClassStatement().addParseException((IParseIssue)new ParseException((IParserState)this.makeFullParserState(), Res.MSG_NO_DEFAULT_CTOR_IN, new Object[]{gsClass.getSupertype().getName()}));
        }
        boolean b = this.isInnerClass(gsClass) || this.match(null, -1);
        this.verify((ParsedElement)this.getClassStatement(), b, Res.MSG_END_OF_STMT, new String[0]);
        gsClass.addDelegateImpls(this.getSymbolTable(), this);
        if (gsClass instanceof IGosuProgramInternal) {
            ((IGosuProgramInternal)gsClass).addProgramEntryPoint(this.getSymbolTable(), this);
            if (gsClass instanceof IGosuTemplateInternal) {
                IGosuTemplateInternal gsTemplate = (IGosuTemplateInternal)gsClass;
                gsTemplate.addTemplateEntryPoints(this.getSymbolTable(), this);
                IProgram program = gsTemplate.getTemplateGenerator().getProgram();
                if (program != null) {
                    ((IGosuProgramInternal)program.getGosuProgram()).setContextType((IType)gsTemplate);
                }
            } else {
                ((IGosuProgramInternal)gsClass).addExecuteEntryPoint(this.getSymbolTable(), this);
            }
        }
        gsClass.syncGenericAndParameterizedClasses();
        gsClass.setDeclarationsCompiled();
        if (this.parseDeclarationsOfLeftOverInnerClasses(gsClass)) {
            gsClass.setInnerDeclarationsCompiled();
        }
    }

    private void maybeForceRecursiveTypeToAssignSuperTypes(IGosuClassInternal gsClass) {
        if (gsClass.isParameterizedType()) {
            gsClass.getSupertype();
            gsClass.getInterfaces();
        }
    }

    private boolean putClassMembersOfSuperAndInterfaces(IGosuClassInternal gsClass) {
        if (gsClass.isAnnotation() && JavaTypes.ANNOTATION().isAssignableFrom((IType)gsClass)) {
            return true;
        }
        ICompilableTypeInternal enclosingType = gsClass.getEnclosingType();
        if (enclosingType instanceof IGosuClassInternal && ((IGosuClassInternal)enclosingType).isHeaderCompiled() && TypeLord.encloses((IType)enclosingType, (IType)this.getOwner().getGosuClass())) {
            enclosingType.putClassMembers(this.getOwner(), this.getSymbolTable(), this.getGosuClass(), gsClass.isStatic());
        }
        for (IType type : gsClass.getInterfaces()) {
            if (type instanceof ErrorType || this.putClassMembers(type)) continue;
            return false;
        }
        return this.putClassMembers((IType)gsClass.getSuperClass());
    }

    private boolean putClassMembers(IType type) {
        IGosuClassInternal gsType = IGosuClassInternal.Util.getGosuClassFrom(type);
        if (gsType != null) {
            gsType.compileDeclarationsIfNeeded();
            if (!gsType.isDeclarationsCompiled()) {
                this.advanceToClassBodyEnd();
                return false;
            }
            gsType.putClassMembers(this.getOwner(), this.getSymbolTable(), this.getGosuClass(), false);
        }
        return true;
    }

    private boolean parseDeclarationsOfLeftOverInnerClasses(IGosuClassInternal gsClass) {
        int iCount = 0;
        Collection innerClasses = gsClass.getKnownInnerClassesWithoutCompiling().values();
        do {
            int iPriorCount = iCount;
            iCount = 0;
            for (IGosuClass c : innerClasses) {
                IGosuClassInternal innerClass = (IGosuClassInternal)c;
                if (innerClass.isDeclarationsCompiled() && innerClass.isInnerDeclarationsCompiled()) continue;
                if (innerClass.getSourceFileHandle() instanceof InnerClassFileSystemSourceFileHandle) {
                    int state = this.getTokenizer().mark();
                    this.parseInnerClassDeclaration(innerClass);
                    this.getTokenizer().restoreToMark(state);
                }
                iCount += innerClass.isDeclarationsCompiled() && innerClass.isInnerDeclarationsCompiled() ? 0 : 1;
            }
            if (iPriorCount <= 0 || iPriorCount != iCount) continue;
            return false;
        } while (iCount > 0);
        return true;
    }

    private void addAutomaticEnumMethodsAndProperties(IGosuClassInternal gsClass) {
        if (gsClass.isEnum()) {
            this.addEnumProperty(gsClass, new EnumCodePropertySymbol(gsClass, TypeSystem.getCompiledGosuClassSymbolTable()));
            this.addEnumProperty(gsClass, new EnumDisplayNamePropertySymbol(gsClass, TypeSystem.getCompiledGosuClassSymbolTable()));
            this.addEnumProperty(gsClass, new EnumNamePropertySymbol(gsClass, TypeSystem.getCompiledGosuClassSymbolTable()));
            this.addEnumProperty(gsClass, new EnumOrdinalPropertySymbol(gsClass, TypeSystem.getCompiledGosuClassSymbolTable()));
            this.addEnumProperty(gsClass, new EnumValuePropertySymbol(gsClass, TypeSystem.getCompiledGosuClassSymbolTable()));
            this.addEnumProperty(gsClass, new EnumAllValuesPropertySymbol(gsClass, TypeSystem.getCompiledGosuClassSymbolTable()));
            DynamicFunctionSymbol dfs = new EnumValueOfFunctionSymbol(gsClass, TypeSystem.getCompiledGosuClassSymbolTable());
            gsClass.getParseInfo().addMemberFunction(dfs);
            this.getOwner().putDfsDeclInSetByName(dfs);
            dfs = new EnumValuesFunctionSymbol(gsClass, TypeSystem.getCompiledGosuClassSymbolTable());
            gsClass.getParseInfo().addMemberFunction(dfs);
            this.getOwner().putDfsDeclInSetByName(dfs);
        }
    }

    private void addEnumProperty(IGosuClassInternal gsClass, DynamicPropertySymbol dps) {
        gsClass.getParseInfo().addMemberProperty(dps);
        this.getOwner().putDfsDeclInSetByName(dps.getGetterDfs());
    }

    private void processEnumConstants(IGosuClassInternal gsClass) {
        boolean bConst;
        boolean bEnum;
        boolean bl = bEnum = gsClass != null && gsClass.isEnum();
        if (!bEnum) {
            return;
        }
        Token t = new Token();
        int state = this.getTokenizer().mark();
        boolean bAtLeastOneConst = false;
        do {
            bConst = false;
            int iOffset = this.getTokenizer().getTokenStart();
            int iLineNum = this.getTokenizer().getLineNumber();
            int iColumn = this.getTokenizer().getTokenColumn();
            if (!this.match(t, null, -5, true) || Keyword.isKeyword((String)t._strValue) || !this.match(t, -5)) continue;
            VarStatement varStmt = this.parseEnumConstantDecl(t._strValue);
            varStmt.setNameOffset(t.getTokenStart(), t._strValue);
            this.setLocation(iOffset, iLineNum, iColumn);
            this.popStatement();
            this.processVarStmt(gsClass, varStmt);
            bConst = true;
            bAtLeastOneConst = true;
        } while (!this.match(null, 59) && bConst && this.match(null, 44));
        if (!bAtLeastOneConst) {
            this.getTokenizer().restoreToMark(state);
        }
    }

    private VarStatement parseEnumConstantDecl(String strIdentifier) {
        VarStatement varStmt = new VarStatement();
        ModifierInfo modifiers = new ModifierInfo(25);
        varStmt.setModifierInfo(modifiers);
        this.verify((ParsedElement)varStmt, this.getSymbolTable().getSymbol((CharSequence)strIdentifier) == null, Res.MSG_VARIABLE_ALREADY_DEFINED, strIdentifier);
        if (this.match(null, null, 40, true)) {
            this.eatParenthesized(varStmt, Res.MSG_EXPECTING_RIGHTPAREN_FUNCTION_DEF);
            if (this.match(null, null, 123, true)) {
                this.eatStatementBlock(varStmt, Res.MSG_EXPECTING_RIGHTBRACE_STMTBLOCK);
            }
        }
        IGosuClassInternal type = this.getGosuClass();
        DynamicSymbol symbol = new DynamicSymbol(this.getGosuClass(), this.getSymbolTable(), strIdentifier, (IType)type, null);
        modifiers.addAll(symbol.getModifierInfo());
        symbol.setModifierInfo(modifiers);
        varStmt.setSymbol((ISymbol)symbol);
        varStmt.setEnumConstant(true);
        this.getSymbolTable().putSymbol((ISymbol)symbol);
        this.pushStatement(varStmt);
        return varStmt;
    }

    private void processVarStmt(IGosuClassInternal gsClass, VarStatement varStmt) {
        gsClass.getParseInfo().addMemberField(varStmt);
    }

    public void processFunctionSymbol(DynamicFunctionSymbol dfs, IGosuClassInternal gsClass) {
        this.getSymbolTable().putSymbol((ISymbol)dfs);
        if (dfs.getDisplayName().equals(gsClass.getRelativeName())) {
            gsClass.getParseInfo().addConstructorFunction(dfs);
        } else {
            gsClass.getParseInfo().addMemberFunction(dfs);
        }
    }

    void processPropertySymbol(DynamicPropertySymbol dps, ICompilableTypeInternal gsClass) {
        this.getSymbolTable().putSymbol((ISymbol)dps);
        dps.addMemberSymbols(gsClass);
    }

    private void addOuterMember(ICompilableTypeInternal gsClass) {
        while (gsClass instanceof IBlockClass) {
            gsClass = gsClass.getEnclosingType();
        }
        OuterFunctionSymbol dfs = new OuterFunctionSymbol(this.getSymbolTable(), gsClass);
        dfs.setClassMember(true);
        DynamicPropertySymbol dps = this.getOrCreateDynamicPropertySymbol(this.getClassStatement(), gsClass, dfs, true);
        this.processPropertySymbol(dps, gsClass);
    }

    private void parseEnhancementBodyDecl(IGosuClassInternal gsClass) {
        try {
            IType type = TypeLoaderAccess.instance().getIntrinsicTypeByFullName(gsClass.getName());
            if (gsClass != type) {
                this.getClassStatement().addParseException((IParseIssue)new ParseException((IParserState)this.makeFullParserState(), Res.MSG_DUPLICATE_ENHANCEMENT_FOUND, new Object[]{type.getName()}));
            }
        }
        catch (ClassNotFoundException type) {
            // empty catch block
        }
        this.verify((ParsedElement)this.getClassStatement(), this.match(null, 123), Res.MSG_EXPECTING_OPEN_BRACE_FOR_CLASS_DEF, new String[0]);
        Object result = this.parseFunctionDeclForEnhancement(gsClass);
        while (result != null) {
            if (!result.equals(Boolean.FALSE)) {
                this.popStatement();
                if (result instanceof DynamicFunctionSymbol) {
                    DynamicFunctionSymbol dfs = (DynamicFunctionSymbol)result;
                    this.getSymbolTable().putSymbol((ISymbol)dfs);
                    gsClass.getParseInfo().addMemberFunction(dfs);
                } else if (result instanceof DynamicPropertySymbol) {
                    this.getSymbolTable().putSymbol((ISymbol)((DynamicPropertySymbol)result));
                    ((DynamicPropertySymbol)result).addMemberSymbols(gsClass);
                }
            }
            result = this.parseFunctionDeclForEnhancement(gsClass);
        }
        this.verify((ParsedElement)this.getClassStatement(), this.isInnerClass(gsClass) || this.match(null, -1), Res.MSG_END_OF_STMT, new String[0]);
        gsClass.syncGenericAndParameterizedClasses();
        gsClass.setDeclarationsCompiled();
        gsClass.setInnerDeclarationsCompiled();
    }

    public List<ParseException> resolveFunctionAndPropertyDecls(ISymbolTable table) {
        Object member = this.parseFunctionOrConstructorOrFieldDeclaration(null);
        while (member != null) {
            this.popStatement();
            if (member instanceof DynamicFunctionSymbol) {
                table.putSymbol((ISymbol)((DynamicFunctionSymbol)member));
            } else if (member instanceof DynamicPropertySymbol) {
                table.putSymbol((ISymbol)((DynamicPropertySymbol)member));
            }
            member = this.parseFunctionOrConstructorOrFieldDeclaration(null);
        }
        this.pushStatement(this.getClassStatement());
        this.setLocation(this._iClassOffset, this._iClassLineNum, this._iClassColumn);
        this.popStatement();
        return this.getClassStatement().getParseExceptions();
    }

    private Object parseFunctionDeclForEnhancement(IGosuClassInternal gsClass) {
        int[] location = new int[3];
        Object rtn = this._parseFunctionDeclForEnhancement(gsClass, location);
        if (rtn != null && !Boolean.FALSE.equals(rtn)) {
            this.setLocation(location[0], location[1], location[2]);
        }
        return rtn;
    }

    private Object _parseFunctionDeclForEnhancement(IGosuClassInternal gsClass, int[] location) {
        int iOffset = this.getTokenizer().getTokenStart();
        int iLineNum = this.getTokenizer().getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        String[] strMemberKeyword = new String[1];
        ModifierInfo modifiers = this.parseUntilMemberKeyword(strMemberKeyword, false, location);
        if (modifiers.getModifiers() == -1) {
            return null;
        }
        if (strMemberKeyword[0] != null && strMemberKeyword[0].equals(Keyword.KW_function.toString())) {
            FunctionStatement fs = new FunctionStatement();
            DynamicFunctionSymbol dfs = this.getOwner().parseFunctionDecl(fs, false, false, modifiers);
            fs.setDynamicFunctionSymbol(dfs);
            this.pushStatement(fs);
            this.verify((ParsedElement)fs, !Modifier.isTransient((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_transient, Keyword.KW_function);
            if (dfs != null) {
                dfs.setClassMember(true);
            }
            if (this.verify((ParsedElement)this.getClassStatement(), !Modifier.isAbstract((int)modifiers.getModifiers()), Res.MSG_MODIFIER_ABSTRACT_NOT_ALLOWED_HERE, new String[0]) && !Modifier.isNative((int)modifiers.getModifiers())) {
                this.eatStatementBlock(fs, Res.MSG_EXPECTING_OPEN_BRACE_FOR_FUNCTION_DEF);
            }
            return dfs;
        }
        if (strMemberKeyword[0] != null && strMemberKeyword[0].equals(Keyword.KW_property.toString())) {
            boolean bGetter = this.match(null, Keyword.KW_get);
            this.verify((ParsedElement)this.getClassStatement(), bGetter || this.match(null, Keyword.KW_set), Res.MSG_EXPECTING_PROPERTY_GET_OR_SET_MODIFIER, new String[0]);
            FunctionStatement fs = new FunctionStatement();
            DynamicFunctionSymbol dfs = this.getOwner().parseFunctionDecl(fs, true, bGetter, modifiers);
            fs.setDynamicFunctionSymbol(dfs);
            this.pushStatement(fs);
            this.setLocation(iOffset, iLineNum, iColumn);
            this.popStatement();
            this.verify((ParsedElement)fs, !Modifier.isTransient((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_transient, Keyword.KW_function);
            if (dfs != null) {
                dfs.setClassMember(true);
            }
            if (this.verify((ParsedElement)this.getClassStatement(), !Modifier.isAbstract((int)modifiers.getModifiers()), Res.MSG_MODIFIER_ABSTRACT_NOT_ALLOWED_HERE, new String[0]) && !Modifier.isNative((int)modifiers.getModifiers())) {
                this.eatStatementBlock(fs, Res.MSG_EXPECTING_OPEN_BRACE_FOR_FUNCTION_DEF);
            }
            DynamicPropertySymbol dps = dfs == null ? null : this.getOrCreateDynamicPropertySymbol(this.getClassStatement(), gsClass, dfs, bGetter);
            PropertyStatement statement = new PropertyStatement(fs, dps);
            this.verifyPropertiesAreSymmetric(bGetter, dfs, dps, statement);
            this.pushStatement(statement);
            return dps;
        }
        if (strMemberKeyword[0] != null && strMemberKeyword[0].equals(Keyword.KW_var.toString())) {
            return Boolean.FALSE;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseClassStatementAsEnhancement(IGosuClassInternal gsClass) {
        IGosuEnhancementInternal enhancement = (IGosuEnhancementInternal)gsClass;
        this.getSymbolTable().pushScope();
        try {
            this.verify((ParsedElement)this.getClassStatement(), this.match(null, 123), Res.MSG_EXPECTING_OPEN_BRACE_FOR_CLASS_DEF, new String[0]);
            this.parseClassMembers(gsClass);
            Statement stmt = this.peekStatement();
            while (stmt != null) {
                DynamicFunctionSymbol dfs;
                ITypeInfo typeInfo;
                stmt = this.popStatement();
                IType enhancedType = enhancement.getEnhancedType();
                if (stmt instanceof FunctionStatement) {
                    FunctionStatement func = (FunctionStatement)stmt;
                    if (func.getDynamicFunctionSymbol() != null && !(enhancedType instanceof ErrorType) && (typeInfo = enhancedType.getTypeInfo()) != null) {
                        IMethodInfo mi;
                        IMethodInfo iMethodInfo = mi = typeInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)typeInfo).getMethod((IType)enhancement, (CharSequence)func.getFunctionName(), func.getDynamicFunctionSymbol().getArgTypes()) : typeInfo.getMethod((CharSequence)func.getFunctionName(), func.getDynamicFunctionSymbol().getArgTypes());
                        if (this.overridesMethodWithDefaultParams(func, typeInfo)) {
                            this.addDeclaredNameParseError((IParsedElementWithAtLeastOneDeclaration)func, Res.MSG_OVERLOADING_NOT_ALLOWED_WITH_OPTIONAL_PARAMS, mi.getDisplayName(), enhancedType.getRelativeName());
                        } else if (mi != null && (!this.featureIsOwnedByEnhancement(enhancement, (IFeatureInfo)mi) || enhancedType != JavaTypes.OBJECT() && GosuClass.isObjectMethod(mi))) {
                            this.addDeclaredNameParseError((IParsedElementWithAtLeastOneDeclaration)func, Res.MSG_CANNOT_OVERRIDE_FUNCTIONS_IN_ENHANCEMENTS, mi.getDisplayName(), enhancedType.getRelativeName());
                        } else if (enhancedType instanceof IGosuClass) {
                            ReducedDynamicPropertySymbol dps;
                            IPropertyInfo pi;
                            ITypeInfo ti;
                            String name = func.getFunctionName();
                            dfs = func.getDynamicFunctionSymbol();
                            if (name.startsWith("set") && dfs.getArgs().size() == 1) {
                                ti = enhancedType.getTypeInfo();
                                pi = ((IRelativeTypeInfo)ti).getProperty((IType)enhancement, (CharSequence)name.substring(3, name.length()));
                                if (pi instanceof GosuPropertyInfo && (dps = ((GosuPropertyInfo)pi).getDps()).getSetterDfs() != null) {
                                    IType argType = dfs.getArgs().get(0).getType();
                                    if (argType.equals(dps.getType())) {
                                        this.addDeclaredNameParseError((IParsedElementWithAtLeastOneDeclaration)func, Res.MSG_PROPERTY_AND_FUNCTION_CONFLICT, dfs.getName(), dps.getName());
                                    } else if (this.getOwner().doTypesReifyToTheSameBytecodeType(argType, dps.getType())) {
                                        this.addDeclaredNameParseError((IParsedElementWithAtLeastOneDeclaration)func, Res.MSG_PROPERTY_AND_FUNCTION_CONFLICT_UPON_REIFICATION, dfs.getName(), dps.getName());
                                    }
                                }
                            } else if ((name.startsWith("get") || name.startsWith("is")) && dfs.getArgs().size() == 0 && (pi = ((IRelativeTypeInfo)(ti = enhancedType.getTypeInfo())).getProperty((IType)enhancement, (CharSequence)name.substring(name.startsWith("get") ? 3 : 2, name.length()))) instanceof GosuPropertyInfo && (dps = ((GosuPropertyInfo)pi).getDps()).getGetterDfs() != null) {
                                this.addDeclaredNameParseError((IParsedElementWithAtLeastOneDeclaration)func, Res.MSG_PROPERTY_AND_FUNCTION_CONFLICT, dfs.getName(), dps.getName());
                            }
                        }
                    }
                } else if (stmt instanceof PropertyStatement) {
                    PropertyStatement prop = (PropertyStatement)stmt;
                    typeInfo = enhancedType.getTypeInfo();
                    if (typeInfo != null && !(enhancedType instanceof ErrorType)) {
                        IPropertyInfo pi;
                        IPropertyInfo iPropertyInfo = pi = typeInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)typeInfo).getProperty((IType)enhancement, (CharSequence)prop.getFunctionName()) : typeInfo.getProperty((CharSequence)prop.getFunctionName());
                        if (pi != null && !this.featureIsOwnedByEnhancement(enhancement, (IFeatureInfo)pi)) {
                            this.addDeclaredNameParseError((IParsedElementWithAtLeastOneDeclaration)prop, Res.MSG_CANNOT_OVERRIDE_PROPERTIES_IN_ENHANCEMENTS, pi.getDisplayName(), enhancedType.getRelativeName());
                        } else {
                            ITypeInfo ti;
                            FunctionStatement funcStmt = prop.getPropertyGetterOrSetter();
                            dfs = funcStmt.getDynamicFunctionSymbol();
                            String name = dfs.getDisplayName().substring(1);
                            if (dfs.getArgs().size() == 0) {
                                ti = enhancedType.getTypeInfo();
                                IMethodInfo mi = ((IRelativeTypeInfo)ti).getMethod((IType)enhancement, (CharSequence)("get" + name), new IType[0]);
                                IMethodInfo iMethodInfo = mi = mi == null ? ((IRelativeTypeInfo)ti).getMethod((IType)enhancement, (CharSequence)("is" + name), new IType[0]) : mi;
                                if (mi != null) {
                                    this.addDeclaredNameParseError((IParsedElementWithAtLeastOneDeclaration)prop, Res.MSG_PROPERTY_AND_FUNCTION_CONFLICT, mi.getName(), name);
                                }
                            } else if (funcStmt.getParameters().size() > 0) {
                                ti = enhancedType.getTypeInfo();
                                for (IMethodInfo mi : ((IRelativeTypeInfo)ti).getMethods((IType)enhancement)) {
                                    if (!mi.getDisplayName().equals("set" + name) || mi.getParameters().length != 1) continue;
                                    IType argType = mi.getParameters()[0].getFeatureType();
                                    if (argType.equals(dfs.getArgTypes()[0])) {
                                        this.addDeclaredNameParseError((IParsedElementWithAtLeastOneDeclaration)prop, Res.MSG_PROPERTY_AND_FUNCTION_CONFLICT, mi.getName(), dfs.getName());
                                        continue;
                                    }
                                    if (!this.getOwner().doTypesReifyToTheSameBytecodeType(argType, dfs.getArgTypes()[0])) continue;
                                    this.addDeclaredNameParseError((IParsedElementWithAtLeastOneDeclaration)prop, Res.MSG_PROPERTY_AND_FUNCTION_CONFLICT, mi.getName(), dfs.getName());
                                }
                            }
                        }
                    }
                } else if (!(stmt instanceof NoOpStatement || stmt instanceof NamespaceStatement || stmt instanceof UsesStatement)) {
                    ParseException parseException = new ParseException(Integer.valueOf(stmt.getLineNum()), Integer.valueOf(1), Integer.valueOf(stmt.getLocation().getColumn()), Integer.valueOf(stmt.getLocation().getOffset()), Integer.valueOf(stmt.getLocation().getExtent()), this.getSymbolTable(), Res.MSG_ENHANCEMENT_DOES_NOT_ACCEPT_THIS_STATEMENT, new Object[0]);
                    stmt.addParseException((IParseIssue)parseException);
                }
                stmt = this.peekStatement();
            }
            this.verify((ParsedElement)this.getClassStatement(), this.match(null, 125), Res.MSG_EXPECTING_CLOSE_BRACE_FOR_CLASS_DEF, new String[0]);
        }
        finally {
            this.getSymbolTable().popScope();
        }
    }

    void addDeclaredNameParseError(IParsedElementWithAtLeastOneDeclaration stmt, ResourceKey key, Object ... args) {
        int nameOffset = stmt.getNameOffset(null);
        ParseException parseException = new ParseException(Integer.valueOf(stmt.getLineNum()), Integer.valueOf(1), Integer.valueOf(stmt.getLocation().getColumn()), Integer.valueOf(nameOffset), Integer.valueOf(nameOffset + (stmt instanceof VarStatement ? ((VarStatement)stmt).getIdentifierName().length() : stmt.getFunctionName().length())), this.getSymbolTable(), key, args);
        stmt.addParseException((IParseIssue)parseException);
    }

    private boolean overridesMethodWithDefaultParams(FunctionStatement func, ITypeInfo typeInfo) {
        if (!(typeInfo instanceof IRelativeTypeInfo)) {
            return false;
        }
        IRelativeTypeInfo rti = (IRelativeTypeInfo)typeInfo;
        for (IMethodInfo mi : rti.getMethods((IType)func.getGosuClass())) {
            if (!mi.getDisplayName().equals(func.getFunctionName()) || !(mi instanceof GosuMethodInfo) || this.featureIsOwnedByEnhancement(func.getGosuClass(), (IFeatureInfo)mi)) continue;
            IReducedDynamicFunctionSymbol dfs0 = ((GosuMethodInfo)mi).getDfs();
            DynamicFunctionSymbol dfs1 = func.getDynamicFunctionSymbol();
            return dfs0 != null && dfs1 != null && (((IInvocableType)dfs0.getType()).hasOptionalParams() || dfs1.hasOptionalParameters());
        }
        return false;
    }

    private boolean featureIsOwnedByEnhancement(IGosuClass enhancement, IFeatureInfo iMethodInfo) {
        IGosuClass enhancementType;
        if (!(enhancement instanceof IGosuEnhancementInternal)) {
            return false;
        }
        IType ownerType = iMethodInfo.getOwnersType();
        if (ownerType != null && ownerType.isParameterizedType()) {
            ownerType = ownerType.getGenericType();
        }
        if ((enhancementType = enhancement) != null && enhancementType.isParameterizedType()) {
            enhancementType = enhancementType.getGenericType();
        }
        if (enhancementType instanceof IGosuEnhancementInternal && ownerType instanceof IGosuEnhancementInternal) {
            return GosuObjectUtil.equals((Object)enhancementType.getName(), (Object)ownerType.getName());
        }
        return GosuObjectUtil.equals((Object)enhancementType, (Object)ownerType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String parseHeader(IGosuClassInternal gsClass, boolean bParseEnhancementOnly, boolean bIsAnonymous, boolean bResolveUsesTypes) {
        boolean bPushedScope = this.pushScopeIfNeeded(gsClass);
        if (gsClass.isHeaderCompiled()) {
            ((CompilationState)gsClass.getCompilationState()).setReparsingHeader(true);
        } else {
            gsClass.setCompilingHeader(true);
        }
        this.getTokenizer().pushOffsetMarker(this);
        gsClass.createNewParseInfo();
        this.setClassStatement(gsClass.getParseInfo().getClassStatement());
        ScriptPartId scriptPartId = new ScriptPartId((IType)gsClass, null);
        this.getOwner().pushScriptPart((IScriptPartId)scriptPartId);
        GosuClassCompilingStack.pushCompilingType((IType)gsClass);
        try {
            ClassType classType;
            this.setTokenizerToClassStart();
            if (this.match(null, -1)) {
                if (gsClass instanceof IGosuProgram) {
                    gsClass.setSuperType((IType)JavaTypes.OBJECT());
                } else if (this.getClassStatement() != null && this.getClassStatement().getClassFileStatement() != null) {
                    this.getClassStatement().getClassFileStatement().addParseException((IParseIssue)new ParseException((IParserState)this.makeFullParserState(), Res.MSG_NO_SOURCE_FOUND, new Object[0]));
                }
                String string = null;
                return string;
            }
            this.getOwner().checkInstruction(true);
            if (gsClass instanceof IGosuProgram) {
                this.getOwner().parseProgramClasspathStatements();
                this.getOwner().parseProgramTypeLoaderStatements();
            }
            this.getOwner().checkInstruction(true);
            int iOffset = this.getTokenizer().getTokenStart();
            int iLineNum = this.getTokenizer().getLineNumber();
            int iColumn = this.getTokenizer().getTokenColumn();
            if (this.match(null, Keyword.KW_package)) {
                this.getOwner().parseNamespaceStatement();
                this.setLocation(iOffset, iLineNum, iColumn);
                this.popStatement();
            } else if (gsClass instanceof IGosuProgram) {
                ITypeUsesMap typeUsesMap;
                ISourceFileHandle sfh = gsClass.getSourceFileHandle();
                boolean bEval = sfh instanceof StringSourceFileHandle;
                if (bEval && (typeUsesMap = ((StringSourceFileHandle)sfh).getTypeUsesMap()) != null) {
                    this.getOwner().setTypeUsesMap(typeUsesMap);
                }
                if (gsClass.isAnonymous()) {
                    Map capturedTypeVars;
                    gsClass.setEnclosingType(TypeSystem.getByFullNameIfValid((String)sfh.getParentType()));
                    IType enclosingType = gsClass.getEnclosingTypeReference();
                    this.getOwner().setNamespace(enclosingType.getNamespace());
                    Map map = capturedTypeVars = bEval ? ((StringSourceFileHandle)sfh).getCapturedTypeVars() : null;
                    if (capturedTypeVars != null) {
                        ((HashMap)this.getOwner().getTypeVariables()).putAll(capturedTypeVars);
                    }
                } else {
                    String strNamespace = this.getGosuClass().getNamespace();
                    this.getOwner().setNamespace(strNamespace != null && !strNamespace.isEmpty() ? strNamespace : "program_");
                }
            } else if (!this.isInnerClass(gsClass)) {
                this.getOwner().setNamespace("");
            }
            this.getOwner().checkInstruction(true);
            this.getOwner().parseUsesStatementList(bResolveUsesTypes);
            if (gsClass.getEnclosingType() == null) {
                gsClass.setTypeUsesMap(this.getOwner().getTypeUsesMap());
            }
            if (gsClass.isAnonymous() && !(gsClass instanceof IGosuProgram)) {
                try {
                    classType = this.parseAnonymousClassHeader(gsClass);
                }
                catch (InnerClassNotFoundException e) {
                    classType = ClassType.Class;
                }
                this._iClassOffset = this.getTokenizer().getTokenStart();
                this._iClassLineNum = this.getTokenizer().getLineNumber();
                this._iClassColumn = this.getTokenizer().getTokenColumn();
            } else if (gsClass instanceof IGosuProgram) {
                gsClass.setModifierInfo(new ModifierInfo(17));
                if (gsClass.isAnonymous()) {
                    IFunctionStatement fs;
                    IParsedElement enclosingEvalExpression = ((IGosuProgram)gsClass).getEnclosingEvalExpression();
                    IParseTree parseTree = enclosingEvalExpression == null ? null : enclosingEvalExpression.getLocation();
                    IFunctionStatement iFunctionStatement = fs = parseTree == null ? null : parseTree.getEnclosingFunctionStatement();
                    if (fs != null && fs.getDynamicFunctionSymbol().isStatic() || enclosingEvalExpression == null) {
                        ((ModifierInfo)gsClass.getModifierInfo()).addModifiers(8);
                    }
                }
                this.parseProgramExtendsStatement(gsClass, bResolveUsesTypes);
                classType = ClassType.Class;
            } else {
                this.getOwner().checkInstruction(true);
                this._iClassOffset = this.getTokenizer().getTokenStart();
                this._iClassLineNum = this.getTokenizer().getLineNumber();
                this._iClassColumn = this.getTokenizer().getTokenColumn();
                if (!bIsAnonymous) {
                    classType = this.parseClassType(gsClass, true);
                    if (classType == ClassType.Interface || classType == ClassType.Structure || classType == ClassType.Annotation) {
                        ((ModifierInfo)gsClass.getModifierInfo()).addModifiers(1024);
                    } else if (classType == ClassType.Enum) {
                        ((ModifierInfo)gsClass.getModifierInfo()).addModifiers(16);
                    }
                    if (classType == ClassType.Annotation) {
                        gsClass.addInterface((IType)JavaTypes.ANNOTATION());
                    }
                } else {
                    classType = this.parseClassTypeForHeader(gsClass);
                }
            }
            if (classType == null) {
                if (bParseEnhancementOnly) {
                    String enclosingEvalExpression = null;
                    return enclosingEvalExpression;
                }
                this.verify((ParsedElement)this.getClassStatement(), false, Res.MSG_EXPECTING_NAME_CLASS_DEF, new String[0]);
            }
            if (classType == ClassType.Enhancement) {
                if (gsClass instanceof IGosuEnhancementInternal) {
                    IGosuEnhancementInternal scriptEnhancement = (IGosuEnhancementInternal)gsClass;
                    scriptEnhancement.setFoundCorrectHeader();
                    String bHeaderCompiled = this.parseEnhancementHeaderSuffix(scriptEnhancement);
                    return bHeaderCompiled;
                }
                this.getClassStatement().addParseException((IParseIssue)new ParseException((IParserState)this.makeFullParserState(), Res.MSG_MUST_BE_DEFINED_AS_CLASS, new Object[0]));
                String string = null;
                return string;
            }
            if (classType != null && !bParseEnhancementOnly) {
                if (classType == ClassType.Enum) {
                    gsClass.setEnum();
                }
                String string = this.parseClassOrInterfaceHeaderSuffix(gsClass, classType, bResolveUsesTypes);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            boolean bHeaderCompiled;
            try {
                bHeaderCompiled = gsClass.isHeaderCompiled();
                if (!bHeaderCompiled) {
                    this.parseInnerClassHeaders(gsClass, bResolveUsesTypes);
                }
            }
            finally {
                GosuClassCompilingStack.popCompilingType();
            }
            this.getOwner().popScriptPart((IScriptPartId)scriptPartId);
            ((CompilationState)gsClass.getCompilationState()).setReparsingHeader(false);
            gsClass.setCompilingHeader(false);
            gsClass.setHeaderCompiled();
            this.popScopeIfNeeded(bPushedScope, gsClass);
            this.getTokenizer().popOffsetMarker(this);
            if (!bHeaderCompiled) {
                this.removeTypeVarsFromParserMap(gsClass);
            }
        }
    }

    private void removeTypeVarsFromParserMap(IGosuClassInternal gsClass) {
        for (IGenericTypeVariable gtv : gsClass.getGenericTypeVariables()) {
            ITypeVariableDefinition typeVarDef = gtv.getTypeVariableDefinition();
            Map typeVarMap = this.getOwner().getTypeVariables();
            if (!typeVarMap.containsValue(typeVarDef)) continue;
            typeVarMap.remove(typeVarDef.getName());
        }
    }

    private boolean pushScopeIfNeeded(IGosuClassInternal gsClass) {
        ISymbolTable compilingClass = CompiledGosuClassSymbolTable.instance().getSymbolTableForCompilingClass(gsClass);
        if (compilingClass != null) {
            return false;
        }
        if (gsClass.getParser() != null) {
            CompiledGosuClassSymbolTable.instance().pushCompileTimeSymbolTable(gsClass, gsClass.getParser().getSymbolTable());
        } else {
            CompiledGosuClassSymbolTable.instance().pushCompileTimeSymbolTable(gsClass);
        }
        this.getSymbolTable().pushIsolatedScope((IActivationContext)new GosuClassTransparentActivationContext(gsClass, false));
        return true;
    }

    private void popScopeIfNeeded(boolean bPop, IGosuClass gsClass) {
        if (bPop) {
            this.getSymbolTable().popScope();
            CompiledGosuClassSymbolTable.instance().popCompileTimeSymbolTable((ICompilableType)gsClass);
        }
    }

    private void setTokenizerToClassStart() {
        if (this.isInnerClass(this.getGosuClass())) {
            this.getTokenizer().reset();
        }
        if (!this.getTokenizer().isPositioned()) {
            this.getTokenizer().nextToken();
        }
    }

    private ClassType parseAnonymousClassHeader(IGosuClassInternal gsClass) {
        ParsedElement elem;
        ClassType classType = ClassType.Class;
        if (this.match(null, null, 40, true)) {
            elem = this.getClassStatement();
        } else {
            if (!this.getOwner().parseTypeLiteral()) {
                throw new InnerClassNotFoundException();
            }
            elem = this.popExpression();
        }
        this.eatParenthesized(elem, Res.MSG_EXPECTING_FUNCTION_CLOSE);
        return classType;
    }

    private boolean goToPosition(int iOffset) {
        try {
            this.getTokenizer().goToPosition(iOffset);
            return true;
        }
        catch (IOException e) {
            this.getClassStatement().addParseException((IParseIssue)ParseException.wrap((Throwable)e, (IParserState)this.makeFullParserState()));
            return false;
        }
    }

    private ClassType parseClassTypeForHeader(IGosuClassInternal gsClass) {
        while (!this.match(null, -1)) {
            ClassType classType = this.parseClassType(gsClass, !gsClass.isDeclarationsCompiled());
            if (classType != null) {
                return classType;
            }
            this.getTokenizer().nextToken();
        }
        return null;
    }

    private ClassType parseClassType(IGosuClassInternal gsClass, boolean bSetModifiers) {
        ModifierInfo modifiers = this.parseModifiersForClass(gsClass, bSetModifiers);
        if (!(Modifier.isInternal((int)modifiers.getModifiers()) || Modifier.isProtected((int)modifiers.getModifiers()) || Modifier.isPrivate((int)modifiers.getModifiers()))) {
            modifiers.addModifiers(1);
        }
        ClassType classType = null;
        if (this.match(null, Keyword.KW_enhancement)) {
            classType = ClassType.Enhancement;
            if (bSetModifiers) {
                this.verify((ParsedElement)this.getClassStatement(), !Modifier.isPrivate((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_private, classType.name());
                this.verify((ParsedElement)this.getClassStatement(), !Modifier.isProtected((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_protected, classType.name());
                this.verify((ParsedElement)this.getClassStatement(), !Modifier.isInternal((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_internal, classType.name());
                this.verify((ParsedElement)this.getClassStatement(), !Modifier.isFinal((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_final, classType.name());
                this.verify((ParsedElement)this.getClassStatement(), !Modifier.isAbstract((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_abstract, classType.name());
                this.verify((ParsedElement)this.getClassStatement(), !Modifier.isTransient((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_transient, classType.name());
                this.verifyNoAbstractHideOverrideStaticModifierDefined(this.getClassStatement(), false, modifiers.getModifiers(), Keyword.KW_enhancement);
                gsClass.setModifierInfo(modifiers);
            }
        } else if (this.match(null, Keyword.KW_interface)) {
            classType = ClassType.Interface;
            if (bSetModifiers) {
                this.verify((ParsedElement)this.getClassStatement(), !Modifier.isHide((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_hide, classType.name());
                this.verify((ParsedElement)this.getClassStatement(), !Modifier.isOverride((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_override, classType.name());
                this.verify((ParsedElement)this.getClassStatement(), !Modifier.isFinal((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_final, classType.name());
                this.verify((ParsedElement)this.getClassStatement(), !Modifier.isTransient((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_transient, classType.name());
                if (gsClass.getEnclosingType() != null) {
                    modifiers.addModifiers(8);
                }
                gsClass.setModifierInfo(modifiers);
            }
        } else if (this.match(null, Keyword.KW_structure)) {
            classType = ClassType.Structure;
            if (bSetModifiers) {
                this.verify((ParsedElement)this.getClassStatement(), !Modifier.isHide((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_hide, classType.name());
                this.verify((ParsedElement)this.getClassStatement(), !Modifier.isOverride((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_override, classType.name());
                this.verify((ParsedElement)this.getClassStatement(), !Modifier.isFinal((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_final, classType.name());
                this.verify((ParsedElement)this.getClassStatement(), !Modifier.isTransient((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_transient, classType.name());
                if (gsClass.getEnclosingType() != null) {
                    modifiers.addModifiers(8);
                }
                gsClass.setModifierInfo(modifiers);
            }
        } else if (this.match(null, Keyword.KW_annotation)) {
            classType = ClassType.Annotation;
            if (bSetModifiers) {
                this.verify((ParsedElement)this.getClassStatement(), !Modifier.isHide((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_hide, classType.name());
                this.verify((ParsedElement)this.getClassStatement(), !Modifier.isOverride((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_override, classType.name());
                this.verify((ParsedElement)this.getClassStatement(), !Modifier.isFinal((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_final, classType.name());
                this.verify((ParsedElement)this.getClassStatement(), !Modifier.isTransient((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_transient, classType.name());
                modifiers.addModifiers(8192);
                if (gsClass.getEnclosingType() != null) {
                    modifiers.addModifiers(8);
                }
                gsClass.setModifierInfo(modifiers);
            }
        } else if (this.match(null, Keyword.KW_class)) {
            classType = ClassType.Class;
            if (bSetModifiers) {
                this.verify((ParsedElement)this.getClassStatement(), !Modifier.isHide((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_hide, classType.name());
                this.verify((ParsedElement)this.getClassStatement(), !Modifier.isOverride((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_override, classType.name());
                this.verify((ParsedElement)this.getClassStatement(), !Modifier.isTransient((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_transient, classType.name());
                gsClass.setModifierInfo(modifiers);
            }
        } else if (this.match(null, Keyword.KW_enum)) {
            classType = ClassType.Enum;
            if (bSetModifiers) {
                this.verifyNoAbstractHideOverrideModifierDefined(this.getClassStatement(), false, modifiers.getModifiers(), Keyword.KW_final);
                this.verify((ParsedElement)this.getClassStatement(), !Modifier.isFinal((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_final, classType.name());
                this.verify((ParsedElement)this.getClassStatement(), !Modifier.isTransient((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_transient, classType.name());
                gsClass.setModifierInfo(modifiers);
            }
        }
        if (gsClass.shouldFullyCompileAnnotations()) {
            this.verifyModifiers(this.getClassStatement(), modifiers, UsageTarget.TypeTarget);
        }
        gsClass.setFullDescription(modifiers.getDescription());
        if (bSetModifiers && classType != null && gsClass.getEnclosingType() == null) {
            this.verify((ParsedElement)this.getClassStatement(), !Modifier.isPrivate((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_private, classType.name());
            this.verify((ParsedElement)this.getClassStatement(), !Modifier.isProtected((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_protected, classType.name());
            this.verify((ParsedElement)this.getClassStatement(), !Modifier.isStatic((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_static, classType.name());
        }
        return classType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModifierInfo parseModifiersForClass(IGosuClassInternal gsClass, boolean bSetModifiers) {
        ModifierInfo modifiers;
        ICompilableTypeInternal enclosingType = gsClass.getEnclosingType();
        if (enclosingType instanceof IGosuClassInternal && ((IGosuClassInternal)enclosingType).isDeclarationsCompiled()) {
            ClassScopeCache scopeCache = this.makeClassScopeCache((IGosuClassInternal)enclosingType);
            this.pushClassSymbols(true, scopeCache);
            try {
                modifiers = this.parseModifiers(!bSetModifiers);
            }
            finally {
                this.popClassSymbols();
            }
        } else {
            modifiers = this.parseModifiers(!bSetModifiers);
        }
        return modifiers;
    }

    private String parseClassOrInterfaceHeaderSuffix(IGosuClassInternal gsClass, ClassType classType, boolean bResolveTypes) {
        String strClassName;
        IGosuClassInternal gosuObjectInterface = this.getGosuObjectInterface();
        if (gosuObjectInterface == null) {
            return gsClass.getName();
        }
        if (gsClass instanceof IGosuProgram) {
            gsClass.addInterface((IType)gosuObjectInterface);
            if (!gsClass.isAnonymous()) {
                IType type = this.parseEnhancedOrImplementedType(gsClass, false, Collections.emptyList());
                gsClass.setSuperType(type);
            }
            strClassName = gsClass.getName();
        } else if (gsClass.isAnonymous()) {
            gsClass.addInterface((IType)gosuObjectInterface);
            strClassName = gsClass.getName();
            if (gsClass.isHeaderCompiled()) {
                ClassDeclaration classDeclaration = new ClassDeclaration(strClassName);
                this.pushExpression(classDeclaration);
                SourceCodeTokenizer tokenizer = this.getOwner().getTokenizer();
                this.setLocation(tokenizer.getTokenStart(), tokenizer.getLineNumber(), tokenizer.getTokenColumn(), true, true);
                this.popExpression();
                this.getClassStatement().setClassDeclaration(classDeclaration);
            }
        } else {
            boolean bStructure = classType.equals((Object)ClassType.Structure);
            boolean bAnnotation = classType.equals((Object)ClassType.Annotation);
            boolean bInterface = bStructure || bAnnotation || classType.equals((Object)ClassType.Interface);
            gsClass.setInterface(bInterface);
            gsClass.setStructure(bStructure);
            int iOffset = this.getTokenizer().getTokenStart();
            int iLineNum = this.getTokenizer().getLineNumber();
            int iColumn = this.getTokenizer().getTokenColumn();
            Token t = new Token();
            this.verify((ParsedElement)this.getClassStatement(), this.match(t, -5), Res.MSG_EXPECTING_NAME_CLASS_DEF, new String[0]);
            strClassName = t._strValue;
            String strNamespace = this.isTopLevelClass(this.getGosuClass()) ? this.getOwner().getNamespace() : this.getGosuClass().getEnclosingType().getName();
            String string = strClassName = GosuStringUtil.isEmpty((String)strNamespace) ? strClassName : strNamespace + '.' + strClassName;
            if (gsClass.getEnclosingTypeReference() == null && strClassName != null && !strClassName.equals(gsClass.getName())) {
                this.verify((ParsedElement)this.getClassStatement(), false, Res.MSG_WRONG_CLASSNAME, strClassName, gsClass.getName());
            }
            if (strClassName != null && gsClass.isHeaderCompiled()) {
                ClassDeclaration classDeclaration = new ClassDeclaration(strClassName);
                this.pushExpression(classDeclaration);
                this.setLocation(iOffset, iLineNum, iColumn);
                this.popExpression();
                this.getClassStatement().setClassDeclaration(classDeclaration);
            }
            this.parseTypeVarsAndExtends(gsClass, classType, bResolveTypes, gosuObjectInterface, bAnnotation, bInterface);
        }
        if ((this.isTopLevelClass(gsClass) || gsClass instanceof IGosuProgram || gsClass.isAnonymous()) && !gsClass.isHeaderCompiled()) {
            int state = this.getTokenizer().mark();
            this.loadAllNestedInnerClasses(gsClass);
            this.getTokenizer().restoreToMark(state);
        }
        return strClassName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseTypeVarsAndExtends(IGosuClassInternal gsClass, ClassType classType, boolean bResolveTypes, IGosuClassInternal gosuObjectInterface, boolean bAnnotation, boolean bInterface) {
        List<TypeVariableDefinitionImpl> declTypeVars;
        if (!gsClass.isHeaderCompiled()) {
            int mark = this.getOwner().getTokenizer().mark();
            int iLocationsCount = this.getOwner().getLocationsList().size();
            this._parseTypeVarsAndExtends(gsClass, classType, bResolveTypes, gosuObjectInterface, bAnnotation, bInterface, Collections.emptyList());
            declTypeVars = this.getDeclTypeVars();
            if (declTypeVars.isEmpty()) return;
            this.getOwner().getTokenizer().restoreToMark(mark);
            this.getOwner().removeLocationsFrom(iLocationsCount);
        } else {
            declTypeVars = this.getDeclTypeVars();
        }
        this._parseTypeVarsAndExtends(gsClass, classType, bResolveTypes, gosuObjectInterface, bAnnotation, bInterface, declTypeVars);
    }

    private void _parseTypeVarsAndExtends(IGosuClassInternal gsClass, ClassType classType, boolean bResolveTypes, IGosuClassInternal gosuObjectInterface, boolean bAnnotation, boolean bInterface, List<TypeVariableDefinitionImpl> declTypeVars) {
        List<ITypeVariableDefinitionExpression> typeVarLiteralList = this.parseTypeVariableDefinitionExpressions(gsClass, declTypeVars);
        if (gsClass.isEnum()) {
            this.verify((ParsedElement)this.getClassStatement(), typeVarLiteralList.isEmpty(), Res.MSG_ENUM_MAY_NOT_HAVE_TYPEPARAM, new String[0]);
        }
        int iOffset = this.getTokenizer().getTokenStart();
        int iLineNum = this.getTokenizer().getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        if (!bInterface && (this.match(null, Keyword.KW_extends) || gsClass.isEnum())) {
            IType superType = this.parseEnhancedOrImplementedType(gsClass, true, Collections.emptyList());
            if (superType instanceof IGosuClassInternal && bResolveTypes) {
                ((IGosuClassInternal)superType).compileDeclarationsIfNeeded();
            }
            gsClass.setSuperType(superType);
            if (gsClass.getCompilationState().isCompilingDeclarations() && gsClass.isGenericType()) {
                this.verify((ParsedElement)this.getClassStatement(), !JavaTypes.THROWABLE().isAssignableFrom(superType), Res.MSG_INVALID_GENERIC_EXCEPTION, new String[0]);
            }
            SuperTypeClause extendsClause = new SuperTypeClause(superType);
            this.pushExpression(extendsClause);
            if (gsClass.isDeclarationsCompiled()) {
                this.verifySuperTypeVarVariance(this.getClassStatement(), superType);
            }
            this.setLocation(iOffset, iLineNum, iColumn);
            this.popExpression();
            iOffset = this.getTokenizer().getTokenStart();
            iLineNum = this.getTokenizer().getLineNumber();
            iColumn = this.getTokenizer().getTokenColumn();
        }
        boolean hasImplements = false;
        if (bInterface && this.match(null, Keyword.KW_extends) || (hasImplements = this.match(null, Keyword.KW_implements))) {
            if (this.verify((ParsedElement)this.getClassStatement(), !bInterface || !hasImplements, Res.MSG_NO_IMPLEMENTS_ALLOWED, new String[0])) {
                this.verify((ParsedElement)this.getClassStatement(), !bAnnotation, Res.MSG_NO_EXTENDS_ALLOWED, new String[0]);
            }
            ArrayList<IType> interfaces = new ArrayList<IType>();
            do {
                IType type = this.parseEnhancedOrImplementedType(gsClass, bInterface, interfaces);
                gsClass.addInterface(type);
                if (gsClass.isDeclarationsCompiled()) {
                    this.verifySuperTypeVarVariance(this.getClassStatement(), type);
                }
                interfaces.add(type);
            } while (this.match(null, 44));
            InterfacesClause interfacesClause = new InterfacesClause((IType)gsClass, interfaces.toArray(new IType[interfaces.size()]));
            this.pushExpression(interfacesClause);
            this.setLocation(iOffset, iLineNum, iColumn);
            this.popExpression();
        }
        if (classType == ClassType.Class || classType == ClassType.Interface || classType == ClassType.Structure) {
            IGosuClassInternal gsObjectInterace = gosuObjectInterface;
            if (!(gsClass.isInterface() && this.interfaceExtendsGosuObject(gsClass, gsObjectInterace) || gsClass.getName().startsWith("_proxy_"))) {
                gsClass.addInterface((IType)gsObjectInterace);
            }
        } else if (classType == ClassType.Enum) {
            gsClass.addInterface((IType)gosuObjectInterface);
        }
    }

    private List<ITypeVariableDefinitionExpression> parseTypeVariableDefinitionExpressions(IGosuClassInternal gsClass, List<TypeVariableDefinitionImpl> declTypeVars) {
        List<ITypeVariableDefinitionExpression> typeVarLiteralList = this.getOwner().parseTypeVariableDefs(this.getClassStatement(), false, declTypeVars);
        gsClass.setGenericTypeVariables(typeVarLiteralList);
        return typeVarLiteralList;
    }

    private boolean interfaceExtendsGosuObject(IGosuClassInternal gsClass, IGosuClassInternal gsObjectInterace) {
        if (gsClass == gsObjectInterace) {
            return true;
        }
        for (IType iface : gsClass.getInterfaces()) {
            if (!(iface instanceof IGosuClass)) continue;
            return true;
        }
        return false;
    }

    private List<TypeVariableDefinitionImpl> getDeclTypeVars() {
        IGosuClassInternal gsClass = this.getGosuClass();
        IGenericTypeVariable[] typeVars = gsClass.getGenericTypeVariables();
        if (typeVars == null) {
            return Collections.emptyList();
        }
        ArrayList<TypeVariableDefinitionImpl> result = new ArrayList<TypeVariableDefinitionImpl>(typeVars.length);
        for (IGenericTypeVariable typeVar : typeVars) {
            result.add((TypeVariableDefinitionImpl)typeVar.getTypeVariableDefinition());
        }
        return result;
    }

    private void makeSyntheticClassDeclaration(String strClassName, boolean bProgram) {
        ClassDeclaration classDeclaration = new ClassDeclaration(strClassName);
        this.pushExpression(classDeclaration);
        SourceCodeTokenizer tokenizer = this.getOwner().getTokenizer();
        this.setLocation(bProgram ? 0 : tokenizer.getTokenStart(), tokenizer.getLineNumber(), bProgram ? 0 : tokenizer.getTokenColumn(), true, true);
        this.popExpression();
        this.getClassStatement().setClassDeclaration(classDeclaration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseInnerClassHeaders(IGosuClassInternal gsClass, boolean bResolveTypes) {
        Map innerClassesByName = gsClass.getKnownInnerClassesWithoutCompiling();
        if (innerClassesByName.isEmpty()) {
            return;
        }
        int state = this.getTokenizer().mark();
        int iLocationsSize = this.getLocationsList().size();
        try {
            for (CharSequence name : innerClassesByName.keySet()) {
                IGosuClassInternal innerClass = (IGosuClassInternal)innerClassesByName.get(name);
                if (innerClass instanceof IBlockClass) continue;
                innerClass.createNewParseInfo();
                new GosuClassParser(this.getOwner(), innerClass).parseHeader(innerClass, false, false, bResolveTypes);
            }
        }
        finally {
            while (this.getLocationsList().size() > iLocationsSize) {
                this.getLocationsList().remove(this.getLocationsList().size() - 1);
            }
            this.getTokenizer().restoreToMark(state);
        }
    }

    private void loadAllNestedInnerClasses(IGosuClassInternal gsClass) {
        String[] strMemberKeyword = new String[1];
        if (!(gsClass instanceof IGosuProgram)) {
            this.advanceToClassBodyStart();
        }
        while (true) {
            int[] location = new int[3];
            int[] mark = new int[]{-1};
            ModifierInfo modifiers = this.parseUntilMemberKeyword(strMemberKeyword, true, -1, location, mark);
            if (modifiers.getModifiers() == -1) {
                if (this.getTokenizer().isEOF()) break;
                if (!this.isInnerClassesEmpty()) {
                    IGosuClassInternal innerClass = this.popInnerClass(this.getCurrentInnerClass());
                    innerClass.getSourceFileHandle().setEnd(location[0]);
                    continue;
                }
                if (!gsClass.isAnonymous()) continue;
                break;
            }
            ClassType classType = this.getClassType(strMemberKeyword[0]);
            if (classType == null) continue;
            IGosuClassInternal innerClass = this.loadNextInnerClass(gsClass, classType);
            if (innerClass == null) break;
            innerClass.getSourceFileHandle().setOffset(location[0]);
            ((InnerClassFileSystemSourceFileHandle)innerClass.getSourceFileHandle()).setMark(mark[0]);
            this.pushInnerClass(innerClass);
        }
    }

    private ClassType getClassType(String strValue) {
        return Keyword.KW_class.toString().equals(strValue) ? ClassType.Class : (Keyword.KW_interface.equals(strValue) ? ClassType.Interface : (Keyword.KW_annotation.equals(strValue) ? ClassType.Annotation : (Keyword.KW_structure.equals(strValue) ? ClassType.Structure : (Keyword.KW_enum.toString().equals(strValue) ? ClassType.Enum : null))));
    }

    private void advanceToClassBodyStart() {
        while (!this.match(null, 123) && !this.match(null, -1)) {
            this.getTokenizer().nextToken();
        }
    }

    private void advanceToClassBodyEnd() {
        int iEnd = this.getGosuClass().getSourceFileHandle().getEnd();
        if (iEnd <= 0) {
            return;
        }
        try {
            this.getTokenizer().goToPosition(iEnd);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.verify((ParsedElement)this.getClassStatement(), this.match(null, 125), Res.MSG_EXPECTING_CLOSE_BRACE_FOR_CLASS_DEF, new String[0]);
    }

    private IGosuClassInternal loadNextInnerClass(IGosuClassInternal gsClass, ClassType classType) {
        Token T = new Token();
        IGosuClassInternal enclosingGsClass = this.getGosuClass();
        if (this.verify((ParsedElement)this.getClassStatement(), this.match(T, -5), Res.MSG_EXPECTING_NAME_CLASS_DEF, new String[0])) {
            enclosingGsClass = this.getCurrentInnerClass() != null ? this.getCurrentInnerClass() : enclosingGsClass;
            String strInnerClass = T._strValue;
            IGosuClassInternal innerGsClass = (IGosuClassInternal)enclosingGsClass.getKnownInnerClassesWithoutCompiling().get(strInnerClass);
            if (innerGsClass != null) {
                this.getClassStatement().addParseException((IParseIssue)new ParseException((IParserState)this.makeFullParserState(), Res.MSG_DUPLICATE_CLASS_FOUND, new Object[]{strInnerClass}));
                strInnerClass = strInnerClass + "_duplicate_" + this.nextIndexOfErrantDuplicateInnerClass(enclosingGsClass, innerGsClass);
            }
            innerGsClass = (IGosuClassInternal)gsClass.getTypeLoader().makeNewClass((ISourceFileHandle)new InnerClassFileSystemSourceFileHandle(classType, enclosingGsClass.getName(), strInnerClass, gsClass.isTestClass()));
            innerGsClass.setEnclosingType((IType)enclosingGsClass);
            innerGsClass.setNamespace(enclosingGsClass.getNamespace());
            enclosingGsClass.addInnerClass(innerGsClass);
            this.advanceToClassBodyStart();
            return innerGsClass;
        }
        return null;
    }

    public int nextIndexOfErrantDuplicateInnerClass(IGosuClassInternal enclosingGsClass, IGosuClassInternal innerClass) {
        IType existingInnerClass;
        int iMax = -1;
        String strName = innerClass.getRelativeName() + "_duplicate_";
        while ((existingInnerClass = (IType)enclosingGsClass.getKnownInnerClassesWithoutCompiling().get(strName + ++iMax)) != null) {
        }
        return iMax;
    }

    private IGosuClassInternal getGosuObjectInterface() {
        return IGosuClassInternal.Util.getGosuClassFrom((IType)JavaTypes.IGOSU_OBJECT());
    }

    private String parseEnhancementHeaderSuffix(IGosuEnhancementInternal gsClass) {
        int iOffset = this.getTokenizer().getTokenStart();
        int iLineNum = this.getTokenizer().getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        Token t = new Token();
        this.verify((ParsedElement)this.getClassStatement(), this.match(t, -5), Res.MSG_EXPECTING_NAME_CLASS_DEF, new String[0]);
        String strClassName = t._strValue;
        strClassName = GosuStringUtil.isEmpty((String)this.getOwner().getNamespace()) ? strClassName : this.getOwner().getNamespace() + '.' + strClassName;
        ClassDeclaration classDeclaration = new ClassDeclaration(strClassName);
        this.pushExpression(classDeclaration);
        this.setLocation(iOffset, iLineNum, iColumn);
        this.popExpression();
        this.getClassStatement().setClassDeclaration(classDeclaration);
        if (gsClass.getEnclosingTypeReference() == null && !strClassName.equals(gsClass.getName())) {
            this.verify((ParsedElement)this.getClassStatement(), false, Res.MSG_WRONG_CLASSNAME, strClassName, gsClass.getName());
        }
        this.parseEnhancementTypeVarsAndExtends(gsClass);
        return strClassName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseEnhancementTypeVarsAndExtends(IGosuEnhancementInternal gsClass) {
        List<TypeVariableDefinitionImpl> declTypeVars;
        if (!gsClass.isHeaderCompiled()) {
            int mark = this.getOwner().getTokenizer().mark();
            int iLocationsCount = this.getOwner().getLocationsList().size();
            this._parseEnhancementTypeVarsAndExtends(gsClass, Collections.emptyList());
            declTypeVars = this.getDeclTypeVars();
            if (declTypeVars.isEmpty()) return;
            this.getOwner().getTokenizer().restoreToMark(mark);
            this.getOwner().removeLocationsFrom(iLocationsCount);
        } else {
            declTypeVars = this.getDeclTypeVars();
        }
        this._parseEnhancementTypeVarsAndExtends(gsClass, declTypeVars);
    }

    private void _parseEnhancementTypeVarsAndExtends(IGosuEnhancementInternal gsClass, List<TypeVariableDefinitionImpl> declTypeVars) {
        List<ITypeVariableDefinitionExpression> typeVarLiteralList = this.parseTypeVariableDefinitionExpressions(gsClass, declTypeVars);
        this.verify((ParsedElement)this.getClassStatement(), this.match(null, ":", -6), Res.MSG_EXPECTING_COLON_ENHANCEMENT, new String[0]);
        IType enhancedType = this.parseEnhancedOrImplementedType(gsClass, true, Collections.emptyList());
        if (!(enhancedType instanceof ErrorType) && !(enhancedType instanceof IEnhanceableType)) {
            this.verify((ParsedElement)this.getClassStatement(), false, Res.MSG_NOT_AN_ENHANCEABLE_TYPE, enhancedType.getName());
        }
        gsClass.setEnhancedType(enhancedType);
        this.ensureEnhancedTypeUsesTypeVarsOfEnhancement(typeVarLiteralList, enhancedType);
    }

    private void ensureEnhancedTypeUsesTypeVarsOfEnhancement(List<ITypeVariableDefinitionExpression> typeVarLiteralList, IType enhancedType) {
        if (typeVarLiteralList.isEmpty()) {
            return;
        }
        for (ITypeVariableDefinitionExpression expr : typeVarLiteralList) {
            boolean bReferencedByOtherTypeVar = false;
            for (ITypeVariableDefinitionExpression expr2 : typeVarLiteralList) {
                if (expr2 == expr || !this.hasTypeVar(expr2.getTypeVarDef().getBoundingType(), expr.getTypeVarDef().getType())) continue;
                bReferencedByOtherTypeVar = true;
                break;
            }
            this.verify((ParsedElement)this.getClassStatement(), !this.getGosuClass().isHeaderCompiled() || bReferencedByOtherTypeVar || this.hasTypeVar(enhancedType, expr.getTypeVarDef().getType()), Res.MSG_ENHANCED_TYPE_MUST_USE_ENHANCEMENT_TYPEVARS, new String[0]);
        }
    }

    private boolean hasTypeVar(IType type, ITypeVariableType typeVar) {
        if (type == null) {
            return false;
        }
        if (type.isArray()) {
            type = TypeLord.getCoreType(type);
        }
        if (type == null || type.equals(typeVar)) {
            return true;
        }
        if (type.isParameterizedType()) {
            for (IType typeParam : type.getTypeParameters()) {
                if (!this.hasTypeVar(typeParam, typeVar)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseProgramExtendsStatement(IGosuClassInternal gsClass, boolean bResolveTypes) {
        int iOffset = this.getTokenizer().getTokenStart();
        int iLineNum = this.getTokenizer().getLineNumber();
        int iColumn = this.getTokenizer().getLineOffset();
        if (this.match(new Token(), Keyword.KW_extends)) {
            IConstructorInfo noArgCtor;
            IType superType = this.parseEnhancedOrImplementedType(gsClass, true, Collections.emptyList());
            SuperTypeClause stmt = new SuperTypeClause(superType);
            if (superType instanceof IGosuClassInternal && bResolveTypes) {
                ((IGosuClassInternal)superType).compileDeclarationsIfNeeded();
            }
            this.pushExpression(stmt);
            try {
                this.setLocation(iOffset, iLineNum, iColumn);
            }
            finally {
                this.popExpression();
            }
            ITypeInfo typeInfo = superType.getTypeInfo();
            if (!(superType instanceof IErrorType) && typeInfo instanceof IRelativeTypeInfo && this.verify((ParsedElement)stmt, (noArgCtor = ((IRelativeTypeInfo)typeInfo).getConstructor((IType)gsClass, null)) != null, Res.MSG_NO_DEFAULT_CTOR_IN, superType.getName())) {
                gsClass.setSuperType(superType);
            }
        }
    }

    private IType parseEnhancedOrImplementedType(IGosuClassInternal gsClass, boolean bExtended, List<IType> interfaces) {
        Object extendedType = null;
        TypeLiteral extendedTypeExpr = null;
        if (gsClass instanceof IGosuProgram && !bExtended) {
            extendedType = gsClass.getSupertype() != null ? gsClass.getSupertype() : JavaTypes.OBJECT();
        } else if (!gsClass.isEnum() || !bExtended) {
            this.getOwner().parseTypeLiteral(!(gsClass instanceof IGosuEnhancementInternal) && (gsClass.isInterface() || !bExtended));
            extendedTypeExpr = (TypeLiteral)this.popExpression();
            extendedType = extendedTypeExpr.getType().getType();
            if (!this.verify((ParsedElement)extendedTypeExpr, !extendedType.isCompoundType(), Res.MSG_COMPOUND_TYPE_NOT_ALLOWED_HERE, new String[0])) {
                extendedType = ErrorType.getInstance();
            }
            if (!(extendedType instanceof ErrorType)) {
                if (!(gsClass instanceof IGosuEnhancementInternal)) {
                    IType[] conflict;
                    if (gsClass.isInterface()) {
                        this.verify((ParsedElement)extendedTypeExpr, extendedType.isInterface(), Res.MSG_INTERFACE_CANNOT_EXTEND_CLASS, new String[0]);
                    } else if (bExtended) {
                        if (this.verify((ParsedElement)extendedTypeExpr, !extendedType.isInterface(), Res.MSG_CLASS_CANNOT_EXTEND_INTERFACE, new String[0])) {
                            this.verify((ParsedElement)extendedTypeExpr, !gsClass.isEnum(), Res.MSG_ENUM_CANNOT_EXTEND_CLASS, new String[0]);
                            this.verify((ParsedElement)extendedTypeExpr, extendedType != JavaTypes.OBJECT(), Res.MSG_SUBCLASS_OBJECT, gsClass.getRelativeName());
                            this.verify((ParsedElement)extendedTypeExpr, !extendedType.isArray(), Res.MSG_CANNOT_EXTEND_ARRAY, extendedType.getRelativeName());
                        }
                    } else {
                        this.verify((ParsedElement)extendedTypeExpr, extendedType.isInterface(), Res.MSG_CLASS_CANNOT_IMPLEMENT_CLASS, new String[0]);
                    }
                    this.verify((ParsedElement)extendedTypeExpr, !extendedType.isPrimitive(), Res.MSG_CANNOT_EXTEND_PRIMITIVE_TYPE, new String[0]);
                    this.verify((ParsedElement)extendedTypeExpr, !extendedType.isFinal(), Res.MSG_CANNOT_EXTEND_FINAL_TYPE, extendedType.getName());
                    if (this.verify((ParsedElement)extendedTypeExpr, !interfaces.contains(extendedType), Res.MSG_DUPLICATE_CLASS_FOUND, extendedType.getRelativeName()) && (conflict = this.inheritsWithDifferentTypeParams(gsClass.getSupertype(), interfaces, (IType)extendedType)) != null) {
                        extendedTypeExpr.addParseException(Res.MSG_INHEREITED_WITH_DIFF_ARG_TYPES, TypeLord.getPureGenericType(conflict[0]).getName(), Arrays.toString(conflict[0].getTypeParameters()) + " , " + Arrays.toString(conflict[1].getTypeParameters()));
                    }
                    if (this.isCyclicInheritance((IType)extendedType, gsClass)) {
                        extendedType = ErrorType.getInstance(extendedType.getName());
                        this.verify((ParsedElement)extendedTypeExpr, false, Res.MSG_CYCLIC_INHERITANCE, extendedType.getName());
                    }
                } else if (extendedType instanceof IGosuEnhancementInternal) {
                    this.verify((ParsedElement)extendedTypeExpr, false, Res.MSG_ENHANCEMENTS_CANNOT_ENHANCE_OTHER_ENHANCEMENTS, extendedType.getName());
                }
            }
        } else if (gsClass.isEnum()) {
            extendedType = JavaTypes.ENUM();
            extendedType = extendedType.getParameterizedType(new IType[]{gsClass});
        }
        this.makeProxy(gsClass, (IType)extendedType);
        extendedType = TypeLord.makeDefaultParameterizedType((IType)extendedType);
        if (!this.verify(extendedTypeExpr == null ? this.getClassStatement() : extendedTypeExpr, !extendedType.isGenericType() || extendedType instanceof IGosuClass && !((IGosuClass)extendedType).isHeaderCompiled() || extendedType.isParameterizedType() || gsClass instanceof IGosuEnhancementInternal, Res.MSG_CANNOT_EXTEND_RAW_GENERIC_TYPE, extendedType.getName())) {
            extendedType = ErrorType.getInstance();
        }
        if (bExtended && !(gsClass instanceof IGosuEnhancementInternal)) {
            this.verify(extendedTypeExpr == null ? this.getClassStatement() : extendedTypeExpr, Modifier.isStatic((int)extendedType.getModifiers()) || extendedType.getEnclosingType() == null || TypeLord.enclosingTypeInstanceInScope(extendedType.getEnclosingType(), this.getGosuClass()), Res.MSG_NO_ENCLOSING_INSTANCE_IN_SCOPE, extendedType.getEnclosingType());
        }
        if (!(extendedType instanceof ErrorType) && gsClass.isDeclarationsCompiled()) {
            this.verifySuperTypeVarVariance(this.getClassStatement(), (IType)extendedType);
        }
        return extendedType;
    }

    private IType[] inheritsWithDifferentTypeParams(IType superType, List<IType> interfaces, IType iface) {
        IType[] conflict;
        if (superType != null && (conflict = this.inheritsWithDifferentTypeParams(null, Arrays.asList(superType.getInterfaces()), iface)) != null) {
            return conflict;
        }
        IType rawIface = TypeLord.getPureGenericType(iface);
        for (IType csr : interfaces) {
            if (TypeLord.getPureGenericType(csr) == rawIface && csr != iface) {
                return new IType[]{csr, iface};
            }
            IType[] conflict2 = this.inheritsWithDifferentTypeParams(null, Arrays.asList(csr.getInterfaces()), iface);
            if (conflict2 != null) {
                return conflict2;
            }
            conflict2 = this.inheritsWithDifferentTypeParams(null, Arrays.asList(iface.getInterfaces()), csr);
            if (conflict2 == null) continue;
            return conflict2;
        }
        return null;
    }

    private void makeProxy(IGosuClassInternal gsClass, IType extendedType) {
        if (!(gsClass instanceof IGosuEnhancementInternal) && extendedType instanceof IJavaType) {
            GosuClassProxyFactory.instance().create(extendedType);
        }
    }

    private Object parseFunctionOrConstructorOrFieldDeclaration(IGosuClassInternal gsClass) {
        int[] location = new int[3];
        Object rtn = this._parseFunctionOrConstructorOrFieldDeclaration(gsClass, location);
        if (rtn != null) {
            this.setLocation(location[0], location[1], location[2]);
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _parseFunctionOrConstructorOrFieldDeclaration(IGosuClassInternal gsClass, int[] location) {
        ModifierInfo modifiers;
        String[] T = new String[1];
        boolean bInterface = gsClass.isInterface();
        while (true) {
            if ((modifiers = this.parseUntilMemberKeyword(T, false, -1, location)).getModifiers() == -1) {
                return null;
            }
            if (!Keyword.KW_class.equals(T[0]) && !Keyword.KW_interface.equals(T[0]) && !Keyword.KW_annotation.equals(T[0]) && !Keyword.KW_structure.equals(T[0]) && !Keyword.KW_enum.equals(T[0])) break;
            if (bInterface && Keyword.KW_enum.equals(T[0])) {
                this.verify((ParsedElement)this.getClassStatement(), !Modifier.isFinal((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_final, Keyword.KW_enum);
            }
            this.parseInnerClassDeclaration();
        }
        if (bInterface) {
            if (this.match(null, Keyword.KW_var, true)) {
                modifiers.addModifiers(8);
            }
            modifiers.addModifiers(1);
        }
        this.getOwner().pushParsingStaticMember(Modifier.isStatic((int)modifiers.getModifiers()));
        try {
            if (T[0] != null && (Keyword.KW_function.equals(T[0]) || Keyword.KW_construct.equals(T[0]))) {
                String ctorNameToken = null;
                boolean bConstructKeyword = false;
                if (Keyword.KW_construct.equals(T[0])) {
                    T[0] = gsClass.getRelativeName();
                    ctorNameToken = T[0];
                    bConstructKeyword = true;
                } else {
                    int mark = this.getTokenizer().mark();
                    if (this.match(null, null, -5, true)) {
                        T[0] = this.getTokenizer().getTokenAt(mark).getStringValue();
                    }
                }
                FunctionStatement fs = this.makeFunctionOrConstructorStatement(gsClass, T[0], bConstructKeyword);
                LazyLightweightParserState constructOrFunctionState = this.makeLazyLightweightParserState();
                this.verify((ParsedElement)fs, !(gsClass instanceof IGosuProgramInternal) || !((IGosuProgramInternal)gsClass).isStatementsOnly(), Res.MSG_FUNCTIONS_NOT_ALLOWED_IN_THIS_CONTEXT, new String[0]);
                DynamicFunctionSymbol dfs = this.getOwner().parseFunctionDecl(fs, ctorNameToken, false, false, modifiers);
                fs.setDynamicFunctionSymbol(dfs);
                this.pushStatement(fs);
                if (dfs != null) {
                    dfs.setClassMember(true);
                    boolean bConstructor = dfs.getDisplayName().equals(gsClass.getRelativeName());
                    if (bConstructor) {
                        this.verify((ParsedElement)fs, !Modifier.isAbstract((int)modifiers.getModifiers()), Res.MSG_MODIFIER_ABSTRACT_NOT_ALLOWED_HERE, new String[0]);
                        this.verify((ParsedElement)fs, !gsClass.isInterface(), Res.MSG_NOT_ALLOWED_IN_INTERFACE, new String[0]);
                        this.verify((ParsedElement)fs, !(gsClass instanceof IGosuProgramInternal), Res.MSG_CONSTRUCTORS_NOT_ALLOWD_IN_THIS_CONTEXT, new String[0]);
                        this.verify((ParsedElement)fs, !Modifier.isOverride((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_override, Keyword.KW_construct);
                        this.verify((ParsedElement)fs, !Modifier.isFinal((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_final, Keyword.KW_construct);
                        this.verify((ParsedElement)fs, !Modifier.isStatic((int)modifiers.getModifiers()), Res.MSG_NO_STATIC_CONSTRUCTOR, new String[0]);
                        this.verify((ParsedElement)fs, !Modifier.isTransient((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_transient, Keyword.KW_construct);
                        if (!bConstructKeyword) {
                            fs.addParseWarning((IParseIssue)new ObsoleteConstructorWarning((IParserState)constructOrFunctionState, Res.MSG_OBSOLETE_CTOR_SYNTAX));
                        }
                    } else {
                        this.verifyNoCombinedFinalStaticModifierDefined(fs, false, modifiers.getModifiers());
                        this.verify((ParsedElement)fs, !Modifier.isAbstract((int)modifiers.getModifiers()) || !Modifier.isStatic((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_static, Keyword.KW_abstract);
                        this.verify((ParsedElement)fs, !Modifier.isAbstract((int)modifiers.getModifiers()) || !Modifier.isFinal((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_final, Keyword.KW_abstract);
                        this.verify((ParsedElement)fs, !Modifier.isTransient((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_transient, Keyword.KW_function);
                    }
                }
                this.eatOptionalSemiColon(bInterface);
                if (!Modifier.isNative((int)modifiers.getModifiers()) && !Modifier.isAbstract((int)modifiers.getModifiers())) {
                    this.eatStatementBlock(fs, Res.MSG_EXPECTING_OPEN_BRACE_FOR_FUNCTION_DEF);
                }
                DynamicFunctionSymbol bConstructor = dfs;
                return bConstructor;
            }
            if (T[0] != null && T[0].equals(Keyword.KW_property.toString())) {
                boolean bGetter = this.match(null, Keyword.KW_get);
                boolean bSetter = !bGetter && this.match(null, Keyword.KW_set);
                SourceCodeTokenizer tokenizer = this.getTokenizer();
                int mark = tokenizer.mark();
                if (this.match(null, -5)) {
                    this.eatPossibleParametarization(true);
                    if (!this.match(null, null, 40, true)) {
                        tokenizer.restoreToMark(mark);
                        Object dfs = this.parseNewPropertyDecl(bGetter, bSetter, modifiers);
                        return dfs;
                    }
                    tokenizer.restoreToMark(mark);
                }
                this.verify((ParsedElement)this.getClassStatement(), bGetter || bSetter, Res.MSG_EXPECTING_PROPERTY_GET_OR_SET_MODIFIER, new String[0]);
                FunctionStatement fs = new FunctionStatement();
                this.verifyNoCombinedFinalStaticModifierDefined(fs, false, modifiers.getModifiers());
                this.verify((ParsedElement)fs, !(gsClass instanceof IGosuProgramInternal) || !((IGosuProgramInternal)gsClass).isStatementsOnly(), Res.MSG_FUNCTIONS_NOT_ALLOWED_IN_THIS_CONTEXT, new String[0]);
                DynamicFunctionSymbol dfs = this.getOwner().parseFunctionDecl(fs, true, bGetter, modifiers);
                if (dfs == null) {
                    this.getClassStatement().addParseException((IParseIssue)new ParseException((IParserState)this.makeFullParserState(), Res.MSG_EXPECTING_DECL, new Object[0]));
                    Object var12_24 = null;
                    return var12_24;
                }
                if (dfs.getDisplayName().length() > 0 && dfs.getDisplayName().charAt(0) == '@') {
                    String name = dfs.getDisplayName().substring(1);
                    boolean bOuterLocalDefined = this.findLocalInOuters(name) instanceof CapturedSymbol;
                    this.verifyOrWarn(fs, !bOuterLocalDefined, false, Res.MSG_VARIABLE_ALREADY_DEFINED, name);
                }
                if (bInterface && !this.match(null, null, 123, true)) {
                    this.verify((ParsedElement)fs, !Modifier.isFinal((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_final, Keyword.KW_property);
                    modifiers.setModifiers(Modifier.setAbstract((int)modifiers.getModifiers(), (boolean)true));
                    dfs.setAbstract(true);
                }
                this.verify((ParsedElement)fs, !Modifier.isAbstract((int)modifiers.getModifiers()) || !Modifier.isStatic((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_static, Keyword.KW_abstract);
                this.verify((ParsedElement)fs, !Modifier.isAbstract((int)modifiers.getModifiers()) || !Modifier.isFinal((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_final, Keyword.KW_abstract);
                this.verify((ParsedElement)fs, !Modifier.isAbstract((int)modifiers.getModifiers()) || gsClass.isAbstract(), Res.MSG_ABSTRACT_MEMBER_NOT_IN_ABSTRACT_CLASS, new String[0]);
                fs.setDynamicFunctionSymbol(dfs);
                this.pushStatement(fs);
                this.setLocation(location[0], location[1], location[2]);
                this.popStatement();
                dfs.setClassMember(true);
                this.eatOptionalSemiColon(bInterface);
                if (!(bInterface || Modifier.isNative((int)modifiers.getModifiers()) || Modifier.isAbstract((int)modifiers.getModifiers()))) {
                    this.eatStatementBlock(fs, Res.MSG_EXPECTING_OPEN_BRACE_FOR_FUNCTION_DEF);
                }
                DynamicPropertySymbol dps = this.getOrCreateDynamicPropertySymbol(this.getClassStatement(), gsClass, dfs, bGetter);
                PropertyStatement statement = new PropertyStatement(fs, dps);
                this.verifyPropertiesAreSymmetric(bGetter, dfs, dps, statement);
                this.pushStatement(statement);
                DynamicPropertySymbol dynamicPropertySymbol = dps;
                return dynamicPropertySymbol;
            }
            if (T[0] != null && T[0].equals(Keyword.KW_var.toString())) {
                if (bInterface) {
                    modifiers.setModifiers(Modifier.setStatic((int)modifiers.getModifiers(), (boolean)true));
                    modifiers.setModifiers(Modifier.setFinal((int)modifiers.getModifiers(), (boolean)true));
                }
                VarStatement varStatement = this.parseFieldDecl(modifiers);
                return varStatement;
            }
            if (T[0] != null && T[0].equals(Keyword.KW_delegate.toString())) {
                VarStatement varStatement = this.parseDelegateDecl(modifiers, gsClass);
                return varStatement;
            }
            this.getClassStatement().addParseException((IParseIssue)new ParseException((IParserState)this.makeFullParserState(), Res.MSG_EXPECTING_DECL, new Object[0]));
            Object var6_10 = null;
            return var6_10;
        }
        finally {
            this.getOwner().popParsingStaticMember();
        }
    }

    private Object parseNewPropertyDecl(boolean bGetter, boolean bSetter, ModifierInfo modifiers) {
        int iDupIndex;
        Object type;
        ISymbol existing;
        if (!bGetter && !bSetter) {
            bSetter = true;
            bGetter = true;
        }
        Token T = new Token();
        VarStatement varStmt = new VarStatement();
        varStmt.setDeclAnnotations(modifiers.getAnnotations());
        int iNameStart = this.getTokenizer().getTokenStart();
        if (!this.verify((ParsedElement)varStmt, this.match(T, -5), Res.MSG_EXPECTING_IDENTIFIER_VAR, new String[0])) {
            T._strValue = null;
        }
        String strProperty = T._strValue == null ? "" : T._strValue;
        String strField = "";
        if (!strProperty.isEmpty()) {
            strField = "_" + strProperty;
        }
        boolean bAlreadyDefined = (existing = this.getSymbolTable().getSymbol((CharSequence)strField)) != null && (existing.getGosuClass() == null || existing.getGosuClass() == this.getGosuClass());
        this.verify((ParsedElement)varStmt, !bAlreadyDefined, Res.MSG_VARIABLE_ALREADY_DEFINED, strField);
        this.checkForEnumConflict(varStmt, strField);
        boolean bStatic = Modifier.isStatic((int)modifiers.getModifiers());
        TypeLiteral typeLiteral = null;
        if (this.verify((ParsedElement)varStmt, this.match(null, ":", -6), Res.MSG_EXPECTING_TYPELITERAL_OR_NAMESPACE, new String[0])) {
            this.getOwner().parseTypeLiteral();
            typeLiteral = (TypeLiteral)this.popExpression();
        }
        boolean bHasInit = this.match(null, "=", -6, true);
        if (typeLiteral != null) {
            type = typeLiteral.getType().getType();
            varStmt.setTypeLiteral(typeLiteral);
        } else {
            type = GosuParserTypes.NULL_TYPE();
        }
        ModifierInfo varModifiers = new ModifierInfo(2 | (bStatic ? 8 : 0) | (this.getGosuClass().isInterface() || Modifier.isAbstract((int)modifiers.getModifiers()) ? 1024 : 0));
        if (bGetter && !bSetter && Modifier.isFinal((int)modifiers.getModifiers())) {
            varModifiers.addModifiers(16);
            modifiers.removeModifiers(16);
        }
        this.transferModifierInfo(varStmt, modifiers, varModifiers);
        varStmt.setModifierInfo(varModifiers);
        if (!this.verify((ParsedElement)varStmt, varStmt.isPrivate() || type != GosuParserTypes.NULL_TYPE(), Res.MSG_NON_PRIVATE_MEMBERS_MUST_DECLARE_TYPE, new String[0])) {
            type = ErrorType.getInstance();
        }
        DynamicPropertySymbol dps = this.getOwner().makeProperties(varStmt, strField, strProperty, (IType)type, modifiers, bGetter, bSetter);
        ISymbol existingSym = this.getSymbolTable().getSymbol((CharSequence)strProperty);
        boolean bOuterLocalDefined = this.findLocalInOuters(strProperty) instanceof CapturedSymbol;
        bAlreadyDefined = existingSym != null || bOuterLocalDefined;
        this.verify((ParsedElement)varStmt, !bAlreadyDefined || existingSym instanceof DynamicPropertySymbol, Res.MSG_VARIABLE_ALREADY_DEFINED, strProperty);
        this.getSymbolTable().putSymbol((ISymbol)dps);
        this.verifyPropertiesAreSymmetric(true, dps.getGetterDfs(), dps, varStmt);
        this.setStatic(bStatic, dps);
        dps.addMemberSymbols(this.getGosuClass());
        if (this.getGosuClass().isInterface()) {
            if (!bHasInit && dps.getGetterDfs() != null) {
                dps.getGetterDfs().getModifierInfo().addModifiers(1024);
            }
            if (!bHasInit && dps.getSetterDfs() != null) {
                dps.getSetterDfs().getModifierInfo().addModifiers(1024);
            }
        }
        varStmt.setProperty(dps);
        this.verify((ParsedElement)varStmt, !Modifier.isAbstract((int)modifiers.getModifiers()) || this.getGosuClass().isAbstract(), Res.MSG_ABSTRACT_MEMBER_NOT_IN_ABSTRACT_CLASS, new String[0]);
        DynamicSymbol symbol = new DynamicSymbol(this.getGosuClass(), this.getSymbolTable(), strField, (IType)type, (Object)null);
        varModifiers.addAll(symbol.getModifierInfo());
        symbol.setModifierInfo(varModifiers);
        varStmt.setSymbol((ISymbol)symbol);
        varStmt.setNameOffset(iNameStart, strField);
        if (bAlreadyDefined && (iDupIndex = this.getOwner().nextIndexOfErrantDuplicateDynamicSymbol(symbol, this.getSymbolTable().getSymbols().values(), false)) >= 0) {
            symbol.renameAsErrantDuplicate(iDupIndex);
        }
        this.getSymbolTable().putSymbol((ISymbol)symbol);
        this.pushStatement(varStmt);
        return varStmt;
    }

    private void transferModifierInfo(VarStatement varStmt, ModifierInfo modifiers, ModifierInfo varModifiers) {
        varModifiers.setDescription(modifiers.getDescription());
        Iterator<IGosuAnnotation> iter = modifiers.getAnnotations().iterator();
        while (iter.hasNext()) {
            IGosuAnnotation anno = iter.next();
            if (anno.getTarget() != AnnotationUseSiteTarget.field && anno.getTarget() != null) continue;
            boolean appliesToField = this.appliesToField(anno);
            this.verify((ParsedElement)varStmt, anno.getTarget() == null || appliesToField, Res.MSG_ANNOTATION_WHEN_NONE_ALLOWED, anno.getName(), Keyword.KW_field.getName());
            if (!appliesToField) continue;
            this.verify((ParsedElement)varStmt, !anno.isJavaAnnotation() || !GosuClassParser.violatesRepeatable(varModifiers.getAnnotations(), anno), Res.MSG_TOO_MANY_ANNOTATIONS, anno.getName(), Keyword.KW_field.getName());
            if (anno.getType() == JavaTypes.TARGET_MODIFIER()) {
                GosuParser.setFromTargetModifier(anno, varModifiers);
            } else {
                varModifiers.addAnnotation(anno);
            }
            if (anno.getTarget() != AnnotationUseSiteTarget.field) continue;
            iter.remove();
        }
    }

    public static boolean violatesRepeatable(List<IGosuAnnotation> annotations, IGosuAnnotation anno) {
        boolean bRepeatable = anno.getType().getTypeInfo().hasAnnotation((IType)JavaTypes.REPEATABLE());
        if (!bRepeatable) {
            for (IGosuAnnotation atn : annotations) {
                if (atn.getType() != anno.getType()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean appliesToField(IGosuAnnotation anno) {
        IAnnotationInfo annotation = anno.getType().getTypeInfo().getAnnotation((IType)JavaTypes.TARGET());
        if (annotation == null) {
            return true;
        }
        Object[] values = (Object[])annotation.getFieldValue("value");
        if (values == null || values.length == 0) {
            return true;
        }
        for (Object value : values) {
            if (value != ElementType.FIELD && !value.equals(ElementType.FIELD.name())) continue;
            return true;
        }
        return false;
    }

    private void verifySuperTypeVarVariance(ClassStatement classStatement, IType type) {
        if (!type.isParameterizedType() || !this.getGosuClass().isGenericType()) {
            return;
        }
        IGenericTypeVariable[] gtvs = type.getGenericType().getGenericTypeVariables();
        IType[] typeParameters = type.getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            if (gtvs[i] == null || gtvs[i].getTypeVariableDefinition() == null) continue;
            Variance variance = Variance.maybeInferVariance((IType)type, (IGenericTypeVariable)gtvs[i]);
            this.verifyTypeVarVariance(variance, classStatement, typeParameters[i]);
        }
    }

    private void verifyTypeVarVariance(Variance ctxVariance, ParsedElement elem, IType type) {
        if (!this.getGosuClass().isGenericType()) {
            return;
        }
        Variance.verifyTypeVarVariance((Variance)ctxVariance, (IType)this.getGosuClass(), (ctxV, typeVarV) -> this.verify(elem, typeVarV == ctxV || typeVarV == Variance.DEFAULT || typeVarV == Variance.INVARIANT || ctxV == Variance.PENDING || typeVarV == Variance.PENDING, Res.MSG_TYPE_VAR_VARIANCE_ERROR, type.getRelativeName(), typeVarV == null ? "null" : typeVarV.getDesc(), ctxV.getDesc(), type.getRelativeName()), (IType)type);
    }

    private void verifyPropertiesAreSymmetric(boolean bGetter, DynamicFunctionSymbol newFunction, DynamicPropertySymbol propertySymbol, Statement stmt) {
        DynamicFunctionSymbol setter;
        DynamicFunctionSymbol getter;
        if (bGetter) {
            getter = newFunction;
            setter = propertySymbol == null ? null : propertySymbol.getSetterDfs();
        } else {
            getter = propertySymbol == null ? null : propertySymbol.getGetterDfs();
            setter = newFunction;
        }
        if (getter != null && setter != null) {
            IType returnType;
            IType setterType;
            if (getter.isStatic() != setter.isStatic()) {
                this.verify((ParsedElement)stmt, false, Res.MSG_PROPERTIES_MUST_AGREE_ON_STATIC_MODIFIERS, new String[0]);
            }
            if (!(setter.getArgs().size() != 1 || (setterType = setter.getArgTypes()[0]).isAssignableFrom(returnType = getter.getReturnType()) && setterType.isAssignableFrom(propertySymbol.getType()))) {
                this.verify((ParsedElement)stmt, false, Res.MSG_PROPERTIES_MUST_AGREE_ON_TYPE, new String[0]);
            }
        } else if (getter != null && propertySymbol != null && newFunction != null && this.getGosuClass() == propertySymbol.getScriptPart().getContainingType() && getter.getSuperDfs() == null) {
            this.verify((ParsedElement)stmt, propertySymbol.getType().equals(newFunction.getReturnType()), Res.MSG_PROPERTIES_MUST_AGREE_ON_TYPE, new String[0]);
        }
    }

    private FunctionStatement makeFunctionOrConstructorStatement(IGosuClassInternal gsClass, String strMemberKeyword, boolean bConstructKeyword) {
        FunctionStatement fs = gsClass != null && (bConstructKeyword || gsClass.getRelativeName().equals(strMemberKeyword)) ? new ConstructorStatement(bConstructKeyword) : new FunctionStatement();
        return fs;
    }

    private ModifierInfo parseUntilMemberKeyword(String[] T, boolean bIgnoreErrors, int[] location) {
        return this.parseUntilMemberKeyword(T, bIgnoreErrors, -1, location);
    }

    private ModifierInfo parseUntilMemberKeyword(String[] T, boolean bIgnoreErrors, int iEnd, int[] location) {
        return this.parseUntilMemberKeyword(T, bIgnoreErrors, iEnd, location, null);
    }

    private ModifierInfo parseUntilMemberKeyword(String[] T, boolean bIgnoreErrors, int iEnd, int[] location, int[] mark) {
        ModifierInfo modifiers;
        boolean bPeek;
        boolean bl = bPeek = T == null;
        while (true) {
            if (location != null) {
                location[0] = this.getTokenizer().getTokenStart();
                location[1] = this.getTokenizer().getLineNumber();
                location[2] = this.getTokenizer().getTokenColumn();
            }
            if (mark != null) {
                mark[0] = this.getTokenizer().mark();
            }
            modifiers = this.parseModifiers(bIgnoreErrors);
            if (GosuClassParser.matchDeclarationKeyword(T, bPeek, this.getTokenizer())) {
                return modifiers;
            }
            this.popModifierList();
            boolean bAte = false;
            if (this.getGosuClass() instanceof IGosuProgram) {
                bAte = this.eatPossibleEnclosedVarInStmt();
            }
            boolean bl2 = bAte = this.eatPossibleStatementBlock() || bAte;
            if (location != null) {
                location[0] = this.getTokenizer().getTokenStart();
            }
            if (this.match(null, -1) || (!(this.getGosuClass() instanceof IGosuProgram) || !this.getGosuClass().isHeaderCompiled()) && this.match(null, 125) || iEnd >= 0 && this.getTokenizer().getTokenStart() >= iEnd) {
                modifiers.setModifiers(-1);
                return modifiers;
            }
            if (bAte) continue;
            this.getTokenizer().nextToken();
            if (this.getTokenizer().isEOF()) break;
        }
        modifiers.setModifiers(-1);
        return modifiers;
    }

    private void popModifierList() {
        ParseTree parseTree = this.getOwner().peekLocation();
        if (parseTree == null) {
            return;
        }
        ParsedElement pe = parseTree.getParsedElement();
        if (pe instanceof IModifierListClause) {
            List<ParseTree> locationsList = this.getLocationsList();
            locationsList.remove(locationsList.size() - 1);
        }
    }

    private void parseInnerClassDeclaration() {
        IGosuClassInternal enclosingGsClass = this.getClassStatement().getGosuClass();
        int mark = this.getTokenizer().mark();
        String strInnerClass = null;
        if (this.verify((ParsedElement)this.getClassStatement(), this.match(null, -5), Res.MSG_EXPECTING_NAME_CLASS_DEF, new String[0])) {
            strInnerClass = this.getTokenizer().getTokenAt(mark).getStringValue();
        }
        if (strInnerClass != null) {
            String name = enclosingGsClass.getName();
            String dotInner = "." + strInnerClass;
            this.verify((ParsedElement)this.getClassStatement(), !name.equals(strInnerClass) && !name.contains(dotInner + ".") && !name.endsWith(dotInner) && !name.startsWith(strInnerClass + "."), Res.MSG_DUPLICATE_CLASS_FOUND, name + dotInner);
            for (IGosuClass c : enclosingGsClass.getKnownInnerClassesWithoutCompiling().values()) {
                IGosuClassInternal innerClass = (IGosuClassInternal)c;
                if (!innerClass.getRelativeName().equals(strInnerClass)) continue;
                int i = 0;
                String relativeName = innerClass.getName();
                while (innerClass.isDeclarationsCompiled() || innerClass.isDeclarationsBypassed()) {
                    String duplicate = relativeName + "_duplicate_" + i++;
                    innerClass = (IGosuClassInternal)TypeSystem.getByFullNameIfValid((String)duplicate);
                    if (innerClass != null) continue;
                    return;
                }
                this.parseInnerClassDeclaration(innerClass);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseInnerClassDeclaration(IGosuClassInternal innerClass) {
        Map<String, List<IFunctionSymbol>> restoreDfsDecls = GosuClassParser.copyDFSDecls(this.getOwner());
        try {
            new GosuClassParser(this.getOwner(), innerClass).parseDeclarations(innerClass);
            if (innerClass.isInterface()) {
                ModifierInfo mi = (ModifierInfo)innerClass.getModifierInfo();
                mi.setModifiers(Modifier.setStatic((int)mi.getModifiers(), (boolean)true));
            }
        }
        finally {
            this.getOwner().setDfsDeclInSetByName(restoreDfsDecls);
        }
    }

    private static Map<String, List<IFunctionSymbol>> copyDFSDecls(GosuParser owner) {
        HashMap<String, List<IFunctionSymbol>> hashMap = new HashMap<String, List<IFunctionSymbol>>(owner.getDfsDecls());
        for (String name : hashMap.keySet()) {
            hashMap.put(name, new ArrayList((Collection)hashMap.get(name)));
        }
        return hashMap;
    }

    private VarStatement parseFieldDecl(ModifierInfo modifiers) {
        int iDupIndex;
        DynamicPropertySymbol dpsVarProperty;
        Object type;
        Token T = new Token();
        VarStatement varStmt = new VarStatement();
        varStmt.setDeclAnnotations(modifiers.getAnnotations());
        this.verify((ParsedElement)varStmt, !Modifier.isAbstract((int)modifiers.getModifiers()), Res.MSG_MODIFIER_ABSTRACT_NOT_ALLOWED_HERE, new String[0]);
        this.verify((ParsedElement)varStmt, !Modifier.isOverride((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_override, Keyword.KW_var);
        int iNameStart = this.getTokenizer().getTokenStart();
        if (!this.verify((ParsedElement)varStmt, this.match(T, -5), Res.MSG_EXPECTING_IDENTIFIER_VAR, new String[0])) {
            T._strValue = null;
        }
        String strIdentifier = T._strValue == null ? "" : T._strValue;
        boolean bAlreadyDefined = this.getSymbolTable().getSymbol((CharSequence)strIdentifier) != null;
        this.verify((ParsedElement)varStmt, !bAlreadyDefined, Res.MSG_VARIABLE_ALREADY_DEFINED, strIdentifier);
        this.checkForEnumConflict(varStmt, strIdentifier);
        boolean bStatic = Modifier.isStatic((int)modifiers.getModifiers());
        TypeLiteral typeLiteral = null;
        if (this.match(null, ":", -6)) {
            this.getOwner().parseTypeLiteral();
            typeLiteral = (TypeLiteral)this.popExpression();
        } else if (!this.match(null, "=", -6, true) && this.match(null, null, 40, true)) {
            this.getOwner().parseBlockLiteral();
            typeLiteral = (TypeLiteral)this.popExpression();
        }
        if (typeLiteral != null) {
            type = typeLiteral.getType().getType();
            varStmt.setTypeLiteral(typeLiteral);
        } else {
            type = GosuParserTypes.NULL_TYPE();
        }
        if (bStatic) {
            modifiers.setModifiers(Modifier.setStatic((int)modifiers.getModifiers(), (boolean)true));
        }
        ModifierInfo varModifiers = new ModifierInfo(modifiers.getModifiers());
        varModifiers.setDescription(modifiers.getDescription());
        this.transferModifierInfo(varStmt, modifiers, varModifiers);
        varStmt.setModifierInfo(varModifiers);
        if (!this.verify((ParsedElement)varStmt, varStmt.isPrivate() || type != GosuParserTypes.NULL_TYPE(), Res.MSG_NON_PRIVATE_MEMBERS_MUST_DECLARE_TYPE, new String[0])) {
            type = ErrorType.getInstance();
        }
        if ((dpsVarProperty = this.getOwner().parseVarPropertyClause(varStmt, modifiers, strIdentifier, (IType)type, false)) != null) {
            String propertyName = dpsVarProperty.getName();
            ISymbol existingSym = this.getSymbolTable().getSymbol((CharSequence)propertyName);
            boolean bOuterLocalDefined = this.findLocalInOuters(propertyName) instanceof CapturedSymbol;
            bAlreadyDefined = existingSym != null || bOuterLocalDefined || propertyName.equals(strIdentifier);
            this.verify((ParsedElement)varStmt, !bAlreadyDefined || existingSym instanceof DynamicPropertySymbol, Res.MSG_VARIABLE_ALREADY_DEFINED, propertyName);
            this.getSymbolTable().putSymbol((ISymbol)dpsVarProperty);
            this.verifyPropertiesAreSymmetric(true, dpsVarProperty.getGetterDfs(), dpsVarProperty, varStmt);
            this.setStatic(bStatic, dpsVarProperty);
            dpsVarProperty.addMemberSymbols(this.getGosuClass());
        }
        DynamicSymbol symbol = new DynamicSymbol(this.getGosuClass(), this.getSymbolTable(), strIdentifier, (IType)type, (Object)null);
        modifiers.addAll(symbol.getModifierInfo());
        if (varStmt.isPrivate()) {
            modifiers.setModifiers(Modifier.setPrivate((int)modifiers.getModifiers(), (boolean)true));
        }
        symbol.setModifierInfo(modifiers);
        varStmt.setSymbol((ISymbol)symbol);
        varStmt.setNameOffset(iNameStart, T._strValue);
        if (bAlreadyDefined && (iDupIndex = this.getOwner().nextIndexOfErrantDuplicateDynamicSymbol(symbol, this.getSymbolTable().getSymbols().values(), false)) >= 0) {
            symbol.renameAsErrantDuplicate(iDupIndex);
        }
        this.getSymbolTable().putSymbol((ISymbol)symbol);
        this.pushStatement(varStmt);
        return varStmt;
    }

    private void checkForEnumConflict(VarStatement varStmt, String identifier) {
        if (this.getGosuClass().isEnum()) {
            DynamicPropertySymbol existingProp = this.getGosuClass().getMemberProperty(identifier);
            this.verify((ParsedElement)varStmt, !(existingProp instanceof DynamicPropertySymbol), Res.MSG_VARIABLE_ALREADY_DEFINED, identifier);
        }
    }

    private VarStatement parseDelegateDecl(ModifierInfo modifiers, IGosuClassInternal gsClass) {
        IType type;
        Token T = new Token();
        DelegateStatement delegateStmt = new DelegateStatement();
        this.verify((ParsedElement)delegateStmt, gsClass == null || !gsClass.isInterface(), Res.MSG_DELEGATION_NOT_ALLOWED_HERE, new String[0]);
        this.verify((ParsedElement)delegateStmt, !Modifier.isStatic((int)modifiers.getModifiers()), Res.MSG_DELEGATES_CANNOT_BE_STATIC, new String[0]);
        this.verify((ParsedElement)delegateStmt, !Modifier.isAbstract((int)modifiers.getModifiers()), Res.MSG_MODIFIER_ABSTRACT_NOT_ALLOWED_HERE, new String[0]);
        this.verify((ParsedElement)delegateStmt, !Modifier.isOverride((int)modifiers.getModifiers()), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_override, Keyword.KW_var);
        int iNameOffset = this.getTokenizer().getTokenStart();
        if (this.verify((ParsedElement)delegateStmt, this.match(T, -5), Res.MSG_EXPECTING_IDENTIFIER_VAR, new String[0])) {
            delegateStmt.setNameOffset(iNameOffset, null);
        }
        String strIdentifier = T._strValue == null ? "" : T._strValue;
        this.verify((ParsedElement)delegateStmt, this.getSymbolTable().getSymbol((CharSequence)strIdentifier) == null, Res.MSG_VARIABLE_ALREADY_DEFINED, strIdentifier);
        TypeLiteral typeLiteral = null;
        if (this.match(null, ":", -6)) {
            this.getOwner().parseTypeLiteral();
            typeLiteral = (TypeLiteral)this.popExpression();
        }
        ArrayList<IType> constituents = new ArrayList<IType>();
        if (this.verify((ParsedElement)delegateStmt, this.match(null, Keyword.KW_represents), Res.MSG_EXPECTING_REPRESENTS, new String[0])) {
            do {
                this.getOwner().parseTypeLiteral();
                TypeLiteral ifaceLiteral = (TypeLiteral)this.popExpression();
                IType iface = ifaceLiteral.getType().getType();
                if (!(iface instanceof ErrorType)) {
                    this.verify((ParsedElement)ifaceLiteral, iface.isInterface() && !iface.isCompoundType(), Res.MSG_DELEGATES_REPRESENT_INTERFACES_ONLY, new String[0]);
                    this.verify((ParsedElement)ifaceLiteral, TypeLord.isDelegatableInterface((IType)gsClass, iface), Res.MSG_CLASS_DOES_NOT_IMPL, iface);
                    this.verify((ParsedElement)typeLiteral, typeLiteral == null || TypeLord.isDelegatableInterface(typeLiteral.getType().getType(), iface), Res.MSG_CLASS_DOES_NOT_IMPL, iface);
                }
                constituents.add(iface);
            } while (this.match(null, 44));
        }
        delegateStmt.setConstituents(constituents);
        if (typeLiteral != null) {
            type = typeLiteral.getType().getType();
            delegateStmt.setTypeLiteral(typeLiteral);
        } else {
            type = GosuParserTypes.NULL_TYPE();
        }
        delegateStmt.setModifierInfo(modifiers);
        this.verify((ParsedElement)delegateStmt, delegateStmt.isPrivate() || type != GosuParserTypes.NULL_TYPE(), Res.MSG_NON_PRIVATE_MEMBERS_MUST_DECLARE_TYPE, new String[0]);
        DynamicSymbol symbol = new DynamicSymbol(this.getGosuClass(), this.getSymbolTable(), strIdentifier, type, null);
        modifiers.addAll(symbol.getModifierInfo());
        symbol.setModifierInfo(modifiers);
        delegateStmt.setSymbol((ISymbol)symbol);
        this.getSymbolTable().putSymbol((ISymbol)symbol);
        this.pushStatement(delegateStmt);
        return delegateStmt;
    }

    private void setStatic(boolean bStatic, DynamicPropertySymbol dpsVarProperty) {
        dpsVarProperty.setStatic(bStatic);
        if (dpsVarProperty.getSetterDfs() != null) {
            dpsVarProperty.getSetterDfs().setStatic(bStatic);
        }
        if (dpsVarProperty.getGetterDfs() != null) {
            dpsVarProperty.getGetterDfs().setStatic(bStatic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean parseClassStatement() {
        IGosuClassInternal gsClass = this.getGosuClass();
        this.ensureAbstractMethodsImpledAndNoDiamonds(gsClass);
        this.ensureInheritedMethodsDoNotClash(gsClass);
        this.getSymbolTable().pushScope();
        try {
            this.verify((ParsedElement)this.getClassStatement(), gsClass instanceof IGosuProgram || this.match(null, 123), Res.MSG_EXPECTING_OPEN_BRACE_FOR_CLASS_DEF, new String[0]);
            Statement currentStmt = this.isTopLevelClass(gsClass) || TypeLord.isEvalProgram((IType)gsClass) ? null : this.peekStatement();
            this.parseClassMembers(gsClass);
            Statement stmt = this.peekStatement();
            while (stmt != currentStmt) {
                stmt = this.popStatement();
                if (!(stmt instanceof VarStatement || stmt instanceof FunctionStatement || stmt instanceof PropertyStatement || stmt instanceof NoOpStatement || stmt instanceof NamespaceStatement || stmt instanceof UsesStatement || stmt instanceof ClassStatement)) {
                    throw new IllegalStateException("Expecting only statements for: package, uses, var, function, or property.");
                }
                stmt = this.peekStatement();
            }
            this.verify((ParsedElement)this.getClassStatement(), this.match(null, 125) || gsClass instanceof IGosuProgram, Res.MSG_EXPECTING_CLOSE_BRACE_FOR_CLASS_DEF, new String[0]);
        }
        finally {
            this.getSymbolTable().popScope();
        }
        return true;
    }

    private void ensureInheritedMethodsDoNotClash(IGosuClassInternal gsClass) {
        if (!this.inheritsFromTwoOrMoreTypes(gsClass)) {
            return;
        }
        MethodList methods = gsClass.getTypeInfo().getMethods((IType)gsClass);
        for (DynamicArray bucket : methods.getMethodBuckets()) {
            if (bucket.size() <= 1) continue;
            HashMap<String, IReducedDynamicFunctionSymbol> functionTypes = new HashMap<String, IReducedDynamicFunctionSymbol>();
            for (IMethodInfo mi : bucket) {
                IReducedDynamicFunctionSymbol dfs;
                if (!(mi instanceof IGosuMethodInfo)) continue;
                IReducedDynamicFunctionSymbol originalDfs = dfs = ((IGosuMethodInfo)mi).getDfs();
                while (true) {
                    IReducedDynamicFunctionSymbol superDfs;
                    if ((superDfs = dfs.getSuperDfs()) != null && superDfs != dfs) {
                        dfs = superDfs;
                        continue;
                    }
                    IReducedDynamicFunctionSymbol backingDfs = dfs.getBackingDfs();
                    if (backingDfs == null || backingDfs == dfs) break;
                    dfs = backingDfs;
                }
                if (dfs == originalDfs || dfs.getGosuClass() instanceof IGosuEnhancement) continue;
                FunctionType ft = ((FunctionType)dfs.getType()).getRuntimeType();
                String paramSignature = ft.getParamSignature();
                IReducedDynamicFunctionSymbol existingDfs = (IReducedDynamicFunctionSymbol)functionTypes.get(paramSignature);
                if (existingDfs != null && existingDfs.getGosuClass() != dfs.getGosuClass()) {
                    this.addError(this.getClassStatement(), Res.MSG_FUNCTION_CLASH_PARAMS, dfs.getName(), dfs.getGosuClass().getName(), existingDfs.getName(), existingDfs.getGosuClass().getName());
                }
                functionTypes.put(paramSignature, dfs);
            }
        }
    }

    private boolean inheritsFromTwoOrMoreTypes(IGosuClassInternal gsClass) {
        int iCount = gsClass.getSuperClass() == null ? 0 : 1;
        return (iCount += gsClass.getInterfaces().length - 1) > 1;
    }

    private void ensureAbstractMethodsImpledAndNoDiamonds(IGosuClassInternal gsClass) {
        List<IFunctionType> unimpled = gsClass.getUnimplementedMethods();
        Iterator<IFunctionType> iter = unimpled.iterator();
        while (iter.hasNext()) {
            IFunctionType funcType = iter.next();
            IMethodInfo mi = funcType.getMethodInfo();
            if (mi.isDefaultImpl()) {
                if (!this.conflictsWithUnrelatedIfaceMethod(gsClass, funcType, unimpled)) continue;
                iter.remove();
                continue;
            }
            if (gsClass.isInterface() || gsClass.isAbstract()) continue;
            String strClass = funcType.getEnclosingType().getName();
            strClass = IGosuClass.ProxyUtil.getNameSansProxy((String)strClass);
            this.getClassStatement().addParseException((IParseIssue)new NotImplementedParseException(this.makeFullParserState(), (IGosuClass)gsClass, strClass, funcType));
        }
    }

    private boolean conflictsWithUnrelatedIfaceMethod(IGosuClassInternal gsClass, IFunctionType ft, List<IFunctionType> unimpled) {
        IMethodInfo mi = ft.getMethodInfo();
        block0: for (IFunctionType funcType : unimpled) {
            IMethodInfo csrMi;
            if (ft == funcType || !(csrMi = funcType.getMethodInfo()).getDisplayName().equals(mi.getDisplayName()) || csrMi.getParameters().length != mi.getParameters().length || csrMi.getOwnersType().isAssignableFrom(mi.getOwnersType()) || mi.getOwnersType().isAssignableFrom(csrMi.getOwnersType())) continue;
            IParameterInfo[] csrParams = csrMi.getParameters();
            IParameterInfo[] params = mi.getParameters();
            for (int i = 0; i < csrParams.length; ++i) {
                IRType descriptor;
                IParameterInfo csrPi = csrParams[i];
                IParameterInfo pi = params[i];
                IRType csrDescriptor = IRTypeResolver.getDescriptor(csrPi.getFeatureType());
                if (!csrDescriptor.equals(descriptor = IRTypeResolver.getDescriptor(pi.getFeatureType()))) break block0;
            }
            if (csrMi.isDefaultImpl()) {
                this.getClassStatement().addParseException(this.makeFullParserState(), Res.MSG_INHERITS_UNRELATED_DEFAULTS, gsClass.getName(), funcType, mi.getOwnersType().getName(), csrMi.getOwnersType().getName());
            } else if (gsClass.isAbstract()) {
                this.getClassStatement().addParseException(this.makeFullParserState(), Res.MSG_INHERITS_ABSTRACT_AND_DEFAULT, gsClass.getName(), funcType, mi.getOwnersType().getName(), csrMi.getOwnersType().getName());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseClassMembers(IGosuClassInternal gsClass) {
        if (this.isInnerClass(gsClass) && !gsClass.isStatic()) {
            this.addOuterMember(gsClass);
        }
        ClassScopeCache scopeCache = this.makeClassScopeCache(gsClass);
        this.parseEnumConstants(gsClass, scopeCache);
        while (true) {
            ModifierInfo modifiers;
            this.getOwner().checkInstruction(true);
            while (this.match(null, 59)) {
                this.pushStatement(new NoOpStatement());
            }
            int iOffset = this.getTokenizer().getTokenStart();
            int iLineNum = this.getTokenizer().getLineNumber();
            int iColumn = this.getTokenizer().getTokenColumn();
            if (gsClass instanceof IGosuProgram) {
                int[] locations = new int[3];
                modifiers = this.parseUntilMemberKeyword(null, false, locations);
                iOffset = locations[0];
                iLineNum = locations[1];
                iColumn = locations[2];
            } else {
                this.pushClassSymbols(true, scopeCache);
                try {
                    modifiers = this.parseModifiers();
                }
                finally {
                    this.popClassSymbols();
                }
            }
            if (gsClass.isInterface()) {
                if (this.match(null, Keyword.KW_var, true)) {
                    modifiers.addModifiers(8);
                }
                modifiers.addModifiers(1);
            }
            boolean bStatic = Modifier.isStatic((int)modifiers.getModifiers());
            boolean bDeprecated = this.isDeprecated(modifiers);
            if (bDeprecated) {
                this.getOwner().pushIgnoreTypeDeprecation();
            }
            this.getOwner().pushParsingStaticMember(bStatic);
            try {
                boolean bConstructSyntax = false;
                Token T = new Token();
                if (this.match(null, Keyword.KW_function) || (bConstructSyntax = this.match(null, Keyword.KW_construct))) {
                    DynamicFunctionSymbol dfs;
                    FunctionStatement functionStmt;
                    if (bConstructSyntax || this.isOldStyleConstructor(gsClass, T)) {
                        functionStmt = this.parseBaseConstructorDefinition(bConstructSyntax, modifiers.getAnnotations(), scopeCache);
                        this.verifyModifiers(functionStmt, modifiers, UsageTarget.ConstructorTarget);
                    } else {
                        this.pushClassSymbols(bStatic, scopeCache);
                        try {
                            functionStmt = this.getOwner().parseBaseFunctionDefinition(null, false, false, modifiers);
                            if (gsClass.isInterface() && !bStatic) {
                                this.eatOptionalSemiColon(true);
                                this.pushStatement(functionStmt);
                            }
                            this.verifyModifiers(functionStmt, modifiers, UsageTarget.MethodTarget);
                        }
                        finally {
                            this.popClassSymbols();
                        }
                    }
                    DynamicFunctionSymbol dynamicFunctionSymbol = dfs = functionStmt == null ? null : functionStmt.getDynamicFunctionSymbol();
                    if (dfs != null) {
                        dfs.setClassMember(true);
                        if (dfs.getDisplayName().equals(gsClass.getRelativeName())) {
                            gsClass.getParseInfo().addConstructorFunction(dfs);
                        } else {
                            gsClass.getParseInfo().addMemberFunction(dfs);
                        }
                        this.verifyTypeVarVariance(Variance.COVARIANT, functionStmt, dfs.getType());
                    }
                    this.setLocation(iOffset, iLineNum, iColumn);
                    continue;
                }
                if (this.match(null, Keyword.KW_property)) {
                    this.pushClassSymbols(bStatic, scopeCache);
                    try {
                        Token t = new Token();
                        boolean bGetter = this.match(t, Keyword.KW_get);
                        boolean bSetter = !bGetter && this.match(null, Keyword.KW_set);
                        SourceCodeTokenizer tokenizer = this.getTokenizer();
                        int mark = tokenizer.mark();
                        if (this.match(null, -5)) {
                            this.eatPossibleParametarization(true);
                            if (!this.match(null, null, 40, true)) {
                                tokenizer.restoreToMark(mark);
                                VarStatement varStmt = this.parseNewPropertyDefn(gsClass, bStatic, scopeCache, bGetter, bSetter, modifiers);
                                this.setLocation(iOffset, iLineNum, iColumn);
                                this.removeInitializerIfInProgram(varStmt);
                                this.verifyModifiers(varStmt, modifiers, UsageTarget.PropertyTarget);
                                continue;
                            }
                            tokenizer.restoreToMark(mark);
                        }
                        if (!bGetter && !bSetter) {
                            this.getOwner().maybeEatNonDeclKeyword(false, t._strValue);
                        }
                        FunctionStatement functionStmt = this.getOwner().parseBaseFunctionDefinition(null, true, bGetter, modifiers);
                        this.verify((ParsedElement)functionStmt, bGetter || bSetter, Res.MSG_EXPECTING_PROPERTY_GET_OR_SET_MODIFIER, new String[0]);
                        this.setLocation(iOffset, iLineNum, iColumn);
                        this.getOwner().popStatement();
                        DynamicFunctionSymbol dfs = functionStmt.getDynamicFunctionSymbol();
                        if (dfs != null) {
                            IType returnType = functionStmt.getDynamicFunctionSymbol().getReturnType();
                            this.verify((ParsedElement)functionStmt, bGetter || returnType == JavaTypes.pVOID(), Res.MSG_PROPERTY_SET_MUST_RETURN_VOID, new String[0]);
                            if (bGetter && dfs.getArgTypes() != null && dfs.getArgTypes().length > 0) {
                                List<IParameterDeclaration> parameters = functionStmt.getParameters();
                                for (IParameterDeclaration par : parameters) {
                                    par.addParseException(Res.MSG_GETTER_CANNOT_HAVE_PARAMETERS, new Object[0]);
                                }
                            }
                            dfs.setClassMember(true);
                            DynamicPropertySymbol dps = this.getOrCreateDynamicPropertySymbol(functionStmt, gsClass, dfs, bGetter);
                            PropertyStatement stmt = new PropertyStatement(functionStmt, dps);
                            this.getOwner().pushStatement(stmt);
                            this.setLocation(iOffset, iLineNum, iColumn, true);
                            this.verifyPropertiesAreSymmetric(bGetter, dfs, dps, stmt);
                            dps.addMemberSymbols(gsClass);
                            if (bGetter) {
                                this.verifyTypeVarVariance(Variance.COVARIANT, functionStmt, dps.getGetterDfs().getReturnType());
                            } else if (dps.getSetterDfs().getArgTypes().length > 0) {
                                this.verifyTypeVarVariance(Variance.CONTRAVARIANT, functionStmt, dps.getSetterDfs().getArgTypes()[0]);
                            }
                        }
                        this.verifyModifiers(functionStmt, modifiers, UsageTarget.PropertyTarget);
                        continue;
                    }
                    finally {
                        this.popClassSymbols();
                        continue;
                    }
                }
                if (this.match(null, Keyword.KW_var)) {
                    VarStatement varStmt = this.parseFieldDefn(gsClass, bStatic, scopeCache, modifiers);
                    this.verifyTypeVarVariance(Variance.INVARIANT, varStmt, varStmt.getType());
                    this.setLocation(iOffset, iLineNum, iColumn);
                    this.removeInitializerIfInProgram(varStmt);
                    this.verifyModifiers(varStmt, modifiers, UsageTarget.PropertyTarget);
                    continue;
                }
                if (this.match(null, Keyword.KW_delegate)) {
                    DelegateStatement ds = this.parseDelegateDefn(gsClass, scopeCache, modifiers);
                    this.verifyModifiers(ds, modifiers, UsageTarget.PropertyTarget);
                    this.verifyTypeVarVariance(Variance.INVARIANT, ds, ds.getType());
                    this.setLocation(iOffset, iLineNum, iColumn);
                    continue;
                }
                if (this.match(T, Keyword.KW_class) || this.match(T, Keyword.KW_interface) || this.match(T, Keyword.KW_annotation) || this.match(T, Keyword.KW_structure) || this.match(T, Keyword.KW_enum)) {
                    this.getOwner().pushParsingStaticMember(false);
                    try {
                        this.popModifierList();
                        IGosuClassInternal inner = this.parseInnerClassDefinition(T);
                        if (inner == null) continue;
                        inner.setAnnotations(modifiers.getAnnotations());
                        if (inner.isInterface()) {
                            modifiers.setModifiers(Modifier.setStatic((int)modifiers.getModifiers(), (boolean)true));
                            ModifierInfo existingMI = (ModifierInfo)inner.getModifierInfo();
                            existingMI.addModifiers(modifiers.getModifiers());
                        }
                        this.verifyModifiers((IParsedElement)inner.getClassStatement(), modifiers, UsageTarget.TypeTarget);
                        continue;
                    }
                    finally {
                        this.getOwner().popParsingStaticMember();
                        continue;
                    }
                }
                this.popModifierList();
                if (this.match(null, null, 125, true) || this.match(null, -1)) break;
                boolean openBrace = false;
                if (this.match(null, 123)) {
                    openBrace = true;
                } else {
                    this.getOwner().getTokenizer().nextToken();
                }
                NoOpStatement noop = new NoOpStatement();
                this.verify((ParsedElement)noop, false, Res.MSG_UNEXPECTED_TOKEN, this.getOwner().getTokenizer().getTokenAsString());
                this.pushStatement(noop);
                this.setLocation(iOffset, iLineNum, iColumn);
                if (!openBrace) continue;
                this.eatBlock('{', '}', false);
                continue;
            }
            finally {
                if (bDeprecated) {
                    this.getOwner().popIgnoreTypeDeprecation();
                }
                this.getOwner().popParsingStaticMember();
                continue;
            }
            break;
        }
    }

    private boolean isDeprecated(ModifierInfo modifiers) {
        List<IGosuAnnotation> annotations = modifiers.getAnnotations();
        if (annotations != null) {
            for (IGosuAnnotation an : annotations) {
                if (!an.getName().equalsIgnoreCase("Deprecated")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isOldStyleConstructor(IGosuClassInternal gsClass, Token t) {
        return this.match(t, null, -5, true) && !gsClass.isInterface() && t._strValue.equals(gsClass.getRelativeName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassScopeCache makeClassScopeCache(IGosuClassInternal gsClass) {
        IScope nonstaticScope;
        Map<String, List<IFunctionSymbol>> nonstaticDfsMap;
        IScope staticScope;
        Map<String, List<IFunctionSymbol>> staticDfsMap;
        this.getSymbolTable().pushScope();
        try {
            this.getOwner().newDfsDeclInSetByName();
            gsClass.putClassMembers(this.getOwner(), this.getSymbolTable(), this.getGosuClass(), true);
            GosuClassParser.putTypeUsesMapFeatures(this.getOwner(), this.getSymbolTable(), this.getGosuClass());
            staticDfsMap = this.getOwner().getDfsDecls();
        }
        finally {
            staticScope = this.getSymbolTable().popScope();
        }
        this.getSymbolTable().pushScope();
        try {
            this.getOwner().newDfsDeclInSetByName();
            gsClass.putClassMembers(this.getOwner(), this.getSymbolTable(), this.getGosuClass(), false);
            GosuClassParser.putTypeUsesMapFeatures(this.getOwner(), this.getSymbolTable(), this.getGosuClass());
            nonstaticDfsMap = this.getOwner().getDfsDecls();
            this.getOwner().newDfsDeclInSetByName();
        }
        finally {
            nonstaticScope = this.getSymbolTable().popScope();
        }
        return new ClassScopeCache(staticScope, staticDfsMap, nonstaticScope, nonstaticDfsMap);
    }

    static void putTypeUsesMapFeatures(GosuParser owner, ISymbolTable table, IGosuClassInternal gsContextClass) {
        ITypeUsesMap typeUsesMap = owner.getTypeUsesMap();
        for (String name : typeUsesMap.getFeatureSpaces()) {
            IGosuClassInternal gsClass;
            IType type = TypeSystem.getByFullNameIfValid((String)name);
            if (type == null || (gsClass = IGosuClassInternal.Util.getGosuClassFrom(type)) == null) continue;
            gsClass.putClassMembers(gsClass.getTypeLoader(), owner, table, gsContextClass, true, true);
        }
        for (IFeatureInfo fi : typeUsesMap.getFeatureLiterals()) {
            DynamicPropertySymbol dps;
            IGosuClassInternal gsClass = (IGosuClassInternal)fi.getOwnersType();
            if (gsClass == null) continue;
            if (fi instanceof IMethodInfo) {
                List<IFunctionSymbol> existing;
                IFunctionStatement stmt = gsClass.getFunctionStatement((IMethodInfo)fi);
                DynamicFunctionSymbol dfs = (DynamicFunctionSymbol)stmt.getDynamicFunctionSymbol();
                if (gsClass.isParameterizedType()) {
                    dfs = dfs.getParameterizedVersion(gsClass);
                }
                table.putSymbol((ISymbol)dfs);
                if (owner == null || (existing = owner.getDfsDeclsForFunction(dfs.getDisplayName())) != null && existing.contains(dfs)) continue;
                owner.putDfsDeclInSetByName(dfs);
                continue;
            }
            if (!(fi instanceof IPropertyInfo)) continue;
            DynamicPropertySymbol dynamicPropertySymbol = dps = fi instanceof GosuVarPropertyInfo ? gsClass.getStaticField(fi.getName()).getSymbol() : gsClass.getStaticProperty(fi.getName());
            if (dps instanceof DynamicPropertySymbol && gsClass.isParameterizedType()) {
                dps = dps.getParameterizedVersion(gsClass);
            }
            if (table.getSymbol((CharSequence)dps.getName()) != null) continue;
            table.putSymbol((ISymbol)dps);
        }
    }

    private void popClassSymbols() {
        this.getSymbolTable().popScope();
        this.getOwner().popParsingStaticMember();
        this.getOwner().newDfsDeclInSetByName();
    }

    private void pushClassSymbols(boolean bStatic, ClassScopeCache classScopeCache) {
        this.getOwner().setDfsDeclInSetByName(bStatic ? classScopeCache.getStaticDfsMap() : classScopeCache.getNonstaticDfsMap());
        this.getSymbolTable().pushScope(bStatic ? classScopeCache.getStaticScope() : classScopeCache.getNonstaticScope());
        this.getOwner().pushParsingStaticMember(bStatic);
    }

    private void removeInitializerIfInProgram(VarStatement varStmt) {
        if (!(this.getGosuClass() instanceof IGosuProgram) || this.getOwner().isEditorParser()) {
            return;
        }
        ParseTree location = varStmt.getLocation();
        List<IParseTree> children = location.getChildren();
        int iChildCount = children.size();
        if (iChildCount > 3) {
            if (iChildCount > 4 && !(children.get(3).getParsedElement() instanceof NameInDeclaration)) {
                throw new IllegalStateException("Expecting children: 1 for NameInDeclaration, 1 for the type, (maybe another NameInDeclaration if an alias property declared), and 1 for the initializer");
            }
            IParseTree initializerExpr = children.get(iChildCount - 1);
            if (initializerExpr != null) {
                location.removeChild(initializerExpr);
            }
        }
    }

    private IGosuClassInternal parseInnerClassDefinition(Token t) {
        IGosuClassInternal enclosingGsClass = this.getClassStatement().getGosuClass();
        this.verify((ParsedElement)this.getClassStatement(), this.match(t, -5), Res.MSG_EXPECTING_NAME_CLASS_DEF, new String[0]);
        String strInnerClass = t._strValue;
        if (strInnerClass != null) {
            for (IGosuClass c : enclosingGsClass.getKnownInnerClassesWithoutCompiling().values()) {
                IGosuClassInternal innerClass = (IGosuClassInternal)c;
                if (!innerClass.getRelativeName().equals(strInnerClass)) continue;
                int i = 0;
                String relativeName = innerClass.getName();
                while (innerClass.isDefinitionsCompiled()) {
                    String duplicate = relativeName + "_duplicate_" + i++;
                    innerClass = (IGosuClassInternal)TypeSystem.getByFullNameIfValid((String)duplicate);
                    if (innerClass != null) continue;
                    return null;
                }
                new GosuClassParser(this.getOwner(), innerClass).parseDefinitions(innerClass);
                return innerClass;
            }
        }
        return null;
    }

    private void parseEnumConstants(IGosuClassInternal gsClass, ClassScopeCache scopeCache) {
        boolean bConst;
        boolean bEnum;
        boolean bl = bEnum = gsClass != null && gsClass.isEnum();
        if (!bEnum) {
            return;
        }
        HashSet<String> constants = new HashSet<String>();
        Token t = new Token();
        do {
            bConst = false;
            int iOffset = this.getTokenizer().getTokenStart();
            int iLineNum = this.getTokenizer().getLineNumber();
            int iColumn = this.getTokenizer().getTokenColumn();
            if (!this.match(t, null, -5, true) || Keyword.isKeyword((String)t._strValue) || !this.match(t, -5)) continue;
            this.parseEnumConstant(t._strValue, scopeCache, constants.contains(t._strValue));
            this.setLocation(iOffset, iLineNum, iColumn);
            constants.add(t._strValue);
            this.popStatement();
            bConst = true;
        } while (!this.match(null, 59) && bConst && this.match(null, 44));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseEnumConstant(String strIdentifier, ClassScopeCache scopeCache, boolean bIsDuplicate) {
        IGosuClassInternal gsClass = this.getGosuClass();
        VarStatement varStmt = gsClass.getStaticField(strIdentifier);
        if (bIsDuplicate) {
            VarStatement dup = new VarStatement();
            dup.setSymbol(varStmt.getSymbol());
            dup.setModifierInfo(varStmt.getModifierInfo());
            dup.setParent(varStmt.getParent());
            varStmt = dup;
        }
        this.pushClassSymbols(true, scopeCache);
        try {
            this.getOwner().parseNewExpressionOrAnnotation((IType)gsClass, false, !this.match(null, null, 40, true), null, -1);
            Expression asExpr = this.popExpression();
            varStmt.setAsExpression(asExpr);
            if (asExpr.hasParseExceptions()) {
                for (IParseIssue pe : asExpr.getParseExceptions()) {
                    varStmt.addParseException(pe);
                    asExpr.removeParseException(pe.getMessageKey());
                }
            }
            varStmt.setScriptPart(this.getOwner().getScriptPart());
            this.pushStatement(varStmt);
            ISymbol symbol = varStmt.getSymbol();
            symbol.setType((IType)gsClass);
            varStmt.setType((IType)gsClass);
            varStmt.setEnumConstant(true);
            varStmt.setDefinitionParsed(true);
            scopeCache.getNonstaticScope().put((Object)varStmt.getSymbol().getName(), varStmt.getSymbol());
            gsClass.getParseInfo().addMemberField(varStmt);
        }
        finally {
            this.popClassSymbols();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VarStatement parseFieldDefn(IGosuClassInternal gsClass, boolean bStatic, ClassScopeCache scopeCache, ModifierInfo modifiers) {
        VarStatement varStmt;
        boolean bOuterLocalDefined;
        if (gsClass.isInterface()) {
            bStatic = true;
        }
        Token t = new Token();
        String strIdentifier = "";
        boolean bHasName = this.match(t, -5);
        if (bHasName) {
            strIdentifier = t._strValue;
        } else {
            t._strValue = null;
        }
        this.getOwner().maybeEatNonDeclKeyword(bHasName, strIdentifier);
        boolean bl = bOuterLocalDefined = this.findLocalInOuters(strIdentifier) != null;
        if (!bStatic) {
            varStmt = this.findMemberField(gsClass, strIdentifier);
            if (varStmt == null && (varStmt = this.findStaticMemberField(gsClass, strIdentifier)) != null) {
                bStatic = true;
            }
        } else {
            varStmt = this.findStaticMemberField(gsClass, strIdentifier);
        }
        this.verifyOrWarn(varStmt, varStmt == null || !bOuterLocalDefined, false, Res.MSG_VARIABLE_ALREADY_DEFINED, strIdentifier);
        if (!bStatic && varStmt != null && varStmt.isStatic()) {
            bStatic = true;
        }
        this.pushClassSymbols(bStatic, scopeCache);
        try {
            DynamicPropertySymbol dps;
            if (varStmt == null) {
                varStmt = new VarStatement();
                this.getOwner().parseVarStatement(varStmt, t, false);
            } else {
                this.getOwner().parseVarStatement(varStmt, t, true);
            }
            if (bStatic) {
                scopeCache.getNonstaticScope().put((Object)varStmt.getSymbol().getName(), varStmt.getSymbol());
            }
            if ((dps = this.getOwner().parseVarPropertyClause(varStmt, modifiers, varStmt.getIdentifierName(), varStmt.getType(), true)) != null) {
                this.verifyPropertiesAreSymmetric(true, dps.getGetterDfs(), dps, varStmt);
                this.setStatic(bStatic, dps);
                dps.addMemberSymbols(gsClass);
            }
            this.match(null, 59);
            this.updateAnnotationExpressions(varStmt, modifiers.getAnnotations());
            gsClass.getParseInfo().addMemberField(varStmt);
            VarStatement varStatement = varStmt;
            return varStatement;
        }
        finally {
            this.popClassSymbols();
        }
    }

    private void updateAnnotationExpressions(VarStatement varStmt, List<IGosuAnnotation> defnAnnotations) {
        List<IGosuAnnotation> declAnnotations = varStmt.getDeclAnnotations();
        if (declAnnotations == null) {
            return;
        }
        int declAnnotationsSize = declAnnotations.size();
        for (int i = 0; i < declAnnotationsSize; ++i) {
            if (defnAnnotations.size() <= i) continue;
            IGosuAnnotation decl = declAnnotations.get(i);
            IGosuAnnotation defn = defnAnnotations.get(i);
            if (!(defn instanceof GosuAnnotation)) continue;
            ((GosuAnnotation)decl).setExpression((Expression)defn.getExpression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VarStatement parseNewPropertyDefn(IGosuClassInternal gsClass, boolean bStatic, ClassScopeCache scopeCache, boolean bGetter, boolean bSetter, ModifierInfo modifiers) {
        VarStatement varStmt;
        boolean bOuterLocalDefined;
        if (!bGetter && !bSetter) {
            bSetter = true;
            bGetter = true;
        }
        Token t = new Token();
        String strProperty = "";
        String strVariable = "";
        boolean bHasName = this.match(t, -5);
        if (bHasName) {
            strProperty = t._strValue;
            strVariable = "_" + strProperty;
        } else {
            t._strValue = null;
        }
        this.getOwner().maybeEatNonDeclKeyword(bHasName, strVariable);
        boolean bl = bOuterLocalDefined = this.findLocalInOuters(strVariable) != null;
        if (!bStatic) {
            varStmt = this.findMemberField(gsClass, strVariable);
            if (varStmt == null && (varStmt = this.findStaticMemberField(gsClass, strVariable)) != null) {
                bStatic = true;
            }
        } else {
            varStmt = this.findStaticMemberField(gsClass, strVariable);
        }
        this.verifyOrWarn(varStmt, varStmt == null || !bOuterLocalDefined, false, Res.MSG_VARIABLE_ALREADY_DEFINED, strVariable);
        if (!bStatic && varStmt != null && varStmt.isStatic()) {
            bStatic = true;
        }
        this.pushClassSymbols(bStatic, scopeCache);
        try {
            DynamicPropertySymbol dps;
            if (varStmt == null) {
                varStmt = new VarStatement();
                this.getOwner().parseVarStatement(varStmt, t, false);
            } else {
                this.getOwner().parseVarStatement(varStmt, t, true);
            }
            if (bStatic) {
                scopeCache.getNonstaticScope().put((Object)varStmt.getSymbol().getName(), varStmt.getSymbol());
            }
            if ((dps = this.getOwner().makeProperties(varStmt, varStmt.getIdentifierName(), strProperty, varStmt.getType(), modifiers, bGetter, bSetter)) != null) {
                this.verifyPropertiesAreSymmetric(true, dps.getGetterDfs(), dps, varStmt);
                this.setStatic(bStatic, dps);
                dps.addMemberSymbols(gsClass);
                dps.getModifierInfo().setAnnotations(modifiers.getAnnotations());
                this.verifyTypeVarVariance(varStmt, dps);
                this.verify((ParsedElement)varStmt, !varStmt.getHasInitializer() || !dps.isAbstract(), Res.MSG_INITIALIZER_NOT_ALLOWED_ABSTRACT_PROPERTY, new String[0]);
            }
            this.updateAnnotationExpressions(varStmt, modifiers.getAnnotations());
            this.match(null, 59);
            gsClass.getParseInfo().addMemberField(varStmt);
            VarStatement varStatement = varStmt;
            return varStatement;
        }
        finally {
            this.popClassSymbols();
        }
    }

    private void verifyTypeVarVariance(VarStatement varStmt, DynamicPropertySymbol dps) {
        boolean bSet;
        if (!this.getGosuClass().isGenericType()) {
            return;
        }
        boolean bGet = dps.getGetterDfs() != null;
        boolean bl = bSet = dps.getSetterDfs().getArgTypes().length > 0;
        if (bGet && bSet) {
            this.verifyTypeVarVariance(Variance.INVARIANT, varStmt, dps.getGetterDfs().getReturnType());
        } else if (bGet) {
            this.verifyTypeVarVariance(Variance.COVARIANT, varStmt, dps.getGetterDfs().getReturnType());
        } else if (bSet) {
            this.verifyTypeVarVariance(Variance.CONTRAVARIANT, varStmt, dps.getSetterDfs().getArgTypes()[0]);
        }
    }

    private ISymbol findLocalInOuters(String strIdentifier) {
        if ((this.isParsingBlock() || this.getParsingAnonymousClass() != null) && !this.getOwner().isParsingAnnotation()) {
            return this.captureSymbol(this.getCurrentEnclosingGosuClass(), strIdentifier, null);
        }
        return null;
    }

    private VarStatement findMemberField(IGosuClassInternal gsClass, String name) {
        gsClass.compileDeclarationsIfNeeded();
        return this.assignPossibleDuplicateField(name, gsClass.getParseInfo().getMemberFields());
    }

    private VarStatement findStaticMemberField(IGosuClassInternal gsClass, String name) {
        gsClass.compileDeclarationsIfNeeded();
        return this.assignPossibleDuplicateField(name, gsClass.getParseInfo().getStaticFields());
    }

    private VarStatement assignPossibleDuplicateField(String name, Map<String, VarStatement> fields) {
        VarStatement varStmt = fields.get(name);
        varStmt = this.assignPossibleDuplicateField(name, varStmt, fields);
        return varStmt;
    }

    VarStatement assignPossibleDuplicateField(String name, VarStatement varStmt, Map<String, VarStatement> map) {
        VarStatement result = varStmt;
        if (varStmt == null || varStmt.isDefinitionParsed()) {
            int iMin = Integer.MAX_VALUE;
            for (String nameCsr : map.keySet()) {
                int iIndex;
                VarStatement stmtCsr;
                String strName = nameCsr.toString();
                if (!strName.toLowerCase().contains("_duplicate_" + name.toString().toLowerCase()) || (stmtCsr = map.get(nameCsr)).isDefinitionParsed() || (iIndex = Integer.parseInt(strName.substring(0, strName.indexOf(95)))) >= iMin) continue;
                iMin = iIndex;
                result = stmtCsr;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DelegateStatement parseDelegateDefn(IGosuClassInternal gsClass, ClassScopeCache scopeCache, ModifierInfo modifiers) {
        Token t = new Token();
        int iNameOffset = this.getTokenizer().getTokenStart();
        boolean bHasName = this.match(t, -5);
        String strIdentifier = t._strValue == null ? "" : t._strValue;
        this.getOwner().maybeEatNonDeclKeyword(bHasName, strIdentifier);
        String insensitveIdentifier = strIdentifier;
        VarStatement varStmt = gsClass.getMemberField(insensitveIdentifier);
        if (varStmt != null) {
            varStmt.setNameOffset(iNameOffset, strIdentifier);
        }
        this.pushClassSymbols(false, scopeCache);
        try {
            DelegateStatement delStmt;
            if (varStmt instanceof DelegateStatement) {
                delStmt = (DelegateStatement)varStmt;
            } else {
                delStmt = new DelegateStatement();
                delStmt.setModifierInfo(modifiers);
            }
            if (varStmt == null) {
                varStmt = new DelegateStatement();
                varStmt.setModifierInfo(modifiers);
                varStmt.setSymbol((ISymbol)new Symbol(strIdentifier, (IType)JavaTypes.OBJECT(), null));
                this.verify((ParsedElement)delStmt, !Modifier.isStatic((int)modifiers.getModifiers()), Res.MSG_DELEGATES_CANNOT_BE_STATIC, new String[0]);
                this.getOwner().parseDelegateStatement(delStmt, strIdentifier);
            } else {
                this.getOwner().parseDelegateStatement(delStmt, strIdentifier);
            }
            gsClass.getParseInfo().addMemberField(varStmt);
            DelegateStatement delegateStatement = delStmt;
            return delegateStatement;
        }
        finally {
            this.popClassSymbols();
        }
    }

    DynamicPropertySymbol getOrCreateDynamicPropertySymbol(ParsedElement parsedElement, ICompilableTypeInternal gsClass, DynamicFunctionSymbol dfs, boolean bGetter) {
        String strPropertyName = dfs.getDisplayName().substring(1);
        ISymbol symbol = this.getSymbolTable().getSymbol((CharSequence)strPropertyName);
        if (symbol != null && !dfs.getDisplayName().contains(symbol.getDisplayName())) {
            symbol = null;
        }
        if (!(gsClass instanceof IGosuClass && ((IGosuClass)gsClass).isCompilingDefinitions() || this.verify(parsedElement, symbol == null || symbol instanceof DynamicPropertySymbol, Res.MSG_VARIABLE_ALREADY_DEFINED, strPropertyName))) {
            return new DynamicPropertySymbol(dfs, bGetter);
        }
        if (symbol == null || gsClass != null && gsClass.getMemberProperty(strPropertyName) == null && gsClass.getStaticProperty(strPropertyName) == null) {
            DynamicPropertySymbol dps = new DynamicPropertySymbol(dfs, bGetter);
            dps.setClassMember(true);
            if (symbol != null) {
                assert (symbol instanceof DynamicPropertySymbol);
                dps.setParent((DynamicPropertySymbol)symbol);
            }
            return dps;
        }
        if (!(symbol instanceof DynamicPropertySymbol)) {
            return new DynamicPropertySymbol(dfs, bGetter);
        }
        assert (symbol instanceof DynamicPropertySymbol);
        DynamicPropertySymbol dps = (DynamicPropertySymbol)symbol;
        if (bGetter) {
            this.verify(parsedElement, strPropertyName.equals(Keyword.KW_outer.getName()) || dps.getImmediateGetterDfs() == null || dps.getImmediateGetterDfs() instanceof VarPropertyGetFunctionSymbol || dps.getImmediateGetterDfs().getValueDirectly() != null || dps.getImmediateGetterDfs() == dfs || dps.getImmediateGetterDfs().isAbstract() && !dfs.isAbstract() || gsClass != null && gsClass.isInterface(), Res.MSG_GETTER_FOR_PROPERTY_ALREADY_DEFINED, strPropertyName);
            if (parsedElement.hasParseException(Res.MSG_FUNCTION_ALREADY_DEFINED) && parsedElement.hasParseException(Res.MSG_GETTER_FOR_PROPERTY_ALREADY_DEFINED)) {
                parsedElement.removeParseException(Res.MSG_FUNCTION_ALREADY_DEFINED);
            }
            dps.setGetterDfs(dfs);
        } else {
            this.verify(parsedElement, dps.getImmediateSetterDfs() == null || dps.getImmediateSetterDfs() instanceof VarPropertySetFunctionSymbol || dps.getImmediateSetterDfs().getValueDirectly() != null || dps.getImmediateSetterDfs() == dfs || dps.getImmediateSetterDfs().isAbstract() && !dfs.isAbstract() || gsClass != null && gsClass.isInterface(), Res.MSG_SETTER_FOR_PROPERTY_ALREADY_DEFINED, strPropertyName);
            if (parsedElement.hasParseException(Res.MSG_FUNCTION_ALREADY_DEFINED) && parsedElement.hasParseException(Res.MSG_SETTER_FOR_PROPERTY_ALREADY_DEFINED)) {
                parsedElement.removeParseException(Res.MSG_FUNCTION_ALREADY_DEFINED);
            }
            dps.setSetterDfs(dfs);
        }
        return dps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FunctionStatement parseBaseConstructorDefinition(boolean bConstructor, List<IGosuAnnotation> defnAnnotations, ClassScopeCache scopeCache) {
        IGosuClassInternal gsClass = this.getGosuClass();
        Token T = new Token();
        this.getSymbolTable().pushScope();
        try {
            IType[] argTypes;
            List<ISymbol> args;
            String strFunctionName;
            if (bConstructor) {
                strFunctionName = gsClass.getRelativeName();
            } else {
                this.match(T, -5);
                strFunctionName = T._strValue;
            }
            this.match(null, 40);
            ConstructorStatement functionStmt = new ConstructorStatement(bConstructor);
            int iOffsetParamList = this.getTokenizer().getTokenStart();
            int iColumnParamList = this.getTokenizer().getTokenColumn();
            int iLineParamList = this.getTokenizer().getLineNumber();
            if (!this.match(null, null, 41, true)) {
                this.pushClassSymbols(false, scopeCache);
                try {
                    args = this.getOwner().parseParameterDeclarationList(functionStmt, false, null);
                }
                finally {
                    this.popClassSymbols();
                }
                argTypes = new IType[args.size()];
                for (int i = 0; i < args.size(); ++i) {
                    this.getSymbolTable().putSymbol((ISymbol)args.get(i));
                    argTypes[i] = ((ISymbol)args.get(i)).getType();
                }
            } else {
                argTypes = IType.EMPTY_ARRAY;
                args = Collections.emptyList();
                this.pushExpression(new ParameterListClause());
                this.setLocation(iOffsetParamList, iLineParamList, iColumnParamList, this.getTokenizer().getTokenStart() <= iOffsetParamList, true);
                this.popExpression();
            }
            this.match(null, 41);
            if (this.match(null, ":", -6)) {
                this.getOwner().parseTypeLiteral();
                Expression expression = this.popExpression();
                this.verify((ParsedElement)expression, false, Res.MSG_NO_TYPE_AFTER_CONSTRUCTOR, new String[0]);
            }
            int iOffset = this.getOwner().getTokenizer().getTokenStart();
            int iLineNum = this.getOwner().getTokenizer().getLineNumber();
            int iColumn = this.getOwner().getTokenizer().getTokenColumn();
            FunctionType ft = new FunctionType(gsClass.getRelativeName(), (IType)gsClass, argTypes);
            ft.setScriptPart(this.getOwner().getScriptPart());
            this.getOwner().pushParsingFunction(ft);
            DynamicFunctionSymbol dfsDecl = this.findConstructorFunction(gsClass, DynamicFunctionSymbol.getSignatureName(strFunctionName, args));
            dfsDecl = dfsDecl == null || dfsDecl.getType() == GosuTypes.DEF_CTOR_TYPE() ? null : dfsDecl;
            functionStmt = dfsDecl == null ? functionStmt : dfsDecl.getDeclFunctionStmt();
            this.verify((ParsedElement)functionStmt, dfsDecl != null, Res.MSG_EXPECTING_NAME_FUNCTION_DEF, new String[0]);
            if (this.verify((ParsedElement)functionStmt, this.match(null, 123), Res.MSG_EXPECTING_OPEN_BRACE_FOR_CONSTRUCTOR_DEF, new String[0])) {
                Statement statement;
                MethodCallExpression e;
                boolean bSuperOrThisCall;
                IGosuClassInternal superClass = gsClass.getSuperClass();
                if (superClass != null) {
                    List declaredConstructors;
                    if (gsClass.isAnonymous() && this.verifyCallSiteCtorImpled(functionStmt, declaredConstructors = gsClass.getTypeInfo().getDeclaredConstructors())) {
                        this.verify((ParsedElement)functionStmt, declaredConstructors.size() <= 1, Res.MSG_SINGLE_ANON_CTOR, new String[0]);
                    }
                    if (gsClass.getSupertype().getGenericType() != JavaTypes.ENUM()) {
                        DynamicFunctionSymbol superDefaultConstructor = superClass.getDefaultConstructor();
                        this.verify((ParsedElement)functionStmt, this.match(T, Keyword.KW_super, true) || this.match(T, Keyword.KW_this, true) || superDefaultConstructor != null && superClass.isAccessible(this.getGosuClass(), superDefaultConstructor), Res.MSG_NO_DEFAULT_CTOR_IN, superClass.getName());
                    }
                } else if (gsClass.isAnonymous() && this.verify((ParsedElement)functionStmt, gsClass.getTypeInfo().getDeclaredConstructors().size() <= 1, Res.MSG_SINGLE_ANON_CTOR, new String[0])) {
                    this.verify((ParsedElement)functionStmt, argTypes.length == 0, Res.MSG_ANON_CTOR_PARAMS_CONFLICT_WITH_CALL_SITE, new String[0]);
                }
                boolean bMoreStatements = true;
                MethodCallStatement initializer = null;
                boolean bl = bSuperOrThisCall = (this.match(T, Keyword.KW_super, true) || this.match(T, Keyword.KW_this, true)) && this.getTokenizer().lookaheadType(1, true) == 40;
                if (bSuperOrThisCall) {
                    this.pushClassSymbols(true, scopeCache);
                    try {
                        this.putSuperAndThisConstructorSymbols();
                        bMoreStatements = this.getOwner().parseStatement();
                        initializer = (MethodCallStatement)this.popStatement();
                    }
                    finally {
                        this.popClassSymbols();
                    }
                } else if (superClass != null) {
                    e = new MethodCallExpression();
                    e.setParent(this.getClassStatement());
                    DynamicFunctionSymbol defaultSuperConstructor = gsClass.getSupertype().getGenericType() == JavaTypes.ENUM() ? superClass.getConstructorFunction("Enum(java.lang.String, int)") : superClass.getDefaultConstructor();
                    if (defaultSuperConstructor != null) {
                        e.setFunctionSymbol(new SuperConstructorFunctionSymbol(defaultSuperConstructor));
                        e.setArgs(null);
                        e.setType(GosuParserTypes.NULL_TYPE());
                        initializer = new MethodCallStatement();
                        initializer.setMethodCall(e);
                        e.setParent(initializer);
                        initializer.setParent(functionStmt);
                    }
                } else {
                    e = new MethodCallExpression();
                    e.setParent(this.getClassStatement());
                    e.setFunctionSymbol(new InitConstructorFunctionSymbol(this.getSymbolTable()));
                    e.setArgs(null);
                    e.setType(GosuParserTypes.NULL_TYPE());
                    initializer = new MethodCallStatement();
                    initializer.setMethodCall(e);
                    e.setParent(initializer);
                    initializer.setParent(functionStmt);
                }
                ArrayList<Statement> statements = new ArrayList<Statement>(8);
                if (bMoreStatements) {
                    this.pushClassSymbols(false, scopeCache);
                    this.getOwner().pushParsingAbstractConstructor(this.getClassStatement().getGosuClass().isAbstract());
                    this.getSymbolTable().pushScope();
                    try {
                        this.getSymbolTable().putSymbol((ISymbol)new Symbol(Keyword.KW_this.getName(), TypeLord.getConcreteType((IType)gsClass), (IStackProvider)this.getSymbolTable(), null));
                        this.getSymbolTable().putSymbol((ISymbol)new Symbol(Keyword.KW_super.getName(), (IType)(superClass == null ? IGosuClassInternal.Util.getGosuClassFrom((IType)JavaTypes.OBJECT()) : superClass), (IStackProvider)this.getSymbolTable(), null));
                        this.getOwner().parseStatementsAndDetectUnreachable(statements);
                    }
                    finally {
                        this.getSymbolTable().popScope();
                        this.getOwner().popParsingAbstractConstructor();
                        this.popClassSymbols();
                    }
                }
                this.verify((ParsedElement)functionStmt, this.match(null, 125), Res.MSG_EXPECTING_CLOSE_BRACE_FOR_CONSTRUCTOR_DEF, new String[0]);
                StatementList stmtList = new StatementList((IStackProvider)this.getSymbolTable());
                stmtList.setStatements(statements);
                Statement statement2 = statement = this.isDontOptimizeStatementLists() ? stmtList : stmtList.getSelfOrSingleStatement();
                if (statement == stmtList) {
                    this.pushStatement(statement);
                    this.setLocation(iOffset, iLineNum, iColumn);
                    this.popStatement();
                }
                if (dfsDecl != null) {
                    dfsDecl.setArgs(args);
                    dfsDecl.setValueDirectly(statement);
                    dfsDecl.setInitializer(initializer);
                    dfsDecl.getModifierInfo().setAnnotations(defnAnnotations);
                }
            } else {
                this.eatStatementBlock(functionStmt, Res.MSG_EXPECTING_OPEN_BRACE_FOR_FUNCTION_DEF);
                NotAStatement nas = new NotAStatement();
                this.pushStatement(nas);
                this.setLocation(iOffset, iLineNum, iColumn);
                this.popStatement();
                if (dfsDecl != null) {
                    dfsDecl.setArgs(args);
                    dfsDecl.setValueDirectly(nas);
                    dfsDecl.getModifierInfo().setAnnotations(defnAnnotations);
                }
            }
            this.getOwner().pushDynamicFunctionSymbol(dfsDecl);
            if (functionStmt != null) {
                functionStmt.setDynamicFunctionSymbol(dfsDecl);
                this.pushStatement(functionStmt);
            }
            ConstructorStatement constructorStatement = functionStmt;
            return constructorStatement;
        }
        finally {
            this.getSymbolTable().popScope();
            if (this.getOwner().isParsingFunction()) {
                this.getOwner().popParsingFunction();
            }
        }
    }

    private boolean verifyCallSiteCtorImpled(FunctionStatement functionStmt, List<? extends IConstructorInfo> declaredConstructors) {
        if (declaredConstructors.size() != 2) {
            return true;
        }
        for (IConstructorInfo iConstructorInfo : declaredConstructors) {
            if (!(iConstructorInfo instanceof GosuConstructorInfo) || this.verify((ParsedElement)functionStmt, !((GosuConstructorInfo)iConstructorInfo).getDfs().getType().getName().equals(GosuTypes.DEF_CTOR_TYPE().getName()), Res.MSG_ANON_CTOR_PARAMS_CONFLICT_WITH_CALL_SITE, new String[0])) continue;
            return false;
        }
        return true;
    }

    private DynamicFunctionSymbol findConstructorFunction(IGosuClassInternal gsClass, String signatureName) {
        gsClass.compileDeclarationsIfNeeded();
        DynamicFunctionSymbol dfs = gsClass.getParseInfo().getConstructorFunctions().get(signatureName);
        if (dfs != null && dfs.getValueDirectly() != null) {
            dfs = GosuParser.assignPossibleDuplicateDfs(dfs, gsClass.getParseInfo().getConstructorFunctions().values());
        }
        return dfs;
    }

    private void putSuperAndThisConstructorSymbols() {
        IGosuClassInternal thisClass = this.getGosuClass();
        IGosuClassInternal superClass = thisClass.getSuperClass();
        if (superClass != null) {
            for (DynamicFunctionSymbol dfs : superClass.getConstructorFunctions()) {
                if (!superClass.isAccessible(this.getGosuClass(), dfs)) continue;
                dfs = new SuperConstructorFunctionSymbol(superClass.isParameterizedType() ? dfs.getParameterizedVersion(superClass) : dfs);
                this.getSymbolTable().putSymbol((ISymbol)dfs);
                this.getOwner().putDfsDeclInSetByName(dfs);
            }
        }
        for (DynamicFunctionSymbol dfs : thisClass.getConstructorFunctions()) {
            dfs = new ThisConstructorFunctionSymbol(dfs);
            this.getSymbolTable().putSymbol((ISymbol)dfs);
            this.getOwner().putDfsDeclInSetByName(dfs);
        }
    }

    private boolean isCyclicInheritance(IType superType, IGosuClassInternal gsClass) {
        if (TypeLord.getPureGenericType(superType) == gsClass) {
            return true;
        }
        if (superType != null && superType instanceof IGosuClassInternal) {
            if (this.isCyclicInheritance((IType)((IGosuClassInternal)superType).getSuperClass(), gsClass)) {
                return true;
            }
            if (this.isCyclicInheritance((IType)((IGosuClassInternal)superType).getEnclosingType(), gsClass)) {
                return true;
            }
        }
        return superType instanceof IGosuClassInternal && this.isCyclicInterfaceInheritance((IGosuClassInternal)superType, gsClass);
    }

    private boolean isCyclicInterfaceInheritance(IGosuClassInternal gsExtendee, IGosuClass gsExtendor) {
        if (gsExtendee == gsExtendor) {
            return true;
        }
        IType[] interfaces = gsExtendee.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            IType type = interfaces[i];
            if (type instanceof ErrorType) {
                return false;
            }
            IGosuClassInternal gsClass = IGosuClassInternal.Util.getGosuClassFrom(type);
            if (!this.isCyclicInterfaceInheritance(gsClass, gsExtendor)) continue;
            return true;
        }
        return false;
    }

    @Override
    IGosuClassInternal getGosuClass() {
        return (IGosuClassInternal)super.getGosuClass();
    }

    public String toString() {
        IGosuClassInternal gosuClass = this.getGosuClass();
        return "Parsing Class: " + (gosuClass == null ? "null" : gosuClass.getName());
    }
}

