/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.ir.nodes.IRMethod;
import gw.internal.gosu.ir.nodes.IRPropertyFactory;
import gw.internal.gosu.ir.transform.AbstractElementTransformer;
import gw.internal.gosu.ir.transform.util.NameResolver;
import gw.internal.gosu.parser.DynamicPropertySymbol;
import gw.internal.gosu.parser.GenericTypeVariable;
import gw.internal.gosu.parser.GosuBaseAttributedFeatureInfo;
import gw.internal.gosu.parser.GosuClassTypeInfo;
import gw.internal.gosu.parser.GosuMethodInfo;
import gw.internal.gosu.parser.IGosuAnnotation;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.IGosuEnhancementInternal;
import gw.internal.gosu.parser.ReducedDynamicFunctionSymbol;
import gw.internal.gosu.parser.ReducedDynamicPropertySymbol;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRType;
import gw.lang.parser.EvaluationException;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.parser.exceptions.ErrantGosuClassException;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IMethodBackedPropertyInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IPresentationInfo;
import gw.lang.reflect.IPropertyAccessor;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.NotLazyTypeResolver;
import gw.lang.reflect.ReflectUtil;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuPropertyInfo;
import gw.util.GosuExceptionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class GosuPropertyInfo
extends GosuBaseAttributedFeatureInfo
implements IGosuPropertyInfo {
    private ReducedDynamicPropertySymbol _dps;
    private IType _type;
    private IPropertyAccessor _accessor;
    private boolean _bReadable;

    public GosuPropertyInfo(IFeatureInfo container, DynamicPropertySymbol dps) {
        super(container);
        this._dps = (ReducedDynamicPropertySymbol)dps.createReducedSymbol();
        this._bReadable = this._dps.isReadable();
        ((GosuClassTypeInfo)this.getOwnersType().getTypeInfo()).setModifierInfo(this, dps.getModifierInfo());
    }

    public String getName() {
        return this._dps.getName();
    }

    public String getDisplayName() {
        return this._dps.getDisplayName();
    }

    public String getShortDescription() {
        return this._dps.getDisplayName();
    }

    public String getDescription() {
        return this._dps.getFullDescription();
    }

    public boolean isStatic() {
        return this._dps.isStatic();
    }

    public boolean isPrivate() {
        return this._dps.isPrivate();
    }

    public boolean isInternal() {
        return this._dps.isInternal();
    }

    public boolean isProtected() {
        return this._dps.isProtected();
    }

    public boolean isPublic() {
        return this._dps.isPublic();
    }

    public boolean isAbstract() {
        return this._dps.isAbstract();
    }

    public boolean isFinal() {
        return this._dps.isFinal();
    }

    public boolean isGetterDefault() {
        return this.isDefault(this._dps.getGetterDfs());
    }

    public boolean isSetterDefault() {
        return this.isDefault(this._dps.getSetterDfs());
    }

    private boolean isDefault(ReducedDynamicFunctionSymbol dfs) {
        if (dfs == null) {
            return false;
        }
        return (dfs.getModifiers() & 0x409) == 1 && this.getOwnersType().isInterface();
    }

    @Override
    protected List<IGosuAnnotation> getGosuAnnotations() {
        return this._dps.getAnnotations();
    }

    public boolean isReadable() {
        return this.isReadable(null);
    }

    public boolean isReadable(IType whosAskin) {
        return this.isAccessible(whosAskin, this._dps.getGetterDfs());
    }

    public boolean isWritable() {
        return this.isWritable(null);
    }

    public boolean isWritable(IType whosAskin) {
        return this.isAccessible(whosAskin, this._dps.getSetterDfs());
    }

    public boolean isAccessible(IType whosAskin, ReducedDynamicFunctionSymbol accessor) {
        if (accessor != null) {
            IRelativeTypeInfo.Accessibility accessibilityForType = ((IRelativeTypeInfo)this.getContainer()).getAccessibilityForType(whosAskin);
            switch (accessibilityForType) {
                case PUBLIC: {
                    return accessor.isPublic();
                }
                case PROTECTED: {
                    return accessor.isPublic() || accessor.isProtected();
                }
                case INTERNAL: {
                    return accessor.isPublic() || accessor.isInternal() || accessor.isProtected();
                }
                case PRIVATE: {
                    return accessor.isPublic() || accessor.isInternal() || accessor.isProtected() || accessor.isPrivate();
                }
            }
        }
        return false;
    }

    public IPropertyAccessor getAccessor() {
        if (this._accessor == null) {
            IGosuClassInternal gsClass = this.getGosuClass();
            if (!gsClass.isValid()) {
                throw new ErrantGosuClassException((IGosuClass)gsClass);
            }
            this._accessor = this.getOwnersType().isStructure() ? new ReflectivePropertyAccessor() : new GosuPropertyAccessor();
        }
        return this._accessor;
    }

    public IPresentationInfo getPresentationInfo() {
        return IPresentationInfo.Default.GET;
    }

    IGosuClassInternal getGosuClass() {
        return this.getOwnersType();
    }

    public IType getFeatureType() {
        if (this._type == null) {
            this._type = this.getActualTypeInContainer((IFeatureInfo)this, this._dps.getType());
        }
        return this._type;
    }

    public ReducedDynamicPropertySymbol getDps() {
        return this._dps;
    }

    public IType getContainingType() {
        return this.getGosuClass();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GosuPropertyInfo that = (GosuPropertyInfo)((Object)o);
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public GenericTypeVariable[] getTypeVariables() {
        return GenericTypeVariable.EMPTY_TYPEVARS;
    }

    public IType getParameterizedReturnType(IType ... typeParams) {
        return null;
    }

    public IType[] getParameterizedParameterTypes(IType ... typeParams) {
        return IType.EMPTY_ARRAY;
    }

    public IType[] getParameterizedParameterTypes2(IType ownersType, IType ... typeParams) {
        return IType.EMPTY_ARRAY;
    }

    public TypeVarToTypeMap inferTypeParametersFromArgumentTypes(IType ... argTypes) {
        return null;
    }

    public TypeVarToTypeMap inferTypeParametersFromArgumentTypes2(IType owningParameterizedType, IType ... argTypes) {
        return null;
    }

    public IMethodInfo getReadMethodInfo() {
        ReducedDynamicFunctionSymbol getterDfs = this._dps.getGetterDfs();
        if (getterDfs != null) {
            return (IMethodInfo)getterDfs.getMethodOrConstructorInfo();
        }
        if (this.isReadable() && this._dps.getParent() instanceof IMethodBackedPropertyInfo) {
            return ((IMethodBackedPropertyInfo)this._dps.getParent()).getReadMethodInfo();
        }
        return null;
    }

    public IMethodInfo getWriteMethodInfo() {
        ReducedDynamicFunctionSymbol setterDfs = this._dps.getSetterDfs();
        if (setterDfs != null) {
            return (IMethodInfo)setterDfs.getMethodOrConstructorInfo();
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    private class ReflectivePropertyAccessor
    implements IPropertyAccessor {
        private ReflectivePropertyAccessor() {
        }

        public Object getValue(Object ctx) {
            return ReflectUtil.getProperty((Object)ctx, (String)GosuPropertyInfo.this.getName());
        }

        public void setValue(Object ctx, Object value) {
            ReflectUtil.setProperty((Object)ctx, (String)GosuPropertyInfo.this.getName(), (Object)value);
        }
    }

    private class GosuPropertyAccessor
    implements IPropertyAccessor {
        private GosuPropertyAccessor() {
        }

        public Object getValue(Object ctx) {
            String methodName = NameResolver.getGetterNameForDPS(GosuPropertyInfo.this._dps);
            try {
                Object[] args;
                if (AbstractElementTransformer.requiresImplicitEnhancementArg(GosuPropertyInfo.this._dps.getGetterDfs())) {
                    IGosuEnhancementInternal enhancement = (IGosuEnhancementInternal)GosuPropertyInfo.this._dps.getGetterDfs().getGosuClass();
                    ArrayList<Object> argList = new ArrayList<Object>();
                    argList.add(ctx);
                    if (enhancement.isParameterizedType()) {
                        IType[] parameters;
                        for (IType iType : parameters = enhancement.getTypeParameters()) {
                            argList.add(new NotLazyTypeResolver(iType));
                        }
                    } else {
                        IGenericTypeVariable[] typeVariables = enhancement.getGenericTypeVariables();
                        for (IType iType : typeVariables) {
                            argList.add(new NotLazyTypeResolver(iType.getBoundingType()));
                        }
                    }
                    args = argList.toArray(new Object[argList.size()]);
                } else {
                    args = new Object[]{};
                }
                IRMethod getterMethod = IRPropertyFactory.createIRProperty((IPropertyInfo)GosuPropertyInfo.this).getGetterMethod();
                List<IRType> allParameterTypes = getterMethod.getAllParameterTypes();
                Class[] paramClasses = new Class[allParameterTypes.size()];
                for (int i = 0; i < allParameterTypes.size(); ++i) {
                    paramClasses[i] = IRElement.maybeEraseStructuralType((IRType)allParameterTypes.get(i)).getJavaClass();
                }
                Method method = GosuMethodInfo.getMethod(GosuPropertyInfo.this.getOwnersType().getBackingClass(), methodName, paramClasses);
                return method.invoke(ctx, args);
            }
            catch (IllegalAccessException e) {
                throw GosuExceptionUtil.forceThrow((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw GosuExceptionUtil.forceThrow((Throwable)e.getTargetException());
            }
        }

        public void setValue(Object ctx, Object value) {
            if (!GosuPropertyInfo.this.isWritable((IType)GosuPropertyInfo.this.getOwnersType())) {
                throw new EvaluationException("Can't set value on read-only property: " + GosuPropertyInfo.this.getDisplayName());
            }
            String methodName = NameResolver.getSetterNameForDPS(GosuPropertyInfo.this._dps);
            try {
                Object[] args;
                if (AbstractElementTransformer.requiresImplicitEnhancementArg(GosuPropertyInfo.this._dps.getSetterDfs())) {
                    IGosuEnhancementInternal enhancement = (IGosuEnhancementInternal)GosuPropertyInfo.this._dps.getSetterDfs().getGosuClass();
                    ArrayList<Object> argList = new ArrayList<Object>();
                    argList.add(ctx);
                    if (enhancement.isParameterizedType()) {
                        IType[] parameters;
                        for (IType iType : parameters = enhancement.getTypeParameters()) {
                            argList.add(new NotLazyTypeResolver(iType));
                        }
                    } else {
                        IGenericTypeVariable[] typeVariables = enhancement.getGenericTypeVariables();
                        for (IType iType : typeVariables) {
                            argList.add(new NotLazyTypeResolver(iType.getBoundingType()));
                        }
                    }
                    argList.add(value);
                    args = argList.toArray(new Object[argList.size()]);
                } else {
                    args = new Object[]{value};
                }
                IRMethod setterMethod = IRPropertyFactory.createIRProperty((IPropertyInfo)GosuPropertyInfo.this).getSetterMethod();
                List<IRType> allParameterTypes = setterMethod.getAllParameterTypes();
                Class[] paramClasses = new Class[allParameterTypes.size()];
                for (int i = 0; i < allParameterTypes.size(); ++i) {
                    paramClasses[i] = IRElement.maybeEraseStructuralType((IRType)allParameterTypes.get(i)).getJavaClass();
                }
                Method method = GosuMethodInfo.getMethod(GosuPropertyInfo.this.getOwnersType().getBackingClass(), methodName, paramClasses);
                method.invoke(ctx, args);
            }
            catch (InvocationTargetException e) {
                throw GosuExceptionUtil.forceThrow((Throwable)e.getTargetException());
            }
            catch (IllegalAccessException e) {
                throw GosuExceptionUtil.forceThrow((Throwable)e);
            }
        }
    }
}

