/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.DocCommentBlock;
import gw.internal.gosu.parser.StringToken;
import gw.internal.gosu.parser.Token;
import gw.lang.parser.ITokenizerInstructor;
import gw.lang.parser.Keyword;
import gw.lang.parser.SourceCodeReader;
import gw.util.Stack;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class SourceCodeTokenizerInternal {
    protected static final int CT_WHITESPACE = 1;
    protected static final int CT_DIGIT = 2;
    protected static final int CT_ALPHA = 4;
    protected static final int CT_QUOTE = 8;
    protected static final int CT_COMMENT = 16;
    protected static final int CT_OPERATOR = 32;
    protected static final int CT_BITSHIFT_OPERATOR = 64;
    protected static final int CT_CHARQUOTE = 128;
    private static final Set<String> DEFAULT_OPERATORS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(SourceCodeTokenizerInternal.getDefaultOperators())));
    private static final Set<String> BITSHIFT_OPERATORS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(SourceCodeTokenizerInternal.getBitshiftOperators())));
    private SourceCodeReader _reader;
    int _peekc;
    private boolean _bForceLower;
    private boolean _bEOLIsSignificantP;
    private int[] _ctype;
    private Set<String> _operators;
    private int _iPos;
    private int _iLineNum;
    private int _iColumn;
    private int _iTokenStart;
    private int _iTokenColumn;
    private boolean _bWhitespaceSignificant;
    private boolean _bCommentsSignificant;
    public int _iType;
    public Keyword _keyword;
    public String _strValue;
    public int _iInvalidCharPos;
    public boolean _bUnterminatedString;
    public boolean _bUnterminatedComment;
    private ITokenizerInstructor _instructor;
    private DocCommentBlock _lastComment;
    private boolean _bParseDotsAsOperators;
    private int _iLineOffset;
    private Stack<Token> _tokens;
    private Token _eof;
    private boolean _supportsKeywords = true;

    SourceCodeTokenizerInternal(boolean initForCopy) {
        if (!initForCopy) {
            this._iLineOffset = -1;
            this._iLineNum = 1;
            this._bEOLIsSignificantP = false;
            this._ctype = new int[256];
            this._iType = -8;
            this._bParseDotsAsOperators = true;
            this._tokens = new Stack();
            this.wordChars(97, 122);
            this.wordChars(65, 90);
            this.wordChars(160, 255);
            this.wordChars(36, 36);
            this.whitespaceChars(0, 32);
            this.quoteChar(34);
            this.quoteChar(39);
            this.charQuoteChar(39);
            this.parseNumbers();
            this._operators = DEFAULT_OPERATORS;
            this.setOperatorChars(this._operators);
            this.setBitshiftOperatorChars(BITSHIFT_OPERATORS);
        }
    }

    public SourceCodeTokenizerInternal(CharSequence sourceCode) {
        this(new SourceCodeReader(sourceCode), null);
    }

    public SourceCodeTokenizerInternal(Reader reader) {
        this(SourceCodeReader.makeSourceCodeReader((Reader)reader), null);
    }

    public SourceCodeTokenizerInternal(SourceCodeReader reader) {
        this(reader, null);
    }

    public SourceCodeTokenizerInternal(SourceCodeReader reader, ITokenizerInstructor instructor) {
        this(false);
        this._reader = reader;
        this._instructor = instructor;
    }

    public Token copy() {
        throw new IllegalStateException("should not call this from internal");
    }

    public void reset() {
        this.reset(this._reader, true);
    }

    public void reset(Reader reader) {
        this.reset(SourceCodeReader.makeSourceCodeReader((Reader)reader), false);
    }

    public void reset(SourceCodeReader reader) {
        this.reset(reader, false);
    }

    void reset(SourceCodeReader reader, boolean bResetReader) {
        this._reader = reader;
        if (bResetReader && this._reader != null) {
            try {
                reader.setPosition(0);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this._peekc = 0;
        this._bForceLower = false;
        this._iType = -8;
        this._strValue = null;
        this._iInvalidCharPos = -1;
        this._iPos = 0;
        this._iLineNum = this._iLineOffset > -1 ? this._iLineOffset : 1;
        this._iColumn = 0;
        this._iTokenStart = 0;
        this._iTokenColumn = 0;
        this._bUnterminatedString = false;
        this._bUnterminatedComment = false;
        this._lastComment = null;
        this._tokens = new Stack();
        if (this._instructor != null) {
            this._instructor.reset();
        }
    }

    public SourceCodeReader getReader() {
        return this._reader;
    }

    public String getSource() {
        return this._reader == null ? "" : this._reader.getSource();
    }

    public ITokenizerInstructor getInstructor() {
        return this._instructor;
    }

    public void setInstructor(ITokenizerInstructor instructor) {
        if (this._instructor != instructor) {
            this.reset();
            this._instructor = instructor;
        }
    }

    public boolean isWhitespaceSignificant() {
        return this._bWhitespaceSignificant;
    }

    public void setWhitespaceSignificant(boolean bWhitespaceSignificant) {
        this._bWhitespaceSignificant = bWhitespaceSignificant;
    }

    public boolean isCommentsSignificant() {
        return this._bCommentsSignificant;
    }

    public void setCommentsSignificant(boolean bCommentsSignificant) {
        this._bCommentsSignificant = bCommentsSignificant;
    }

    public int getLineNumber() {
        return this._iLineNum;
    }

    public int getLineOffset() {
        return this._iLineOffset;
    }

    protected void incrementLineNumber() {
        this._iColumn = 0;
        ++this._iLineNum;
    }

    public int getTokenColumn() {
        return this._iTokenColumn;
    }

    public void wordChars(int iLow, int iHigh) {
        if (iLow < 0) {
            iLow = 0;
        }
        if (iHigh >= this._ctype.length) {
            iHigh = this._ctype.length - 1;
        }
        while (iLow <= iHigh) {
            int n = iLow++;
            this._ctype[n] = this._ctype[n] | 4;
        }
    }

    public void whitespaceChars(int iLow, int iHigh) {
        if (iLow < 0) {
            iLow = 0;
        }
        if (iHigh >= this._ctype.length) {
            iHigh = this._ctype.length - 1;
        }
        while (iLow <= iHigh) {
            this._ctype[iLow++] = 1;
        }
    }

    public void ordinaryChars(int iLow, int iHigh) {
        if (iLow < 0) {
            iLow = 0;
        }
        if (iHigh >= this._ctype.length) {
            iHigh = this._ctype.length - 1;
        }
        while (iLow <= iHigh) {
            this._ctype[iLow++] = 0;
        }
    }

    public void ordinaryChar(int ch) {
        if (ch >= 0 && ch < this._ctype.length) {
            this._ctype[ch] = 0;
        }
    }

    public static String[] getDefaultOperators() {
        return new String[]{"=", ">", "<", "!", "~", "?", ":", "?:", "==", "<=", "!=", "<>", "&&", "||", "++", "--", "===", "!==", "*.", "+", "-", "*", "/", "&", "|", "^", "%", "?+", "?-", "?*", "?/", "?%", "!+", "!-", "!*", "+=", "-=", "*=", "/=", "&=", "&&=", "|=", "||=", "^=", "%=", "\\", "->", ".", "?.", "?[", "..", "|..", "..|", "|..|", "#"};
    }

    public static List<String> getDefaultBindingOperators() {
        return Arrays.asList(":", "-", "/", "|", "\\", "#");
    }

    public static String[] getBitshiftOperators() {
        return new String[]{"<<", "<<="};
    }

    public void operators(String[] astrOperators) {
        if (astrOperators == null) {
            return;
        }
        for (String astrOperator : astrOperators) {
            if (astrOperator == null || astrOperator.length() == 0) continue;
            if (this._operators == null || this._operators == DEFAULT_OPERATORS) {
                this._operators = new HashSet<String>();
            }
            this._operators.add(astrOperator);
        }
        this.setOperatorChars(this._operators);
    }

    private void setOperatorChars(Set<String> operators) {
        for (String operator : operators) {
            char c = operator.charAt(0);
            this.operatorChars(c, c);
        }
    }

    public void operatorChars(int iLow, int iHigh) {
        if (iLow < 0) {
            iLow = 0;
        }
        if (iHigh >= this._ctype.length) {
            iHigh = this._ctype.length - 1;
        }
        while (iLow <= iHigh) {
            int n = iLow++;
            this._ctype[n] = this._ctype[n] | 0x20;
        }
    }

    private void setBitshiftOperatorChars(Set<String> operators) {
        for (String operator : operators) {
            char c = operator.charAt(0);
            this.bitshiftOperatorChars(c, c);
        }
    }

    public void bitshiftOperatorChars(int iLow, int iHigh) {
        if (iLow < 0) {
            iLow = 0;
        }
        if (iHigh >= this._ctype.length) {
            iHigh = this._ctype.length - 1;
        }
        while (iLow <= iHigh) {
            int n = iLow++;
            this._ctype[n] = this._ctype[n] | 0x40;
        }
    }

    public boolean isOperator(String strOperator) {
        return this._operators != null && this._operators.contains(strOperator) || BITSHIFT_OPERATORS.contains(strOperator);
    }

    public void commentChar(int ch) {
        if (ch >= 0 && ch < this._ctype.length) {
            this._ctype[ch] = 16;
        }
    }

    public void quoteChar(int ch) {
        if (ch >= 0 && ch < this._ctype.length) {
            this._ctype[ch] = 8;
        }
    }

    public void charQuoteChar(int ch) {
        if (ch >= 0 && ch < this._ctype.length) {
            this._ctype[ch] = 128;
        }
    }

    public void parseNumbers() {
        int i = 48;
        while (i <= 57) {
            int n = i++;
            this._ctype[n] = this._ctype[n] | 2;
        }
    }

    public void eolIsSignificant(boolean bFlag) {
        this._bEOLIsSignificantP = bFlag;
    }

    public void lowerCaseMode(boolean bLowerCaseMode) {
        this._bForceLower = bLowerCaseMode;
    }

    public boolean isUnterminatedString() {
        return this._bUnterminatedString;
    }

    public boolean isUnterminatedComment() {
        return this._bUnterminatedComment;
    }

    public void setParseDotsAsOperators(boolean parseDotsAsOperators) {
        this._bParseDotsAsOperators = parseDotsAsOperators;
    }

    public boolean isParseDotsAsOperators() {
        return this._bParseDotsAsOperators;
    }

    public DocCommentBlock popLastComment() {
        DocCommentBlock block = this._lastComment;
        this._lastComment = null;
        return block;
    }

    public int getTokenStart() {
        return this._iTokenStart - 1;
    }

    public int getTokenEnd() {
        return this._iPos - 1;
    }

    private int read() throws IOException {
        int c = this.readOne();
        if (this._instructor == null) {
            return c;
        }
        return this.readWithInstructions(c);
    }

    private int readOne() throws IOException {
        if (this._reader != null) {
            int iRet = this._reader.read();
            ++this._iPos;
            ++this._iColumn;
            return iRet;
        }
        throw new IllegalStateException();
    }

    protected int readWithInstructions(int c) throws IOException {
        this._instructor.getInstructionFor(c);
        return c;
    }

    private void pushWhitespaceToken(StringBuilder sbWhitespace) {
        if (sbWhitespace.length() == 0) {
            return;
        }
        int iSaveType = this._iType;
        String strValueSave = this._strValue;
        this._strValue = sbWhitespace.toString();
        this._iType = -2;
        this.pushToken();
        this._strValue = strValueSave;
        this._iType = iSaveType;
    }

    private void pushToken() {
        Token token;
        if (this._iType == -1) {
            this.initEofToken();
            return;
        }
        switch (this._iType) {
            case 34: 
            case 39: {
                token = new StringToken();
                break;
            }
            default: {
                token = new Token();
            }
        }
        this.pushToken(this.initToken(token));
    }

    private void initEofToken() {
        this._eof = this._eof == null ? this.initToken(new Token()) : this._eof;
    }

    Token initToken(Token token) {
        return token.init(this._iType, this._iInvalidCharPos, this.getTokenStart(), this.getTokenEnd(), this.getTokenColumn(), this.getLineNumber(), this.getLineOffset(), this.isUnterminatedString(), this._strValue, this._keyword, this.isAnalyzingSeparately(), this.isAnalyzingDirective(), this.getReader(), this.popLastComment());
    }

    private void pushToken(Token token) {
        if (this._iType == -1) {
            return;
        }
        if (this._tokens.size() == 0 || ((Token)((Object)this._tokens.peek())).getTokenEnd() < token.getTokenEnd()) {
            this._tokens.push((Object)token);
        }
    }

    public boolean isAnalyzingSeparately() {
        return this._instructor != null && this._instructor.isAnalyzingSeparately();
    }

    public boolean isAnalyzingDirective() {
        return this._instructor != null && this._instructor.isAnalyzingDirective();
    }

    public final Stack<Token> getTokens() {
        return this._tokens;
    }

    void rip() {
        if (this._iType == -1) {
            this.initEofToken();
            return;
        }
        while (true) {
            if (this._iType == -1) {
                this._eof = this.initToken(new Token());
                return;
            }
            try {
                this.nextToken();
            }
            catch (IOException e) {
                return;
            }
        }
    }

    public int nextToken() throws IOException {
        int token = this._nextTokenImpl();
        this.pushToken();
        return token;
    }

    private int _nextTokenImpl() throws IOException {
        int iCharType;
        int c;
        char[] _buf = new char[20];
        this._bUnterminatedComment = false;
        this._bUnterminatedString = false;
        this._iTokenStart = this._iPos;
        this._iTokenColumn = this._iColumn;
        int[] ct = this._ctype;
        this._strValue = null;
        this._keyword = null;
        this._iInvalidCharPos = -1;
        if (this._iType == -8) {
            c = this.read();
            if (c >= 0) {
                this._iType = c;
            }
        } else {
            c = this._peekc;
        }
        if (c < 0) {
            this._iType = -1;
            return -1;
        }
        if (this._iType == -1) {
            return this._iType;
        }
        this._iTokenStart = this._iPos;
        this._iTokenColumn = this._iColumn;
        int n = iCharType = c < 256 ? ct[c] : 4;
        if ((iCharType & 1) != 0 || this.isAtIgnorePos()) {
            StringBuilder sbWhitespace = new StringBuilder();
            while ((iCharType & 1) != 0 || this.isAtIgnorePos()) {
                if (c >= 0) {
                    sbWhitespace.append((char)c);
                }
                if (c == 13) {
                    c = this.read();
                    if (c == 10) {
                        if (c >= 0) {
                            sbWhitespace.append((char)c);
                        }
                        this.incrementLineNumber();
                        c = this.read();
                    }
                    if (this._bEOLIsSignificantP) {
                        this._peekc = c;
                        this._iType = 10;
                        return 10;
                    }
                } else {
                    if (c == 10) {
                        this.incrementLineNumber();
                        if (this._bEOLIsSignificantP) {
                            this._peekc = this.read();
                            this._iType = 10;
                            return 10;
                        }
                    }
                    c = this.read();
                }
                if (c < 0) {
                    this.pushWhitespaceToken(sbWhitespace);
                    this._peekc = c;
                    this._iType = -1;
                    return -1;
                }
                iCharType = c < 256 ? ct[c] : 4;
            }
            this.pushWhitespaceToken(sbWhitespace);
        }
        this._iTokenStart = this._iPos;
        this._iTokenColumn = this._iColumn;
        if ((iCharType & 2) != 0) {
            StringBuilder v = new StringBuilder();
            boolean hex = false;
            while (true) {
                if (48 <= c && c <= 57) {
                    v.append((char)c);
                } else if (!(hex || c != 98 && c != 66)) {
                    if (Character.isJavaIdentifierPart(this._reader.peek()) && Character.isJavaIdentifierPart(this._reader.peek(2)) && v.charAt(0) != '0') break;
                    v.append((char)c);
                    int next = this.read();
                    if (c == 98 && next == 100 || c == 66 && next == 68 || c == 98 && next == 105 || c == 66 && next == 73) {
                        v.append((char)next);
                        c = this.read();
                        break;
                    }
                    c = next;
                    if (v.length() != 2 || v.charAt(0) != '0' || 48 > c || c > 57) break;
                    v.append((char)c);
                } else if ((c == 120 || c == 88) && v.length() == 1 && v.charAt(0) == '0') {
                    hex = true;
                    v.append((char)c);
                } else if (hex && (65 <= c && c <= 70 || 97 <= c && c <= 102)) {
                    v.append((char)c);
                } else {
                    if (c != 108 && c != 76 && c != 102 && c != 70 && c != 100 && c != 68 && c != 114 && c != 82 || Character.isJavaIdentifierPart(this._reader.peek())) break;
                    v.append((char)c);
                    c = this.read();
                    break;
                }
                c = this.read();
            }
            this._peekc = c;
            this._strValue = v.toString();
            this._iType = -9;
            return this._iType;
        }
        if ((iCharType & 4) != 0) {
            int iStart = this._iPos - 1;
            do {
                int n2 = (c = this.read()) < 0 ? 1 : (iCharType = c < 256 ? ct[c] : 4);
            } while ((iCharType & 6) != 0 && !this.stopOnDot(c));
            this._peekc = c;
            this._strValue = this._reader.subsequence(iStart, this._iPos - 1).toString();
            if (this._bForceLower) {
                this._strValue = this._strValue.toLowerCase();
            }
            this._keyword = this.isSupportsKeywords() ? Keyword.get((String)this._strValue) : null;
            this._iType = this.isReserved() ? -7 : -5;
            return this._iType;
        }
        if ((iCharType & 0x10) != 0) {
            while ((c = this.read()) != 10 && c != 13 && c >= 0) {
            }
            this._peekc = c;
            if (c == -1) {
                this._iType = -1;
                return -1;
            }
            return this.nextToken();
        }
        this._iTokenStart = this._iPos;
        this._iTokenColumn = this._iColumn;
        if ((iCharType & 8) != 0 || (iCharType & 0x80) != 0) {
            this._iType = c;
            int i = 0;
            boolean bEscapedScriptlet = false;
            this._peekc = this.read();
            while (this._peekc >= 0 && this._peekc != this._iType && this._peekc != 10 && this._peekc != 13) {
                if (this._peekc == 92) {
                    int first = c = this.read();
                    if (c >= 48 && c <= 55) {
                        c -= 48;
                        int c2 = this.read();
                        if (48 <= c2 && c2 <= 55) {
                            c = (c << 3) + (c2 - 48);
                            c2 = this.read();
                            if (48 <= c2 && c2 <= 55 && first <= 51) {
                                c = (c << 3) + (c2 - 48);
                                this._peekc = this.read();
                            } else {
                                this._peekc = c2;
                            }
                        } else {
                            this._peekc = c2;
                        }
                    } else {
                        boolean bValidChar = true;
                        switch (c) {
                            case 97: {
                                c = 7;
                                break;
                            }
                            case 98: {
                                c = 8;
                                break;
                            }
                            case 102: {
                                c = 12;
                                break;
                            }
                            case 110: {
                                c = 10;
                                break;
                            }
                            case 114: {
                                c = 13;
                                break;
                            }
                            case 116: {
                                c = 9;
                                break;
                            }
                            case 118: {
                                c = 11;
                                break;
                            }
                            case 34: 
                            case 39: 
                            case 92: {
                                break;
                            }
                            case 117: {
                                c = this.read();
                                if (this.isHexDigit(c)) {
                                    StringBuilder sb = new StringBuilder();
                                    sb.append((char)c);
                                    c = this.read();
                                    if (this.isHexDigit(c)) {
                                        sb.append((char)c);
                                        c = this.read();
                                        if (this.isHexDigit(c)) {
                                            sb.append((char)c);
                                            c = this.read();
                                            if (this.isHexDigit(c)) {
                                                sb.append((char)c);
                                                c = Integer.parseInt(sb.toString(), 16);
                                                break;
                                            }
                                            bValidChar = false;
                                            this._peekc = c;
                                            break;
                                        }
                                        bValidChar = false;
                                        this._peekc = c;
                                        break;
                                    }
                                    bValidChar = false;
                                    this._peekc = c;
                                    break;
                                }
                                bValidChar = false;
                                this._peekc = c;
                                break;
                            }
                            case 60: {
                                bEscapedScriptlet = true;
                                c = 65505;
                                break;
                            }
                            case 36: {
                                bEscapedScriptlet = true;
                                c = 65506;
                                break;
                            }
                            default: {
                                if (!Character.isWhitespace(c)) {
                                    bValidChar = false;
                                    this._peekc = this.read();
                                    break;
                                }
                                if (c != 10) break;
                                this.incrementLineNumber();
                            }
                        }
                        if (bValidChar) {
                            this._peekc = this.read();
                        } else {
                            if (this._iInvalidCharPos < 0) {
                                this._iInvalidCharPos = i;
                            }
                            c = -1;
                        }
                    }
                } else {
                    c = this._peekc;
                    this._peekc = this.read();
                    if (c == "<%".charAt(0) && this._peekc == "<%".charAt(1) || c == "${".charAt(0) && this._peekc == "${".charAt(1)) {
                        boolean alternateStyle = c == "${".charAt(0) && this._peekc == "${".charAt(1);
                        int numOpenCurlies = 0;
                        while (!(this._peekc < 0 || this._peekc == 10 || this._peekc == 13 || !alternateStyle && c == "%>".charAt(0) && this._peekc == "%>".charAt(1) || alternateStyle && this._peekc == "}".charAt(0) && numOpenCurlies <= 1)) {
                            if (this._peekc == 123) {
                                ++numOpenCurlies;
                            } else if (this._peekc == 125) {
                                --numOpenCurlies;
                            }
                            if (i >= _buf.length) {
                                char[] nb = new char[_buf.length * 2];
                                System.arraycopy(_buf, 0, nb, 0, _buf.length);
                                _buf = nb;
                            }
                            _buf[i++] = (char)c;
                            c = this._peekc;
                            this._peekc = this.read();
                        }
                    }
                }
                if (i >= _buf.length) {
                    char[] nb = new char[_buf.length * 2];
                    System.arraycopy(_buf, 0, nb, 0, _buf.length);
                    _buf = nb;
                }
                _buf[i++] = (char)c;
            }
            if (this._peekc == this._iType) {
                this._peekc = this.read();
            } else {
                this._bUnterminatedString = true;
            }
            this._strValue = String.copyValueOf(_buf, 0, i);
            if (bEscapedScriptlet) {
                this._strValue = '\uffe0' + this._strValue;
            }
            return this._iType;
        }
        if (this._iPos == 1 && c == 35) {
            int iCommnetPos = this._iPos - 1;
            while ((c = this.read()) != 10 && c != 13 && c >= 0) {
            }
            this._peekc = c;
            String strSaveValue = this._strValue;
            this._strValue = this._reader.getSource().substring(iCommnetPos, this._iPos - 1);
            int iSaveType = this._iType;
            this._iType = -3;
            this.pushToken();
            this._iType = iSaveType;
            this._strValue = strSaveValue;
            if (c == -1) {
                this._iType = -1;
                return -1;
            }
            return -3;
        }
        boolean bSlashConsumed = false;
        int srcLen = this._reader.getSource().length();
        if (c == 47) {
            int iCommnetPos = this._iPos - 1;
            c = this.read();
            if (c == 42) {
                this._lastComment = new DocCommentBlock();
                this.consumeBlockComment();
                String strSaveValue = this._strValue;
                int endIndex = Math.min(srcLen, this._iPos - 1);
                this._strValue = this._reader.getSource().substring(iCommnetPos, endIndex);
                this._lastComment.setRawComment(this._strValue);
                int iSaveType = this._iType;
                this._iType = -3;
                this.pushToken();
                this._iType = iSaveType;
                this._strValue = strSaveValue;
                if (this._bUnterminatedComment) {
                    this._iType = -1;
                    return -1;
                }
                return this.nextToken();
            }
            if (c == 47) {
                while ((c = this.read()) != 10 && c != 13 && c >= 0) {
                }
                this._peekc = c;
                String strSaveValue = this._strValue;
                this._strValue = this._reader.getSource().substring(iCommnetPos, this._iPos - 1);
                int iSaveType = this._iType;
                this._iType = -3;
                this.pushToken();
                this._iType = iSaveType;
                this._strValue = strSaveValue;
                if (c == -1) {
                    this._iType = -1;
                    return -1;
                }
                return -3;
            }
            if ((iCharType & 0x20) == 0) {
                this._peekc = c;
                this._iType = 47;
                return 47;
            }
            bSlashConsumed = true;
        }
        if (!bSlashConsumed) {
            this._iTokenStart = this._iPos;
            this._iTokenColumn = this._iColumn;
        }
        if ((iCharType & 0x20) != 0 || (iCharType & 0x40) != 0) {
            int i = 0;
            while (true) {
                if (i >= _buf.length) {
                    char[] nb = new char[_buf.length * 2];
                    System.arraycopy(_buf, 0, nb, 0, _buf.length);
                    _buf = nb;
                }
                _buf[i++] = (char)(bSlashConsumed ? 47 : (char)c);
                String strOpTest = new String(_buf, 0, i);
                if (!this.isOperator(strOpTest) && !this.isLeftOpenIntervalOp(strOpTest)) break;
                c = bSlashConsumed ? c : this.read();
                bSlashConsumed = false;
            }
            this._peekc = c;
            this._strValue = String.copyValueOf(_buf, 0, --i);
            if (this._strValue.equals(".")) {
                this._iType = 46;
                return 46;
            }
            this._iType = -6;
            return -6;
        }
        this._iTokenStart = this._iPos;
        this._iTokenColumn = this._iColumn;
        this._iType = c;
        this._peekc = this.read();
        this._iType = c;
        return this._iType;
    }

    private void consumeBlockComment() throws IOException {
        int c = this.read();
        int prev = -1;
        while (c >= 0 && (prev != 42 || c != 47)) {
            if (prev == 47 && c == 42) {
                this.consumeBlockComment();
                prev = -1;
                continue;
            }
            if (c == 10) {
                this.incrementLineNumber();
            }
            prev = c;
            c = this.read();
        }
        boolean bl = this._bUnterminatedComment = c == -1;
        if (!this._bUnterminatedComment) {
            this._peekc = this.read();
        }
    }

    private boolean isReserved() {
        return this.isSupportsKeywords() && Keyword.isKeyword((String)this._strValue);
    }

    private boolean isAtIgnorePos() {
        return this._instructor != null && this._instructor.isAtIgnoredPos();
    }

    private boolean isHexDigit(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70;
    }

    private boolean isLeftOpenIntervalOp(String strOpTest) {
        return strOpTest.equals("|.") && this._reader.peek() == 46;
    }

    private boolean stopOnDot(int c) {
        return this._bParseDotsAsOperators && c == 46;
    }

    public String toString() {
        String ret;
        switch (this._iType) {
            case -1: {
                ret = "EOF";
                break;
            }
            case 10: {
                ret = "EOL";
                break;
            }
            case -8: {
                ret = "NOTHING";
                break;
            }
            default: {
                ret = ((Token)((Object)this.getTokens().peek())).getText();
            }
        }
        return "Token[" + ret + "], line " + this.getLineNumber();
    }

    public int getType() {
        return this._iType;
    }

    public boolean isEOF() {
        return this._iType == -1;
    }

    public boolean isNOTHING() {
        return this._iType == -8;
    }

    void goToPosition(int iOffset) throws IOException {
        if (this.getTokenStart() > iOffset) {
            this.reset(this._reader, true);
            this.goToPosition(iOffset);
        } else {
            while (this.getTokenStart() < iOffset) {
                this.popLastComment();
                this.nextToken();
                if (!this.isEOF() && !this.isNOTHING()) continue;
                throw new IOException("Unexpected EOF");
            }
        }
    }

    void setTokens(Stack<Token> tokens) {
        this._tokens = tokens;
    }

    public Token getEofToken() {
        return this._eof;
    }

    public boolean isSupportsKeywords() {
        return this._supportsKeywords;
    }

    public void setSupportsKeywords(boolean supportsKeywords) {
        this._supportsKeywords = supportsKeywords;
    }
}

