/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.config.CommonServices;
import gw.internal.gosu.parser.expressions.ArithmeticExpression;
import gw.internal.gosu.parser.expressions.UnsupportedNumberTypeException;
import gw.lang.parser.expressions.IBitshiftExpression;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.JavaTypes;

public final class BitshiftExpression
extends ArithmeticExpression
implements IBitshiftExpression {
    @Override
    public Object evaluate() {
        if (!this.isCompileTimeConstant()) {
            return super.evaluate();
        }
        Object lhsValue = this.getLHS().evaluate();
        if (lhsValue == null) {
            return null;
        }
        Object rhsValue = this.getRHS().evaluate();
        if (rhsValue == null) {
            return null;
        }
        IType type = this.getType();
        if (this.getOperator().equals("<<")) {
            if (type == JavaTypes.pINT()) {
                return CommonServices.getCoercionManager().makeIntegerFrom(lhsValue) << CommonServices.getCoercionManager().makeIntegerFrom(rhsValue);
            }
            if (type == JavaTypes.pLONG()) {
                return BitshiftExpression.makeLong(CommonServices.getCoercionManager().makeLongFrom(lhsValue) << CommonServices.getCoercionManager().makeIntegerFrom(rhsValue));
            }
            throw new UnsupportedNumberTypeException(type);
        }
        if (this.getOperator().equals(">>")) {
            if (type == JavaTypes.pINT()) {
                return CommonServices.getCoercionManager().makeIntegerFrom(lhsValue) >> CommonServices.getCoercionManager().makeIntegerFrom(rhsValue);
            }
            if (type == JavaTypes.pLONG()) {
                return BitshiftExpression.makeLong(CommonServices.getCoercionManager().makeLongFrom(lhsValue) >> CommonServices.getCoercionManager().makeIntegerFrom(rhsValue));
            }
            throw new UnsupportedNumberTypeException(type);
        }
        if (this.getOperator().equals(">>>")) {
            if (type == JavaTypes.pINT()) {
                return CommonServices.getCoercionManager().makeIntegerFrom(lhsValue) >>> CommonServices.getCoercionManager().makeIntegerFrom(rhsValue);
            }
            if (type == JavaTypes.pLONG()) {
                return BitshiftExpression.makeLong(CommonServices.getCoercionManager().makeLongFrom(lhsValue) >>> CommonServices.getCoercionManager().makeIntegerFrom(rhsValue));
            }
            throw new UnsupportedNumberTypeException(type);
        }
        throw new UnsupportedNumberTypeException(type);
    }
}

