/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.internal.gosu.parser.CannotExecuteGosuException;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.IGosuProgramInternal;
import gw.lang.parser.GosuParserTypes;
import gw.lang.parser.ICapturedSymbol;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.parser.expressions.IEvalExpression;
import gw.lang.parser.expressions.ITypeVariableDefinition;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.ITypeRef;
import gw.lang.reflect.RefreshKind;
import gw.lang.reflect.TypeSystem;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class EvalExpression
extends Expression
implements IEvalExpression {
    private ITypeUsesMap _typeUsesMap;
    private Expression _expression;
    private List<ICapturedSymbol> _capturedForBytecode;
    private Map<String, ITypeVariableDefinition> _capturedTypeVars;
    private Map<String, IGosuProgramInternal> _cacheProgramByFingerprint;
    private int _refreshChecksum = 0;

    public EvalExpression(ITypeUsesMap typeUsesMap) {
        this._typeUsesMap = typeUsesMap;
        this._type = GosuParserTypes.GENERIC_BEAN_TYPE();
        this._cacheProgramByFingerprint = new ProgramCache();
    }

    public void setCapturedSymbolsForBytecode(List<ICapturedSymbol> captured) {
        this._capturedForBytecode = captured;
    }

    public List<ICapturedSymbol> getCapturedForBytecode() {
        return this._capturedForBytecode;
    }

    public void cacheProgram(String strTypeName, IGosuProgramInternal gsClass) {
        this.clearCacheOnChecksumChange();
        this._cacheProgramByFingerprint.put(strTypeName, gsClass);
    }

    public IGosuProgramInternal getCachedProgram(String strTypeName) {
        this.clearCacheOnChecksumChange();
        return this._cacheProgramByFingerprint.get(strTypeName);
    }

    private void clearCacheOnChecksumChange() {
        if (this._refreshChecksum != TypeSystem.getRefreshChecksum()) {
            this._cacheProgramByFingerprint.clear();
            this._refreshChecksum = TypeSystem.getRefreshChecksum();
        }
    }

    public ITypeUsesMap getTypeUsesMap() {
        return this._typeUsesMap;
    }

    public void setExpression(Expression expression) {
        this._expression = expression;
    }

    public Expression getExpression() {
        return this._expression;
    }

    @Override
    public Object evaluate() {
        if (!this.isCompileTimeConstant()) {
            return super.evaluate();
        }
        throw new CannotExecuteGosuException();
    }

    @Override
    public String toString() {
        return "eval( " + this._expression.toString() + " )\n";
    }

    public void setCapturedTypeVars(Map<String, ITypeVariableDefinition> typeVariables) {
        Iterator<ITypeVariableDefinition> iter = typeVariables.values().iterator();
        while (iter.hasNext()) {
            ITypeVariableDefinition tvd = iter.next();
            if (tvd.getEnclosingType() instanceof IFunctionType) continue;
            iter.remove();
        }
        this._capturedTypeVars = typeVariables;
    }

    public Map<String, ITypeVariableDefinition> getCapturedTypeVars() {
        return this._capturedTypeVars;
    }

    static class ProgramCache
    extends LinkedHashMap<String, IGosuProgramInternal> {
        private static final int CACHE_SIZE = 100;

        public ProgramCache() {
            super(100);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean removeEldestEntry(Map.Entry<String, IGosuProgramInternal> eldest) {
            TypeSystem.lock();
            try {
                if (this.size() > 100) {
                    IGosuProgramInternal program = eldest.getValue();
                    if (!program.getInnerClasses().isEmpty()) {
                        boolean bl = true;
                        return bl;
                    }
                    ITypeRef type = (ITypeRef)program;
                    type._setStale(RefreshKind.MODIFICATION);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                TypeSystem.unlock();
            }
            return false;
        }
    }
}

