/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.java.compiler;

import gw.lang.javac.ClassJavaFileObject;
import gw.lang.reflect.ITypeLoaderListener;
import gw.lang.reflect.RefreshRequest;
import gw.lang.reflect.TypeSystem;
import gw.util.cache.FqnCache;
import java.io.IOException;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

class GosuJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager>
implements ITypeLoaderListener {
    private FqnCache<ClassJavaFileObject> _classFiles = new FqnCache();

    GosuJavaFileManager(JavaFileManager fileManager) {
        super(fileManager);
        TypeSystem.addTypeLoaderListenerAsWeakRef((ITypeLoaderListener)this);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        ClassJavaFileObject file = new ClassJavaFileObject(className, kind);
        this._classFiles.add(className, (Object)file);
        className = className.replace('$', '.');
        this._classFiles.add(className, (Object)file);
        return file;
    }

    public ClassJavaFileObject findCompiledFile(String fqn) {
        return (ClassJavaFileObject)this._classFiles.get(fqn);
    }

    public void remove(String fqn) {
        this._classFiles.remove(fqn);
    }

    public void refreshedTypes(RefreshRequest request) {
        switch (request.kind) {
            case MODIFICATION: 
            case DELETION: {
                this._classFiles.remove(request.types);
            }
        }
    }

    public void refreshed() {
        this._classFiles = new FqnCache();
    }
}

