/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.bytecode.expression;

import gw.internal.ext.org.objectweb.asm.Handle;
import gw.internal.ext.org.objectweb.asm.Type;
import gw.internal.gosu.ir.compiler.bytecode.AbstractBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeContext;
import gw.lang.ir.expression.IRLazyTypeMethodCallExpression;
import gw.lang.reflect.IType;
import gw.lang.reflect.LazyTypeResolver;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;

public class IRLazyTypeMethodCallExpressionCompiler
extends AbstractBytecodeCompiler {
    public static void compile(IRLazyTypeMethodCallExpression expression, IRBytecodeContext context) {
        try {
            MethodType mt = MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, MethodType.class, MethodHandle.class, MethodType.class);
            Handle bootstrap = new Handle(6, LambdaMetafactory.class.getName().replace('.', '/'), "metafactory", mt.toMethodDescriptorString());
            Type resolveDesc = Type.getType((Method)LazyTypeResolver.ITypeResolver.class.getDeclaredMethod("resolve", new Class[0]));
            context.getMv().visitInvokeDynamicInsn("resolve", Type.getMethodDescriptor((Type)Type.getType(LazyTypeResolver.ITypeResolver.class), (Type[])IRLazyTypeMethodCallExpressionCompiler.getAnonCtorParams(expression)), bootstrap, new Object[]{resolveDesc, new Handle(expression.isStatic() ? 6 : 7, IRLazyTypeMethodCallExpressionCompiler.getOwnersName(expression), expression.getName(), IRLazyTypeMethodCallExpressionCompiler.makeDescriptor(expression.getFunctionTypeParamCount())), resolveDesc});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getOwnersName(IRLazyTypeMethodCallExpression expression) {
        if (!expression.getOwnersType().getName().equals(Object.class.getName())) {
            return expression.getOwnersType().getSlashName();
        }
        return expression.getOwnerTypeName().replace('.', '/');
    }

    private static Type[] getAnonCtorParams(IRLazyTypeMethodCallExpression expression) {
        boolean bStatic = expression.isStatic();
        Type[] params = new Type[(bStatic ? 0 : 1) + expression.getFunctionTypeParamCount()];
        int i = 0;
        if (!bStatic) {
            params[0] = Type.getType((String)expression.getOwnersType().getDescriptor());
            i = 1;
        }
        Type typeResClass = Type.getType(LazyTypeResolver.class);
        while (i < params.length) {
            params[i] = typeResClass;
            ++i;
        }
        return params;
    }

    private static String makeDescriptor(int iFunctionTypeParamCount) {
        Type[] params = new Type[iFunctionTypeParamCount];
        Type typeResClass = Type.getType(LazyTypeResolver.class);
        for (int i = 0; i < params.length; ++i) {
            params[i] = typeResClass;
        }
        return Type.getMethodDescriptor((Type)Type.getType(IType.class), (Type[])params);
    }
}

