/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.bytecode.expression;

import gw.internal.gosu.parser.GosuClassProxyFactory;
import gw.internal.gosu.parser.MetaType;
import gw.internal.gosu.parser.TypeLord;
import gw.lang.parser.StandardCoercionManager;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IDynamicType;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.TypeInfoUtil;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ClassType;
import gw.lang.reflect.gs.GosuClassTypeLoader;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.gs.IGosuPropertyInfo;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.gs.LazyStringSourceFileHandle;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.module.IModule;

public class StructuralTypeProxyGenerator {
    private final boolean _bStatic;
    private String _type;

    private StructuralTypeProxyGenerator(boolean bStatic) {
        this._bStatic = bStatic;
    }

    public static Class makeProxy(Class<?> iface, Class<?> rootClass, String name, boolean bStaticImpl) {
        IType pureGenericType = TypeLord.getPureGenericType(TypeSystem.get(rootClass));
        Object type = StructuralTypeProxyGenerator.isExpando(pureGenericType) ? IDynamicType.instance() : pureGenericType;
        IType ifaceType = TypeLord.getPureGenericType(TypeSystem.get(iface));
        IModule module = ifaceType.getTypeLoader().getModule();
        GosuClassTypeLoader loader = GosuClassTypeLoader.getDefaultClassLoader((IModule)module);
        StructuralTypeProxyGenerator gen = new StructuralTypeProxyGenerator(bStaticImpl);
        IGosuClass gsProxy = loader.makeNewClass((ISourceFileHandle)new LazyStringSourceFileHandle(gen.getNamespace(ifaceType), name, () -> StructuralTypeProxyGenerator.lambda$makeProxy$0(module, gen, ifaceType, (IType)type, name), ClassType.Class));
        return gsProxy.getBackingClass();
    }

    private StringBuilder generateProxy(IType ifaceType, IType type, String name) {
        this._type = type.getName();
        if (ifaceType.isGenericType() && !ifaceType.isParameterizedType()) {
            TypeVarToTypeMap inferenceMap;
            if (!StandardCoercionManager.isStructurallyAssignable_Laxed((IType)ifaceType, (IType)(this._bStatic ? MetaType.getLiteral(type) : type), (TypeVarToTypeMap)(inferenceMap = new TypeVarToTypeMap()))) {
                throw new IllegalStateException("Unexpected structural type incompatibility: " + ifaceType.getName() + " from " + type.getName());
            }
            ifaceType = TypeLord.makeParameteredType(ifaceType, inferenceMap);
            ifaceType = TypeLord.replaceTypeVariableTypeParametersWithBoundingTypes(ifaceType);
        }
        return new StringBuilder().append("package ").append(this.getNamespace(ifaceType)).append("\n").append("\n").append("class ").append(name).append(" implements ").append(ifaceType.getName()).append(" {\n").append("  final var _root: ").append(this._bStatic ? "Type<" + type.getName() + ">" : type.getName()).append("\n").append("  \n").append("  construct( root: ").append(this._bStatic ? "Type<" + type.getName() + ">" : type.getName()).append(" ) {\n").append("    _root = root\n").append("  }\n").append("  \n").append(this.implementIface(ifaceType, type)).append("}");
    }

    private String getNamespace(IType ifaceType) {
        String nspace = TypeLord.getOuterMostEnclosingClass(ifaceType).getNamespace();
        if (nspace.startsWith("java.") || nspace.startsWith("javax.")) {
            nspace = "not" + nspace;
        }
        return nspace;
    }

    private String implementIface(IType ifaceType, IType rootType) {
        StringBuilder sb = new StringBuilder();
        ITypeInfo ti = ifaceType.getTypeInfo();
        for (Object o : ti.getProperties()) {
            IPropertyInfo pi = (IPropertyInfo)o;
            this.genInterfacePropertyDecl(sb, pi, rootType);
        }
        for (Object o : ti.getMethods()) {
            IMethodInfo mi = (IMethodInfo)o;
            this.genInterfaceMethodDecl(sb, mi, rootType);
        }
        return sb.toString();
    }

    private void genInterfaceMethodDecl(StringBuilder sb, IMethodInfo mi, IType rootType) {
        if (mi.isDefaultImpl() && !this.implementsMethod(rootType, mi) || mi.isStatic()) {
            return;
        }
        if (mi.getOwnersType() instanceof IGosuEnhancement) {
            return;
        }
        if (mi.getDisplayName().startsWith("@")) {
            return;
        }
        if (GosuClassProxyFactory.isObjectMethod(mi)) {
            return;
        }
        if (mi.getOwnersType() == JavaTypes.IGOSU_OBJECT().getAdapterClass()) {
            return;
        }
        sb.append("  function ").append(mi.getDisplayName()).append(TypeInfoUtil.getTypeVarList((IFeatureInfo)mi)).append("(");
        IParameterInfo[] params = mi.getParameters();
        for (int i = 0; i < params.length; ++i) {
            IParameterInfo pi = params[i];
            sb.append(' ').append("p").append(i).append(": ").append(TypeLord.replaceTypeVariableTypeParametersWithBoundingTypes(pi.getFeatureType()).getName());
            sb.append(i < params.length - 1 ? (char)',' : ' ');
        }
        IType returnType = TypeLord.replaceTypeVariableTypeParametersWithBoundingTypes(mi.getReturnType());
        sb.append(") : ").append(returnType.getName()).append(" {\n").append(returnType == JavaTypes.pVOID() ? "    " : "    return ").append(this._bStatic ? this._type : "_root").append(".").append(mi.getDisplayName()).append("(");
        for (int i = 0; i < params.length; ++i) {
            IParameterInfo pi = params[i];
            sb.append(' ').append("p").append(i).append(this.maybeCastParamType(mi, TypeLord.replaceTypeVariableTypeParametersWithBoundingTypes(pi.getFeatureType()), rootType, i)).append(i < params.length - 1 ? (char)',' : ' ');
        }
        sb.append(")").append(this.maybeCastReturnType(mi, returnType, rootType)).append("  }\n");
    }

    private boolean implementsMethod(IType type, IMethodInfo mi) {
        return StandardCoercionManager.isStructurallyAssignable_Laxed((IType)mi.getOwnersType(), (IType)type, (IMethodInfo)mi, (TypeVarToTypeMap)new TypeVarToTypeMap());
    }

    private String maybeCastReturnType(IMethodInfo mi, IType returnType, IType rootType) {
        return returnType != JavaTypes.pVOID() ? " as " + returnType.getName() : "";
    }

    private String maybeCastParamType(IMethodInfo ifaceMethod, IType paramType, IType rootType, int iParam) {
        return "";
    }

    private String maybeCastPropertyAssignment(IPropertyInfo pi, IType rootType) {
        return " as " + TypeLord.replaceTypeVariableTypeParametersWithBoundingTypes(pi.getFeatureType()).getName() + "\n";
    }

    private void genInterfacePropertyDecl(StringBuilder sb, IPropertyInfo pi, IType rootType) {
        String reflectiveName;
        if (pi.isStatic()) {
            return;
        }
        if (!pi.isReadable()) {
            return;
        }
        if (pi.getOwnersType() instanceof IGosuEnhancement) {
            return;
        }
        if (GosuClassProxyFactory.isObjectProperty(pi)) {
            return;
        }
        if (pi.getOwnersType() == JavaTypes.IGOSU_OBJECT().getAdapterClass()) {
            return;
        }
        IType ifacePropertyType = TypeLord.replaceTypeVariableTypeParametersWithBoundingTypes(pi.getFeatureType());
        ITypeInfo rootTypeInfo = rootType.getTypeInfo();
        if (!(pi instanceof IGosuPropertyInfo) || !((IGosuPropertyInfo)pi).isGetterDefault() || this.implementsMethod(rootType, (IMethodInfo)((IGosuPropertyInfo)pi).getDps().getGetterDfs().getMethodOrConstructorInfo())) {
            reflectiveName = this.getReflectiveName((IAttributedFeatureInfo)pi, rootType, rootTypeInfo);
            if (pi.getDescription() != null) {
                sb.append("\n/** ").append(pi.getDescription()).append(" */\n");
            }
            sb.append("  property get ").append(pi.getName()).append("() : ").append(ifacePropertyType.getName()).append(" {\n");
            if (reflectiveName != null) {
                sb.append("    return _root[\"").append(reflectiveName).append("\"] as ").append(ifacePropertyType.getName()).append("\n");
            } else {
                sb.append("    return ").append(this._bStatic ? this._type : "_root").append(".").append(pi.getName()).append(" as ").append(ifacePropertyType.getName()).append("\n");
            }
            sb.append("  }\n");
        }
        if ((!(pi instanceof IGosuPropertyInfo) || !((IGosuPropertyInfo)pi).isSetterDefault() || this.implementsMethod(rootType, (IMethodInfo)((IGosuPropertyInfo)pi).getDps().getSetterDfs().getMethodOrConstructorInfo())) && pi.isWritable(pi.getOwnersType())) {
            reflectiveName = this.getReflectiveName((IAttributedFeatureInfo)pi, rootType, rootTypeInfo);
            sb.append("  property set ").append(pi.getName()).append("( value: ").append(ifacePropertyType.getName()).append(" ) {\n");
            if (reflectiveName != null) {
                sb.append("    _root[\"").append(reflectiveName).append("\"] = value").append(this.maybeCastPropertyAssignment(pi, rootType));
            } else {
                sb.append("    ").append(this._bStatic ? this._type : "_root").append(".").append(pi.getName()).append(" = value").append(this.maybeCastPropertyAssignment(pi, rootType));
            }
            sb.append("  }\n");
        }
    }

    private String getReflectiveName(IAttributedFeatureInfo pi, IType rootType, ITypeInfo rootTypeInfo) {
        if (rootType.isDynamic() || StructuralTypeProxyGenerator.isExpando(rootType)) {
            IAnnotationInfo actualNameAnno = pi.getAnnotation((IType)JavaTypes.ACTUAL_NAME());
            if (actualNameAnno != null) {
                return (String)actualNameAnno.getFieldValue("value");
            }
        } else if (rootTypeInfo instanceof IRelativeTypeInfo && ((IRelativeTypeInfo)rootTypeInfo).getProperty(rootType, (CharSequence)pi.getName()).isPrivate()) {
            return pi.getName();
        }
        return null;
    }

    private static boolean isExpando(IType rootType) {
        return JavaTypes.BINDINGS().isAssignableFrom(rootType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ String lambda$makeProxy$0(IModule module, StructuralTypeProxyGenerator gen, IType ifaceType, IType type, String name) throws Exception {
        TypeSystem.pushModule((IModule)module);
        try {
            String string = gen.generateProxy(ifaceType, type, name).toString();
            return string;
        }
        finally {
            TypeSystem.popModule((IModule)module);
        }
    }
}

