/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.ExecutionMode;
import gw.fs.IDirectory;
import gw.internal.gosu.compiler.GosuClassLoader;
import gw.internal.gosu.parser.AbstractTypeRef;
import gw.internal.gosu.parser.AsmClassJavaClassInfo;
import gw.internal.gosu.parser.ClassCache;
import gw.internal.gosu.parser.ClassJavaClassInfo;
import gw.internal.gosu.parser.ExecutionEnvironment;
import gw.internal.gosu.parser.JavaType;
import gw.internal.gosu.parser.MetaType;
import gw.internal.gosu.parser.ModuleTypeLoader;
import gw.internal.gosu.parser.java.classinfo.JavaSourceClass;
import gw.lang.parser.IBlockClass;
import gw.lang.reflect.IDefaultTypeLoader;
import gw.lang.reflect.IErrorType;
import gw.lang.reflect.IExtendedTypeLoader;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.RefreshKind;
import gw.lang.reflect.RefreshRequest;
import gw.lang.reflect.SimpleTypeLoader;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.GosuClassPathThing;
import gw.lang.reflect.gs.IGosuClassLoader;
import gw.lang.reflect.gs.IGosuObject;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.gs.TypeName;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassType;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.java.asm.AsmClass;
import gw.lang.reflect.module.IModule;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultTypeLoader
extends SimpleTypeLoader
implements IExtendedTypeLoader,
IDefaultTypeLoader {
    private ClassCache _classCache;
    private IGosuClassLoader _gosuClassLoader;
    private Map<String, IJavaClassInfo> _classInfoCache = new ConcurrentHashMap<String, IJavaClassInfo>(1000);
    protected Set<String> _namespaces;

    public static DefaultTypeLoader instance(IModule module) {
        if (module == null) {
            module = ExecutionEnvironment.instance().getJreModule();
        }
        return (DefaultTypeLoader)module.getModuleTypeLoader().getTypeLoader(DefaultTypeLoader.class);
    }

    public DefaultTypeLoader(IModule module) {
        super(module);
        this._classCache = new ClassCache(module);
    }

    public static DefaultTypeLoader instance() {
        IModule module = TypeSystem.getCurrentModule();
        return DefaultTypeLoader.instance(module);
    }

    public IType getType(String fullyQualifiedName) {
        IJavaClassInfo classInfo = this.getJavaClassInfo(fullyQualifiedName);
        if (classInfo != null) {
            return JavaType.create(classInfo, this);
        }
        return null;
    }

    public IJavaType getInnerType(String fqn) {
        IType cachedType = ((ModuleTypeLoader)this._module.getModuleTypeLoader()).getCachedType(fqn);
        if (cachedType != null && !(cachedType instanceof IErrorType)) {
            return (IJavaType)cachedType;
        }
        return (IJavaType)this.getType(fqn);
    }

    public IJavaClassInfo getJavaClassInfo(String fullyQualifiedName) {
        if (fullyQualifiedName.startsWith("[")) {
            throw new IllegalArgumentException("Cannot call getJavaClassInfo with a raw array descriptor");
        }
        if (ExecutionMode.isIDE() && this._module != TypeSystem.getJreModule() && this._module.equals(TypeSystem.getGlobalModule())) {
            return null;
        }
        String fqnNoArrays = ModuleTypeLoader.stripArrayBrackets(fullyQualifiedName);
        IJavaClassInfo result = this._classInfoCache.get(fqnNoArrays);
        if (result == null) {
            result = this.resolveJavaClassInfo(fqnNoArrays);
            if (result == null) {
                result = IJavaClassInfo.NULL_TYPE;
            }
            this._classInfoCache.put(fqnNoArrays, result);
        }
        if (result != IJavaClassType.NULL_TYPE) {
            int numArrays = (fullyQualifiedName.length() - fqnNoArrays.length()) / 2;
            for (int i = 0; i < numArrays; ++i) {
                result = result.getArrayType();
            }
        }
        return result == IJavaClassInfo.NULL_TYPE ? null : result;
    }

    public IJavaClassInfo getJavaClassInfoForClassDirectly(Class clazz, IModule module) {
        return new ClassJavaClassInfo(clazz, module);
    }

    public IJavaClassInfo getJavaClassInfo(Class aClass, IModule gosuModule) {
        if (ExecutionMode.isIDE() && this._module != TypeSystem.getJreModule() && this._module.equals(TypeSystem.getGlobalModule())) {
            return null;
        }
        String fullyQualifiedName = aClass.getName().replace('$', '.');
        Object result = this._classInfoCache.get(fullyQualifiedName);
        if (result == null) {
            result = new ClassJavaClassInfo(aClass, gosuModule);
            this._classInfoCache.put(fullyQualifiedName, (IJavaClassInfo)result);
        }
        return result == IJavaClassInfo.NULL_TYPE ? null : result;
    }

    public IJavaClassInfo getJavaClassInfo(AsmClass aClass, IModule gosuModule) {
        if (ExecutionMode.isIDE() && this._module != TypeSystem.getJreModule() && this._module.equals(TypeSystem.getGlobalModule())) {
            return null;
        }
        String fullyQualifiedName = aClass.getName().replace('$', '.');
        Object result = this._classInfoCache.get(fullyQualifiedName);
        if (result == null) {
            result = new AsmClassJavaClassInfo(aClass, gosuModule);
            this._classInfoCache.put(fullyQualifiedName, (IJavaClassInfo)result);
        }
        return result == IJavaClassInfo.NULL_TYPE ? null : result;
    }

    public IJavaClassInfo resolveJavaClassInfo(String fqn) {
        if (!ExecutionMode.isIDE() && this.classFileExists(fqn)) {
            return this.getByClass(fqn, this._module, this._module);
        }
        ISourceFileHandle fileHandle = this.getSouceFileHandle(fqn);
        if (fileHandle == null) {
            return this.getByClass(fqn, this._module, this._module);
        }
        if (fileHandle.getParentType() != null && !fileHandle.getParentType().isEmpty()) {
            String parentType = fileHandle.getTypeNamespace();
            IJavaClassInfo parentClassInfo = this.getJavaClassInfo(parentType);
            if (parentClassInfo == null) {
                return null;
            }
            IJavaClassInfo[] declaredClasses = parentClassInfo.getDeclaredClasses();
            IJavaClassInfo inner = null;
            for (IJavaClassInfo declaredClass : declaredClasses) {
                String name = declaredClass.getName();
                if (!this._classInfoCache.containsKey(name)) {
                    this._classInfoCache.put(name, declaredClass);
                }
                if (!fqn.equals(name) && !name.replace('$', '.').equals(fqn)) continue;
                inner = declaredClass;
            }
            return inner;
        }
        return JavaSourceClass.createTopLevel(fileHandle, this._module);
    }

    public ISourceFileHandle getSouceFileHandle(String qualifiedName) {
        ISourceFileHandle aClass = this._module.getFileRepository().findClass(qualifiedName, EXTENSIONS_ARRAY);
        if (aClass == null || !aClass.getClassType().isJava()) {
            return null;
        }
        return aClass;
    }

    private IJavaClassInfo getByClass(String className, IModule lookupModule, IModule actualModule) {
        DefaultTypeLoader loader = (DefaultTypeLoader)((Object)lookupModule.getTypeLoaders(IDefaultTypeLoader.class).get(0));
        if (ExecutionMode.isRuntime()) {
            Class theClass = loader.loadClass(className);
            if (theClass == null) {
                return null;
            }
            return this.getJavaClassInfo(theClass, actualModule);
        }
        AsmClass theClass = loader.loadAsmClass(className);
        if (theClass == null) {
            return null;
        }
        return this.getJavaClassInfo(theClass, actualModule);
    }

    public IType getIntrinsicTypeFromObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof IGosuObject) {
            IType type;
            if (object instanceof AbstractTypeRef) {
                object = ((AbstractTypeRef)object)._getType();
            }
            if ((type = ((IGosuObject)object).getIntrinsicType()) instanceof IBlockClass) {
                return ((IBlockClass)type).getBlockType();
            }
            return type;
        }
        if (object instanceof IType) {
            return MetaType.get((IType)object);
        }
        return TypeSystem.get(object.getClass());
    }

    public Set<String> computeTypeNames() {
        Set<String> allTypeNames = this._classCache.getAllTypeNames();
        allTypeNames.addAll(this._module.getFileRepository().getAllTypeNames(new String[]{".java"}));
        return allTypeNames;
    }

    public URL getResource(String name) {
        return this.getGosuClassLoader().getActualLoader().getResource(name);
    }

    public void refreshedTypesImpl(RefreshRequest request) {
        for (String fullyQualifiedTypeName : request.types) {
            this._classCache.remove(fullyQualifiedTypeName);
            this._classInfoCache.remove(fullyQualifiedTypeName);
        }
        this._module.getFileRepository().typesRefreshed(request);
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public List<String> getHandledPrefixes() {
        return Collections.emptyList();
    }

    public boolean handlesNonPrefixLoads() {
        return true;
    }

    public void refreshedImpl() {
        JavaType.unloadTypes();
        if (ExecutionMode.isRuntime()) {
            this._classCache.clearClasspathInfo();
        } else {
            this._classCache.dispose();
            this._classCache = new ClassCache(this.getModule());
            this.dumpGosuClassLoader();
        }
        this._namespaces = null;
        this._classInfoCache.clear();
        this._module.getFileRepository().typesRefreshed(null);
        JavaTypes.flushCache();
    }

    public void clearMisses() {
        Iterator<Map.Entry<String, IJavaClassInfo>> iterator = this._classInfoCache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, IJavaClassInfo> entry = iterator.next();
            if (entry.getValue() != IJavaClassInfo.NULL_TYPE) continue;
            iterator.remove();
        }
    }

    public Class loadClass(String className) {
        return this._classCache.loadClass(className);
    }

    public AsmClass loadAsmClass(String className) {
        return this._classCache.loadAsmClass(className);
    }

    public boolean classFileExists(String className) {
        return this._classCache.classFileExists(className);
    }

    public IGosuClassLoader getGosuClassLoader() {
        if (this._gosuClassLoader == null) {
            this._gosuClassLoader = new GosuClassLoader(this._module.getModuleClassLoader());
            GosuClassPathThing.init();
        }
        return this._gosuClassLoader;
    }

    void dumpGosuClassLoader() {
        if (this._gosuClassLoader != null) {
            this._gosuClassLoader.dumpAllClasses();
            if (!this.haveWeRecreatedTheModuleLoader()) {
                this._classCache.reassignClassLoader();
            }
            this._gosuClassLoader.assignParent(this._module.getModuleClassLoader());
            GosuClassPathThing.init();
        }
    }

    private boolean haveWeRecreatedTheModuleLoader() {
        ClassLoader gosusLoader = this._gosuClassLoader.getActualLoader();
        for (ClassLoader csr = this._module.getModuleClassLoader(); csr != null; csr = csr.getParent()) {
            if (csr != gosusLoader) continue;
            return false;
        }
        return true;
    }

    public Set<String> getExtensions() {
        return EXTENSIONS;
    }

    public boolean hasNamespace(String namespace) {
        return this._module.getFileRepository().hasNamespace(namespace) > 0 || this._classCache.hasNamespace(namespace);
    }

    public Set<String> getAllNamespaces() {
        if (this._namespaces == null) {
            try {
                this._namespaces = TypeSystem.getNamespacesFromTypeNames((Set)this.getAllTypeNames(), new HashSet());
            }
            catch (NullPointerException e) {
                return Collections.emptySet();
            }
        }
        return this._namespaces;
    }

    public void refreshedNamespace(String namespace, IDirectory dir, RefreshKind kind) {
        if (this._namespaces != null) {
            if (kind == RefreshKind.CREATION) {
                this._namespaces.add(namespace);
            } else if (kind == RefreshKind.DELETION) {
                this._namespaces.remove(namespace);
            }
        }
    }

    public Set<TypeName> getTypeNames(String namespace) {
        HashSet<TypeName> names = new HashSet<TypeName>();
        names.addAll(this._module.getFileRepository().getTypeNames(namespace, Collections.singleton(".java"), (ITypeLoader)this));
        names.addAll(this._classCache.getTypeNames(namespace));
        return names;
    }

    public <T> T getInterface(Class<T> apiInterface) {
        if (apiInterface.getName().equals("editor.plugin.typeloader.ITypeFactory")) {
            try {
                return (T)Class.forName("editor.plugin.typeloader.java.JavaTypeFactory").newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return (T)super.getInterface(apiInterface);
    }
}

