/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.config.ExecutionMode;
import gw.internal.ext.org.objectweb.asm.ClassWriter;
import gw.internal.ext.org.objectweb.asm.MethodVisitor;
import gw.internal.ext.org.objectweb.asm.Type;
import gw.internal.gosu.parser.AbstractExtendedProperty;
import gw.internal.gosu.parser.AbstractExtendedType;
import gw.internal.gosu.parser.ExtendedProperty;
import gw.internal.gosu.parser.ExtendedType;
import gw.internal.gosu.parser.ExtendedTypeData;
import gw.internal.gosu.parser.ExtendedTypeDataFactory;
import gw.internal.gosu.parser.IJavaTypeInternal;
import gw.internal.gosu.parser.JavaPropertyInfo;
import gw.internal.gosu.parser.JavaType;
import gw.lang.parser.ILanguageLevel;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IInjectableClassLoader;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.IJavaPropertyInfo;
import gw.lang.reflect.java.IJavaType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

class JavaTypeExtensions {
    private JavaTypeExtensions() {
    }

    public static IJavaPropertyInfo maybeExtendProperty(JavaPropertyInfo javaProperty) {
        ExtendedTypeDataFactory factory;
        IAnnotationInfo extendedPropertyAnnotation;
        if (ILanguageLevel.Util.STANDARD_GOSU()) {
            return javaProperty;
        }
        JavaPropertyInfo result = javaProperty;
        IJavaClassMethod readMethod = javaProperty.getPropertyDescriptor().getReadMethod();
        if (readMethod != null && (extendedPropertyAnnotation = readMethod.getAnnotation(ExtendedProperty.class)) != null && (factory = JavaTypeExtensions.getExtendedTypeDataFactory((IJavaType)javaProperty.getOwnersType())) != null) {
            ExtendedTypeData extendedTypeInfoData = factory.newPropertyData((IJavaType)javaProperty.getOwnersType(), javaProperty.getName());
            result = JavaTypeExtensions.newExtendedProperty(extendedTypeInfoData.getExtensionInterface(), javaProperty, extendedTypeInfoData.getData());
        }
        return result;
    }

    public static IJavaTypeInternal maybeExtendType(JavaType javaType) {
        if (ILanguageLevel.Util.STANDARD_GOSU()) {
            return javaType;
        }
        IJavaTypeInternal result = javaType;
        ExtendedTypeDataFactory factory = JavaTypeExtensions.getExtendedTypeDataFactory(javaType);
        if (factory != null) {
            ExtendedTypeData extendedTypeInfoData = factory.newTypeData(javaType.getName());
            result = JavaTypeExtensions.newExtendedType(extendedTypeInfoData.getExtensionInterface(), javaType, extendedTypeInfoData.getData());
        }
        return result;
    }

    private static ExtendedTypeDataFactory getExtendedTypeDataFactory(IJavaType javaType) {
        boolean extendedType;
        if (!ExecutionMode.isIDE()) {
            Class backingClass = javaType.getBackingClass();
            extendedType = backingClass.isAnnotationPresent(ExtendedType.class);
        } else {
            extendedType = javaType.getBackingClassInfo().getAnnotation(ExtendedType.class) != null;
        }
        return extendedType ? CommonServices.getEntityAccess().getExtendedTypeDataFactory(javaType.getName()) : null;
    }

    static IJavaTypeInternal newExtendedType(Class<?> secondaryInterface, IJavaTypeInternal originalType, Object secondaryObject) {
        return JavaTypeExtensions.newCompositeInstance(AbstractExtendedType.class, IJavaTypeInternal.class, secondaryInterface, originalType, secondaryObject);
    }

    static IJavaPropertyInfo newExtendedProperty(Class<?> secondaryInterface, IJavaPropertyInfo originalProperty, Object secondaryObject) {
        return JavaTypeExtensions.newCompositeInstance(AbstractExtendedProperty.class, IJavaPropertyInfo.class, secondaryInterface, originalProperty, secondaryObject);
    }

    private static <T> T newCompositeInstance(Class<?> superClass, Class<T> primaryInterface, Class<?> secondaryInterface, T primaryObject, Object secondaryObject) {
        Class<T> compositeClass = JavaTypeExtensions.getCompositeClass(superClass, primaryInterface, secondaryInterface, secondaryObject.getClass());
        try {
            return primaryInterface.cast(compositeClass.getConstructors()[0].newInstance(primaryObject, secondaryObject));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(String.format("Couldn't create an instance of %s with arguments (%s, %s)", compositeClass, primaryObject, secondaryObject), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(String.format("Couldn't create an instance of %s with arguments (%s, %s)", compositeClass, primaryObject, secondaryObject), e.getTargetException());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> Class<? extends T> getCompositeClass(Class<?> superClass, Class<T> primaryInterface, Class<?> secondaryInterface, Class<?> secondaryObjectClass) {
        try {
            return JavaTypeExtensions.loadCompositeClass(primaryInterface, secondaryObjectClass);
        }
        catch (ClassNotFoundException notFound) {
            TypeSystem.lock();
            try {
                Class<T> clazz = JavaTypeExtensions.loadCompositeClass(primaryInterface, secondaryObjectClass);
                return clazz;
            }
            catch (ClassNotFoundException stillNotFound) {
                JavaTypeExtensions.defineCompositeClass(superClass, primaryInterface, secondaryInterface, secondaryObjectClass);
                try {
                    Class<T> clazz = JavaTypeExtensions.loadCompositeClass(primaryInterface, secondaryObjectClass);
                    return clazz;
                }
                catch (ClassNotFoundException uhOh) {
                    throw new IllegalStateException(String.format("Could not load extended type proxy class '%s' with primary interface '%s' and secondary interface '%s'", JavaTypeExtensions.getCompositeClassName(secondaryObjectClass), primaryInterface.getName(), secondaryInterface.getName()));
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
    }

    private static <T> Class<? extends T> loadCompositeClass(Class<T> primaryInterface, Class<?> secondaryObjectClass) throws ClassNotFoundException {
        return Class.forName(JavaTypeExtensions.getCompositeClassName(secondaryObjectClass), true, secondaryObjectClass.getClassLoader()).asSubclass(primaryInterface);
    }

    private static String getCompositeClassName(Class<?> secondaryObjectClass) {
        return secondaryObjectClass.getName() + "_ExtendedJavaTypeProxy";
    }

    private static void defineCompositeClass(Class<?> superClass, Class<?> primaryInterface, Class<?> secondaryInterface, Class<?> secondaryObjectClass) {
        String className = JavaTypeExtensions.getCompositeClassName(secondaryObjectClass);
        String classInternalName = className.replace('.', '/');
        ClassWriter classWriter = new ClassWriter(3);
        classWriter.visit(52, 49, classInternalName, null, Type.getInternalName(superClass), new String[]{Type.getInternalName(primaryInterface), Type.getInternalName(secondaryInterface)});
        classWriter.visitField(18, "_secondary", Type.getDescriptor(secondaryObjectClass), null, null);
        classWriter.visitEnd();
        MethodVisitor constructor = classWriter.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(primaryInterface), Type.getType(secondaryObjectClass)}), null, null);
        constructor.visitCode();
        constructor.visitVarInsn(25, 0);
        constructor.visitVarInsn(25, 1);
        constructor.visitMethodInsn(183, Type.getInternalName(superClass), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(primaryInterface)}), false);
        constructor.visitVarInsn(25, 0);
        constructor.visitVarInsn(25, 2);
        constructor.visitFieldInsn(181, classInternalName, "_secondary", Type.getDescriptor(secondaryObjectClass));
        constructor.visitInsn(177);
        constructor.visitMaxs(0, 0);
        constructor.visitEnd();
        HashSet<String> signatures = new HashSet<String>();
        for (Method method : primaryInterface.getMethods()) {
            JavaTypeExtensions.implementMethodViaDelegation(classWriter, Type.getInternalName(superClass), method, "_primary", primaryInterface, signatures);
        }
        for (Method method : secondaryInterface.getMethods()) {
            JavaTypeExtensions.implementMethodViaDelegation(classWriter, classInternalName, method, "_secondary", secondaryObjectClass, signatures);
        }
        byte[] bytes = classWriter.toByteArray();
        ClassLoader classLoader = secondaryInterface.getClassLoader();
        if (classLoader instanceof IInjectableClassLoader) {
            ((IInjectableClassLoader)classLoader).defineClass(className, bytes);
        } else {
            try {
                Method method = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                method.setAccessible(true);
                method.invoke((Object)classLoader, className, bytes, 0, bytes.length);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void implementMethodViaDelegation(ClassWriter classWriter, String fieldOwnerInternalName, Method method, String fieldName, Class<?> fieldType, Set<String> signatures) {
        if (!signatures.add(method.getName() + Type.getMethodDescriptor((Method)method))) {
            return;
        }
        MethodVisitor methodBuilder = classWriter.visitMethod(1, method.getName(), Type.getMethodDescriptor((Method)method), null, JavaTypeExtensions.toInternalNames(method.getExceptionTypes()));
        methodBuilder.visitCode();
        methodBuilder.visitVarInsn(25, 0);
        methodBuilder.visitFieldInsn(180, fieldOwnerInternalName, fieldName, Type.getDescriptor(fieldType));
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            methodBuilder.visitVarInsn(Type.getType(parameterTypes[i]).getOpcode(21), i + 1);
        }
        methodBuilder.visitMethodInsn(fieldType.isInterface() ? 185 : 182, Type.getInternalName(fieldType), method.getName(), Type.getMethodDescriptor((Method)method), fieldType.isInterface());
        if (Void.TYPE.equals(method.getReturnType())) {
            methodBuilder.visitInsn(177);
        } else {
            methodBuilder.visitInsn(Type.getType(method.getReturnType()).getOpcode(172));
        }
        methodBuilder.visitMaxs(0, 0);
        methodBuilder.visitEnd();
    }

    private static String[] toInternalNames(Class<?>[] classes) {
        return (String[])Arrays.asList(classes).stream().map(Type::getInternalName).toArray(String[]::new);
    }
}

