/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.internal.gosu.parser.AnnotationConstructorGenerator;
import gw.internal.gosu.parser.CompiledGosuClassSymbolTable;
import gw.internal.gosu.parser.GosuClassCompilingStack;
import gw.internal.gosu.parser.GosuClassTypeInfo;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.JavaBaseFeatureInfo;
import gw.internal.gosu.parser.JavaConstructorInfo;
import gw.internal.gosu.parser.JavaFieldPropertyInfo;
import gw.internal.gosu.parser.JavaMethodInfo;
import gw.internal.gosu.parser.JavaPropertyInfo;
import gw.internal.gosu.parser.TypeLord;
import gw.lang.GosuShop;
import gw.lang.SimplePropertyProcessing;
import gw.lang.javadoc.IClassDocNode;
import gw.lang.javadoc.IDocRef;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.Keyword;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.reflect.FeatureManager;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IEventInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.ILocationInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.TypeInfoUtil;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.java.IJavaAnnotatedElement;
import gw.lang.reflect.java.IJavaClassConstructor;
import gw.lang.reflect.java.IJavaClassField;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaMethodDescriptor;
import gw.lang.reflect.java.IJavaMethodInfo;
import gw.lang.reflect.java.IJavaPropertyDescriptor;
import gw.lang.reflect.java.IJavaPropertyInfo;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.IJavaTypeInfo;
import gw.lang.reflect.java.JavaSourceElement;
import gw.util.concurrent.LockingLazyVar;
import java.beans.IndexedPropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class JavaTypeInfo
extends JavaBaseFeatureInfo
implements IJavaTypeInfo {
    private final IType _type;
    private final IJavaClassInfo _backingClass;
    private WeakReference<IClassDocNode> _classDocumentation;
    private LockingLazyVar<List<IPropertyInfo>> _declaredProperties;
    private LockingLazyVar<List<IJavaMethodInfo>> _declaredMethods;
    private LockingLazyVar<List<IConstructorInfo>> _allCtors;
    private JavaFeatureManager _fm;
    private final ReentrantLock _myLock = new ReentrantLock();
    private IDocRef<IClassDocNode> _docRef = new IDocRef<IClassDocNode>(){

        public IClassDocNode get() {
            JavaTypeInfo.this._myLock.lock();
            try {
                IClassDocNode classDoc;
                IClassDocNode iClassDocNode = classDoc = JavaTypeInfo.this._classDocumentation == null ? null : (IClassDocNode)JavaTypeInfo.this._classDocumentation.get();
                if (classDoc == null) {
                    classDoc = JavaTypeInfo.this._backingClass.createClassDocNode();
                    if (classDoc == null) {
                        classDoc = GosuShop.getJavaDocFactory().create();
                    }
                    JavaTypeInfo.this._classDocumentation = new WeakReference<IClassDocNode>(classDoc);
                }
                IClassDocNode iClassDocNode2 = classDoc;
                return iClassDocNode2;
            }
            finally {
                JavaTypeInfo.this._myLock.unlock();
            }
        }
    };

    public JavaTypeInfo(IType intrType, IJavaClassInfo backingClass) {
        super(intrType);
        this._type = intrType;
        this._backingClass = backingClass;
        this._fm = new JavaFeatureManager((IRelativeTypeInfo)this);
        this._declaredProperties = new LockingLazyVar<List<IPropertyInfo>>(){

            protected List<IPropertyInfo> init() {
                List<IPropertyInfo> ret;
                IJavaPropertyDescriptor[] properties = JavaTypeInfo.this._backingClass.getPropertyDescriptors();
                if (properties == null) {
                    ret = Collections.emptyList();
                } else {
                    ret = new ArrayList();
                    for (IJavaPropertyDescriptor property : properties) {
                        IJavaPropertyInfo pi;
                        IndexedPropertyDescriptor indexedProp;
                        if (property instanceof IndexedPropertyDescriptor && (indexedProp = (IndexedPropertyDescriptor)property).getPropertyType() == null || !(pi = JavaPropertyInfo.newInstance((IFeatureInfo)JavaTypeInfo.this, property)).isReadable()) continue;
                        ret.add((IPropertyInfo)pi);
                    }
                    this.addFieldProperties(ret);
                    this.addArrayProperties(ret);
                    ret = Collections.unmodifiableList(ret);
                }
                return ret;
            }

            private void addArrayProperties(List<IPropertyInfo> ret) {
                if (JavaTypeInfo.this.getOwnersType().isArray()) {
                    Iterator<IPropertyInfo> iterator = ret.iterator();
                    while (iterator.hasNext()) {
                        IPropertyInfo propertyInfo = iterator.next();
                        if (!propertyInfo.getName().equals(Keyword.KW_length.toString())) continue;
                        iterator.remove();
                    }
                    IPropertyInfo lengthProperty = GosuShop.createPropertyDelegate((IFeatureInfo)JavaTypeInfo.this, (IPropertyInfo)GosuShop.createLengthProperty((ITypeInfo)JavaTypeInfo.this));
                    ret.add(lengthProperty);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void addFieldProperties(List<IPropertyInfo> properties) {
                TypeSystem.lock();
                try {
                    Object[] fields;
                    boolean simplePropertyProcessing = JavaTypeInfo.this._backingClass.getAnnotation(SimplePropertyProcessing.class) != null;
                    for (IJavaClassField iJavaClassField : fields = JavaTypeInfo.this._backingClass.getDeclaredFields()) {
                        int pos;
                        TypeVarToTypeMap actualParamByVarName;
                        if (iJavaClassField.isSynthetic()) continue;
                        if (Modifier.isStatic(iJavaClassField.getModifiers())) {
                            actualParamByVarName = TypeLord.mapTypeByVarName(JavaTypeInfo.this.getOwnersType(), JavaTypeInfo.this.getOwnersType());
                            JavaFieldPropertyInfo staticProp = new JavaFieldPropertyInfo((IFeatureInfo)JavaTypeInfo.this, iJavaClassField.getGenericType().getActualType(actualParamByVarName, true), iJavaClassField, true, simplePropertyProcessing);
                            pos = this.getPosition(properties, staticProp.getName());
                            if (pos == -1 || properties.get(pos).isStatic()) {
                                if (pos == -1) {
                                    properties.add((IPropertyInfo)staticProp);
                                    continue;
                                }
                                properties.set(pos, (IPropertyInfo)staticProp);
                                continue;
                            }
                            staticProp.changeNameForNonStaticCollision();
                            properties.add((IPropertyInfo)staticProp);
                            continue;
                        }
                        if (JavaTypeInfo.this._backingClass.hasCustomBeanInfo()) continue;
                        actualParamByVarName = TypeLord.mapTypeByVarName(JavaTypeInfo.this.getOwnersType(), JavaTypeInfo.this.getOwnersType());
                        if (iJavaClassField == null) {
                            throw new IllegalStateException("A null field was found for " + JavaTypeInfo.this._backingClass.getName() + " : " + Arrays.toString(fields));
                        }
                        if (iJavaClassField.getGenericType() == null) {
                            throw new IllegalStateException("The generic type for the field " + iJavaClassField.getName() + " on " + JavaTypeInfo.this._backingClass.getName() + " was null");
                        }
                        JavaFieldPropertyInfo prop = new JavaFieldPropertyInfo((IFeatureInfo)JavaTypeInfo.this, iJavaClassField.getGenericType().getActualType(actualParamByVarName, true), iJavaClassField, false, simplePropertyProcessing);
                        pos = this.getPosition(properties, prop.getName());
                        if (pos != -1 && !(properties.get(pos) instanceof JavaFieldPropertyInfo)) continue;
                        if (pos == -1) {
                            properties.add((IPropertyInfo)prop);
                            continue;
                        }
                        properties.set(pos, (IPropertyInfo)prop);
                    }
                }
                finally {
                    TypeSystem.unlock();
                }
            }

            private int getPosition(List<IPropertyInfo> properties, String name) {
                for (int i = 0; i < properties.size(); ++i) {
                    IPropertyInfo propertyInfo = properties.get(i);
                    if (!propertyInfo.getName().equals(name)) continue;
                    return i;
                }
                return -1;
            }
        };
        this._declaredMethods = new LockingLazyVar<List<IJavaMethodInfo>>(){

            protected List<IJavaMethodInfo> init() {
                List<IJavaMethodInfo> ret;
                IJavaMethodDescriptor[] methods = JavaTypeInfo.this._backingClass.getMethodDescriptors();
                if (methods == null) {
                    ret = Collections.emptyList();
                } else {
                    ret = new ArrayList<IJavaMethodInfo>(methods.length);
                    for (IJavaMethodDescriptor method : methods) {
                        ret.add(new JavaMethodInfo((IFeatureInfo)JavaTypeInfo.this, method, !Modifier.isStatic(method.getMethod().getModifiers()) && JavaTypeInfo.this.isPropertyMethod(method)));
                    }
                    ((ArrayList)ret).trimToSize();
                    ret = Collections.unmodifiableList(ret);
                }
                return ret;
            }
        };
        this._allCtors = new LockingLazyVar<List<IConstructorInfo>>(){

            protected List<IConstructorInfo> init() {
                List constructors;
                if (JavaTypeInfo.this._backingClass.isAnnotation()) {
                    return AnnotationConstructorGenerator.generateAnnotationConstructors((IRelativeTypeInfo)JavaTypeInfo.this);
                }
                IJavaClassConstructor[] ctors = JavaTypeInfo.this._backingClass.getDeclaredConstructors();
                if (ctors == null) {
                    constructors = Collections.emptyList();
                } else {
                    constructors = new ArrayList<IConstructorInfo>(ctors.length);
                    for (IJavaClassConstructor ctor : ctors) {
                        try {
                            constructors.add(new JavaConstructorInfo((IFeatureInfo)JavaTypeInfo.this, ctor));
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                    constructors = TypeInfoUtil.makeSortedUnmodifiableRandomAccessList(constructors);
                }
                return constructors;
            }
        };
    }

    private boolean isPropertyMethod(IJavaMethodDescriptor md) {
        String name = md.getName();
        int paramCount = md.getMethod().getParameterTypes().length;
        if (paramCount > 1) {
            return false;
        }
        String propName = null;
        boolean bSetter = name.startsWith("set");
        if (paramCount == 0 && name.startsWith("get") || bSetter && paramCount == 1) {
            propName = name.substring(3);
        } else if (paramCount == 0 && name.startsWith("is")) {
            propName = name.substring(2);
        }
        if (propName != null) {
            for (IPropertyInfo propertyInfo : (List)this._declaredProperties.get()) {
                if (!propertyInfo.getName().equals(propName) || propertyInfo instanceof IJavaPropertyInfo && (bSetter || !((IJavaPropertyInfo)propertyInfo).getPropertyDescriptor().getReadMethod().getName().equals(md.getMethod().getName()))) continue;
                return true;
            }
        }
        return false;
    }

    public void unload() {
        TypeSystem.lock();
        try {
            this._declaredMethods.clear();
            this._declaredProperties.clear();
            this._fm = new JavaFeatureManager((IRelativeTypeInfo)this);
        }
        finally {
            TypeSystem.unlock();
        }
    }

    @Override
    protected IJavaAnnotatedElement getAnnotatedElement() {
        return this._backingClass;
    }

    @Override
    protected boolean isVisibleViaFeatureDescriptor(IScriptabilityModifier constraint) {
        return this._backingClass.isVisibleViaFeatureDescriptor(constraint);
    }

    @Override
    protected boolean isHiddenViaFeatureDescriptor() {
        return this._backingClass.isHiddenViaFeatureDescriptor();
    }

    public IRelativeTypeInfo.Accessibility getAccessibilityForType(IType whosaskin) {
        return this.getAccessibilityForClass(this._type, whosaskin == null ? JavaTypeInfo.getCompilingClass(this._type) : whosaskin);
    }

    public List<? extends IPropertyInfo> getProperties() {
        return this.getProperties(null);
    }

    public List<IPropertyInfo> getProperties(IType whosAskin) {
        return this._fm.getProperties(this.getAccessibilityForType(whosAskin));
    }

    public IPropertyInfo getProperty(CharSequence propName) {
        return this.getProperty(null, propName);
    }

    public IPropertyInfo getProperty(IType whosAskin, CharSequence propName) {
        return this._fm.getProperty(this.getAccessibilityForType(whosAskin), propName);
    }

    public MethodList getMethods() {
        return this.getMethods(null);
    }

    public MethodList getMethods(IType whosAskin) {
        return this._fm.getMethods(this.getAccessibilityForType(whosAskin));
    }

    public List<? extends IConstructorInfo> getConstructors() {
        return this.getConstructors(null);
    }

    public List<? extends IConstructorInfo> getConstructors(IType whosAskin) {
        return this._fm.getConstructors(this.getAccessibilityForType(whosAskin));
    }

    public IMethodInfo getMethod(CharSequence methodName, IType ... params) {
        return ITypeInfo.FIND.method((MethodList)this.getMethods(), (CharSequence)methodName, (IType[])params);
    }

    public IMethodInfo getMethod(IType whosaskin, CharSequence methodName, IType ... params) {
        MethodList methods = this.getMethods(whosaskin);
        return ITypeInfo.FIND.method((MethodList)methods, (CharSequence)methodName, (IType[])params);
    }

    public IConstructorInfo getConstructor(IType ... params) {
        return ITypeInfo.FIND.constructor(this.getConstructors(), (IType[])params);
    }

    public IConstructorInfo getConstructor(IType whosAskin, IType[] params) {
        List<? extends IConstructorInfo> ctors = this.getConstructors(whosAskin);
        return ITypeInfo.FIND.constructor(ctors, (IType[])params);
    }

    public List<? extends IPropertyInfo> getDeclaredProperties() {
        return (List)this._declaredProperties.get();
    }

    public List<? extends IMethodInfo> getDeclaredMethods() {
        return (List)this._declaredMethods.get();
    }

    public List<? extends IConstructorInfo> getDeclaredConstructors() {
        return (List)this._allCtors.get();
    }

    public IMethodInfo getCallableMethod(CharSequence strMethod, IType ... params) {
        return ITypeInfo.FIND.callableMethod((MethodList)this.getMethods(), (CharSequence)strMethod, (IType[])params);
    }

    public IConstructorInfo getCallableConstructor(IType ... params) {
        return ITypeInfo.FIND.callableConstructor(this.getConstructors(), (IType[])params);
    }

    public List<IEventInfo> getEvents() {
        return Collections.emptyList();
    }

    public IEventInfo getEvent(CharSequence strEvent) {
        return null;
    }

    public String getName() {
        return this._backingClass.getRelativeName();
    }

    public String getDisplayName() {
        return CommonServices.getEntityAccess().getLocalizedTypeInfoName(this._type);
    }

    public String getDescription() {
        if (this.getDocNode().get() != null && ((IClassDocNode)this.getDocNode().get()).getDescription() != null) {
            return ((IClassDocNode)this.getDocNode().get()).getDescription();
        }
        return null;
    }

    public boolean isDeprecated() {
        return super.isDeprecated() || this._backingClass.isAnnotationPresent(Deprecated.class);
    }

    @Override
    public List<IAnnotationInfo> getDeclaredAnnotations() {
        List<IAnnotationInfo> annotations = super.getDeclaredAnnotations();
        String deprecatedWarningToAdd = null;
        if (this.getDocNode().get() != null && ((IClassDocNode)this.getDocNode().get()).isDeprecated()) {
            deprecatedWarningToAdd = ((IClassDocNode)this.getDocNode().get()).getDeprecated();
        }
        if (deprecatedWarningToAdd != null) {
            annotations.add(GosuShop.getAnnotationInfoFactory().createJavaAnnotation((Annotation)this.makeDeprecated(deprecatedWarningToAdd), (IFeatureInfo)this));
        }
        return annotations;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    protected boolean isDefaultEnumFeature() {
        return false;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this._type.getModifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this._type.getModifiers());
    }

    public boolean isInternal() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public boolean isProtected() {
        return Modifier.isProtected(this._type.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this._type.getModifiers());
    }

    private IRelativeTypeInfo.Accessibility getAccessibilityForClass(IType ownersClass, IType whosAskin) {
        IJavaType javaType;
        if (GosuClassTypeInfo.isIncludeAll()) {
            return IRelativeTypeInfo.Accessibility.PRIVATE;
        }
        if (ownersClass == null || whosAskin == null) {
            return IRelativeTypeInfo.Accessibility.PUBLIC;
        }
        if (whosAskin instanceof IGosuClassInternal && ((IGosuClassInternal)whosAskin).isProxy() && (javaType = ((IGosuClassInternal)whosAskin).getJavaType()) != null) {
            whosAskin = javaType;
        }
        if (ownersClass == whosAskin) {
            return IRelativeTypeInfo.Accessibility.PRIVATE;
        }
        if (FeatureManager.isInSameNamespace((IType)ownersClass, (IType)whosAskin)) {
            return IRelativeTypeInfo.Accessibility.INTERNAL;
        }
        if (IGosuClass.ProxyUtil.isProxyStart((String)whosAskin.getNamespace())) {
            IType genOwnerType = TypeLord.getPureGenericType(ownersClass);
            String strGenericOwnerClass = genOwnerType.getName();
            if (IGosuClass.ProxyUtil.getNameSansProxy((IType)whosAskin).equals(strGenericOwnerClass)) {
                return IRelativeTypeInfo.Accessibility.INTERNAL;
            }
            if (genOwnerType.getRelativeName().startsWith("_java_")) {
                return IRelativeTypeInfo.Accessibility.INTERNAL;
            }
        }
        if (FeatureManager.isInEnclosingClassHierarchy((IType)ownersClass, (IType)whosAskin)) {
            return IRelativeTypeInfo.Accessibility.PROTECTED;
        }
        return IRelativeTypeInfo.Accessibility.PUBLIC;
    }

    public static IType getCompilingClass(IType type) {
        IType thisSymbolType;
        ISymbolTable symTableCtx;
        ISymbol thisSymbol;
        if (GosuClassTypeInfo.isIncludeAll()) {
            return type;
        }
        IType compilingClass = GosuClassCompilingStack.getCurrentCompilingType();
        if (compilingClass == null && (thisSymbol = (symTableCtx = CompiledGosuClassSymbolTable.getSymTableCtx()).getThisSymbolFromStackOrMap()) != null && (thisSymbolType = thisSymbol.getType()) instanceof IGosuClassInternal) {
            compilingClass = thisSymbolType;
        }
        if (IGosuClass.ProxyUtil.isProxy((IType)compilingClass)) {
            return compilingClass;
        }
        return null;
    }

    IDocRef<IClassDocNode> getDocNode() {
        return this._docRef;
    }

    public ILocationInfo getLocationInfo() {
        IJavaClassInfo classInfo = ((IJavaType)this.getOwnersType()).getBackingClassInfo();
        if (classInfo instanceof JavaSourceElement) {
            return classInfo.getLocationInfo();
        }
        return super.getLocationInfo();
    }

    private static class JavaFeatureManager
    extends FeatureManager {
        public JavaFeatureManager(IRelativeTypeInfo type) {
            super(type, true, type.getOwnersType().isInterface() && type.getOwnersType().getSupertype() == null);
        }
    }
}

