/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.IGosuAnnotation;
import gw.lang.reflect.IModifierInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ModifierInfo
implements IModifierInfo {
    private int _iModifiers;
    private List<IGosuAnnotation> _annotations;
    private String _description;

    public ModifierInfo(int iModifiers) {
        this._iModifiers = iModifiers;
        this._annotations = Collections.emptyList();
    }

    public int getModifiers() {
        return this._iModifiers;
    }

    public void syncAnnotations(IModifierInfo from) {
        if (from instanceof ModifierInfo) {
            ModifierInfo fromAnn = (ModifierInfo)from;
            List<IGosuAnnotation> annotations = fromAnn.getAnnotations();
            if (this.getAnnotations().size() == annotations.size()) {
                this.setAnnotations(annotations);
            }
        }
    }

    public void setModifiers(int iModifiers) {
        this._iModifiers = iModifiers;
    }

    public List<IGosuAnnotation> getAnnotations() {
        return this._annotations;
    }

    public void setAnnotations(List<IGosuAnnotation> annotations) {
        this._annotations = annotations;
    }

    public void addModifiers(int iModifiers) {
        this._iModifiers |= iModifiers;
    }

    public void removeModifiers(int iModifiers) {
        this._iModifiers &= ~iModifiers;
    }

    public void addAnnotation(IGosuAnnotation annotation) {
        if (this._annotations.isEmpty()) {
            this._annotations = new ArrayList<IGosuAnnotation>(2);
        }
        this._annotations.add(annotation);
    }

    private void addAnnotations(List<IGosuAnnotation> annotations) {
        if (this._annotations.isEmpty()) {
            this._annotations = new ArrayList<IGosuAnnotation>(annotations.size());
        }
        this._annotations.addAll(annotations);
    }

    public void addAll(ModifierInfo modifiers) {
        if (modifiers == null) {
            return;
        }
        this.addModifiers(modifiers.getModifiers());
        this.addAnnotations(modifiers.getAnnotations());
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String fullDescription) {
        this._description = fullDescription;
    }

    public void update(ModifierInfo modifiers) {
        this._annotations = modifiers.getAnnotations();
        this._description = modifiers.getDescription();
        this._iModifiers = modifiers.getModifiers();
    }
}

