/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.internal.gosu.ir.transform.AbstractElementTransformer;
import gw.internal.gosu.parser.AbstractDynamicSymbol;
import gw.internal.gosu.parser.BeanAccess;
import gw.internal.gosu.parser.BlockClass;
import gw.internal.gosu.parser.CompiledGosuClassSymbolTable;
import gw.internal.gosu.parser.DocCommentBlock;
import gw.internal.gosu.parser.DynamicPropertySymbol;
import gw.internal.gosu.parser.DynamicSymbol;
import gw.internal.gosu.parser.ErrorType;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.GosuAnnotation;
import gw.internal.gosu.parser.GosuParser;
import gw.internal.gosu.parser.IBlockClassInternal;
import gw.internal.gosu.parser.ICompilableTypeInternal;
import gw.internal.gosu.parser.IGosuAnnotation;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.IGosuEnhancementInternal;
import gw.internal.gosu.parser.LazyLightweightParserState;
import gw.internal.gosu.parser.LightweightParserState;
import gw.internal.gosu.parser.ModifierInfo;
import gw.internal.gosu.parser.NamespaceType;
import gw.internal.gosu.parser.ParseTree;
import gw.internal.gosu.parser.ParsedElement;
import gw.internal.gosu.parser.QueryPathRootSymbol;
import gw.internal.gosu.parser.SourceCodeTokenizer;
import gw.internal.gosu.parser.StandardParserState;
import gw.internal.gosu.parser.Statement;
import gw.internal.gosu.parser.Symbol;
import gw.internal.gosu.parser.Token;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.expressions.AnnotationExpression;
import gw.internal.gosu.parser.expressions.AnnotationUseSiteTargetClause;
import gw.internal.gosu.parser.expressions.ArithmeticExpression;
import gw.internal.gosu.parser.expressions.BlockExpression;
import gw.internal.gosu.parser.expressions.DefaultArgLiteral;
import gw.internal.gosu.parser.expressions.Identifier;
import gw.internal.gosu.parser.expressions.ImplicitTypeAsExpression;
import gw.internal.gosu.parser.expressions.ModifierListClause;
import gw.internal.gosu.parser.expressions.NotAWordExpression;
import gw.internal.gosu.parser.expressions.NullExpression;
import gw.internal.gosu.parser.expressions.StringLiteral;
import gw.internal.gosu.parser.expressions.TypeAsExpression;
import gw.internal.gosu.parser.expressions.TypeLiteral;
import gw.internal.gosu.parser.statements.ClassFileStatement;
import gw.internal.gosu.parser.statements.ClassStatement;
import gw.internal.gosu.parser.statements.HideFieldNoOpStatement;
import gw.internal.gosu.parser.statements.VarStatement;
import gw.lang.annotation.UsageModifier;
import gw.lang.annotation.UsageTarget;
import gw.lang.parser.AnnotationUseSiteTarget;
import gw.lang.parser.GosuParserTypes;
import gw.lang.parser.ICapturedSymbol;
import gw.lang.parser.ICoercer;
import gw.lang.parser.ICoercionManager;
import gw.lang.parser.IFullParserState;
import gw.lang.parser.IFunctionSymbol;
import gw.lang.parser.IGosuValidator;
import gw.lang.parser.INonCapturableSymbol;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IParserPart;
import gw.lang.parser.IParserState;
import gw.lang.parser.IResolvingCoercer;
import gw.lang.parser.IScope;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.ISourceCodeTokenizer;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.IToken;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.parser.Keyword;
import gw.lang.parser.ScriptPartId;
import gw.lang.parser.StandardCoercionManager;
import gw.lang.parser.StandardScope;
import gw.lang.parser.exceptions.ImplicitCoercionError;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.parser.exceptions.ParseIssue;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.parser.exceptions.ParseWarning;
import gw.lang.parser.exceptions.SymbolNotFoundException;
import gw.lang.parser.expressions.IBlockExpression;
import gw.lang.parser.expressions.IOverridableOperation;
import gw.lang.parser.resources.Res;
import gw.lang.parser.resources.ResourceKey;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IErrorType;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.INamespaceType;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeVariableType;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ICompilableType;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.module.IModule;
import gw.util.Stack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ParserBase
implements IParserPart {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final IParserState PLACEHOLDER_PARSER_STATE = new PlaceholderParserState();
    private static final INamespaceType PROGRAM_NAMESPACE = new NamespaceType("program_", null);
    private boolean _snapshotSymbols;
    private GosuParser _owner;
    Stack<BlockExpression> _blocks;
    private IGosuValidator _validator;
    protected int _offsetShift;
    private int _lineNumShift;
    protected boolean _bDontOptimizeStatementLists;
    private List<IParseTree> _subTree;
    private Stack<List<IType>> _inferringFunctionTypes = new Stack();
    private static final NotAWordExpression NOT_SET_EXPRESSION = new NotAWordExpression();
    private Set<ResourceKey> _ignoreWarnings;

    public ParserBase() {
        this(null);
    }

    public ParserBase(GosuParser owner) {
        this._owner = owner;
    }

    public GosuParser getOwner() {
        return this._owner;
    }

    protected void setOwner(GosuParser owner) {
        this._owner = owner;
    }

    public void setIgnoreWarnings(Set<ResourceKey> msgKeys) {
        this._ignoreWarnings = msgKeys;
    }

    SourceCodeTokenizer getTokenizer() {
        return this._owner.getTokenizer();
    }

    ISymbolTable getSymbolTable() {
        return this._owner.getSymbolTable();
    }

    void setLocation(int iOffset, int iLineNum, int iColumn) {
        this.setLocation(iOffset, iLineNum, iColumn, false);
    }

    void setLocation(int iOffset, int iLineNum, int iColumn, boolean bForceRedundancy) {
        this.setLocation(iOffset, iLineNum, iColumn, false, bForceRedundancy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLocation(int iOffset, int iLineNum, int iColumn, boolean bZeroLength, boolean bForceRedundancy) {
        int iLength;
        if (iOffset == -1) {
            iOffset = 0;
        }
        if (iOffset < 0) {
            throw new IllegalArgumentException(iOffset + " is out of bounds");
        }
        ParsedElement e = this.getOwner().peekParsedElement();
        Token priorToken = e instanceof ClassFileStatement && this.getTokenizer().isEOF() ? this.getTokenizer().getCurrentToken() : this.getTokenizer().getPriorToken();
        int n = iLength = bZeroLength ? 0 : priorToken.getTokenEnd() - iOffset;
        if (iLength < 0) {
            iLength = 0;
        }
        if (e != null && (e.getLocation() == null || e.getLocation().getLength() > 0 || e instanceof ClassStatement)) {
            ParseTree node = e.initLocation(iOffset, iLength, iLineNum, iColumn, this.getOwner().getScriptPart());
            ParseTree location = this.addLocation(node, bForceRedundancy);
            e.setLocation(location);
            if (this._subTree != null) {
                try {
                    for (IParseTree childLocation : this._subTree) {
                        childLocation.addUnder((IParseTree)location);
                        childLocation.getParsedElement().setParent((IParsedElement)location.getParsedElement());
                    }
                }
                finally {
                    this._subTree = null;
                }
            }
        }
    }

    private ParseTree addLocation(ParseTree location, boolean bForceRedundancy) {
        List<ParseTree> locationsList = this.getLocationsList();
        int iLast = location.getChildCount();
        for (int i = locationsList.size() - 1; i >= 0; --i) {
            ParseTree l = locationsList.get(i);
            if (l.getParsedElement() == location.getParsedElement()) {
                return l;
            }
            if (location.getLength() == 0 || !location.contains(l) && (l.getLength() != 0 || l.getOffset() <= location.getOffset())) break;
            if (!bForceRedundancy && l.contains(location) && (!(location.getParsedElement() instanceof Statement) || l.getParsedElement() instanceof Statement)) {
                return l;
            }
            ParseTree tree = locationsList.remove(i);
            location.addChild(iLast, tree);
        }
        if (!(location.getParsedElement() instanceof HideFieldNoOpStatement)) {
            locationsList.add(location);
        }
        return location;
    }

    List<ParseTree> getLocationsList() {
        return this.getOwner().getLocationsList();
    }

    protected void pushExpression(Expression e) {
        this.getOwner().pushExpression(e);
    }

    protected void verifyParsedElement(IParsedElement element) throws ParseResultsException {
        this.verifyParsedElement(element, this.getOwner().isThrowParseResultsExceptionForWarnings());
    }

    protected void verifyParsedElement(IParsedElement element, boolean bThrowOnWarnings) throws ParseResultsException {
        IGosuValidator validator = this.getValidator();
        if (validator != null) {
            validator.validate(element, this.getScript());
        }
        List issues = element.getParseIssues();
        boolean hasParseException = false;
        boolean hasParseWarning = false;
        for (IParseIssue issue : issues) {
            if (issue instanceof ParseException) {
                hasParseException = true;
            } else {
                hasParseWarning = true;
            }
            issue.resolve((IParserPart)this);
        }
        if (hasParseException || bThrowOnWarnings && hasParseWarning) {
            ParseResultsException resultsException = new ParseResultsException(element);
            resultsException.setContextType((ICompilableType)this.getOwner().getGosuClass());
            throw resultsException;
        }
    }

    protected abstract String getScript();

    protected Expression popExpression() {
        return this.getOwner().popExpression();
    }

    protected Expression peekExpression() {
        return this.getOwner().peekExpression();
    }

    protected void pushStatement(Statement stmt) {
        this.getOwner().pushStatement(stmt);
    }

    protected Statement popStatement() {
        return this.getOwner().popStatement();
    }

    protected Statement peekStatement() {
        return this.getOwner().peekStatement();
    }

    boolean eatStatementBlock(ParsedElement parsedElement, ResourceKey errorKey) {
        this.verify(parsedElement, this.match(null, 123), errorKey, new String[0]);
        return this.eatBlock('{', '}', false) != null;
    }

    boolean eatPossibleStatementBlock() {
        if (this.match(null, 123)) {
            this.eatBlock('{', '}', false);
            return true;
        }
        return false;
    }

    boolean eatPossibleEnclosedVarInStmt() {
        if ((this.match(null, Keyword.KW_for) || this.match(null, Keyword.KW_foreach) || this.match(null, Keyword.KW_using)) && this.match(null, 40)) {
            this.eatBlock('(', ')', false);
            return true;
        }
        return false;
    }

    void eatParenthesized(ParsedElement parsedElement, ResourceKey errorKey) {
        this.verify(parsedElement, this.match(null, 40), errorKey, new String[0]);
        this.eatBlock('(', ')', false);
    }

    void eatPossibleParametarization() {
        this.eatPossibleParametarization(true);
    }

    void eatPossibleParametarization(boolean bMatchStart) {
        if (!bMatchStart || this.match(null, "<", -6)) {
            this.eatBlock('<', '>', true);
        }
    }

    void eatPossibleArrayBrackets() {
        this.eatPossibleArrayBrackets(true);
    }

    void eatPossibleArrayBrackets(boolean bMatchStart) {
        if (!bMatchStart || this.match(null, 91)) {
            this.eatBlock('[', ']', false);
        }
    }

    public final Token eatBlock(char cBegin, char cEnd, boolean bOperator) {
        return (Token)IParserPart.eatBlock((char)cBegin, (char)cEnd, (boolean)bOperator, (ISourceCodeTokenizer)this.getTokenizer());
    }

    public final Token eatBlock(char cBegin, char cEnd, boolean bOperator, boolean bStopAtDeclarationKeyword) {
        return (Token)IParserPart.eatBlock((char)cBegin, (char)cEnd, (boolean)bOperator, (boolean)bStopAtDeclarationKeyword, (ISourceCodeTokenizer)this.getTokenizer());
    }

    public void eatTypeLiteral() {
        do {
            if (this.getOwner().matchPrimitiveType(false)) {
                this.getTokenizer().nextToken();
            } else {
                this.match(null, -5);
                this.parseDotPathWord(null);
            }
            this.eatPossibleParametarization();
            while (this.match(null, 91)) {
                this.eatPossibleArrayBrackets(false);
            }
        } while (this.match(null, "&", -6));
    }

    public String parseDotPathWord(String t) {
        StringBuilder sb = t == null ? null : new StringBuilder(t == null ? "" : t);
        SourceCodeTokenizer tokenizer = this.getTokenizer();
        while (this.match(null, 46)) {
            if (sb != null) {
                sb.append('.');
            }
            int mark = tokenizer.mark();
            if (!this.match(null, null, -5) && !this.match(null, null, -7) || sb == null) continue;
            sb.append(tokenizer.getTokenAt(mark).getStringValue());
        }
        if (sb != null) {
            t = sb.toString();
        }
        return t;
    }

    protected final boolean match(Token T, String token) {
        return this.match(T, token, 0, false);
    }

    protected final boolean match(Token T, int iType) {
        return this.match(T, null, iType, false);
    }

    public final boolean match(Token T, String token, int iType) {
        return this.match(T, token, iType, false);
    }

    public final boolean match(Token T, String token, int iType, boolean bPeek) {
        return IParserPart.match((IToken)T, (String)token, (int)iType, (boolean)bPeek, (ISourceCodeTokenizer)this.getTokenizer());
    }

    final boolean isWordOrValueKeyword(Token T) {
        return T.getType() == -5 || T.isValueKeyword();
    }

    protected final boolean match(Token T, Keyword token) {
        return this.match(T, token, false);
    }

    final boolean match(Token T, Keyword keyword, boolean bPeek) {
        SourceCodeTokenizer tokenizer;
        Token t;
        boolean bMatch;
        if (T != null) {
            this.getTokenizer().copyInto(T);
        }
        boolean bl = bMatch = (t = (tokenizer = this.getTokenizer()).getCurrentToken()).getKeyword() == keyword;
        if (bMatch && !bPeek) {
            tokenizer.nextToken();
        }
        return bMatch;
    }

    final void addError(ParsedElement parsedElement, ResourceKey errorMsg, Object ... args) {
        this.verify(parsedElement, false, errorMsg, args);
    }

    final void addError(ParsedElement parsedElement, ResourceKey errorMsg) {
        this.verify(parsedElement, false, errorMsg, EMPTY_ARRAY);
    }

    final boolean verify(ParsedElement parsedElement, boolean bExpression, ResourceKey errorMesg, String arg0) {
        if (!bExpression) {
            return this.verify(parsedElement, bExpression, false, errorMesg, arg0);
        }
        return bExpression;
    }

    final boolean verify(ParsedElement parsedElement, boolean bExpression, ResourceKey errorMesg, String ... args) {
        if (!bExpression) {
            return this.verify(parsedElement, bExpression, false, errorMesg, (Object[])args);
        }
        return bExpression;
    }

    final boolean verify(ParsedElement parsedElement, boolean bExpression, ResourceKey errorMesg, Object ... args) {
        return this.verify(parsedElement, bExpression, false, errorMesg, args);
    }

    final boolean verify(ParsedElement parsedElement, boolean bExpression, IParserState parserState, ResourceKey errorMesg, Object ... args) {
        return this.verify(parsedElement, bExpression, false, false, parserState, errorMesg, args);
    }

    final boolean verify(ParsedElement parsedElement, boolean bExpression, boolean bNextTokenIfException, ResourceKey errorMesg, Object ... args) {
        return this.verify(parsedElement, bExpression, bNextTokenIfException, false, PLACEHOLDER_PARSER_STATE, errorMesg, args);
    }

    boolean verify(ParsedElement parsedElement, boolean bExpression, boolean bNextTokenIfException, IParserState parserState, ResourceKey errorMesg, Object ... args) {
        return this.verify(parsedElement, bExpression, bNextTokenIfException, false, parserState, errorMesg, args);
    }

    final boolean warn(ParsedElement target, boolean bExpression, ResourceKey err, Object ... args) {
        return this.warn(target, bExpression, (IParserState)this.makeFullParserState(), err, args);
    }

    final boolean warn(ParsedElement target, boolean bExpression, IParserState state, ResourceKey err, Object ... args) {
        return this.verify(target, bExpression, false, true, state, err, args);
    }

    final boolean verifyOrWarn(ParsedElement target, boolean bExpression, boolean bWarning, ResourceKey err, Object ... args) {
        return this.verify(target, bExpression, false, bWarning, PLACEHOLDER_PARSER_STATE, err, args);
    }

    private boolean verify(ParsedElement parsedElement, boolean bExpression, boolean bNextTokenIfException, boolean bWarning, IParserState parserState, ResourceKey errorMesg, Object ... args) {
        if (!bExpression) {
            if (bNextTokenIfException) {
                this.advanceToNextTokenSilently();
            }
            if (parserState == PLACEHOLDER_PARSER_STATE) {
                parserState = this.makeFullParserState();
            }
            if (bWarning) {
                if (this._ignoreWarnings == null || !this._ignoreWarnings.contains(errorMesg)) {
                    parsedElement.addParseWarning((IParseIssue)new ParseWarning(parserState, errorMesg, args));
                }
            } else {
                parsedElement.addParseException((IParseIssue)new ParseException(parserState, errorMesg, args));
            }
        }
        return bExpression;
    }

    final void advanceToNextTokenSilently() {
        try {
            this.getTokenizer().nextToken();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    final IFullParserState makeFullParserState() {
        if (this.getOwner().isEditorParser()) {
            return this.makeFullParserStateWithSymbols();
        }
        return new StandardParserState(null, this.getTokenizer(), this.getOffsetShift(), this.getLineNumShift(), this.getOwner().isEditorParser());
    }

    final IFullParserState makeFullParserStateWithSymbols() {
        ISymbolTable symTable = this.getOwner().isEditorParser() ? this.getSymbolTable().copy() : null;
        return new StandardParserState(symTable, this.getTokenizer(), this.getOffsetShift(), this.getLineNumShift(), this.getOwner().isEditorParser());
    }

    final LightweightParserState makeLightweightParserState() {
        return new LightweightParserState(this.getTokenizer(), this.getOffsetShift(), this.getLineNumShift());
    }

    final LazyLightweightParserState makeLazyLightweightParserState() {
        return new LazyLightweightParserState(this.getTokenizer(), this.getOffsetShift(), this.getLineNumShift());
    }

    protected IType resolveTypeForArithmeticExpression(ParsedElement parsedElement, IType lhsType, String op, IType rhsType) {
        IType type = this.resolveType(parsedElement, lhsType, op.charAt(0), rhsType);
        if (parsedElement.hasParseException(Res.MSG_TYPE_MISMATCH)) {
            parsedElement.removeParseException(Res.MSG_TYPE_MISMATCH);
            parsedElement.addParseException((IParseIssue)new ParseException((IParserState)this.makeLightweightParserState(), Res.MSG_ARITHMETIC_OPERATOR_CANNOT_BE_APPLIED_TO_TYPES, new Object[]{op, rhsType.getDisplayName(), lhsType.getDisplayName()}));
        }
        return type;
    }

    protected IType resolveType(ParsedElement parsedElement, IType lhsType, int op, IType rhsType) {
        if (lhsType.isDynamic()) {
            return lhsType;
        }
        if (rhsType.isDynamic()) {
            return rhsType;
        }
        if (op == 43 && !(lhsType instanceof IErrorType) && !(rhsType instanceof IErrorType) && (JavaTypes.CHAR_SEQUENCE().isAssignableFrom(lhsType) || JavaTypes.CHAR_SEQUENCE().isAssignableFrom(rhsType))) {
            return GosuParserTypes.STRING_TYPE();
        }
        IType retType = ParserBase.resolveIfDimensionOperand(this, parsedElement, lhsType, op, rhsType);
        if (retType != null) {
            this.verify(parsedElement, retType != ErrorType.getInstance() && (!ParserBase.isFinalDimension(this, lhsType, parsedElement) || BeanAccess.isNumericType(retType)), Res.MSG_TYPE_MISMATCH, rhsType.getDisplayName(), lhsType.getDisplayName(), rhsType.getTypeLoader() == null ? null : rhsType.getTypeLoader().getModule().getName(), lhsType.getTypeLoader() == null ? null : lhsType.getTypeLoader().getModule().getName());
            return retType;
        }
        if (ParserBase.isNonFinalDimension(lhsType) || ParserBase.isNonFinalDimension(rhsType)) {
            int size = parsedElement.getParseExceptions().size();
            assert (size > 0);
            return ErrorType.getInstance();
        }
        IType type = ParserBase.resolveType(lhsType, op, rhsType);
        this.verify(parsedElement, type != ErrorType.getInstance() && (!ParserBase.isFinalDimension(this, lhsType, parsedElement) || BeanAccess.isNumericType(type)), Res.MSG_TYPE_MISMATCH, rhsType.getDisplayName(), lhsType.getDisplayName());
        return type;
    }

    private static boolean isNonFinalDimension(IType type) {
        return JavaTypes.IDIMENSION().isAssignableFrom(type) && !type.isFinal();
    }

    public static IType resolveRuntimeType(ArithmeticExpression expr, IType lhsType, int op, IType rhsType) {
        if (op == 43 && (JavaTypes.CHAR_SEQUENCE().isAssignableFrom(lhsType) || JavaTypes.CHAR_SEQUENCE().isAssignableFrom(rhsType))) {
            return GosuParserTypes.STRING_TYPE();
        }
        IType retType = ParserBase.resolveIfDimensionOperand(null, expr, lhsType, op, rhsType);
        if (retType != null) {
            return retType;
        }
        return ParserBase.resolveType(lhsType, op, rhsType);
    }

    public static IType resolveType(IType lhsType, int op, IType rhsType) {
        if (lhsType.isDynamic()) {
            return lhsType;
        }
        if (rhsType.isDynamic()) {
            return rhsType;
        }
        if (op == 43 && !(lhsType instanceof IErrorType) && !(rhsType instanceof IErrorType) && (JavaTypes.CHAR_SEQUENCE().isAssignableFrom(lhsType) || JavaTypes.CHAR_SEQUENCE().isAssignableFrom(rhsType))) {
            return GosuParserTypes.STRING_TYPE();
        }
        if (!BeanAccess.isNumericType(lhsType) || !BeanAccess.isNumericType(rhsType)) {
            return ErrorType.getInstance();
        }
        if (op == 8810 || op == 8811 || op == 8921) {
            if (rhsType == JavaTypes.INTEGER() || rhsType == JavaTypes.pINT()) {
                return lhsType;
            }
            return ErrorType.getInstance();
        }
        if (JavaTypes.RATIONAL() == lhsType || JavaTypes.RATIONAL() == rhsType) {
            return JavaTypes.RATIONAL();
        }
        if (JavaTypes.BIG_DECIMAL() == lhsType || JavaTypes.BIG_DECIMAL() == rhsType) {
            return JavaTypes.BIG_DECIMAL();
        }
        if (lhsType == JavaTypes.BIG_INTEGER()) {
            if (rhsType == JavaTypes.DOUBLE() || rhsType == JavaTypes.pDOUBLE() || rhsType == JavaTypes.FLOAT() || rhsType == JavaTypes.pFLOAT()) {
                return JavaTypes.BIG_DECIMAL();
            }
            return JavaTypes.BIG_INTEGER();
        }
        if (rhsType == JavaTypes.BIG_INTEGER()) {
            if (lhsType == JavaTypes.DOUBLE() || lhsType == JavaTypes.pDOUBLE() || lhsType == JavaTypes.FLOAT() || lhsType == JavaTypes.pFLOAT()) {
                return JavaTypes.BIG_DECIMAL();
            }
            return JavaTypes.BIG_INTEGER();
        }
        return ParserBase.handleBoxedAndPrimitiveTypes(lhsType, rhsType);
    }

    private static IType handleBoxedAndPrimitiveTypes(IType lhsType, IType rhsType) {
        Object retType = lhsType == JavaTypes.DOUBLE() || lhsType == JavaTypes.pDOUBLE() ? lhsType : (rhsType == JavaTypes.DOUBLE() || rhsType == JavaTypes.pDOUBLE() ? rhsType : (lhsType == JavaTypes.FLOAT() || lhsType == JavaTypes.pFLOAT() ? lhsType : (rhsType == JavaTypes.FLOAT() || rhsType == JavaTypes.pFLOAT() ? rhsType : (lhsType == JavaTypes.LONG() || lhsType == JavaTypes.pLONG() ? lhsType : (rhsType == JavaTypes.LONG() || rhsType == JavaTypes.pLONG() ? rhsType : (lhsType == JavaTypes.INTEGER() || lhsType == JavaTypes.pINT() ? lhsType : (rhsType == JavaTypes.INTEGER() || rhsType == JavaTypes.pINT() ? rhsType : (lhsType == JavaTypes.SHORT() || lhsType == JavaTypes.pSHORT() || rhsType == JavaTypes.SHORT() || rhsType == JavaTypes.pSHORT() || lhsType == JavaTypes.CHARACTER() || lhsType == JavaTypes.pCHAR() || rhsType == JavaTypes.CHARACTER() || rhsType == JavaTypes.pCHAR() || lhsType == JavaTypes.BYTE() || lhsType == JavaTypes.pBYTE() || rhsType == JavaTypes.BYTE() || rhsType == JavaTypes.pBYTE() ? JavaTypes.pINT() : ErrorType.getInstance()))))))));
        retType = ParserBase.makeBoxedTypeIfEitherOperandIsBoxed(lhsType, rhsType, retType);
        return retType;
    }

    private static IType makeBoxedTypeIfEitherOperandIsBoxed(IType lhsType, IType rhsType, IType retType) {
        if (retType.isPrimitive() && (StandardCoercionManager.isBoxed((IType)lhsType) || StandardCoercionManager.isBoxed((IType)rhsType))) {
            retType = TypeLord.getBoxedTypeFromPrimitiveType(retType);
        }
        return retType;
    }

    private static IType resolveIfDimensionOperand(ParserBase parser, ParsedElement parsedElement, IType lhsType, int op, IType rhsType) {
        if (ParserBase.isFinalDimension(parser, lhsType, parsedElement)) {
            IType retType = ParserBase.getAndAssignOperatorOverloader(lhsType, rhsType, op, parsedElement);
            if (retType != null) {
                return retType;
            }
            if (!ParserBase.assertBoxedOrBigNumber(parser, parsedElement, lhsType, op)) {
                return ErrorType.getInstance();
            }
            if (ParserBase.isFinalDimension(parser, rhsType, parsedElement)) {
                if (op == 42) {
                    if (parser != null) {
                        parser.addError(parsedElement, Res.MSG_DIMENSION_MULTIPLICATION_UNDEFINED);
                    }
                    return ErrorType.getInstance();
                }
                if (lhsType != rhsType) {
                    if (parser != null) {
                        parser.addError(parsedElement, Res.MSG_DIMENSION_ADDITION_MUST_BE_SAME_TYPE);
                    }
                    return ErrorType.getInstance();
                }
                if (op == 47 || op == 37) {
                    IType dimType = TypeLord.findParameterizedType(lhsType, (IType)JavaTypes.IDIMENSION());
                    return dimType.getTypeParameters()[1];
                }
            } else if (op == 43 || op == 45) {
                if (parser != null) {
                    parser.addError(parsedElement, Res.MSG_DIMENSION_ADDITION_MUST_BE_SAME_TYPE);
                }
                return ErrorType.getInstance();
            }
            return lhsType;
        }
        if (ParserBase.isFinalDimension(parser, rhsType, parsedElement)) {
            IType retType;
            if ((op == 42 || op == 43) && (retType = ParserBase.getAndAssignOperatorOverloader(rhsType, lhsType, op, parsedElement)) != null) {
                Expression temp = ((ArithmeticExpression)parsedElement).getLHS();
                if (parsedElement != null) {
                    ((ArithmeticExpression)parsedElement).setLHS(((ArithmeticExpression)parsedElement).getRHS());
                    ((ArithmeticExpression)parsedElement).setRHS(temp);
                }
                return retType;
            }
            if (!ParserBase.assertBoxedOrBigNumber(parser, parsedElement, rhsType, op)) {
                return ErrorType.getInstance();
            }
            if (op == 43 || op == 45) {
                if (parser != null) {
                    parser.addError(parsedElement, Res.MSG_DIMENSION_ADDITION_MUST_BE_SAME_TYPE);
                }
                return ErrorType.getInstance();
            }
            if (op == 47 || op == 37) {
                if (parser != null) {
                    parser.addError(parsedElement, Res.MSG_DIMENSION_DIVIDE_SCALAR_BY_DIMENSION);
                }
                return ErrorType.getInstance();
            }
            return rhsType;
        }
        return null;
    }

    private static boolean assertBoxedOrBigNumber(ParserBase parser, ParsedElement parsedElement, IType rhsType, int op) {
        switch (op) {
            case 37: 
            case 42: 
            case 43: 
            case 45: 
            case 47: {
                break;
            }
            default: {
                return true;
            }
        }
        IType numberType = AbstractElementTransformer.findDimensionType(rhsType);
        if (!StandardCoercionManager.isBoxed((IType)numberType) && !AbstractElementTransformer.isBigType(numberType) && numberType != JavaTypes.RATIONAL()) {
            if (parser != null) {
                parser.addError(parsedElement, Res.MSG_DIMENSION_NONSTANDARD_NUMBER_NO_OVERRIDE, rhsType, numberType);
            }
            return false;
        }
        return true;
    }

    static boolean isFinalDimension(ParserBase parser, IType lhsType, ParsedElement pe) {
        if (JavaTypes.IDIMENSION().isAssignableFrom(lhsType)) {
            if (!lhsType.isFinal()) {
                if (parser != null) {
                    parser.addError(pe, Res.MSG_DIMENSION_MUST_BE_FINAL, lhsType.getName());
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private static IType getAndAssignOperatorOverloader(IType lhsType, IType rhsType, int op, ParsedElement parsedElement) {
        IMethodInfo mi = ParserBase.findMathOpMethod(lhsType, op, rhsType);
        if (mi != null) {
            if (parsedElement instanceof IOverridableOperation) {
                ((IOverridableOperation)parsedElement).setOverride(mi);
            }
            return mi.getReturnType();
        }
        return null;
    }

    public static IMethodInfo findMathOpMethod(IType lhsType, int op, IType rhsType) {
        String strMethod;
        switch (op) {
            case 43: {
                strMethod = "add";
                break;
            }
            case 45: {
                strMethod = "subtract";
                break;
            }
            case 42: {
                strMethod = "multiply";
                break;
            }
            case 47: {
                strMethod = "divide";
                break;
            }
            case 37: {
                strMethod = "modulo";
                break;
            }
            default: {
                return null;
            }
        }
        return lhsType.getTypeInfo().getMethod((CharSequence)strMethod, new IType[]{rhsType});
    }

    protected ISymbol resolveSymbol(ParsedElement e, String strName, boolean ignoreFunctionSymbols) {
        boolean b;
        boolean bl = b = this.getSymbolTable() != null;
        assert (b) : CommonServices.getGosuLocalizationService().localize(Res.MSG_NULL_SYMBOL_TABLE, new Object[0]);
        ISymbol symbol = this.findSymbol(strName, ignoreFunctionSymbols);
        if (symbol instanceof QueryPathRootSymbol) {
            return symbol;
        }
        ISymbol sym = this.isParsingBlock() || this.isOrIsEnclosedByAnonymousClass(this.getGosuClass()) && !this.getOwner().isParsingAnnotation() ? this.captureSymbol(this.getCurrentEnclosingGosuClass(), strName, e) : this.findSymbol(strName, ignoreFunctionSymbols);
        if (sym == null && this.getGosuClass() != null) {
            sym = this.getGosuClass().getExternalSymbol(strName);
        }
        if (sym == null) {
            sym = this.resolveNamespaceSymbol(e, strName);
        } else if (sym.getType() instanceof IErrorType && !e.hasParseExceptions()) {
            SymbolNotFoundException pe = new SymbolNotFoundException(this.makeFullParserState(), strName);
            IType ctxType = this.getOwner().getContextType().getType();
            if (ctxType != null) {
                pe.setExpectedType(ctxType);
            }
            e.addParseException((IParseIssue)pe);
        }
        if (sym == null) {
            throw new IllegalStateException("Should never return null symbol: " + sym.getName());
        }
        if (e != null) {
            sym = this.handleForwardReference(e, sym);
        }
        return sym;
    }

    private ISymbol handleForwardReference(ParsedElement e, ISymbol sym) {
        if (!(this.getOwner().isParsingFieldInitializer() && (sym instanceof DynamicSymbol || sym instanceof DynamicPropertySymbol && ((DynamicPropertySymbol)sym).getVarIdentifier() != null) && sym.getScriptPart() != null && sym.getScriptPart().getContainingType() == this.getGosuClass())) {
            return sym;
        }
        String varName = sym instanceof DynamicSymbol ? sym.getName() : ((DynamicPropertySymbol)sym).getVarIdentifier();
        VarStatement varStmt = (VarStatement)this.getGosuClass().getMemberField(varName);
        if (varStmt == null) {
            varStmt = ((IGosuClassInternal)this.getGosuClass()).getStaticField(varName);
        }
        if (varStmt == this.getOwner().peekParsingFieldInitializer()) {
            sym = this.resolveNamespaceSymbol(e, sym.getName());
        } else {
            this.verify(e, varStmt == null || varStmt.isDefinitionParsed(), Res.MSG_ILLEGAL_FORWARD_REFERENCE, new String[0]);
        }
        return sym;
    }

    boolean isOrIsEnclosedByAnonymousClass(ICompilableType type) {
        return type instanceof IGosuClassInternal && (type.isAnonymous() || this.isOrIsEnclosedByAnonymousClass(type.getEnclosingType()));
    }

    protected ISymbol resolveNamespaceSymbol(ParsedElement e, String strName) {
        Symbol sym;
        INamespaceType namespaceType = this.resolveNamespace(strName);
        if (namespaceType != null) {
            sym = new Symbol(strName, (IType)namespaceType, null);
        } else {
            this.maybeAddLocalsOfEnclosingType();
            IType ctxType = this.getOwner().getContextType().getType();
            SymbolNotFoundException pe = new SymbolNotFoundException(this.makeFullParserStateWithSymbols(), strName);
            if (ctxType != null) {
                pe.setExpectedType(ctxType);
            }
            e.addParseException((IParseIssue)pe);
            sym = new Symbol(strName, (IType)ErrorType.getInstance(), null);
        }
        return sym;
    }

    private void maybeAddLocalsOfEnclosingType() {
        if (this.shouldSnapshotSymbols()) {
            ISymbolTable completionSymbolTable = this.getSymbolTable();
            ICompilableTypeInternal gosuClass = this.getGosuClass();
            if (gosuClass != null) {
                for (ICompilableTypeInternal enclosingType = gosuClass.getEnclosingType(); enclosingType != null; enclosingType = enclosingType.getEnclosingType()) {
                    ISymbolTable symbolTableForClass = this.getSymbolTableForClass(enclosingType);
                    if (symbolTableForClass == null) continue;
                    for (Object key : symbolTableForClass.getSymbols().keySet()) {
                        String name = key.toString();
                        if (completionSymbolTable.getSymbol((CharSequence)name) != null) continue;
                        completionSymbolTable.putSymbol(symbolTableForClass.getSymbol((CharSequence)name));
                    }
                }
            }
        }
    }

    protected INamespaceType resolveNamespace(String strName) {
        INamespaceType namespaceType = TypeSystem.getNamespace((String)strName);
        if (namespaceType == null) {
            ITypeUsesMap typeUsesMap = this.getOwner().getTypeUsesMap();
            if (typeUsesMap != null) {
                namespaceType = typeUsesMap.resolveRelativeNamespaceInAllNamespaces(strName);
            }
            if (namespaceType == null && strName.equals("program_")) {
                return PROGRAM_NAMESPACE;
            }
        }
        return namespaceType;
    }

    protected void captureAllSymbols(ICompilableTypeInternal anonClass, ICompilableTypeInternal enclosingClass, List<ICapturedSymbol> capturedSymbols) {
        ISymbolTable tableForClass = this.getSymbolTableForClass(enclosingClass);
        if (tableForClass == null) {
            if (anonClass instanceof IGosuProgram) {
                Map<String, ICapturedSymbol> enclCaptured = anonClass.getCapturedSymbols();
                capturedSymbols.addAll(enclCaptured.values());
            }
            return;
        }
        Map symbols = tableForClass.getSymbols();
        for (ISymbol sym : symbols.values()) {
            if (sym == null || !sym.canBeCaptured() || enclosingClass != null && enclosingClass.getExternalSymbol(sym.getName()) != null) continue;
            ICapturedSymbol capturedSymbol = sym.makeCapturedSymbol(sym.getName(), this.getSymbolTable(), (IScope)(anonClass == null ? new StandardScope() : this.getScope(anonClass)));
            if (anonClass != null) {
                if (anonClass instanceof IBlockClassInternal) {
                    IBlockExpression expression = ((IBlockClassInternal)anonClass).getBlock();
                    if (expression.isWithinScope(sym, tableForClass)) continue;
                    anonClass.addCapturedSymbol(capturedSymbol);
                    continue;
                }
                anonClass.addCapturedSymbol(capturedSymbol);
                continue;
            }
            capturedSymbols.add(capturedSymbol);
        }
        if (enclosingClass != null && enclosingClass.isAnonymous()) {
            this.captureAllSymbols(enclosingClass, enclosingClass.getEnclosingType(), capturedSymbols);
        }
    }

    protected ISymbol captureSymbol(ICompilableTypeInternal anonClass, String strName, ParsedElement e) {
        if (Keyword.KW_this.equals(strName) || Keyword.KW_super.equals(strName) || Keyword.KW_outer.equals(strName)) {
            return this.findSymbol(strName, true);
        }
        try {
            ICapturedSymbol sym = anonClass.getCapturedSymbol(strName);
            if (sym == null && (sym = this.getUncapturedSymbol(anonClass, strName)) == null && this.isOrIsEnclosedByAnonymousClass(anonClass)) {
                ICompilableTypeInternal enclosingType = anonClass.getEnclosingType();
                sym = enclosingType == null ? this.resolveForNullEnclosingClass(strName) : this.captureSymbol(enclosingType, strName, e);
                this.warnOnPcfVariablesHack(e, (ISymbol)sym);
                if (sym != null && sym.canBeCaptured() && (enclosingType == null || enclosingType.getExternalSymbol(strName) == null)) {
                    ICapturedSymbol capturedSymbol = sym.makeCapturedSymbol(strName, this.getSymbolTable(), this.getScope(anonClass));
                    anonClass.addCapturedSymbol(capturedSymbol);
                    sym = capturedSymbol;
                }
            }
            return sym;
        }
        catch (IllegalStateException ise) {
            if (e != null) {
                e.addParseException((IParseIssue)new ParseException((IParserState)this.makeFullParserState(), Res.MSG_BAD_CAPTURE_TYPE, new Object[0]));
            }
            return null;
        }
    }

    private void warnOnPcfVariablesHack(ParsedElement e, ISymbol sym) {
        if (sym instanceof INonCapturableSymbol) {
            e.addParseWarning((IParseIssue)new ParseWarning((IParserState)this.makeFullParserState(), Res.MSG_POTENTIALLY_BAD_CAPTURE, new Object[0]));
        }
    }

    private IScope getScope(ICompilableType anonClass) {
        if (anonClass instanceof IBlockClassInternal) {
            return ((IBlockClassInternal)anonClass).getBlock().getScope();
        }
        return this.getSymbolTableForClass(anonClass).peekIsolatedScope();
    }

    private ISymbol resolveForNullEnclosingClass(String strName) {
        ISymbol symbol = this.getSymbolTable().getSymbol((CharSequence)strName);
        if (symbol == null) {
            symbol = CompiledGosuClassSymbolTable.instance().getSymbol(strName);
        }
        return symbol;
    }

    protected ISymbol getUncapturedSymbol(ICompilableType gsClass, String strName) {
        ISymbolTable symTable = this.getSymbolTableForClass(gsClass);
        if (symTable == null) {
            return null;
        }
        ISymbol symbol = symTable.getSymbol((CharSequence)strName);
        if (symbol == null && (symbol = this.getSymbolTable().getSymbol((CharSequence)strName)) != null) {
            symTable = this.getSymbolTable();
        }
        if (gsClass instanceof IBlockClassInternal) {
            IBlockExpression block = ((IBlockClassInternal)gsClass).getBlock();
            return block.isWithinScope(symbol, symTable) ? symbol : null;
        }
        return symbol;
    }

    private ISymbolTable getSymbolTableForClass(ICompilableType gsClass) {
        if (gsClass == null) {
            return this.getSymbolTable();
        }
        if (gsClass instanceof IBlockClassInternal) {
            return this.getSymbolTableForClass(gsClass.getEnclosingType());
        }
        return CompiledGosuClassSymbolTable.instance().getSymbolTableForCompilingClass(gsClass);
    }

    private ISymbol findSymbol(String strName, boolean ignoreFunctionSymbols) {
        return this.findSymbol(strName, this.getSymbolTable(), ignoreFunctionSymbols);
    }

    private ISymbol findSymbol(String strName, ISymbolTable symTable, boolean ignoreFunctionSymbols) {
        ISymbol sym;
        if (Keyword.KW_this.getName().equals(strName)) {
            if (this.isEvalClass()) {
                strName = Keyword.KW_outer.getName();
            } else if (this.getGosuClass() instanceof IGosuProgram) {
                return null;
            }
        }
        if ((sym = symTable.getSymbol((CharSequence)strName)) == null && !ignoreFunctionSymbols) {
            List<IFunctionSymbol> dfsDecls = this.getOwner().getDfsDeclsForFunction(strName);
            sym = dfsDecls.isEmpty() ? null : (ISymbol)dfsDecls.get(dfsDecls.size() - 1);
        }
        return sym;
    }

    protected boolean isEvalClass() {
        return this.getGosuClass() instanceof IGosuProgram && this.getGosuClass().isAnonymous();
    }

    protected void verifyComparable(IType lhsType, Expression rhs) {
        this.verifyComparable(lhsType, rhs, false, true);
    }

    protected void verifyComparable(IType lhsType, Expression rhs, boolean bBiDirectional, boolean bErrorIfCoercion) {
        this.verifyComparable(lhsType, rhs, bBiDirectional, bErrorIfCoercion, (IParserState)this.makeFullParserState());
    }

    protected void verifyComparable(IType lhsType, Expression rhs, boolean bBiDirectional, boolean bErrorIfCoercion, IParserState state) {
        IType rhsType = rhs.getType();
        if (TypeSystem.isDeleted((IType)lhsType) || TypeSystem.isDeleted((IType)rhsType)) {
            return;
        }
        if (lhsType != JavaTypes.pVOID() && rhsType == GosuParserTypes.NULL_TYPE() && !(rhs instanceof NullExpression) && rhs instanceof Identifier && ((Identifier)rhs).getSymbol() instanceof AbstractDynamicSymbol) {
            rhs.addParseException((IParseIssue)new ParseException(state, Res.MSG_FIELD_TYPE_HAS_NOT_BEEN_INFERRED, new Object[0]));
        }
        if (rhsType != null) {
            String str;
            this.verifyTypesComparable(rhs, lhsType, rhsType, bBiDirectional, bErrorIfCoercion, state);
            if (lhsType == GosuParserTypes.DATETIME_TYPE() && rhs instanceof StringLiteral && (str = ((StringLiteral)rhs).getValue()) != null) {
                try {
                    CommonServices.getCoercionManager().isDateTime(str);
                }
                catch (java.text.ParseException e) {
                    ParseException pe = ParseException.wrap((Throwable)e, (IParserState)state);
                    pe.setExpectedType(lhsType);
                    rhs.addParseException((IParseIssue)pe);
                }
            }
        }
    }

    protected IType verifyTypesComparable(ParsedElement element, IType lhsType, IType rhsType, boolean bBiDirectional, boolean bErrorIfCoercion) {
        return this.verifyTypesComparable(element, lhsType, rhsType, bBiDirectional, bErrorIfCoercion, (IParserState)this.makeFullParserState());
    }

    protected IType verifyTypesComparable(ParsedElement element, IType lhsType, IType rhsType, boolean bBiDirectional, boolean bErrorIfCoercion, IParserState state) {
        try {
            List<IParseIssue> pes;
            ICoercionManager coercionManager = CommonServices.getCoercionManager();
            coercionManager.verifyTypesComparable(lhsType, rhsType, bBiDirectional);
            if (bErrorIfCoercion) {
                boolean bNotCoercibleOrRequiresExplicitCoercion = coercionManager.notCoercibleOrRequiresExplicitCoercion(lhsType, rhsType);
                if (bNotCoercibleOrRequiresExplicitCoercion && bBiDirectional) {
                    bNotCoercibleOrRequiresExplicitCoercion = coercionManager.notCoercibleOrRequiresExplicitCoercion(rhsType, lhsType);
                }
                if (bNotCoercibleOrRequiresExplicitCoercion) {
                    element.addParseException((IParseIssue)new ImplicitCoercionError(state, Res.MSG_IMPLICIT_COERCION_ERROR, lhsType, new Object[]{rhsType.getDisplayName(), lhsType.getDisplayName()}));
                }
            }
            if (rhsType instanceof ErrorType && (pes = element.getParseExceptions()).size() > 0) {
                ParseException pe = (ParseException)pes.get(pes.size() - 1);
                pe.setExpectedType(lhsType);
            }
        }
        catch (ParseIssue issue) {
            ParseException wrappedPe = ParseException.wrap((Throwable)issue, (IParserState)state);
            wrappedPe.setExpectedType(lhsType);
            element.addParseException((IParseIssue)wrappedPe);
        }
        return lhsType;
    }

    public void verifyNonVoidExpression(Expression eas) {
        if (eas != null) {
            this.verify((ParsedElement)eas, eas instanceof NullExpression || eas.getType() != JavaTypes.pVOID(), Res.MSG_VOID_EXPRESSION_NOT_ALLOWED, new String[0]);
        }
    }

    ICompilableTypeInternal getGosuClass() {
        return this.getOwner() == null || this.getOwner().getScriptPart() == null ? null : (this.getOwner().getScriptPart().getContainingType() instanceof ICompilableTypeInternal ? (ICompilableTypeInternal)this.getOwner().getScriptPart().getContainingType() : null);
    }

    ClassStatement getClassStatement() {
        return null;
    }

    ModifierInfo parseModifiers() {
        return this.parseModifiers(false);
    }

    ModifierInfo parseModifiers(boolean bIgnoreErrors) {
        Keyword keyword;
        Token token;
        int iOffsetList = this.getTokenizer().getTokenStart();
        int iLineNumList = this.getTokenizer().getLineNumber();
        int iColumnList = this.getTokenizer().getTokenColumn();
        ICompilableTypeInternal gsClass = this.getGosuClass();
        boolean bNotInterface = gsClass == null || gsClass instanceof IGosuEnhancementInternal || !gsClass.isInterface();
        ClassStatement elem = this.getClassStatement();
        bIgnoreErrors = bIgnoreErrors || elem == null;
        List<IGosuAnnotation> annotations = Collections.emptyList();
        ModifierInfo modifiers = new ModifierInfo(0);
        int iModifiers = 0;
        DocCommentBlock block = null;
        boolean matchedStatic = false;
        boolean matchedAbstract = false;
        while (true) {
            token = this.getTokenizer().getCurrentToken();
            String value = token.getStringValue();
            keyword = token.getKeyword();
            if (token.getType() == -1) {
                this.getTokenizer().nextToken();
                modifiers.setModifiers(-1);
                return modifiers;
            }
            if (block == null && (block = this.popLastComment()) != null) {
                modifiers.setDescription(block.getDescription());
                if (annotations.isEmpty()) {
                    annotations = new ArrayList<IGosuAnnotation>(2);
                }
                annotations.addAll(block.getAnnotations());
            }
            if (token.getType() == 64) {
                if (this.getOwner() == null) {
                    this.match(null, 64);
                    throw new IllegalStateException("Found null owning parser");
                }
                if (annotations.isEmpty()) {
                    annotations = new ArrayList<IGosuAnnotation>(2);
                }
                this.parseAnnotation(annotations);
                continue;
            }
            if (token.getType() != -7) break;
            if (Keyword.KW_private == keyword) {
                this.getTokenizer().nextToken();
                this.verify((ParsedElement)elem, bIgnoreErrors || bNotInterface || gsClass.getEnclosingType() != null && !gsClass.getEnclosingType().isInterface(), Res.MSG_NOT_ALLOWED_IN_INTERFACE, new String[0]);
                this.verifyNoAccessibilityModifierDefined(elem, bIgnoreErrors, iModifiers, Keyword.KW_private);
                this.verifyNoHideOverrideModifierDefined(elem, bIgnoreErrors, iModifiers, Keyword.KW_private);
                iModifiers = Modifier.setPrivate((int)iModifiers, (boolean)true);
                continue;
            }
            if (Keyword.KW_internal == keyword) {
                this.getTokenizer().nextToken();
                this.verify((ParsedElement)elem, bIgnoreErrors || bNotInterface || gsClass.getEnclosingType() != null && !gsClass.getEnclosingType().isInterface(), Res.MSG_NOT_ALLOWED_IN_INTERFACE, new String[0]);
                this.verifyNoAccessibilityModifierDefined(elem, bIgnoreErrors, iModifiers, Keyword.KW_internal);
                iModifiers = Modifier.setInternal((int)iModifiers, (boolean)true);
                continue;
            }
            if (Keyword.KW_protected == keyword) {
                this.getTokenizer().nextToken();
                this.verify((ParsedElement)elem, bIgnoreErrors || bNotInterface || gsClass.getEnclosingType() != null && !gsClass.getEnclosingType().isInterface(), Res.MSG_NOT_ALLOWED_IN_INTERFACE, new String[0]);
                this.verifyNoAccessibilityModifierDefined(elem, bIgnoreErrors, iModifiers, Keyword.KW_protected);
                iModifiers = Modifier.setProtected((int)iModifiers, (boolean)true);
                continue;
            }
            if (Keyword.KW_public == keyword) {
                this.getTokenizer().nextToken();
                this.verifyNoAccessibilityModifierDefined(elem, bIgnoreErrors, iModifiers, Keyword.KW_public);
                iModifiers = Modifier.setPublic((int)iModifiers, (boolean)true);
                continue;
            }
            if (Keyword.KW_static == keyword) {
                this.getTokenizer().nextToken();
                this.verifyNoAbstractHideOverrideStaticModifierDefined(elem, bIgnoreErrors, iModifiers, Keyword.KW_static, matchedStatic);
                iModifiers = Modifier.setStatic((int)iModifiers, (boolean)true);
                matchedStatic = true;
                continue;
            }
            if (Keyword.KW_abstract == keyword) {
                this.getTokenizer().nextToken();
                this.verify((ParsedElement)elem, bIgnoreErrors || !Modifier.isFinal((int)iModifiers), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_final, Keyword.KW_abstract);
                this.verifyNoAbstractHideStaticModifierDefined(elem, bIgnoreErrors, iModifiers, Keyword.KW_abstract, matchedAbstract);
                iModifiers = Modifier.setAbstract((int)iModifiers, (boolean)true);
                matchedAbstract = true;
                continue;
            }
            if (Keyword.KW_override == keyword) {
                this.getTokenizer().nextToken();
                this.verifyNoHideOverrideStaticModifierDefined(elem, bIgnoreErrors, iModifiers, Keyword.KW_override);
                this.verify((ParsedElement)elem, bIgnoreErrors || !Modifier.isPrivate((int)iModifiers), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_private, Keyword.KW_override);
                iModifiers = Modifier.setOverride((int)iModifiers, (boolean)true);
                continue;
            }
            if (Keyword.KW_hide == keyword) {
                this.getTokenizer().nextToken();
                this.verifyNoAbstractHideOverrideStaticModifierDefined(elem, bIgnoreErrors, iModifiers, Keyword.KW_hide);
                this.verify((ParsedElement)elem, bIgnoreErrors || !Modifier.isPrivate((int)iModifiers), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_private, Keyword.KW_hide);
                iModifiers = Modifier.setHide((int)iModifiers, (boolean)true);
                continue;
            }
            if (Keyword.KW_reified == keyword) {
                this.getTokenizer().nextToken();
                this.verify((ParsedElement)elem, bIgnoreErrors || !Modifier.isFinal((int)iModifiers), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_reified, Keyword.KW_reified);
                iModifiers = Modifier.setReified((int)iModifiers, (boolean)true);
                continue;
            }
            if (Keyword.KW_final == keyword) {
                this.getTokenizer().nextToken();
                this.verify((ParsedElement)elem, bIgnoreErrors || !Modifier.isAbstract((int)iModifiers), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_abstract, Keyword.KW_final);
                this.verify((ParsedElement)elem, bIgnoreErrors || !Modifier.isFinal((int)iModifiers), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_final, Keyword.KW_final);
                iModifiers = Modifier.setFinal((int)iModifiers, (boolean)true);
                continue;
            }
            if (Keyword.KW_transient != keyword) break;
            this.getTokenizer().nextToken();
            this.verify((ParsedElement)elem, bIgnoreErrors || !Modifier.isTransient((int)iModifiers), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_transient, Keyword.KW_transient);
            iModifiers = Modifier.setTransient((int)iModifiers, (boolean)true);
        }
        if (token.getType() == -7 && (Keyword.KW_function == keyword || Keyword.KW_property == keyword || Keyword.KW_var == keyword || Keyword.KW_delegate == keyword)) {
            this.verifyNoCombinedPrivateAbstract(elem, bIgnoreErrors, iModifiers);
        }
        iModifiers = this.maybeAddJavadocDeprecatedModifier(iModifiers, annotations);
        modifiers.setModifiers(iModifiers);
        modifiers.setAnnotations(annotations);
        if (!bIgnoreErrors) {
            this.pushModifierList(iOffsetList, iLineNumList, iColumnList);
        }
        return modifiers;
    }

    private int maybeAddJavadocDeprecatedModifier(int iModifiers, List<IGosuAnnotation> annotations) {
        for (IGosuAnnotation ann : annotations) {
            if (ann.getType() != JavaTypes.GW_LANG_DEPRECATED() && ann.getType() != JavaTypes.JAVA_LANG_DEPRECATED()) continue;
            iModifiers = Modifier.setDeprecated((int)iModifiers, (boolean)true);
            break;
        }
        return iModifiers;
    }

    void pushModifierList(int iOffsetList, int iLineNumList, int iColumnList) {
        ModifierListClause e = new ModifierListClause();
        this.pushExpression(e);
        boolean bZeroLength = this.getTokenizer().getTokenStart() <= iOffsetList;
        this.setLocation(iOffsetList, iLineNumList, iColumnList, bZeroLength, true);
        this.popExpression();
    }

    protected void eatOptionalSemiColon(boolean bEat) {
        if (!bEat || this.match(null, 59)) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseAnnotation(List<IGosuAnnotation> annotations) {
        int end;
        AnnotationUseSiteTargetClause useSiteTarget;
        int iOffset = this.getTokenizer().getTokenStart();
        int iLineNum = this.getTokenizer().getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        this.match(null, 64);
        this.getOwner().pushParsingStaticMember(true);
        ErrorType type = ErrorType.getInstance();
        Expression e = NOT_SET_EXPRESSION;
        try {
            Token token;
            useSiteTarget = this.parseAnnotationUseSiteTarget();
            if (useSiteTarget != null && (useSiteTarget.getTarget().isAccessModifierOk() && (this.match(null, Keyword.KW_private) || this.match(null, Keyword.KW_internal) || this.match(null, Keyword.KW_protected) || this.match(null, Keyword.KW_public)) || useSiteTarget.getTarget().isFinalModifierOk() && this.match(null, Keyword.KW_final))) {
                type = JavaTypes.TARGET_MODIFIER();
                AnnotationExpression annoExpr = new AnnotationExpression();
                this.pushExpression(annoExpr);
                this.setLocation(iOffset, iLineNum, iColumn, true);
                this.popExpression();
                token = this.getTokenizer().getPriorToken();
                Expression[] expr = new StringLiteral[]{new StringLiteral(token._strValue)};
                annoExpr.setArgs(expr);
                annoExpr.setArgTypes(new IType[]{JavaTypes.STRING()});
                annoExpr.setType((IType)type);
                e = annoExpr;
                end = token.getTokenEnd();
            } else if (this.getGosuClass() == null || this.getGosuClass().shouldFullyCompileAnnotations()) {
                this.getOwner().parseNewExpressionOrAnnotation(true);
                this.setLocation(iOffset, iLineNum, iColumn, true);
                e = this.popExpression();
                end = e.getLocation().getExtent() + 1;
                type = e.getType();
                this.maybeVerifyAnnotationArgs(e);
            } else {
                this.getOwner().parseTypeLiteral();
                Expression typeLiteral = this.popExpression();
                if (this.match(null, 40)) {
                    end = this.getTokenizer().getTokenStart();
                    token = this.getOwner().eatBlock('(', ')', false, true);
                    if (token != null) {
                        end = token.getTokenEnd();
                    }
                } else {
                    end = typeLiteral.getLocation().getExtent() + 1;
                }
                if (typeLiteral instanceof TypeLiteral && !typeLiteral.hasParseExceptions()) {
                    type = (IType)typeLiteral.evaluate();
                }
            }
        }
        finally {
            this.getOwner().popParsingStaticMember();
        }
        if (type == null) {
            type = ErrorType.getInstance();
        }
        this.getOwner().checkInstruction(true);
        if (!((Object)((Object)ErrorType.getInstance())).equals((Object)type) && type.getTypeLoader() != null) {
            IModule module = type.getTypeLoader().getModule();
            TypeSystem.pushModule((IModule)module);
            try {
                boolean bAnnotation = JavaTypes.IANNOTATION().isAssignableFrom((IType)type) || JavaTypes.ANNOTATION().isAssignableFrom((IType)type);
                this.verify((ParsedElement)e, bAnnotation || type instanceof IErrorType, Res.MSG_TYPE_NOT_ANNOTATION, type.getName());
            }
            finally {
                TypeSystem.popModule((IModule)module);
            }
        }
        GosuAnnotation annotationInfo = new GosuAnnotation(this.getGosuClass(), (IType)type, e, useSiteTarget == null ? null : useSiteTarget.getTarget(), iOffset, end);
        if (e instanceof AnnotationExpression) {
            ((AnnotationExpression)e).setAnnotation(annotationInfo);
        }
        annotations.add(annotationInfo);
    }

    private AnnotationUseSiteTargetClause parseAnnotationUseSiteTarget() {
        int iOffset = this.getTokenizer().getTokenStart();
        int iLineNum = this.getTokenizer().getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        int mark = this.getTokenizer().mark();
        for (AnnotationUseSiteTarget target : AnnotationUseSiteTarget.values()) {
            if (!this.match(null, target.getKeyword())) continue;
            AnnotationUseSiteTargetClause targetClause = new AnnotationUseSiteTargetClause(target);
            this.pushExpression(targetClause);
            if (this.match(null, ":", -6)) {
                this.setLocation(iOffset, iLineNum, iColumn, false);
                this.popExpression();
                return targetClause;
            }
            this.getTokenizer().restoreToMark(mark);
            return null;
        }
        return null;
    }

    private void maybeVerifyAnnotationArgs(Expression e) {
        if (e instanceof AnnotationExpression) {
            AnnotationExpression ae = (AnnotationExpression)e;
            if (JavaTypes.ANNOTATION().isAssignableFrom(ae.getType()) && ae.getArgs() != null) {
                for (Expression arg : ae.getArgs()) {
                    this.verify((ParsedElement)arg, arg.isCompileTimeConstant(), Res.MSG_COMPILE_TIME_CONSTANT_REQUIRED, new String[0]);
                }
            }
        }
    }

    void verifyModifiers(IParsedElement pe, ModifierInfo modInfo, UsageTarget targetType) {
        this.verifyModifiersForFeature(pe, modInfo);
        this.verifyAnnotations(pe, modInfo, targetType);
    }

    protected void verifyModifiersForFeature(IParsedElement pe, ModifierInfo modInfo) {
        if (this.getGosuClass().getEnclosingType() != null && !this.getGosuClass().isStatic()) {
            this.verify((ParsedElement)pe, !Modifier.isStatic((int)modInfo.getModifiers()) || Modifier.isFinal((int)modInfo.getModifiers()) && pe instanceof VarStatement && ((VarStatement)pe).getAsExpression() != null && ((VarStatement)pe).getAsExpression().isCompileTimeConstant(), Res.MSG_STATIC_MODIFIER_NOT_ALLOWED_HERE, new String[0]);
        }
    }

    void verifyAnnotations(IParsedElement pe, ModifierInfo modInfo, UsageTarget targetType) {
        ArrayList<IType> annotationTypes = new ArrayList<IType>();
        for (IGosuAnnotation annotation : modInfo.getAnnotations()) {
            IType annotationType;
            if (!(annotation instanceof GosuAnnotation) || (annotationType = annotation.getType()) instanceof ErrorType) continue;
            AnnotationUseSiteTarget target = annotation.getTarget();
            if (target != null && !UsageModifier.targetAppliesToParsedElement((IParsedElement)pe, (AnnotationUseSiteTarget)target)) {
                annotation.getExpression().addParseException(Res.MSG_ANNOTATION_USE_SITE_TARGET_NOT_ALLOWED_HERE, new Object[]{annotation.getName(), target.name()});
                continue;
            }
            UsageModifier modifier = UsageModifier.getUsageModifier((IParsedElement)pe, (UsageTarget)targetType, (IType)annotationType, (AnnotationUseSiteTarget)target);
            if (modifier.equals((Object)UsageModifier.None)) {
                annotation.getExpression().addParseException(Res.MSG_ANNOTATION_WHEN_NONE_ALLOWED, new Object[]{annotation.getName(), targetType.toString().toLowerCase()});
            } else if (modifier.equals((Object)UsageModifier.One) && annotationTypes.contains(annotationType)) {
                annotation.getExpression().addParseException(Res.MSG_TOO_MANY_ANNOTATIONS, new Object[]{annotation.getName(), targetType.toString().toLowerCase()});
            }
            annotationTypes.add(annotationType);
        }
    }

    void verifyNoAbstractHideOverrideStaticModifierDefined(ParsedElement elem, boolean bIgnoreErrors, int modifier, Keyword kw) {
        this.verifyNoAbstractHideOverrideStaticModifierDefined(elem, bIgnoreErrors, modifier, kw, false);
    }

    void verifyNoAbstractHideOverrideStaticModifierDefined(ParsedElement elem, boolean bIgnoreErrors, int modifier, Keyword kw, boolean alreadyMatched) {
        if (bIgnoreErrors) {
            return;
        }
        this.verify(elem, !Modifier.isOverride((int)modifier), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_override, kw);
        this.verify(elem, !Modifier.isHide((int)modifier), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_hide, kw);
        if (!(elem instanceof ClassStatement) || alreadyMatched) {
            this.verify(elem, !Modifier.isAbstract((int)modifier), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_abstract, kw);
            this.verify(elem, !Modifier.isStatic((int)modifier), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_static, kw);
        }
    }

    void verifyNoHideOverrideStaticModifierDefined(ParsedElement elem, boolean bIgnoreErrors, int modifier, Keyword kw) {
        if (bIgnoreErrors) {
            return;
        }
        this.verify(elem, !Modifier.isOverride((int)modifier), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_override, kw);
        this.verify(elem, !Modifier.isHide((int)modifier), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_hide, kw);
    }

    void verifyNoAbstractHideStaticModifierDefined(ParsedElement elem, boolean bIgnoreErrors, int modifier, Keyword kw, boolean alreadyMatched) {
        if (bIgnoreErrors) {
            return;
        }
        this.verify(elem, !Modifier.isHide((int)modifier), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_hide, kw);
        if (!(elem instanceof ClassStatement) || alreadyMatched) {
            this.verify(elem, !Modifier.isOverride((int)modifier), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_override, kw);
            this.verify(elem, !Modifier.isAbstract((int)modifier), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_abstract, kw);
            this.verify(elem, !Modifier.isStatic((int)modifier), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_static, kw);
        }
    }

    void verifyNoAccessibilityModifierDefined(ParsedElement elem, boolean bIgnoreErrors, int modifier, Keyword kw) {
        if (bIgnoreErrors) {
            return;
        }
        this.verify(elem, !Modifier.isPrivate((int)modifier), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_private, kw);
        this.verify(elem, !Modifier.isInternal((int)modifier), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_internal, kw);
        this.verify(elem, !Modifier.isProtected((int)modifier), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_protected, kw);
        this.verify(elem, !Modifier.isPublic((int)modifier), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_public, kw);
    }

    void verifyNoAbstractHideOverrideModifierDefined(ParsedElement elem, boolean bIgnoreErrors, int modifier, Keyword kw) {
        if (bIgnoreErrors) {
            return;
        }
        this.verify(elem, !Modifier.isAbstract((int)modifier), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_abstract, kw);
        this.verify(elem, !Modifier.isOverride((int)modifier), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_override, kw);
        this.verify(elem, !Modifier.isHide((int)modifier), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_hide, kw);
    }

    void verifyNoHideOverrideModifierDefined(ParsedElement elem, boolean bIgnoreErrors, int modifier, Keyword kw) {
        if (bIgnoreErrors) {
            return;
        }
        this.verify(elem, !Modifier.isOverride((int)modifier), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_override, kw);
        this.verify(elem, !Modifier.isHide((int)modifier), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_hide, kw);
    }

    void verifyNoCombinedPrivateAbstract(ParsedElement elem, boolean bIgnoreErrors, int modifier) {
        if (bIgnoreErrors) {
            return;
        }
        this.verify(elem, !Modifier.isPrivate((int)modifier) || !Modifier.isAbstract((int)modifier), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_private, Keyword.KW_abstract);
    }

    void verifyNoCombinedFinalPrivateModifierDefined(ParsedElement elem, boolean bIgnoreErrors, int modifier) {
        if (bIgnoreErrors) {
            return;
        }
        this.verify(elem, !Modifier.isPrivate((int)modifier) || !Modifier.isFinal((int)modifier), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_private, Keyword.KW_final);
    }

    void verifyNoCombinedFinalStaticModifierDefined(ParsedElement elem, boolean bIgnoreErrors, int modifier) {
        if (bIgnoreErrors) {
            return;
        }
        this.verify(elem, !Modifier.isStatic((int)modifier) || !Modifier.isFinal((int)modifier), Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_static, Keyword.KW_final);
    }

    public void setDontOptimizeStatementLists(boolean dontOptimizeStatementLists) {
        if (this.getOwner() != this) {
            this.getOwner().setDontOptimizeStatementLists(dontOptimizeStatementLists);
        }
        this._bDontOptimizeStatementLists = dontOptimizeStatementLists;
    }

    public boolean isDontOptimizeStatementLists() {
        if (this.getOwner() != this) {
            return this.getOwner().isDontOptimizeStatementLists();
        }
        return this._bDontOptimizeStatementLists;
    }

    public void setSubTree(List<IParseTree> subTree) {
        this._subTree = subTree;
    }

    public void setBlocks(Stack<BlockExpression> blocks) {
        this._blocks = blocks;
    }

    public void pushCurrentBlock(BlockExpression block) {
        if (this._blocks == null) {
            this._blocks = new Stack();
        }
        ICompilableTypeInternal enclosingClass = this.getCurrentEnclosingGosuClass();
        this._blocks.push((Object)block);
        IBlockClassInternal blockClass = BlockClass.create(enclosingClass, block, this._blocks.size() == 1 && this.getOwner().isParsingStaticFeature());
        block.setBlockGosuClass(blockClass);
        if (enclosingClass != null) {
            enclosingClass.addBlock(blockClass);
        }
    }

    public void addBlockToBlockStack(BlockExpression block) {
        if (this._blocks == null) {
            this._blocks = new Stack();
        }
        this._blocks.push((Object)block);
    }

    protected ICompilableTypeInternal getCurrentEnclosingGosuClass() {
        ICompilableTypeInternal enclosingClass = this._blocks == null || this._blocks.isEmpty() ? this.getGosuClass() : (ICompilableTypeInternal)((BlockExpression)this._blocks.peek()).getBlockGosuClass();
        if (enclosingClass == null) {
            enclosingClass = this.getOuterFromScriptPartStack();
        }
        return enclosingClass;
    }

    private ICompilableTypeInternal getOuterFromScriptPartStack() {
        Stack<IScriptPartId> scriptPartIdStack = this.getOwner().getScriptPartIdStack();
        for (int i = scriptPartIdStack.size() - 1; i >= 0; --i) {
            IType type;
            IScriptPartId id = (IScriptPartId)scriptPartIdStack.get(i);
            if (!(id instanceof ScriptPartId) || !((type = id.getContainingType()) instanceof ICompilableTypeInternal)) continue;
            return (ICompilableTypeInternal)type;
        }
        return null;
    }

    void popCurrentBlock() {
        this._blocks.pop();
    }

    public boolean isParsingBlock() {
        return this._blocks != null && !this._blocks.isEmpty();
    }

    protected void copyBlockStackTo(ParserBase otherParser) {
        if (this._blocks != null) {
            for (BlockExpression block : this._blocks) {
                otherParser.addBlockToBlockStack(block);
            }
        }
    }

    protected IGosuClassInternal getParsingAnonymousClass() {
        IType type;
        IType iType = type = this.getOwner().getScriptPart() != null ? this.getOwner().getScriptPart().getContainingType() : null;
        while (type instanceof IGosuClassInternal && !((IGosuClassInternal)type).isAnonymous()) {
            type = type.getEnclosingType();
        }
        return type instanceof IGosuClassInternal && ((IGosuClassInternal)type).isAnonymous() ? (IGosuClassInternal)type : null;
    }

    protected Expression possiblyWrapWithImplicitCoercion(Expression expressionToCoerce, IType typeToCoerceTo) {
        return this.possiblyWrapWithCoercion(expressionToCoerce, typeToCoerceTo, true);
    }

    protected Expression possiblyWrapWithCoercion(Expression expressionToCoerce, IType typeToCoerceTo, boolean bImplicit) {
        if (expressionToCoerce == null) {
            return null;
        }
        if (typeToCoerceTo == null || typeToCoerceTo instanceof ErrorType) {
            return expressionToCoerce;
        }
        List<IType> inferringTypes = this.getCurrentlyInferringFunctionTypeVars();
        IType resolvedTypeToCoerceTo = inferringTypes.size() > 0 ? TypeLord.boundTypes(typeToCoerceTo, inferringTypes) : typeToCoerceTo;
        IType typeToCoerceFrom = expressionToCoerce.getType();
        ICoercionManager cocerionManager = CommonServices.getCoercionManager();
        ICoercer coercer = cocerionManager.resolveCoercerStatically(resolvedTypeToCoerceTo, typeToCoerceFrom);
        if (coercer == null) {
            return expressionToCoerce;
        }
        if (JavaTypes.pVOID().equals(typeToCoerceFrom) && !(expressionToCoerce instanceof NullExpression)) {
            return expressionToCoerce;
        }
        TypeAsExpression tas = bImplicit ? new ImplicitTypeAsExpression() : new TypeAsExpression();
        tas.setLHS(expressionToCoerce);
        if (coercer instanceof IResolvingCoercer) {
            IResolvingCoercer resolvingCoercer = (IResolvingCoercer)coercer;
            typeToCoerceTo = resolvingCoercer.resolveType(typeToCoerceTo, typeToCoerceFrom);
        }
        tas.setType(typeToCoerceTo);
        tas.setCoercer(coercer);
        this.verifyTypeVarAreReified(expressionToCoerce, typeToCoerceTo);
        this.setLocationForImplicitTypeAs(expressionToCoerce, tas);
        return tas;
    }

    void verifyTypeVarAreReified(Expression expr, IType rhsType) {
        if (expr.hasParseExceptions()) {
            return;
        }
        TypeLord.getTypeVariables(rhsType, tv -> {
            this.isTypeVarInReifiedContext(expr, (ITypeVariableType)tv);
            return false;
        });
        if (rhsType instanceof IFunctionType && this.getGosuClass() instanceof IGosuEnhancement && this.getGosuClass().isGenericType() && !expr.hasParseExceptions()) {
            Arrays.stream(this.getGosuClass().getGenericTypeVariables()).forEach(gtv -> this.isTypeVarInReifiedContext(expr, gtv.getTypeVariableDefinition().getType()));
        }
    }

    boolean isTypeVarInReifiedContext(Expression expr, ITypeVariableType typeVarType) {
        IType typeVarDeclarer = typeVarType.getTypeVarDef().getEnclosingType();
        IType enclosingType = typeVarDeclarer.getEnclosingType();
        if (typeVarDeclarer instanceof IFunctionType && !(enclosingType instanceof IGosuClass)) {
            return true;
        }
        if (typeVarDeclarer instanceof IFunctionType) {
            return this.verify((ParsedElement)expr, Modifier.isReified((int)typeVarDeclarer.getModifiers()), Res.MSG_TYPE_NOT_REIFIED, ((IFunctionType)typeVarDeclarer).getParamSignature(), typeVarType.getRelativeName());
        }
        if (typeVarDeclarer instanceof IGosuEnhancement && this.getOwner().isParsingFunction()) {
            Iterator<FunctionType> iter = this.getOwner().iterateParsingFunctions();
            while (iter.hasNext()) {
                FunctionType funcType = iter.next();
                if (funcType.getEnclosingType() != typeVarDeclarer) continue;
                return this.verify((ParsedElement)expr, Modifier.isReified((int)funcType.getModifiers()), Res.MSG_TYPE_NOT_REIFIED, this.getOwner().peekParsingFunction().getParamSignature(), typeVarType.getRelativeName());
            }
        }
        return true;
    }

    protected void setLocationForImplicitTypeAs(Expression expressionToCoerce, TypeAsExpression tas) {
        if (expressionToCoerce instanceof DefaultArgLiteral) {
            return;
        }
        ParseTree wrappedLoc = this.findAndWrapLocation(expressionToCoerce, tas);
        if (wrappedLoc == null) {
            throw new IllegalStateException("The expression wrapped with an implicit type-as did not have its location set.");
        }
    }

    public ParseTree findAndWrapLocation(Expression oldExpr, ParsedElement newExpr) {
        ParseTree oldLoc = oldExpr.getLocation();
        if (oldLoc == null) {
            return null;
        }
        ParseTree newLoc = newExpr.initLocation(oldLoc.getOffset(), oldLoc.getLength(), oldExpr.getLineNum(), oldExpr.getColumn(), oldLoc.getScriptPartId());
        IParseTree parent = oldLoc.getParent();
        newExpr.setLocation(newLoc);
        newLoc.addChild(oldLoc);
        if (parent != null) {
            parent.removeChild((IParseTree)oldLoc);
            newLoc.addChild(oldLoc);
            parent.addChild((IParseTree)newLoc);
        }
        List<ParseTree> locations = this.getOwner().getLocationsList();
        for (int i = locations.size() - 1; i > 0; --i) {
            ParseTree loc = locations.get(i);
            if (loc.getParsedElement() != oldExpr) continue;
            locations.set(i, newLoc);
            break;
        }
        return newLoc;
    }

    private DocCommentBlock popLastComment() {
        DocCommentBlock lastComment = this.getOwner().getTokenizer().popLastComment();
        if (lastComment != null) {
            lastComment.setOwnersTypes(this.getGosuClass());
        }
        return lastComment;
    }

    public void setValidator(IGosuValidator validator) {
        this._validator = validator;
    }

    public IGosuValidator getValidator() {
        return this._validator != null ? this._validator : (this.getOwner() != null && !this.equals(this.getOwner()) ? this.getOwner().getValidator() : null);
    }

    protected void setOffsetShift(int offsetShift) {
        this._offsetShift = offsetShift;
    }

    public void setLineNumShift(int lineNumShift) {
        this._lineNumShift = lineNumShift;
    }

    public int getLineNumShift() {
        return this._lineNumShift;
    }

    public int getOffsetShift() {
        return this._offsetShift;
    }

    protected void pushInferringFunctionTypeVars(List<IType> typeVariableTypes) {
        this._inferringFunctionTypes.push(typeVariableTypes);
    }

    protected List<IType> popInferringFunctionTypeVariableTypes() {
        return (List)this._inferringFunctionTypes.pop();
    }

    protected List<IType> peekInferringFunctionTypeVariableTypes() {
        return this._inferringFunctionTypes == null || this._inferringFunctionTypes.isEmpty() ? Collections.emptyList() : (List)this._inferringFunctionTypes.peek();
    }

    public List<IType> getCurrentlyInferringFunctionTypeVars() {
        List<IType> types = Collections.emptyList();
        if (this._inferringFunctionTypes.size() != 0) {
            for (List inferringFunctionType : this._inferringFunctionTypes) {
                for (IType type : inferringFunctionType) {
                    if (types.isEmpty()) {
                        types = new ArrayList<IType>();
                    }
                    if (types.contains(type)) continue;
                    types.add(type);
                }
            }
        }
        return types;
    }

    public static boolean matchDeclarationKeyword(String[] ret, boolean bPeek, SourceCodeTokenizer tokenizer) {
        Keyword keyword;
        boolean bMatch = false;
        Token token = tokenizer.getCurrentToken();
        if (token.getType() == -7 && (Keyword.KW_construct == (keyword = token.getKeyword()) || Keyword.KW_function == keyword || Keyword.KW_property == keyword || Keyword.KW_var == keyword || Keyword.KW_delegate == keyword || Keyword.KW_class == keyword || Keyword.KW_interface == keyword || Keyword.KW_annotation == keyword || Keyword.KW_structure == keyword || Keyword.KW_enum == keyword)) {
            if (ret != null) {
                ret[0] = token.getStringValue();
            }
            int mark = tokenizer.mark();
            Token nextToken = tokenizer.getTokenAt(mark + 1);
            Token priorToken = mark == 0 ? null : tokenizer.getTokenAt(mark - 1);
            boolean bl = bMatch = (nextToken == null || nextToken.getType() != 46) && (priorToken == null || priorToken.getType() != 46 && !"#".equals(priorToken.getStringValue()));
            if (!bPeek) {
                tokenizer.nextToken();
            }
        }
        return bMatch;
    }

    public boolean shouldSnapshotSymbols() {
        return this._snapshotSymbols;
    }

    public void setSnapshotSymbols() {
        this._snapshotSymbols = true;
    }

    private static final class PlaceholderParserState
    implements IParserState {
        private PlaceholderParserState() {
        }

        public int getLineNumber() {
            return 0;
        }

        public int getTokenColumn() {
            return 0;
        }

        public String getSource() {
            return null;
        }

        public int getTokenStart() {
            return 0;
        }

        public int getTokenEnd() {
            return 0;
        }

        public int getLineOffset() {
            return 0;
        }

        public IParserState cloneWithNewTokenStartAndTokenEnd(int newTokenStart, int newLength) {
            return null;
        }
    }
}

