/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.internal.gosu.parser.ArrayExpansionPropertyInfo;
import gw.internal.gosu.parser.BeanAccess;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.expressions.MemberAccess;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.parser.expressions.IMemberExpansionExpression;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;

public class MemberExpansionAccess
extends MemberAccess
implements IMemberExpansionExpression {
    @Override
    public IPropertyInfo getPropertyInfo() {
        IType componentType = TypeLord.getExpandableComponentType(this.getRootType());
        try {
            IPropertyInfo pi = BeanAccess.getPropertyInfoDirectly(componentType, this.getMemberName());
            return new ArrayExpansionPropertyInfo(pi);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isNullSafe() {
        return true;
    }

    @Override
    public String toString() {
        return this.getRootExpression().toString() + "*." + this.getMemberName();
    }

    public static MemberExpansionAccess wrap(MemberAccess ma) {
        if (!(ma.getPropertyInfo() instanceof ArrayExpansionPropertyInfo)) {
            throw new IllegalArgumentException("Only MemberAccess expressions whose property is an ArrayExpansionPropertyInfo can be wrapped");
        }
        MemberExpansionAccess mea = new MemberExpansionAccess();
        mea.setGosuProgram(ma.getGosuProgram());
        mea.setRootExpression(ma.getRootExpression());
        mea.setMemberExpression(ma.getMemberExpression());
        mea.setMemberName(ma.getMemberName());
        mea.setType(ma.getType());
        mea.setMemberAccessKind(ma.getMemberAccessKind());
        return mea;
    }
}

