/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.java.classinfo;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.tree.JCTree;
import gw.internal.gosu.parser.java.classinfo.IModifierList;
import gw.internal.gosu.parser.java.classinfo.JavaSourceEnumConstant;
import gw.internal.gosu.parser.java.classinfo.JavaSourceModifierList;
import gw.internal.gosu.parser.java.classinfo.JavaSourceType;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.java.IJavaAnnotatedElement;
import gw.lang.reflect.java.IJavaClassField;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassType;
import gw.lang.reflect.java.JavaSourceElement;
import java.lang.annotation.Annotation;

public class JavaSourceField
extends JavaSourceElement
implements IJavaClassField {
    protected VariableTree _fieldTree;
    protected JavaSourceType _containingClass;
    protected IModifierList _modifierList;
    protected IJavaClassInfo _type;
    protected IJavaClassType _genericType;

    public static JavaSourceField create(VariableTree fieldTree, JavaSourceType containingType) {
        if (JavaSourceField.isEnumInit(fieldTree)) {
            return new JavaSourceEnumConstant(fieldTree, containingType);
        }
        return new JavaSourceField(fieldTree, containingType);
    }

    public static boolean isEnumInit(VariableTree tree) {
        ModifiersTree modifiers = tree.getModifiers();
        JCTree.JCModifiers mod = (JCTree.JCModifiers)modifiers;
        return (mod.flags & 0x4000L) != 0L;
    }

    public JavaSourceField(VariableTree fieldTree, JavaSourceType containingClass) {
        this._fieldTree = fieldTree;
        this._containingClass = containingClass;
    }

    public String getName() {
        return this._fieldTree.getName().toString();
    }

    public String getRhs() {
        ExpressionTree rhs = this._fieldTree.getInitializer();
        return rhs == null ? null : rhs.toString();
    }

    public IJavaClassInfo getType() {
        if (this._type == null) {
            IJavaClassType genericType = this.getGenericType();
            this._type = this._genericType != null ? (IJavaClassInfo)genericType.getConcreteType() : IJavaClassType.NULL_TYPE;
        }
        return this._type == IJavaClassType.NULL_TYPE ? null : this._type;
    }

    public IJavaClassType getGenericType() {
        if (this._genericType == null) {
            Tree type = this._fieldTree.getType();
            this._genericType = JavaSourceType.createType(this.getEnclosingClass(), type);
        }
        return this._genericType;
    }

    public boolean isEnumConstant() {
        return false;
    }

    public IModifierList getModifierList() {
        if (this._modifierList == null) {
            ModifiersTree modifiers = this._fieldTree.getModifiers();
            this._modifierList = new JavaSourceModifierList((IJavaAnnotatedElement)this, modifiers);
        }
        return this._modifierList;
    }

    public JavaSourceType getEnclosingClass() {
        return this._containingClass;
    }

    public String toString() {
        return this.getEnclosingClass().getName() + " . " + this.getName();
    }

    public boolean isSynthetic() {
        return false;
    }

    public int getModifiers() {
        return this.getModifierList().getModifiers();
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getModifierList().isAnnotationPresent(annotationClass);
    }

    public IAnnotationInfo getAnnotation(Class annotationClass) {
        return this.getModifierList().getAnnotation(annotationClass);
    }

    public IAnnotationInfo[] getDeclaredAnnotations() {
        return this.getModifierList().getAnnotations();
    }

    public Tree getTree() {
        return this._fieldTree;
    }
}

