/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.statements;

import gw.internal.gosu.parser.CannotExecuteGosuException;
import gw.internal.gosu.parser.DynamicPropertySymbol;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.IGosuAnnotation;
import gw.internal.gosu.parser.ModifierInfo;
import gw.internal.gosu.parser.Statement;
import gw.internal.gosu.parser.expressions.TypeLiteral;
import gw.internal.gosu.parser.statements.ClassStatement;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.ISymbol;
import gw.lang.parser.expressions.IVarStatement;
import gw.lang.parser.statements.IClassStatement;
import gw.lang.parser.statements.ITerminalStatement;
import gw.lang.reflect.IType;
import gw.lang.reflect.Modifier;
import gw.util.GosuObjectUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VarStatement
extends Statement
implements IVarStatement {
    private String _strPropertyName;
    protected Expression _expression;
    protected TypeLiteral _typeLiteral;
    protected boolean _hasProperty = false;
    protected ModifierInfo _modifiers;
    private List<IGosuAnnotation> _declAnnotations;
    private ISymbol _symbol;
    private IScriptPartId _scriptPartId;
    private int _iNameOffset;
    private int _iPropertyNameOffset;
    private boolean _bDefinitionParsed;
    private boolean _bIsInitializedTopLevelProgVar;
    private DynamicPropertySymbol _dps;

    public String getIdentifierName() {
        return this._symbol.getName();
    }

    public ISymbol getSymbol() {
        return this._symbol;
    }

    public void setSymbol(ISymbol symbol) {
        this._symbol = symbol;
    }

    public String getPropertyName() {
        return this._strPropertyName;
    }

    public void setPropertyName(String strPropertyName) {
        this._strPropertyName = strPropertyName;
    }

    public TypeLiteral getTypeLiteral() {
        return this._typeLiteral;
    }

    public void setTypeLiteral(TypeLiteral typeLiteral) {
        this.detachDeclTypeLiteral();
        this._typeLiteral = typeLiteral;
    }

    private void detachDeclTypeLiteral() {
        if (this._typeLiteral != null && this.getLocation() != null) {
            this.getLocation().removeChild(this._typeLiteral.getLocation());
        }
    }

    public Expression getAsExpression() {
        return this._expression;
    }

    public void setAsExpression(Expression expression) {
        this._expression = expression;
    }

    public void setType(IType newType) {
        this._symbol.setType(newType);
    }

    public boolean hasProperty() {
        return this._hasProperty;
    }

    public void setHasProperty(boolean hasProperty) {
        this._hasProperty = hasProperty;
    }

    public ModifierInfo getModifierInfo() {
        return this._modifiers;
    }

    public void setModifierInfo(ModifierInfo modifiers) {
        this._modifiers = modifiers;
    }

    public List<IGosuAnnotation> getDeclAnnotations() {
        return this._declAnnotations;
    }

    public void setDeclAnnotations(List<IGosuAnnotation> declAnnotations) {
        this._declAnnotations = new ArrayList<IGosuAnnotation>(declAnnotations);
    }

    public int getModifiers() {
        return this._modifiers.getModifiers();
    }

    public boolean isStatic() {
        return Modifier.isStatic((int)this._modifiers.getModifiers());
    }

    public void setStatic(boolean bStatic) {
        this._modifiers.setModifiers(Modifier.setStatic((int)this._modifiers.getModifiers(), (boolean)bStatic));
    }

    public boolean isPrivate() {
        return Modifier.isPrivate((int)this._modifiers.getModifiers()) || !this.isInternal() && !this.isProtected() && !this.isPublic();
    }

    public void setPrivate(boolean bPrivate) {
        this._modifiers.setModifiers(Modifier.setPrivate((int)this._modifiers.getModifiers(), (boolean)bPrivate));
    }

    public boolean isInternal() {
        return Modifier.isInternal((int)this._modifiers.getModifiers());
    }

    public void setInternal(boolean bInternal) {
        this._modifiers.setModifiers(Modifier.setInternal((int)this._modifiers.getModifiers(), (boolean)bInternal));
    }

    public boolean isProtected() {
        return Modifier.isProtected((int)this._modifiers.getModifiers());
    }

    public void setProtected(boolean bProtected) {
        this._modifiers.setModifiers(Modifier.setProtected((int)this._modifiers.getModifiers(), (boolean)bProtected));
    }

    public boolean isPublic() {
        return Modifier.isPublic((int)this._modifiers.getModifiers());
    }

    public void setPublic(boolean bPublic) {
        this._modifiers.setModifiers(Modifier.setPublic((int)this._modifiers.getModifiers(), (boolean)bPublic));
    }

    public boolean isFinal() {
        return Modifier.isFinal((int)this.getModifiers());
    }

    public void setFinal(boolean bFinal) {
        this._modifiers.setModifiers(Modifier.setFinal((int)this._modifiers.getModifiers(), (boolean)bFinal));
    }

    public boolean isAbstract() {
        return Modifier.isAbstract((int)this.getModifiers());
    }

    public boolean isEnumConstant() {
        return Modifier.isEnum((int)this.getModifiers());
    }

    public void setEnumConstant(boolean bEnumConstant) {
        this._modifiers.setModifiers(Modifier.setEnum((int)this._modifiers.getModifiers(), (boolean)bEnumConstant));
    }

    public boolean isTransient() {
        return Modifier.isTransient((int)this.getModifiers());
    }

    public IType getType() {
        return this._symbol == null ? null : this._symbol.getType();
    }

    public void setScriptPart(IScriptPartId partId) {
        this._scriptPartId = partId;
    }

    public IScriptPartId getScriptPart() {
        return this._scriptPartId;
    }

    @Override
    public Object execute() {
        if (!this.isCompileTimeConstant()) {
            return super.execute();
        }
        throw new CannotExecuteGosuException();
    }

    @Override
    protected ITerminalStatement getLeastSignificantTerminalStatement_internal(boolean[] bAbsolute) {
        bAbsolute[0] = false;
        return null;
    }

    @Override
    public String toString() {
        return "var " + this.getIdentifierName() + (this.getTypeLiteral() != null ? " : " + this.getTypeLiteral().toString() : "") + (this.getAsExpression() != null ? " = " + this.getAsExpression().toString() : "");
    }

    @Override
    public String getFunctionName() {
        if (this.getParent() instanceof ClassStatement) {
            return "_init";
        }
        return super.getFunctionName();
    }

    public int getNameOffset(String identifierName) {
        return identifierName == null || identifierName.equals(this.getIdentifierName()) ? this._iNameOffset : (identifierName.equals(this.getPropertyName()) ? (this._iPropertyNameOffset == 0 ? this._iNameOffset : this._iPropertyNameOffset) : -1);
    }

    public void setNameOffset(int iOffset, String identifierName) {
        if (identifierName != null && this.getPropertyName() != null && identifierName.equals(this.getPropertyName())) {
            this._iPropertyNameOffset = iOffset;
        } else {
            this._iNameOffset = iOffset;
        }
    }

    public boolean declares(String identifierName) {
        return GosuObjectUtil.equals((Object)this.getIdentifierName(), (Object)identifierName) || GosuObjectUtil.equals((Object)this.getPropertyName(), (Object)identifierName);
    }

    public String[] getDeclarations() {
        if (this.getPropertyName() == null) {
            return new String[]{this.getIdentifierName().toString()};
        }
        return new String[]{this.getIdentifierName().toString(), this.getPropertyName().toString()};
    }

    @Override
    public List<IGosuAnnotation> getAnnotations() {
        return this._modifiers == null ? Collections.emptyList() : this._modifiers.getAnnotations();
    }

    public String getFullDescription() {
        return this._modifiers == null ? "" : this._modifiers.getDescription();
    }

    public void clearDefn() {
        this._expression = null;
    }

    public boolean isDefinitionParsed() {
        return this._bDefinitionParsed;
    }

    public void setDefinitionParsed(boolean bParsed) {
        this._bDefinitionParsed = bParsed;
    }

    public boolean getHasInitializer() {
        return this._expression != null || this._bIsInitializedTopLevelProgVar;
    }

    public boolean isImplicitlyUsed() {
        return !this.isPrivate() || this.hasProperty();
    }

    public int getPropertyNameOffset() {
        return this._iPropertyNameOffset;
    }

    public boolean isFieldDeclaration() {
        return this.getParent() instanceof IClassStatement;
    }

    public void setIsInitializedTopLevelProgVar() {
        this._bIsInitializedTopLevelProgVar = true;
    }

    public DynamicPropertySymbol getProperty() {
        return this._dps;
    }

    public void setProperty(DynamicPropertySymbol dps) {
        this._dps = dps;
    }
}

