/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.tree;

import gw.lang.ir.IRClass;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.ir.expression.IRArithmeticExpression;
import gw.lang.ir.expression.IRArrayLoadExpression;
import gw.lang.ir.expression.IRBooleanLiteral;
import gw.lang.ir.expression.IRCastExpression;
import gw.lang.ir.expression.IRClassLiteral;
import gw.lang.ir.expression.IRCompositeExpression;
import gw.lang.ir.expression.IREqualityExpression;
import gw.lang.ir.expression.IRFieldGetExpression;
import gw.lang.ir.expression.IRIdentifier;
import gw.lang.ir.expression.IRMethodCallExpression;
import gw.lang.ir.expression.IRNegationExpression;
import gw.lang.ir.expression.IRNewArrayExpression;
import gw.lang.ir.expression.IRNewExpression;
import gw.lang.ir.expression.IRNullLiteral;
import gw.lang.ir.expression.IRNumericLiteral;
import gw.lang.ir.expression.IRPrimitiveTypeConversion;
import gw.lang.ir.expression.IRRelationalExpression;
import gw.lang.ir.expression.IRStringLiteralExpression;
import gw.lang.ir.expression.IRTernaryExpression;
import gw.lang.ir.statement.IRArrayStoreStatement;
import gw.lang.ir.statement.IRAssignmentStatement;
import gw.lang.ir.statement.IRBreakStatement;
import gw.lang.ir.statement.IRCatchClause;
import gw.lang.ir.statement.IRContinueStatement;
import gw.lang.ir.statement.IRFieldDecl;
import gw.lang.ir.statement.IRFieldSetStatement;
import gw.lang.ir.statement.IRForEachStatement;
import gw.lang.ir.statement.IRIfStatement;
import gw.lang.ir.statement.IRMethodCallStatement;
import gw.lang.ir.statement.IRMethodStatement;
import gw.lang.ir.statement.IRNoOpStatement;
import gw.lang.ir.statement.IRReturnStatement;
import gw.lang.ir.statement.IRStatementList;
import gw.lang.ir.statement.IRSyntheticStatement;
import gw.lang.ir.statement.IRThrowStatement;
import gw.lang.ir.statement.IRTryCatchFinallyStatement;
import java.lang.reflect.Modifier;
import java.util.List;

public class IRTreeCompiler {
    private StringBuilder _output = new StringBuilder();
    static final int BRIDGE = 64;
    static final int VARARGS = 128;
    static final int SYNTHETIC = 4096;
    static final int ANNOTATION = 8192;
    static final int ENUM = 16384;

    public StringBuilder getOutput() {
        return this._output;
    }

    public void compileClassStatement(IRClass irClass) {
        this._output.append("IRClass[\n");
        this.appendAttribute(2, "name", irClass.getName());
        this.appendAttribute(2, "modifiers", this.getModifierString(irClass.getModifiers()));
        this.appendAttribute(2, "supertype", irClass.getSuperType().getName());
        this.appendAttribute(2, "interfaces", this.joinTypeNames(irClass.getInterfaces()));
        this.appendAttribute(2, "sourceFile", irClass.getSourceFile());
        if (irClass.getInnerClasses().isEmpty()) {
            this.appendAttribute(2, "innerclasses", "[]");
        }
        if (irClass.getFields().isEmpty()) {
            this.appendAttribute(2, "fields", "[]");
        } else {
            this.appendIndent(2).append("fields: \n");
            for (IRFieldDecl fieldDecl : irClass.getFields()) {
                this.compileIRFieldDecl(fieldDecl, 4);
            }
        }
        if (irClass.getMethods().isEmpty()) {
            this.appendAttribute(2, "methods", "[]");
        } else {
            this.appendIndent(2).append("methods: \n");
            for (IRMethodStatement methodStatement : irClass.getMethods()) {
                this.compileIRMethodStatement(methodStatement, 4);
            }
        }
        this._output.append("]");
    }

    public void compileIRElement(IRElement element, int indent) {
        if (element instanceof IRStatement) {
            this.compileIRStatement((IRStatement)element, indent);
        } else {
            this.compileIRExpression((IRExpression)element, indent);
        }
    }

    public void compileIRStatement(IRStatement statement, int indent) {
        if (statement instanceof IRAssignmentStatement) {
            this.compileIRAssignmentStatement((IRAssignmentStatement)statement, indent);
        } else if (statement instanceof IRFieldDecl) {
            this.compileIRFieldDecl((IRFieldDecl)statement, indent);
        } else if (statement instanceof IRFieldSetStatement) {
            this.compileIRFieldSetStatement((IRFieldSetStatement)statement, indent);
        } else if (statement instanceof IRIfStatement) {
            this.compileIRIfStatement((IRIfStatement)statement, indent);
        } else if (statement instanceof IRMethodCallStatement) {
            this.compileIRMethodCallStatement((IRMethodCallStatement)statement, indent);
        } else if (statement instanceof IRMethodStatement) {
            this.compileIRMethodStatement((IRMethodStatement)statement, indent);
        } else if (statement instanceof IRNoOpStatement) {
            this.compileIRNoOpStatement((IRNoOpStatement)statement, indent);
        } else if (statement instanceof IRReturnStatement) {
            this.compileIRReturnStatement((IRReturnStatement)statement, indent);
        } else if (statement instanceof IRStatementList) {
            this.compileIRStatementList((IRStatementList)statement, indent);
        } else if (statement instanceof IRArrayStoreStatement) {
            this.compileIRArrayStoreStatement((IRArrayStoreStatement)statement, indent);
        } else if (statement instanceof IRThrowStatement) {
            this.compileIRThrowStatement((IRThrowStatement)statement, indent);
        } else if (statement instanceof IRTryCatchFinallyStatement) {
            this.compileIRTryCatchFinallyStatement((IRTryCatchFinallyStatement)statement, indent);
        } else if (statement instanceof IRBreakStatement) {
            this.compileIRBreakStatement((IRBreakStatement)statement, indent);
        } else if (statement instanceof IRContinueStatement) {
            this.compileIRContinueStatement((IRContinueStatement)statement, indent);
        } else if (statement instanceof IRForEachStatement) {
            this.compileIRForEachStatement((IRForEachStatement)statement, indent);
        } else if (statement instanceof IRSyntheticStatement) {
            this.compileIRSyntheticStatement((IRSyntheticStatement)statement, indent);
        } else {
            throw new IllegalArgumentException("Unrecognized statement of type " + statement.getClass());
        }
    }

    private void compileIRSyntheticStatement(IRSyntheticStatement syntheticStatement, int indent) {
        this.compileIRExpression(syntheticStatement.getExpression(), indent);
    }

    private void compileIRForEachStatement(IRForEachStatement irForEachStatement, int indent) {
        this.appendIndent(indent).append("IRForEachStatement[\n");
        for (IRStatement initializer : irForEachStatement.getInitializers()) {
            this.appendNestedElement(indent, "initializer", (IRElement)initializer);
        }
        this.appendNestedElement(indent, "test", (IRElement)irForEachStatement.getLoopTest());
        this.appendNestedElement(indent, "identifierToNullCheck", (IRElement)irForEachStatement.getIdentifierToNullCheck());
        for (IRStatement incrementor : irForEachStatement.getIncrementors()) {
            this.appendNestedElement(indent, "incrementor", (IRElement)incrementor);
        }
        this.appendNestedElement(indent, "body", (IRElement)irForEachStatement.getBody());
        this.appendIndent(indent).append("]\n");
    }

    private void compileIRContinueStatement(IRContinueStatement ircontinueStatement, int indent) {
        this.appendIndent(indent).append("IRContinueStatement[]\n");
    }

    private void compileIRBreakStatement(IRBreakStatement irBreakStatement, int indent) {
        this.appendIndent(indent).append("IRBreakStatement[]\n");
    }

    private void compileIRTryCatchFinallyStatement(IRTryCatchFinallyStatement irTryCatchFinallyStatement, int indent) {
        this.appendIndent(indent).append("IRTryCatchFinallyStatement[\n");
        this.appendNestedElement(indent, "try", (IRElement)irTryCatchFinallyStatement.getTryBody());
        for (IRCatchClause catchClause : irTryCatchFinallyStatement.getCatchStatements()) {
            this.appendAttribute(indent, "catchsymbol", this.getSymbolString(catchClause.getIdentifier()));
            this.appendNestedElement(indent, "catchbody", (IRElement)catchClause.getBody());
        }
        this.appendNestedElement(indent, "finally", (IRElement)irTryCatchFinallyStatement.getFinallyBody());
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRThrowStatement(IRThrowStatement irThrowStatement, int indent) {
        this.appendIndent(indent).append("IRThrowStatement[\n");
        this.appendNestedElement(indent, "exception", (IRElement)irThrowStatement.getException());
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRArrayStoreStatement(IRArrayStoreStatement irArrayStoreStatement, int indent) {
        this.appendIndent(indent).append("IRArrayStoreStatement[\n");
        this.appendAttribute(indent, "componenttype", irArrayStoreStatement.getComponentType().getName());
        this.appendNestedElement(indent, "target", (IRElement)irArrayStoreStatement.getTarget());
        this.appendNestedElement(indent, "index", (IRElement)irArrayStoreStatement.getIndex());
        this.appendNestedElement(indent, "value", (IRElement)irArrayStoreStatement.getValue());
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRFieldSetStatement(IRFieldSetStatement irFieldSetStatement, int indent) {
        this.appendIndent(indent).append("IRFieldSetStatement[\n");
        this.appendAttribute(indent, "name", irFieldSetStatement.getName());
        this.appendAttribute(indent, "fieldtype", irFieldSetStatement.getFieldType().getName());
        this.appendAttribute(indent, "ownerstype", irFieldSetStatement.getOwnersType().getName());
        this.appendNestedElement(indent, "lhs", (IRElement)irFieldSetStatement.getLhs());
        this.appendNestedElement(indent, "rhs", (IRElement)irFieldSetStatement.getRhs());
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRIfStatement(IRIfStatement irIfStatement, int indent) {
        this.appendIndent(indent).append("IRIfStatement[\n");
        this.appendNestedElement(indent, "condition", (IRElement)irIfStatement.getExpression());
        this.appendNestedElement(indent, "if", (IRElement)irIfStatement.getIfStatement());
        this.appendNestedElement(indent, "else", (IRElement)irIfStatement.getElseStatement());
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRMethodCallStatement(IRMethodCallStatement irMethodCallStatement, int indent) {
        this.appendIndent(indent).append("IRMethodCallStatement[\n");
        this.appendNestedElement(indent, "methodcall", (IRElement)irMethodCallStatement.getExpression());
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRNoOpStatement(IRNoOpStatement irNoOpStatement, int indent) {
        this.appendIndent(indent).append("IRNoOpStatement[\n");
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRReturnStatement(IRReturnStatement irReturnStatement, int indent) {
        this.appendIndent(indent).append("IRReturnStatement[\n");
        this.appendNestedElement(indent, "returnvalue", (IRElement)irReturnStatement.getReturnValue());
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRStatementList(IRStatementList irStatementList, int indent) {
        this.appendIndent(indent).append("IRStatementList[\n");
        this.appendAttribute(indent, "lineNumber", "" + irStatementList.getLineNumber());
        this.appendIndent(indent + 2).append("statements").append(": \n");
        for (IRStatement statement : irStatementList.getStatements()) {
            this.compileIRStatement(statement, indent + 4);
        }
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRAssignmentStatement(IRAssignmentStatement irAssignmentStatement, int indent) {
        this.appendIndent(indent).append("IRAssignmentStatement[\n");
        this.appendAttribute(indent, "symbol", this.getSymbolString(irAssignmentStatement.getSymbol()));
        this.appendNestedElement(indent, "value", (IRElement)irAssignmentStatement.getValue());
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRExpression(IRExpression expression, int indent) {
        if (expression instanceof IRArithmeticExpression) {
            this.compileIRAdditiveExpression((IRArithmeticExpression)expression, indent);
        } else if (expression instanceof IRArrayLoadExpression) {
            this.compileIRArrayLoadExpression((IRArrayLoadExpression)expression, indent);
        } else if (expression instanceof IRBooleanLiteral) {
            this.compileIRBooleanLiteral((IRBooleanLiteral)expression, indent);
        } else if (expression instanceof IRCompositeExpression) {
            this.compileIRCompositeExpression((IRCompositeExpression)expression, indent);
        } else if (expression instanceof IREqualityExpression) {
            this.compileIREqualityExpression((IREqualityExpression)expression, indent);
        } else if (expression instanceof IRFieldGetExpression) {
            this.compileIRFieldGetExpression((IRFieldGetExpression)expression, indent);
        } else if (expression instanceof IRIdentifier) {
            this.compileIRIdentifier((IRIdentifier)expression, indent);
        } else if (expression instanceof IRMethodCallExpression) {
            this.compileIRMethodCallExpression((IRMethodCallExpression)expression, indent);
        } else if (expression instanceof IRNullLiteral) {
            this.compileIRNullLiteral((IRNullLiteral)expression, indent);
        } else if (expression instanceof IRPrimitiveTypeConversion) {
            this.compileIRPrimitiveTypeConversion((IRPrimitiveTypeConversion)expression, indent);
        } else if (expression instanceof IRTernaryExpression) {
            this.compileIRTernaryExpression((IRTernaryExpression)expression, indent);
        } else if (expression instanceof IRNumericLiteral) {
            this.compileIRNumericLiteral((IRNumericLiteral)expression, indent);
        } else if (expression instanceof IRStringLiteralExpression) {
            this.compileIRStringLiteralExpression((IRStringLiteralExpression)expression, indent);
        } else if (expression instanceof IRNewArrayExpression) {
            this.compileIRNewArrayExpression((IRNewArrayExpression)expression, indent);
        } else if (expression instanceof IRCastExpression) {
            this.compileIRCastExpression((IRCastExpression)expression, indent);
        } else if (expression instanceof IRNewExpression) {
            this.compileIRNewExpression((IRNewExpression)expression, indent);
        } else if (expression instanceof IRRelationalExpression) {
            this.compileIRRelationalExpression((IRRelationalExpression)expression, indent);
        } else if (expression instanceof IRNegationExpression) {
            this.compileIRNegationExpression((IRNegationExpression)expression, indent);
        } else if (expression instanceof IRClassLiteral) {
            this.compileIRClassLiteral((IRClassLiteral)expression, indent);
        } else {
            throw new IllegalArgumentException("Unrecognized expression of type " + expression.getClass());
        }
    }

    private void compileIRClassLiteral(IRClassLiteral irClassLiteral, int indent) {
        this.appendIndent(indent).append("IRClassLiteral[\n");
        this.appendAttribute(indent, "type", irClassLiteral.getLiteralType().getName());
        this.appendIndent(indent).append("]\n");
    }

    private void compileIRNegationExpression(IRNegationExpression irNegationExpression, int indent) {
        this.appendIndent(indent).append("IRNegationExpression[\n");
        this.appendNestedElement(indent, "root", (IRElement)irNegationExpression.getRoot());
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRRelationalExpression(IRRelationalExpression irRelationalExpression, int indent) {
        String op;
        switch (irRelationalExpression.getOp()) {
            case GT: {
                op = " > ";
                break;
            }
            case GTE: {
                op = " >= ";
                break;
            }
            case LT: {
                op = " < ";
                break;
            }
            case LTE: {
                op = " <= ";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected operation " + irRelationalExpression.getOp());
            }
        }
        this.appendIndent(indent).append("IRRelationalExpression[\n");
        this.appendAttribute(indent, "op", op);
        this.appendNestedElement(indent, "lhs", (IRElement)irRelationalExpression.getLhs());
        this.appendNestedElement(indent, "rhs", (IRElement)irRelationalExpression.getRhs());
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRNewExpression(IRNewExpression irNewExpression, int indent) {
        this.appendIndent(indent).append("IRNewExpression[\n");
        this.appendAttribute(indent, "owner", irNewExpression.getOwnersType().getName());
        this.appendAttribute(indent, "parametertypes", this.joinTypeNames(irNewExpression.getParameterTypes()));
        this.appendIndent(indent + 2).append("args").append(": \n");
        for (IRElement element : irNewExpression.getArgs()) {
            this.compileIRElement(element, indent + 4);
        }
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRCastExpression(IRCastExpression irCastExpression, int indent) {
        this.appendIndent(indent).append("IRCastExpression[\n");
        this.appendAttribute(indent, "type", irCastExpression.getType().getName());
        this.appendNestedElement(indent, "root", (IRElement)irCastExpression.getRoot());
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRNewArrayExpression(IRNewArrayExpression irNewArrayExpression, int indent) {
        this.appendIndent(indent).append("IRNewArrayExpression[\n");
        this.appendAttribute(indent, "type", irNewArrayExpression.getType().getName());
        this.appendNestedElement(indent, "size", (IRElement)irNewArrayExpression.getSizeExpression());
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRStringLiteralExpression(IRStringLiteralExpression irStringLiteralExpression, int indent) {
        this.appendIndent(indent).append("IRStringLiteralExpression[\n");
        this.appendAttribute(indent, "value", irStringLiteralExpression.getValue());
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRNumericLiteral(IRNumericLiteral irNumericLiteral, int indent) {
        this.appendIndent(indent).append("IRNumericLiteral[\n");
        this.appendAttribute(indent, "type", irNumericLiteral.getValue().getClass().getName());
        this.appendAttribute(indent, "value", irNumericLiteral.getValue().toString());
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRAdditiveExpression(IRArithmeticExpression irAdditiveExpression, int indent) {
        this.appendIndent(indent).append("IRAdditiveExpression[\n");
        this.appendAttribute(indent, "type", irAdditiveExpression.getType().getName());
        this.appendAttribute(indent, "op", irAdditiveExpression.getOp().toString());
        this.appendNestedElement(indent, "lhs", (IRElement)irAdditiveExpression.getLhs());
        this.appendNestedElement(indent, "rhs", (IRElement)irAdditiveExpression.getRhs());
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRArrayLoadExpression(IRArrayLoadExpression irArrayLoadExpression, int indent) {
        this.appendIndent(indent).append("IRArrayLoadExpression[\n");
        this.appendAttribute(indent, "componenttype", irArrayLoadExpression.getComponentType().getName());
        this.appendNestedElement(indent, "root", (IRElement)irArrayLoadExpression.getRoot());
        this.appendNestedElement(indent, "index", (IRElement)irArrayLoadExpression.getIndex());
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRBooleanLiteral(IRBooleanLiteral irBooleanLiteral, int indent) {
        this.appendIndent(indent).append("IRBooleanLiteral[\n");
        this.appendAttribute(indent, "value", "" + irBooleanLiteral.getValue());
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRCompositeExpression(IRCompositeExpression irCompositeExpression, int indent) {
        this.appendIndent(indent).append("IRCompositeExpression[\n");
        this.appendIndent(indent + 2).append("expressions").append(": \n");
        for (IRElement element : irCompositeExpression.getElements()) {
            this.compileIRElement(element, indent + 4);
        }
        this.appendIndent(indent).append("]\n");
    }

    public void compileIREqualityExpression(IREqualityExpression irEqualityExpression, int indent) {
        this.appendIndent(indent).append("IREqualityExpression[\n");
        this.appendNestedElement(indent, "lhs", (IRElement)irEqualityExpression.getLhs());
        this.appendNestedElement(indent, "rhs", (IRElement)irEqualityExpression.getRhs());
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRFieldGetExpression(IRFieldGetExpression irFieldGetExpression, int indent) {
        this.appendIndent(indent).append("IRFieldGetExpression[\n");
        this.appendAttribute(indent, "name", irFieldGetExpression.getName());
        this.appendAttribute(indent, "type", irFieldGetExpression.getFieldType().getName());
        this.appendAttribute(indent, "owner", irFieldGetExpression.getOwnersType().getName());
        this.appendNestedElement(indent, "lhs", (IRElement)irFieldGetExpression.getLhs());
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRIdentifier(IRIdentifier irIdentifier, int indent) {
        this.appendIndent(indent).append("IRIdentifier[\n");
        this.appendAttribute(indent, "symbol", this.getSymbolString(irIdentifier.getSymbol()));
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRMethodCallExpression(IRMethodCallExpression irMethodCallExpression, int indent) {
        this.appendIndent(indent).append("IRMethodCallExpression[\n");
        this.appendAttribute(indent, "name", irMethodCallExpression.getName());
        this.appendAttribute(indent, "owner", irMethodCallExpression.getOwnersType().getName());
        this.appendAttribute(indent, "returntype", irMethodCallExpression.getReturnType().getName());
        this.appendAttribute(indent, "parametertypes", this.joinTypeNames(irMethodCallExpression.getParameterTypes()));
        this.appendNestedElement(indent, "root", (IRElement)irMethodCallExpression.getRoot());
        this.appendIndent(indent + 2).append("args").append(": \n");
        for (IRElement element : irMethodCallExpression.getArgs()) {
            this.compileIRElement(element, indent + 4);
        }
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRNullLiteral(IRNullLiteral irNullLiteral, int indent) {
        this.appendIndent(indent).append("IRNullLiteral[\n");
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRPrimitiveTypeConversion(IRPrimitiveTypeConversion irPrimitiveTypeConversion, int indent) {
        this.appendIndent(indent).append("IRPrimitiveTypeConversion[\n");
        this.appendAttribute(indent, "from", irPrimitiveTypeConversion.getFromType().getName());
        this.appendAttribute(indent, "to", irPrimitiveTypeConversion.getToType().getName());
        this.appendNestedElement(indent, "root", (IRElement)irPrimitiveTypeConversion.getRoot());
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRTernaryExpression(IRTernaryExpression irTernaryExpression, int indent) {
        this.appendIndent(indent).append("IRTernaryExpression[\n");
        this.appendNestedElement(indent, "test", (IRElement)irTernaryExpression.getTest());
        this.appendNestedElement(indent, "truevalue", (IRElement)irTernaryExpression.getTrueValue());
        this.appendNestedElement(indent, "falsevalue", (IRElement)irTernaryExpression.getFalseValue());
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRFieldDecl(IRFieldDecl fieldDecl, int indent) {
        this.appendIndent(indent).append("IRFieldDecl[\n");
        this.appendAttribute(indent, "name", fieldDecl.getName());
        this.appendAttribute(indent, "type", fieldDecl.getType().getName());
        this.appendAttribute(indent, "modifiers", this.getModifierString(fieldDecl.getModifiers()));
        if (fieldDecl.getValue() != null) {
            this.appendAttribute(indent, "value", fieldDecl.getValue().toString());
        }
        this.appendIndent(indent).append("]\n");
    }

    public void compileIRMethodStatement(IRMethodStatement methodStatement, int indent) {
        this.appendIndent(indent).append("IRMethodStatement[\n");
        this.appendAttribute(indent, "name", methodStatement.getName());
        this.appendAttribute(indent, "params", this.joinSymbols(methodStatement.getParameters()));
        this.appendAttribute(indent, "returntype", methodStatement.getReturnType().getName());
        this.appendAttribute(indent, "modifiers", this.getModifierString(methodStatement.getModifiers()));
        this.appendIndent(indent + 2).append("body: \n");
        this.compileIRStatement(methodStatement.getMethodBody(), indent + 4);
        this.appendIndent(indent).append("]\n");
    }

    private String getModifierString(int modifiers) {
        StringBuilder sb = new StringBuilder();
        sb.append("(").append(modifiers).append(") ");
        if (Modifier.isPublic(modifiers)) {
            sb.append("public ");
        } else if (Modifier.isPrivate(modifiers)) {
            sb.append("private ");
        } else if (Modifier.isProtected(modifiers)) {
            sb.append("protected ");
        } else {
            sb.append("internal ");
        }
        if (Modifier.isAbstract(modifiers)) {
            sb.append("abstract ");
        }
        if (Modifier.isFinal(modifiers)) {
            sb.append("final ");
        }
        if (Modifier.isInterface(modifiers)) {
            sb.append("interface ");
        }
        if (Modifier.isNative(modifiers)) {
            sb.append("native ");
        }
        if (Modifier.isStatic(modifiers)) {
            sb.append("static ");
        }
        if (Modifier.isTransient(modifiers)) {
            sb.append("transient ");
        }
        if (Modifier.isVolatile(modifiers)) {
            sb.append("volatile ");
        }
        if ((modifiers & 0x40) != 0) {
            sb.append("bridge ");
        }
        if ((modifiers & 0x80) != 0) {
            sb.append("varargs ");
        }
        if ((modifiers & 0x1000) != 0) {
            sb.append("synthetic ");
        }
        if ((modifiers & 0x2000) != 0) {
            sb.append("annotation ");
        }
        if ((modifiers & 0x4000) != 0) {
            sb.append("enum ");
        }
        return sb.toString();
    }

    private String joinTypeNames(List<IRType> types) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < types.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(types.get(i).getName());
        }
        return sb.toString();
    }

    private String joinSymbols(List<IRSymbol> symbols) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < symbols.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.getSymbolString(symbols.get(i)));
        }
        return sb.toString();
    }

    private String getSymbolString(IRSymbol symbol) {
        return symbol.getName() + " : " + symbol.getType().getName();
    }

    private void appendAttribute(int indent, String name, String value) {
        this.appendIndent(indent + 2).append(name).append(": ").append(value).append("\n");
    }

    private void appendNestedElement(int indent, String name, IRElement element) {
        if (element == null) {
            this.appendAttribute(indent, name, "[]");
        } else {
            this.appendIndent(indent + 2).append(name).append(": \n");
            this.compileIRElement(element, indent + 4);
        }
    }

    private StringBuilder appendIndent(int indent) {
        for (int i = 0; i < indent; ++i) {
            this._output.append(" ");
        }
        return this._output;
    }
}

