/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.statement;

import gw.config.CommonServices;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.statement.AbstractStatementTransformer;
import gw.internal.gosu.parser.TypeLoaderAccess;
import gw.internal.gosu.parser.expressions.ArrayAccess;
import gw.internal.gosu.parser.statements.ArrayAssignmentStatement;
import gw.internal.gosu.runtime.GosuRuntimeMethods;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.statement.IRMethodCallStatement;
import gw.lang.ir.statement.IRStatementList;
import gw.lang.parser.EvaluationException;
import gw.lang.reflect.IPlaceholder;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.JavaTypes;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ArrayAssignmentStatementTransformer
extends AbstractStatementTransformer<ArrayAssignmentStatement> {
    public static IRStatement compile(TopLevelTransformationContext cc, ArrayAssignmentStatement stmt) {
        ArrayAssignmentStatementTransformer gen = new ArrayAssignmentStatementTransformer(cc, stmt);
        return gen.compile();
    }

    private ArrayAssignmentStatementTransformer(TopLevelTransformationContext cc, ArrayAssignmentStatement stmt) {
        super(cc, stmt);
    }

    @Override
    protected IRStatement compile_impl() {
        IRExpression index;
        IRExpression root;
        ArrayAccess arrayAccess = ((ArrayAssignmentStatement)this._stmt()).getArrayAccessExpression();
        IRExpression originalRoot = ExpressionTransformer.compile(arrayAccess.getRootExpression(), this._cc());
        IRSymbol tempRoot = null;
        boolean needsAutoinsert = ArrayAssignmentStatementTransformer.needsAutoinsert(arrayAccess);
        if (needsAutoinsert || ((ArrayAssignmentStatement)this._stmt()).isCompoundStatement()) {
            tempRoot = this._cc().makeAndIndexTempSymbol(originalRoot.getType());
            root = this.identifier(tempRoot);
            if (((ArrayAssignmentStatement)this._stmt()).isCompoundStatement()) {
                ExpressionTransformer.addTempSymbolForCompoundAssignment(arrayAccess.getRootExpression(), tempRoot);
            }
        } else {
            root = originalRoot;
        }
        IRExpression originalIndex = ExpressionTransformer.compile(arrayAccess.getMemberExpression(), this._cc());
        IRSymbol tempIndex = null;
        if (needsAutoinsert || ((ArrayAssignmentStatement)this._stmt()).isCompoundStatement()) {
            tempIndex = this._cc().makeAndIndexTempSymbol(originalIndex.getType());
            index = this.identifier(tempIndex);
            if (((ArrayAssignmentStatement)this._stmt()).isCompoundStatement()) {
                ExpressionTransformer.addTempSymbolForCompoundAssignment(arrayAccess.getMemberExpression(), tempIndex);
            }
        } else {
            index = originalIndex;
        }
        IRExpression value = ExpressionTransformer.compile(((ArrayAssignmentStatement)this._stmt()).getExpression(), this._cc());
        IType rootType = arrayAccess.getRootExpression().getType();
        if (rootType.isArray() && ArrayAssignmentStatementTransformer.isBytecodeType(rootType)) {
            IRStatement ret = this.buildArrayStore(root, index, value, ArrayAssignmentStatementTransformer.getDescriptor(rootType.getComponentType()));
            if (((ArrayAssignmentStatement)this._stmt()).isCompoundStatement()) {
                ExpressionTransformer.clearTempSymbolForCompoundAssignment();
                return new IRStatementList(false, new IRStatement[]{this.buildAssignment(tempRoot, originalRoot), this.buildAssignment(tempIndex, originalIndex), ret});
            }
            return ret;
        }
        if (needsAutoinsert) {
            return new IRStatementList(false, new IRStatement[]{this.buildAssignment(tempRoot, originalRoot), this.buildAssignment(tempIndex, originalIndex), this.buildMethodCall(this.callStaticMethod(ArrayAssignmentStatementTransformer.class, "setOrAddElement", new Class[]{Object.class, Integer.TYPE, Object.class}, ArrayAssignmentStatementTransformer.exprList(root, index, value)))});
        }
        IRMethodCallStatement ret = JavaTypes.LIST().isAssignableFrom(rootType) ? this.buildMethodCall((IRExpression)this.buildMethodCall(List.class, "set", Object.class, new Class[]{Integer.TYPE, Object.class}, this.buildCast(ArrayAssignmentStatementTransformer.getDescriptor(List.class), root), Arrays.asList(index, value))) : (JavaTypes.STRING_BUILDER().isAssignableFrom(rootType) ? this.buildMethodCall((IRExpression)this.buildMethodCall(StringBuilder.class, "setCharAt", Void.TYPE, new Class[]{Integer.TYPE, Character.TYPE}, this.buildCast(ArrayAssignmentStatementTransformer.getDescriptor(StringBuilder.class), root), Arrays.asList(index, value))) : (rootType instanceof IPlaceholder ? this.buildMethodCall(this.callStaticMethod(ArrayAssignmentStatementTransformer.class, "setPropertyOrElementOnDynamicType", new Class[]{Object.class, Object.class, Object.class}, ArrayAssignmentStatementTransformer.exprList(root, index, value))) : this.buildMethodCall(this.callStaticMethod(ArrayAssignmentStatementTransformer.class, "setArrayElement", new Class[]{Object.class, Integer.TYPE, Object.class}, ArrayAssignmentStatementTransformer.exprList(root, index, value)))));
        if (((ArrayAssignmentStatement)this._stmt()).isCompoundStatement()) {
            ExpressionTransformer.clearTempSymbolForCompoundAssignment();
            return new IRStatementList(false, new IRStatement[]{this.buildAssignment(tempRoot, originalRoot), this.buildAssignment(tempIndex, originalIndex), ret});
        }
        return ret;
    }

    private static boolean needsAutoinsert(ArrayAccess arrayAccess) {
        if (ArrayAccess.needsAutoinsert(arrayAccess)) {
            return true;
        }
        if (arrayAccess.getRootExpression() instanceof ArrayAccess) {
            return ArrayAccess.needsAutoinsert((ArrayAccess)arrayAccess.getRootExpression());
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setPropertyOrElementOnDynamicType(Object obj, Object index, Object value) {
        if (obj == null) {
            throw new NullPointerException();
        }
        if (index instanceof Number) {
            if (obj instanceof Map) {
                ((Map)obj).put(index, value);
                return;
            } else if (obj.getClass().isArray()) {
                Array.set(obj, ((Number)index).intValue(), value);
                return;
            } else if (obj instanceof List) {
                ((List)obj).set(((Number)index).intValue(), value);
                return;
            } else if (obj instanceof StringBuilder) {
                if (value instanceof Character) {
                    ((StringBuilder)obj).setCharAt(((Number)index).intValue(), ((Character)value).charValue());
                    return;
                } else if (value instanceof Number) {
                    ((StringBuilder)obj).setCharAt(((Number)index).intValue(), (char)((Number)value).intValue());
                    return;
                } else {
                    ArrayAssignmentStatementTransformer.replaceAt((StringBuilder)obj, (Number)index, value);
                }
                return;
            } else {
                IType classObj = TypeLoaderAccess.instance().getIntrinsicTypeFromObject(obj);
                if (!classObj.isArray()) throw new UnsupportedOperationException("Don't know how to assign [" + value + "] to [" + obj + "] at index [" + index + "]");
                value = CommonServices.getCoercionManager().convertValue(value, classObj.getComponentType());
                classObj.setArrayComponent(obj, ((Number)index).intValue(), value);
            }
            return;
        } else if (obj instanceof Map) {
            ((Map)obj).put(index, value);
            return;
        } else {
            GosuRuntimeMethods.setPropertyDynamically(obj, index.toString(), value);
        }
    }

    private static void replaceAt(StringBuilder obj, Number index, Object value) {
        int start = index.intValue();
        int end = start + ((CharSequence)value).length();
        if (end <= obj.length()) {
            obj.replace(start, end, value.toString());
        } else {
            obj.delete(start, obj.length());
            String s = value.toString();
            obj.append(s);
        }
    }

    public static void setArrayElement(Object obj, int iIndex, Object value) {
        if (obj instanceof List) {
            ((List)obj).set(iIndex, value);
            return;
        }
        IType classObj = TypeLoaderAccess.instance().getIntrinsicTypeFromObject(obj);
        if (classObj.isArray()) {
            value = CommonServices.getCoercionManager().convertValue(value, classObj.getComponentType());
            classObj.setArrayComponent(obj, iIndex, value);
            return;
        }
        if (obj instanceof StringBuffer) {
            ((StringBuffer)obj).setCharAt(iIndex, ((Character)CommonServices.getCoercionManager().convertValue(value, (IType)JavaTypes.CHARACTER())).charValue());
        }
        throw new EvaluationException("The type, " + classObj.getName() + ", is not coercible to an indexed-writable array.");
    }

    public static void setOrAddElement(Object obj, int iIndex, Object value) {
        List l = (List)obj;
        if (l.size() == iIndex) {
            l.add(value);
        } else {
            l.set(iIndex, value);
        }
    }
}

