/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.ClassAnnotationInfo;
import gw.internal.gosu.parser.ConstructorJavaClassConstructor;
import gw.internal.gosu.parser.DefaultTypeLoader;
import gw.internal.gosu.parser.FieldJavaClassField;
import gw.internal.gosu.parser.JavaMethodCache;
import gw.internal.gosu.parser.MethodDescriptorJavaMethodDescriptor;
import gw.internal.gosu.parser.MethodJavaClassMethod;
import gw.internal.gosu.parser.TypeJavaClassType;
import gw.internal.gosu.parser.TypeVariableJavaTypeVariable;
import gw.internal.gosu.parser.java.classinfo.JavaSourceUtil;
import gw.internal.gosu.parser.java.classinfo.PropertyDeriver;
import gw.lang.GosuShop;
import gw.lang.javadoc.IClassDocNode;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuObject;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.java.AbstractJavaClassInfo;
import gw.lang.reflect.java.IClassJavaClassInfo;
import gw.lang.reflect.java.IJavaAnnotatedElement;
import gw.lang.reflect.java.IJavaClassConstructor;
import gw.lang.reflect.java.IJavaClassField;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.IJavaClassType;
import gw.lang.reflect.java.IJavaClassTypeVariable;
import gw.lang.reflect.java.IJavaMethodDescriptor;
import gw.lang.reflect.java.IJavaPropertyDescriptor;
import gw.lang.reflect.module.IModule;
import gw.util.concurrent.LocklessLazyVar;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;

public class ClassJavaClassInfo
extends TypeJavaClassType
implements IClassJavaClassInfo {
    private Class<?> _class;
    private IJavaClassMethod[] _declaredMethods;
    private IJavaClassInfo[] _interfaces;
    private IJavaClassInfo _superclass;
    private IJavaClassTypeVariable[] _typeVariables;
    private IJavaClassField[] _declaredFields;
    private IJavaClassConstructor[] _declaredConstructors;
    private IAnnotationInfo[] _declaredAnnotations;
    private IJavaPropertyDescriptor[] _propertyDescriptors;
    private IJavaMethodDescriptor[] _methodDescriptors;
    private IJavaClassField[] _fields;
    private IJavaClassType[] _genericInterfaces;
    private IJavaClassInfo[] _declaredClasses;
    private ISourceFileHandle _fileHandle;
    private IType _javaType;
    private String _namespace;
    private volatile Integer _modifiers;
    private Boolean _bArray;
    private Boolean _bEnum;
    private Boolean _bInterface;
    private LocklessLazyVar<IType> _enclosingClass = new LocklessLazyVar<IType>(){

        protected IType init() {
            Class<?> enclosingClass = ClassJavaClassInfo.this._class.getEnclosingClass();
            return enclosingClass == null ? null : TypeSystem.get(enclosingClass, (IModule)ClassJavaClassInfo.this._module);
        }
    };

    public ClassJavaClassInfo(Class cls, IModule module) {
        super(cls, module);
        if (cls == null) {
            throw new IllegalArgumentException("Class cannot be null.");
        }
        this._class = cls;
        this._module = module;
    }

    public boolean isAnnotation() {
        return this._class.isAnnotation();
    }

    public boolean isInterface() {
        return this._bInterface == null ? (this._bInterface = Boolean.valueOf(this._class.isInterface())) : this._bInterface;
    }

    public IJavaClassType getConcreteType() {
        return this;
    }

    @Override
    public String getName() {
        return this._class.getName();
    }

    public String getNameSignature() {
        if (this._class.isArray()) {
            return this._class.getName();
        }
        return GosuShop.toSignature((String)this._class.getName());
    }

    public IJavaClassMethod getMethod(String methodName, IJavaClassInfo ... paramTypes) throws NoSuchMethodException {
        Class[] javaParamTypes = new Class[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            IJavaClassInfo paramType = paramTypes[i];
            if (paramType == null) {
                javaParamTypes[i] = null;
                continue;
            }
            javaParamTypes[i] = paramType.getBackingClass();
            if (javaParamTypes[i] != null) continue;
            throw new IllegalStateException("Class info for " + this.getName() + " is concrete, but class info for method parameter " + paramType.getName() + " is not (it's a " + paramType.getClass() + "), so can't get method by signature");
        }
        return new MethodJavaClassMethod(this._class.getMethod(methodName, javaParamTypes), this._module);
    }

    public IJavaClassMethod getDeclaredMethod(String methodName, IJavaClassInfo ... paramTypes) throws NoSuchMethodException {
        Class[] javaParamTypes = new Class[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            Class backingClass;
            IJavaClassInfo paramType = paramTypes[i];
            javaParamTypes[i] = backingClass = paramType.getBackingClass();
            if (backingClass != null) continue;
            throw new IllegalStateException("Class info for " + this.getName() + " is concrete, but class info for method parameter " + paramType.getName() + " is not (it's a " + paramType.getClass() + "), so can't get method by signature");
        }
        return new MethodJavaClassMethod(this._class.getMethod(methodName, javaParamTypes), this._module);
    }

    public IJavaClassMethod[] getDeclaredMethods() {
        if (this._declaredMethods == null) {
            Method[] rawMethods = JavaMethodCache.getDeclaredMethods(this._class);
            IJavaClassMethod[] methods = new IJavaClassMethod[rawMethods.length];
            for (int i = 0; i < rawMethods.length; ++i) {
                methods[i] = new MethodJavaClassMethod(rawMethods[i], this._module);
            }
            this._declaredMethods = methods;
        }
        return this._declaredMethods;
    }

    public Object newInstance() throws InstantiationException, IllegalAccessException {
        return this._class.newInstance();
    }

    public Object[] getEnumConstants() {
        return this._class.getEnumConstants();
    }

    public IType getJavaType() {
        return this._javaType == null ? (this._javaType = TypeSystem.get(this._class, (IModule)this._module)) : this._javaType;
    }

    public void setJavaType(IType javaType) {
        this._javaType = javaType;
    }

    public IJavaClassInfo[] getInterfaces() {
        if (this._interfaces == null) {
            Class<?>[] rawInterfaces = this._class.getInterfaces();
            IJavaClassInfo[] interfaces = new IJavaClassInfo[rawInterfaces.length];
            for (int i = 0; i < rawInterfaces.length; ++i) {
                interfaces[i] = JavaSourceUtil.getClassInfo(rawInterfaces[i], this._module);
            }
            this._interfaces = interfaces;
        }
        return this._interfaces;
    }

    public IJavaClassInfo getSuperclass() {
        if (this._superclass == null) {
            this._superclass = this._class.getSuperclass() == null ? NULL_TYPE : JavaSourceUtil.getClassInfo(this._class.getSuperclass(), this._module);
        }
        return this._superclass == NULL_TYPE ? null : this._superclass;
    }

    public IJavaClassTypeVariable[] getTypeParameters() {
        if (this._typeVariables == null) {
            TypeVariable<Class<?>>[] rawTypeVariables = this._class.getTypeParameters();
            IJavaClassTypeVariable[] typeVariables = new IJavaClassTypeVariable[rawTypeVariables.length];
            for (int i = 0; i < rawTypeVariables.length; ++i) {
                typeVariables[i] = new TypeVariableJavaTypeVariable(rawTypeVariables[i], this._module);
            }
            this._typeVariables = typeVariables;
        }
        return this._typeVariables;
    }

    public IJavaClassField[] getDeclaredFields() {
        if (this._declaredFields == null) {
            Field[] rawFields = this._class.getDeclaredFields();
            IJavaClassField[] fields = new IJavaClassField[rawFields.length];
            for (int i = 0; i < rawFields.length; ++i) {
                fields[i] = new FieldJavaClassField(rawFields[i], this._module);
            }
            this._declaredFields = fields;
        }
        return this._declaredFields;
    }

    public IJavaClassConstructor[] getDeclaredConstructors() {
        if (this._declaredConstructors == null) {
            Constructor<?>[] rawCtors = this._class.getDeclaredConstructors();
            ArrayList<ConstructorJavaClassConstructor> ctors = new ArrayList<ConstructorJavaClassConstructor>(rawCtors.length);
            for (Constructor<?> rawCtor : rawCtors) {
                if (rawCtor.isSynthetic()) continue;
                ctors.add(new ConstructorJavaClassConstructor(rawCtor, this._module));
            }
            this._declaredConstructors = ctors.toArray(new IJavaClassConstructor[ctors.size()]);
        }
        return this._declaredConstructors;
    }

    public IJavaClassConstructor getConstructor(IJavaClassInfo ... paramTypes) throws NoSuchMethodException {
        Class[] javaParamTypes = new Class[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            IJavaClassInfo paramType = paramTypes[i];
            if (!(paramType instanceof ClassJavaClassInfo)) {
                throw new IllegalStateException("Class info for " + this.getName() + " is concrete, but class info for method parameter " + paramType.getName() + " is not (it's a " + paramType.getClass() + "), so can't get method by signature");
            }
            javaParamTypes[i] = ((ClassJavaClassInfo)paramType)._class;
        }
        return new ConstructorJavaClassConstructor(this._class.getConstructor(javaParamTypes), this._module);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this._class.isAnnotationPresent(annotationClass);
    }

    public IAnnotationInfo getAnnotation(Class annotationClass) {
        Object annotation = this._class.getAnnotation(annotationClass);
        for (IAnnotationInfo annotationInfo : this.getDeclaredAnnotations()) {
            if (((ClassAnnotationInfo)annotationInfo).getInstance() != annotation) continue;
            return annotationInfo;
        }
        return null;
    }

    public IAnnotationInfo[] getDeclaredAnnotations() {
        if (this._declaredAnnotations == null) {
            Annotation[] annotations = this._class.getDeclaredAnnotations();
            IAnnotationInfo[] declaredAnnotations = new IAnnotationInfo[annotations.length];
            for (int i = 0; i < declaredAnnotations.length; ++i) {
                declaredAnnotations[i] = new ClassAnnotationInfo(annotations[i], (IJavaAnnotatedElement)this);
            }
            this._declaredAnnotations = declaredAnnotations;
        }
        return this._declaredAnnotations;
    }

    public IClassDocNode createClassDocNode() {
        return GosuShop.getJavaDocFactory().create(this._class);
    }

    public IJavaPropertyDescriptor[] getPropertyDescriptors() {
        if (this._propertyDescriptors == null) {
            this._propertyDescriptors = PropertyDeriver.initPropertyDescriptors((IJavaClassInfo)this);
        }
        return this._propertyDescriptors;
    }

    public IJavaMethodDescriptor[] getMethodDescriptors() {
        if (this._methodDescriptors == null) {
            Method[] rawMethods = JavaMethodCache.getDeclaredMethods(this._class);
            this._methodDescriptors = (IJavaMethodDescriptor[])Arrays.stream(rawMethods).filter(m -> !m.isSynthetic()).map(m -> new MethodDescriptorJavaMethodDescriptor((Method)m, this._module)).toArray(IJavaMethodDescriptor[]::new);
        }
        return this._methodDescriptors;
    }

    public boolean hasCustomBeanInfo() {
        return false;
    }

    public String getRelativeName() {
        return this.getName().substring(this.getNamespace().length() + 1);
    }

    public String getDisplayName() {
        return this.getSimpleName();
    }

    public String getSimpleName() {
        return this._class.getSimpleName();
    }

    public boolean isVisibleViaFeatureDescriptor(IScriptabilityModifier constraint) {
        return true;
    }

    public boolean isHiddenViaFeatureDescriptor() {
        return false;
    }

    public IJavaClassField[] getFields() {
        if (this._fields == null) {
            Field[] rawFields = this._class.getFields();
            IJavaClassField[] fields = new IJavaClassField[rawFields.length];
            for (int i = 0; i < rawFields.length; ++i) {
                fields[i] = new FieldJavaClassField(rawFields[i], this._module);
            }
            this._fields = fields;
        }
        return this._fields;
    }

    public Class getJavaClass() {
        return this._class;
    }

    public IJavaClassInfo getComponentType() {
        return JavaSourceUtil.getClassInfo(this._class.getComponentType(), this._module);
    }

    @Override
    public boolean isArray() {
        return this._bArray == null ? (this._bArray = Boolean.valueOf(this._class.isArray())) : this._bArray;
    }

    public boolean isEnum() {
        return this._bEnum == null ? (this._bEnum = Boolean.valueOf(this._class.isEnum())) : this._bEnum;
    }

    public int getModifiers() {
        return this.getCachedModifiers();
    }

    public boolean isPrimitive() {
        return this._class.isPrimitive();
    }

    public IJavaClassInfo getEnclosingClass() {
        Class<?> enclosingClass = this._class.getEnclosingClass();
        if (enclosingClass != null) {
            return TypeSystem.getJavaClassInfo(enclosingClass, (IModule)this._module);
        }
        return null;
    }

    public IType getEnclosingType() {
        return (IType)this._enclosingClass.get();
    }

    @Override
    public String getNamespace() {
        if (this._namespace == null) {
            Class<?> cls = this._class;
            Package aPackage = cls.getPackage();
            if (aPackage == null && this.isArray()) {
                while (aPackage == null && cls.isArray()) {
                    cls = cls.getComponentType();
                    aPackage = cls.getPackage();
                }
            }
            this._namespace = aPackage == null ? null : aPackage.getName();
        }
        return this._namespace;
    }

    public IJavaClassType[] getGenericInterfaces() {
        if (this._genericInterfaces == null) {
            Type[] rawIfaces = this._class.getGenericInterfaces();
            IJavaClassType[] ifaces = new IJavaClassType[rawIfaces.length];
            for (int i = 0; i < rawIfaces.length; ++i) {
                ifaces[i] = TypeJavaClassType.createType(rawIfaces[i], this._module);
            }
            this._genericInterfaces = ifaces;
        }
        return this._genericInterfaces;
    }

    public IJavaClassType getGenericSuperclass() {
        return TypeJavaClassType.createType(this._class.getGenericSuperclass(), this._module);
    }

    public IJavaClassInfo getArrayType() {
        DefaultTypeLoader defaultTypeLoader = (DefaultTypeLoader)this._module.getModuleTypeLoader().getDefaultTypeLoader();
        return defaultTypeLoader.getJavaClassInfo(Array.newInstance(this._class, 0).getClass(), this._module);
    }

    public IJavaClassInfo[] getDeclaredClasses() {
        if (this._declaredClasses == null) {
            Class<?>[] rawClasses = this._class.getDeclaredClasses();
            ArrayList<IJavaClassInfo> declaredClasses = new ArrayList<IJavaClassInfo>(rawClasses.length);
            for (int i = 0; i < rawClasses.length; ++i) {
                if (rawClasses[i].isAnonymousClass()) continue;
                DefaultTypeLoader defaultTypeLoader = (DefaultTypeLoader)this._module.getModuleTypeLoader().getDefaultTypeLoader();
                IJavaClassInfo declaredClassInfo = defaultTypeLoader.getJavaClassInfo(rawClasses[i], this._module);
                declaredClasses.add(declaredClassInfo);
            }
            this._declaredClasses = declaredClasses.toArray(new IJavaClassInfo[declaredClasses.size()]);
        }
        return this._declaredClasses;
    }

    public boolean isAssignableFrom(IJavaClassInfo aClass) {
        return AbstractJavaClassInfo.isAssignableFrom((IJavaClassInfo)this, (IJavaClassInfo)aClass);
    }

    public boolean isPublic() {
        return Modifier.isPublic((int)this.getCachedModifiers());
    }

    private int getCachedModifiers() {
        return this._modifiers == null ? (this._modifiers = Integer.valueOf(this._class.getModifiers())) : this._modifiers;
    }

    public boolean isProtected() {
        return Modifier.isProtected((int)this.getCachedModifiers());
    }

    public boolean isInternal() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public boolean isPrivate() {
        return Modifier.isPrivate((int)this.getCachedModifiers());
    }

    @Override
    public boolean equals(Object obj) {
        return AbstractJavaClassInfo.equals((IJavaClassInfo)this, (Object)obj);
    }

    @Override
    public int hashCode() {
        return AbstractJavaClassInfo.hashCode((IJavaClassInfo)this);
    }

    public String toString() {
        return this._class.toString();
    }

    public Class getBackingClass() {
        return this._class;
    }

    public ISourceFileHandle getSourceFileHandle() {
        return this._fileHandle;
    }

    @Override
    public IModule getModule() {
        return this._module;
    }

    public boolean isTypeGosuClassInstance() {
        return IGosuObject.class.isAssignableFrom(this._class) && TypeSystem.getByFullNameIfValid((String)this._class.getName().replace('$', '.')) instanceof IGosuClass;
    }

    public IJavaClassType resolveType(String relativeName, int ignoreFlags) {
        return null;
    }

    public IJavaClassType resolveType(String relativeName, IJavaClassInfo whosAskin, int ignoreFlags) {
        Class backingClass = this.getBackingClass();
        for (Class<?> innerClass : backingClass.getDeclaredClasses()) {
            if (!innerClass.getName().equals(this.getName() + "$" + relativeName)) continue;
            return JavaSourceUtil.getClassInfo(innerClass, this.getJavaType().getTypeLoader().getModule());
        }
        return null;
    }

    public IJavaClassType resolveImport(String relativeName) {
        return null;
    }

    public void setSourceFileHandle(ISourceFileHandle fileHandle) {
        this._fileHandle = fileHandle;
    }
}

