/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.GosuDocAnnotation;
import gw.internal.gosu.parser.IGosuAnnotation;
import gw.lang.Deprecated;
import gw.lang.Param;
import gw.lang.Returns;
import gw.lang.Throws;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ICompilableType;
import gw.util.GosuStringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DocCommentBlock {
    private List<DocAnnotationData> _annotationData = null;
    private StringBuilder _desc;
    private ITypeUsesMap _typeUsesMap;
    private ICompilableType _ownersType;
    private String _rawComment;
    private boolean computeAnnotationData = false;

    public void setRawComment(String rawComment) {
        this._rawComment = rawComment;
        this.computeAnnotationData = true;
    }

    private void addLine(String line) {
        String strippedLine = this.stripLeadingCommentAndWhiteSpace(line);
        DocAnnotationData annotationData = this.maybeStartDocAnnotation(strippedLine);
        if (annotationData != null) {
            if (this._annotationData == null) {
                this._annotationData = new ArrayList<DocAnnotationData>();
            }
            this._annotationData.add(annotationData);
        } else if (this._annotationData == null) {
            if (this._desc == null) {
                this._desc = new StringBuilder();
                this._desc.append(strippedLine);
            } else {
                this._desc.append("\n");
                this._desc.append(strippedLine);
            }
        } else {
            this._annotationData.get(this._annotationData.size() - 1).getArg().append("\n").append(strippedLine);
        }
    }

    public String getDescription() {
        if (this.computeAnnotationData) {
            this.computeAnnotationData();
            this.computeAnnotationData = false;
        }
        return GosuStringUtil.strip((String)(this._desc == null ? "" : this._desc.toString()));
    }

    public List<IGosuAnnotation> getAnnotations() {
        if (this.computeAnnotationData) {
            this.computeAnnotationData();
            this.computeAnnotationData = false;
        }
        if (this._annotationData == null) {
            return Collections.emptyList();
        }
        ArrayList<IGosuAnnotation> lst = new ArrayList<IGosuAnnotation>(this._annotationData.size());
        for (DocAnnotationData annotation : this._annotationData) {
            IGosuAnnotation gosuAnnotation = annotation.makeAnnotation(this._ownersType, this._typeUsesMap);
            if (gosuAnnotation == null) continue;
            lst.add(gosuAnnotation);
        }
        return lst;
    }

    private void computeAnnotationData() {
        String[] lines;
        for (String line : lines = this._rawComment.substring(2, this._rawComment.length() - 2).split("\n")) {
            this.addLine(line);
        }
    }

    private DocAnnotationData maybeStartDocAnnotation(String line) {
        Class<Deprecated> annotationClass = null;
        if (line.startsWith("@deprecated")) {
            annotationClass = Deprecated.class;
        } else if (line.startsWith("@exception")) {
            annotationClass = Throws.class;
        } else if (line.startsWith("@param")) {
            annotationClass = Param.class;
        } else if (line.startsWith("@return")) {
            annotationClass = Returns.class;
        } else if (line.startsWith("@throws")) {
            annotationClass = Throws.class;
        }
        if (annotationClass != null) {
            int i = line.indexOf(" ");
            return new DocAnnotationData(annotationClass, i == -1 ? "" : line.substring(i));
        }
        return null;
    }

    private String stripLeadingCommentAndWhiteSpace(String line) {
        String s = "";
        for (int i = 0; i < line.length(); ++i) {
            if (this.isBlankOrCommentChar(line.charAt(i))) continue;
            s = line.substring(i);
            break;
        }
        return s.trim();
    }

    private boolean isBlankOrCommentChar(char c) {
        return c == ' ' || c == '\t' || c == '*';
    }

    public void setOwnersTypes(ICompilableType ownersType) {
        this._ownersType = ownersType;
        this._typeUsesMap = this._ownersType == null ? null : this._ownersType.getTypeUsesMap();
    }

    public String toString() {
        return "DocCommentBlock(" + this.getDescription() + ")";
    }

    private static class DocAnnotationData {
        private Class _class;
        private StringBuilder _arg;

        public StringBuilder getArg() {
            return this._arg;
        }

        DocAnnotationData(Class type, String arg) {
            this._class = type;
            this._arg = new StringBuilder(arg);
        }

        public IGosuAnnotation makeAnnotation(ICompilableType ownersType, ITypeUsesMap typeUses) {
            String[] args = this.makeArgs();
            if (this._class == Throws.class) {
                try {
                    IType iType = TypeSystem.getByRelativeName((String)args[0], (ITypeUsesMap)typeUses);
                    args[0] = iType.getName();
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
            return new GosuDocAnnotation(ownersType, TypeSystem.get((Class)this._class), args);
        }

        private String[] makeArgs() {
            String arg = GosuStringUtil.strip((String)GosuStringUtil.strip((String)this._arg.toString()));
            if (this._class == Throws.class || this._class == Param.class) {
                return this.splitFirstArg(arg);
            }
            return new String[]{arg};
        }

        private String[] splitFirstArg(String arg) {
            String[] args = arg.split("\\s+", 2);
            if (args.length == 1) {
                args = new String[]{arg, ""};
            }
            return args;
        }
    }
}

