/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.config.ExecutionMode;
import gw.fs.IFile;
import gw.internal.gosu.coercer.FunctionToInterfaceClassGenerator;
import gw.internal.gosu.compiler.GosuClassLoader;
import gw.internal.gosu.compiler.SingleServingGosuClassLoader;
import gw.internal.gosu.ir.TransformingCompiler;
import gw.internal.gosu.parser.AbstractDynamicSymbol;
import gw.internal.gosu.parser.AmbiguousSymbol;
import gw.internal.gosu.parser.CompilationState;
import gw.internal.gosu.parser.CompiledGosuClassSymbolTable;
import gw.internal.gosu.parser.DelegateFunctionSymbol;
import gw.internal.gosu.parser.DelegateFunctionType;
import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.internal.gosu.parser.DynamicPropertySymbol;
import gw.internal.gosu.parser.ErrorType;
import gw.internal.gosu.parser.GenericTypeVariable;
import gw.internal.gosu.parser.GosuArrayClass;
import gw.internal.gosu.parser.GosuClassCompilingStack;
import gw.internal.gosu.parser.GosuClassParseInfo;
import gw.internal.gosu.parser.GosuClassParser;
import gw.internal.gosu.parser.GosuClassTypeInfo;
import gw.internal.gosu.parser.GosuDocAnnotation;
import gw.internal.gosu.parser.GosuMethodInfo;
import gw.internal.gosu.parser.GosuParser;
import gw.internal.gosu.parser.IBlockClassInternal;
import gw.internal.gosu.parser.ICompilableTypeInternal;
import gw.internal.gosu.parser.IGosuAnnotation;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.IGosuEnhancementInternal;
import gw.internal.gosu.parser.IJavaTypeInternal;
import gw.internal.gosu.parser.JavaType;
import gw.internal.gosu.parser.ModifierInfo;
import gw.internal.gosu.parser.ReducedDynamicFunctionSymbol;
import gw.internal.gosu.parser.ReducedParameterizedDynamicFunctionSymbol;
import gw.internal.gosu.parser.Statement;
import gw.internal.gosu.parser.Symbol;
import gw.internal.gosu.parser.TypeLoaderAccess;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.TypeVariableType;
import gw.internal.gosu.parser.expressions.TypeVariableDefinition;
import gw.internal.gosu.parser.expressions.TypeVariableDefinitionImpl;
import gw.internal.gosu.parser.statements.ClassFileStatement;
import gw.internal.gosu.parser.statements.ClassStatement;
import gw.internal.gosu.parser.statements.DelegateStatement;
import gw.internal.gosu.parser.statements.VarStatement;
import gw.lang.InternalAPI;
import gw.lang.Returns;
import gw.lang.parser.GosuParserFactory;
import gw.lang.parser.GosuParserTypes;
import gw.lang.parser.IBlockClass;
import gw.lang.parser.ICapturedSymbol;
import gw.lang.parser.IDynamicFunctionSymbol;
import gw.lang.parser.IFunctionSymbol;
import gw.lang.parser.IGosuParser;
import gw.lang.parser.ILanguageLevel;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IParsedElementWithAtLeastOneDeclaration;
import gw.lang.parser.IReducedDynamicFunctionSymbol;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.ISource;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.parser.PostCompilationAnalysis;
import gw.lang.parser.ScriptPartId;
import gw.lang.parser.ScriptabilityModifiers;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.parser.coercers.FunctionToInterfaceCoercer;
import gw.lang.parser.exceptions.ErrantGosuClassException;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.parser.expressions.INameInDeclaration;
import gw.lang.parser.expressions.ITypeVariableDefinition;
import gw.lang.parser.expressions.IVarStatement;
import gw.lang.parser.resources.Res;
import gw.lang.parser.statements.IConstructorStatement;
import gw.lang.parser.statements.IFunctionStatement;
import gw.lang.parser.statements.IUsesStatement;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IEnumValue;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.ITypeRef;
import gw.lang.reflect.InnerClassCapableType;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ClassType;
import gw.lang.reflect.gs.GosuClassTypeLoader;
import gw.lang.reflect.gs.IGosuArrayClass;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.module.IModule;
import gw.util.GosuExceptionUtil;
import gw.util.GosuObjectUtil;
import gw.util.GosuStringUtil;
import gw.util.StringPool;
import gw.util.concurrent.LockingLazyVar;
import gw.util.concurrent.LocklessLazyVar;
import java.io.File;
import java.io.InvalidClassException;
import java.io.ObjectStreamException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class GosuClass
extends InnerClassCapableType
implements IGosuClassInternal {
    private static final long serialVersionUID = 5L;
    private String _strFullName;
    private IType[] _typeParams;
    protected transient GosuClassParseInfo _parseInfo;
    private transient String _strNamespace;
    private transient String _strRelativeName;
    private transient GosuClassTypeLoader _typeLoader;
    private transient boolean _bInterface;
    private transient boolean _bStructure;
    private transient boolean _bEnum;
    private transient Map<CharSequence, IGosuClassInternal> _mapInnerClasses;
    private volatile transient Set<IType> _setTypes;
    private transient IType[] _interfaces;
    private transient IType _superType;
    private transient IType _enclosingType;
    private transient IJavaType _proxiedJavaClassInGosuProxy;
    private volatile transient SoftReference<Class<?>> _javaClass;
    private transient IGosuClassInternal _genericClass;
    private transient Map<String, IGosuClassInternal> _parameterizationByParamsName;
    private LocklessLazyVar<IFunctionType> _functionalInterface;
    private volatile transient GosuClassTypeInfo _typeInfo;
    private transient IType _gsArrayClass;
    private volatile transient Boolean _bHasSessionVarStatements;
    private transient int _iMdChecksum;
    private transient int _iTiChecksum;
    private transient CompilationState _compilationState;
    private transient boolean _bEditorParser;
    private transient ISourceFileHandle _sourceFileHandle;
    private transient List<IGosuClassInternal> _subtypes;
    private transient String _description;
    private transient String _defaultConstructorName;
    private transient boolean _bCannotCaptureSymbols;
    private transient Boolean _hasError;
    private transient boolean _bDiscarded;
    private transient boolean _bInitializing;
    private transient List<IGosuClass> _blocks;
    private transient LockingLazyVar<Boolean> _valid;
    private transient ITypeRef _typeRef;
    private transient List<ITypeVariableDefinition> _typeVarDefs;
    private transient GenericTypeVariable[] _genTypeVar;
    private transient GosuParser _parser;
    private transient ITypeUsesMap _typeUsesMap;
    private transient Boolean _bStrictGenerics;
    private transient ModifierInfo _modifierInfo;
    private transient boolean _bHasAssertions;
    private transient boolean _bUsesQueryUsageSiteValidation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GosuClass(String strNamespace, String strRelativeName, GosuClassTypeLoader classTypeLoader, ISourceFileHandle sourceFile, ITypeUsesMap typeUsesMap) {
        this.initLazyVars();
        if (strNamespace == null) {
            throw new IllegalArgumentException("Namespace must be non-null");
        }
        if (strRelativeName == null) {
            throw new IllegalArgumentException("Relative name must be non-null");
        }
        this._bInitializing = true;
        try {
            this._compilationState = new CompilationState();
            this._iMdChecksum = TypeSystem.getRefreshChecksum();
            this._iTiChecksum = TypeSystem.getSingleRefreshChecksum();
            this._strNamespace = StringPool.get((String)strNamespace);
            this._strRelativeName = strRelativeName;
            this._typeLoader = classTypeLoader;
            this._sourceFileHandle = sourceFile;
            this._strFullName = (GosuStringUtil.isEmpty((String)this._strNamespace) ? "" : this._strNamespace + '.') + this._strRelativeName;
            this._mapInnerClasses = Collections.emptyMap();
            this._interfaces = EMPTY_TYPE_ARRAY;
            this._defaultConstructorName = this._strRelativeName + "()";
            this._blocks = Collections.emptyList();
            this._typeUsesMap = typeUsesMap;
            this._modifierInfo = new ModifierInfo(1);
        }
        finally {
            this._bInitializing = false;
        }
        this.getOrCreateTypeReference();
    }

    protected GosuClass(IGosuClass genericClass, IType[] typeParams) {
        this(genericClass, typeParams, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GosuClass(IGosuClass genericClass, IType[] typeParams, boolean bCopyState) {
        this.initLazyVars();
        try {
            IGosuClassInternal pureGenericClass = (IGosuClassInternal)TypeLord.getPureGenericType(genericClass);
            pureGenericClass.compileHeaderIfNeeded();
            this._iMdChecksum = TypeSystem.getRefreshChecksum();
            this._iTiChecksum = TypeSystem.getSingleRefreshChecksum();
            this._genericClass = pureGenericClass;
            this._typeParams = typeParams;
            this.copyGenericState(bCopyState);
        }
        finally {
            this._bInitializing = false;
        }
        this.getOrCreateTypeReference();
    }

    @Override
    public GosuClassParseInfo getParseInfo() {
        return this._parseInfo;
    }

    @Override
    public boolean hasAssertions() {
        return this._bHasAssertions;
    }

    @Override
    public void setHasAssertions(boolean bHasAssertions) {
        this._bHasAssertions = bHasAssertions;
    }

    @Override
    public Object dontEverCallThis() {
        return this;
    }

    @Override
    public void copyGenericState(boolean bCopyHierarchy) {
        this._iMdChecksum = TypeSystem.getRefreshChecksum();
        this._iTiChecksum = TypeSystem.getSingleRefreshChecksum();
        GosuClass realGenericClass = (GosuClass)this._genericClass.dontEverCallThis();
        this._strNamespace = realGenericClass._strNamespace;
        this._typeLoader = realGenericClass._typeLoader;
        this._mapInnerClasses = realGenericClass._mapInnerClasses;
        TypeSystem.lock();
        try {
            this._strRelativeName = realGenericClass._strRelativeName + TypeLord.getNameOfParams(this._typeParams, true, false);
            this._strFullName = realGenericClass._strFullName + TypeLord.getNameOfParams(this._typeParams, false, false);
            this._defaultConstructorName = realGenericClass.getRelativeName() + "()";
            this._bInterface = realGenericClass._bInterface;
            this._bStructure = realGenericClass._bStructure;
            this._compilationState = realGenericClass._compilationState;
            this._hasError = realGenericClass._hasError;
            this._enclosingType = realGenericClass._enclosingType;
            this._sourceFileHandle = realGenericClass._sourceFileHandle;
            this._bHasSessionVarStatements = realGenericClass._bHasSessionVarStatements;
            this._bEnum = realGenericClass._bEnum;
            this._parseInfo = realGenericClass._parseInfo;
            this._typeUsesMap = realGenericClass._typeUsesMap;
            if (bCopyHierarchy) {
                this.copyHierarchyInfo();
            }
            this._blocks = realGenericClass._blocks;
        }
        finally {
            TypeSystem.unlock();
        }
    }

    @Override
    public void copyHierarchyInfo() {
        TypeSystem.lock();
        try {
            this.assignParameterizedInterfaces();
            this.assignParameterizedSuperType();
            this.assignParameterizedJavaTypeIfProxy();
            this.assignTypeVarsFromTypeParams(this.getTypeParameters());
        }
        finally {
            TypeSystem.unlock();
        }
    }

    private void assignParameterizedJavaTypeIfProxy() {
        if (this.isProxy()) {
            IJavaTypeInternal javaType = (IJavaTypeInternal)this._genericClass.getJavaType();
            if (javaType == null) {
                return;
            }
            if (this.isParameterizedType()) {
                this.getOrCreateTypeReference();
                javaType = (IJavaTypeInternal)javaType.getParameterizedType(this.getTypeParameters());
            }
            this.setJavaType(javaType);
        }
    }

    private void assignParameterizedSuperType() {
        IType genSuperType = this._genericClass.getSupertype();
        if (genSuperType == null) {
            return;
        }
        if (genSuperType instanceof IJavaType) {
            IJavaTypeInternal javaGenSuperType = (IJavaTypeInternal)genSuperType;
            TypeVarToTypeMap actualParamByVarName = TypeLord.mapTypeByVarName((IType)this.getOrCreateTypeReference(), (IType)this.getOrCreateTypeReference());
            this.setSuperType(TypeLord.getActualType((IType)javaGenSuperType, actualParamByVarName, true));
            ((IJavaTypeInternal)this._superType).setAdapterClass(javaGenSuperType.getAdapterClass());
        } else if (genSuperType instanceof IGosuClassInternal) {
            IGosuClassInternal gsGenSuperType = (IGosuClassInternal)genSuperType;
            TypeVarToTypeMap actualParamByVarName = TypeLord.mapTypeByVarName((IType)this.getOrCreateTypeReference(), (IType)this.getOrCreateTypeReference());
            this.setSuperType(TypeLord.getActualType((IType)gsGenSuperType, actualParamByVarName, true));
        }
    }

    private void assignParameterizedInterfaces() {
        GosuClass realGenericClass = (GosuClass)this._genericClass.dontEverCallThis();
        IType[] interfaces = realGenericClass._interfaces;
        if (interfaces.length == 0) {
            this._interfaces = EMPTY_TYPE_ARRAY;
            return;
        }
        if (this._interfaces == null) {
            this._interfaces = EMPTY_TYPE_ARRAY;
        }
        for (IType genInterface : interfaces) {
            if (TypeLord.hasTypeVariable(genInterface)) {
                TypeVarToTypeMap actualParamByVarName;
                if (genInterface instanceof IJavaType) {
                    IJavaTypeInternal javaGenInterface = (IJavaTypeInternal)genInterface;
                    actualParamByVarName = TypeLord.mapTypeByVarName((IType)this.getOrCreateTypeReference(), (IType)this.getOrCreateTypeReference());
                    genInterface = TypeLord.getActualType((IType)javaGenInterface, actualParamByVarName, true);
                    ((IJavaTypeInternal)genInterface).setAdapterClass(javaGenInterface.getAdapterClass());
                } else if (genInterface instanceof IGosuClassInternal) {
                    IGosuClassInternal gsGenInterface = (IGosuClassInternal)genInterface;
                    actualParamByVarName = TypeLord.mapTypeByVarName((IType)this.getOrCreateTypeReference(), (IType)this.getOrCreateTypeReference());
                    genInterface = TypeLord.getActualType((IType)gsGenInterface, actualParamByVarName, true);
                }
            }
            this.addInterface(genInterface);
        }
    }

    public String getName() {
        return this._strFullName;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getRelativeName() {
        return this._strRelativeName;
    }

    public String getNamespace() {
        return this._strNamespace;
    }

    public void setNamespace(String namespace) {
        this._strNamespace = namespace == null ? null : StringPool.get((String)namespace);
    }

    @Override
    public GosuClassTypeLoader getTypeLoader() {
        return this._typeLoader;
    }

    public IType getSupertype() {
        this.compileHeaderIfNeeded();
        if (TypeSystem.isDeleted((IType)this._superType)) {
            return TypeSystem.getErrorType((String)this._superType.getName());
        }
        if (this._superType == null && this.isParameterizedType() && this._genericClass.getSupertype() != null) {
            this.assignParameterizedSuperType();
        }
        return this._superType;
    }

    public IGosuClassInternal getGenericType() {
        return this.isParameterizedType() ? this._genericClass : (this.isGenericType() ? (IGosuClassInternal)this.getOrCreateTypeReference() : null);
    }

    public boolean isFinal() {
        this.compileHeaderIfNeeded();
        return Modifier.isFinal((int)this.getModifiers());
    }

    public boolean isInterface() {
        this.compileHeaderIfNeeded();
        return this._bInterface;
    }

    @Override
    public void setInterface(boolean bInterface) {
        this._bInterface = bInterface;
    }

    public boolean isStructure() {
        this.compileHeaderIfNeeded();
        return this._bStructure;
    }

    @Override
    public void setStructure(boolean bStructure) {
        this._bStructure = bStructure;
    }

    public boolean isEnum() {
        this.compileHeaderIfNeeded();
        return this._bEnum;
    }

    @Override
    public void setEnum() {
        this._bEnum = true;
        if (this.getEnclosingType() != null) {
            this.markStatic();
        }
        this.addInterface(TypeSystem.get(IEnumValue.class, (IModule)TypeSystem.getGlobalModule()));
    }

    public List<String> getEnumConstants() {
        if (!this.isEnum()) {
            return Collections.emptyList();
        }
        ArrayList<String> enumConstants = new ArrayList<String>();
        List<IVarStatement> fields = this.getStaticFields();
        for (IVarStatement f : fields) {
            if (!f.isEnumConstant()) continue;
            enumConstants.add(f.getIdentifierName());
        }
        return enumConstants;
    }

    public List<IEnumValue> getEnumValues() {
        return (List)this.getTypeInfo().getProperty("AllValues").getAccessor().getValue(null);
    }

    public IEnumValue getEnumValue(String strName) {
        return (IEnumValue)this.getTypeInfo().getMethod("valueOf", new IType[]{JavaTypes.STRING()}).getCallHandler().handleCall(null, new Object[]{strName});
    }

    public IType[] getInterfaces() {
        this.compileHeaderIfNeeded();
        this.maybeAssignInterfacesForParameterizedClass();
        return this._interfaces;
    }

    private void maybeAssignInterfacesForParameterizedClass() {
        IType[] genInterfaces;
        IType[] interfaces = this._interfaces;
        if (!(interfaces != null && interfaces.length != 0 || !this.isParameterizedType() || (genInterfaces = this._genericClass.getInterfaces()) == null || genInterfaces.length <= 0 || interfaces != null && interfaces.length == genInterfaces.length)) {
            this.assignParameterizedInterfaces();
        }
    }

    @Override
    public void addInterface(IType type) {
        ArrayList<IType> interfaces = new ArrayList<IType>();
        for (IType i : this._interfaces) {
            interfaces.add(i);
        }
        for (int i = 0; i < interfaces.size(); ++i) {
            IType iface = (IType)interfaces.get(i);
            if (!TypeLord.getPureGenericType(iface).equals(TypeLord.getPureGenericType(type))) continue;
            interfaces.remove(i);
        }
        if (!interfaces.contains(type)) {
            interfaces.add(type);
        }
        this._interfaces = interfaces.toArray(new IType[interfaces.size()]);
    }

    public IJavaType getJavaType() {
        IJavaType javaType;
        if (this._proxiedJavaClassInGosuProxy != null) {
            return this._proxiedJavaClassInGosuProxy;
        }
        if (this.getEnclosingType() != null && this.isProxy() && (javaType = ((IGosuClass)this.getEnclosingType()).getJavaType()) != null) {
            IType proxiedJavaClass = javaType.getInnerClass((CharSequence)this.getRelativeName());
            this.setJavaType((IJavaType)proxiedJavaClass);
            return (IJavaType)proxiedJavaClass;
        }
        return null;
    }

    @Override
    public void setJavaType(IJavaType javaType) {
        this._proxiedJavaClassInGosuProxy = javaType;
    }

    public IType findProxiedClassInHierarchy() {
        if (this.getSuperClass() != null) {
            return this.getSuperClass().findProxiedClassInHierarchy();
        }
        return null;
    }

    public boolean isParameterizedType() {
        return this._typeParams != null && this._typeParams.length > 0;
    }

    public boolean isGenericType() {
        this.compileHeaderIfNeeded();
        List<ITypeVariableDefinition> typeVarDefs = this.getTypeVarDefs();
        return typeVarDefs != null && !typeVarDefs.isEmpty();
    }

    public GenericTypeVariable[] getGenericTypeVariables() {
        this.compileHeaderIfNeeded();
        if (this._genTypeVar == null) {
            if (this._typeVarDefs == null || this._typeVarDefs.isEmpty()) {
                this._genTypeVar = GenericTypeVariable.EMPTY_TYPEVARS;
                return GenericTypeVariable.EMPTY_TYPEVARS;
            }
            this._genTypeVar = new GenericTypeVariable[this._typeVarDefs.size()];
            for (int i = 0; i < this._typeVarDefs.size(); ++i) {
                this._genTypeVar[i] = (GenericTypeVariable)this._typeVarDefs.get(i).getTypeVar();
            }
        }
        return this._genTypeVar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGosuClassInternal getParameterizedType(IType ... paramTypes) {
        String strNameOfParams;
        IGosuClassInternal parameterizedClass;
        this.compileHeaderIfNeeded();
        for (IType t : paramTypes) {
            if (t != null) continue;
            throw new IllegalStateException("Type parameters must be non-null");
        }
        if (this.isParameterizedType()) {
            return (IGosuClassInternal)TypeLord.getPureGenericType(this.getOrCreateTypeReference()).getParameterizedType(paramTypes);
        }
        if (paramTypes.length == 0) {
            throw new IllegalArgumentException("Parameter types required. Invoked on type: " + this._strFullName);
        }
        if (this._parameterizationByParamsName == null) {
            TypeSystem.lock();
            try {
                if (this._parameterizationByParamsName == null) {
                    this._parameterizationByParamsName = new ConcurrentHashMap<String, IGosuClassInternal>(2);
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
        if ((parameterizedClass = this._parameterizationByParamsName.get(strNameOfParams = TypeLord.getNameOfParams(paramTypes = TypeSystem.boxPrimitiveTypeParams((IType[])paramTypes), false, true))) == null) {
            TypeSystem.lock();
            try {
                parameterizedClass = this._parameterizationByParamsName.get(strNameOfParams);
                if (parameterizedClass == null) {
                    parameterizedClass = this.makeCopy(paramTypes);
                    this._parameterizationByParamsName.put(strNameOfParams, parameterizedClass);
                    parameterizedClass.copyHierarchyInfo();
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
        return parameterizedClass;
    }

    protected IGosuClassInternal makeCopy(IType ... paramTypes) {
        return (IGosuClassInternal)this.getOrCreateTypeReference((IType)new GosuClass((IGosuClass)this.getOrCreateTypeReference(), paramTypes, false));
    }

    public IType[] getTypeParameters() {
        this.compileHeaderIfNeeded();
        return this._typeParams;
    }

    public Set<IType> getAllTypesInHierarchy() {
        if (this.isCompilingHeader()) {
            return Collections.emptySet();
        }
        this.compileHeaderIfNeeded();
        if (!this.isHeaderCompiled()) {
            return Collections.emptySet();
        }
        if (this._setTypes == null) {
            TypeSystem.lock();
            try {
                if (this._setTypes == null) {
                    this._setTypes = this.createAllTypesInHierarchy();
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
        return this._setTypes;
    }

    private Set<IType> createAllTypesInHierarchy() {
        Set<IType> types;
        if (this.isArray()) {
            types = TypeLord.getArrayVersionsOfEachType(this.getComponentType().getAllTypesInHierarchy());
        } else {
            types = TypeLord.getAllClassesInClassHierarchyAsIntrinsicTypes((IType)this.getOrCreateTypeReference());
            if (!this.isInterface()) {
                if (this.isParameterizedType()) {
                    this.getGenericType().getAllTypesInHierarchy();
                } else if (IGosuClass.ProxyUtil.isProxy((IType)this)) {
                    types.addAll(TypeSystem.getByFullName((String)this.getName().substring("_proxy_".length() + 1)).getAllTypesInHierarchy());
                }
            }
        }
        return types;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public IType getArrayType() {
        if (this._gsArrayClass == null) {
            TypeSystem.lock();
            try {
                if (this._gsArrayClass == null) {
                    IGosuArrayClass gsArrayClass = (IGosuArrayClass)this.getOrCreateTypeReference((IType)new GosuArrayClass((IType)this.getOrCreateTypeReference(), (ITypeLoader)this.getTypeLoader()));
                    this._gsArrayClass = gsArrayClass;
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
        return this._gsArrayClass;
    }

    public Object makeArrayInstance(int iLength) {
        return Array.newInstance(this.isStructure() ? JavaTypes.OBJECT().getBackingClass() : this.getBackingClass(), iLength);
    }

    public Object getArrayComponent(Object array, int iIndex) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return Array.get(array, iIndex);
    }

    public void setArrayComponent(Object array, int iIndex, Object value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Array.set(array, iIndex, value);
    }

    public int getArrayLength(Object array) throws IllegalArgumentException {
        return Array.getLength(array);
    }

    public IType getComponentType() {
        return null;
    }

    public boolean isAssignableFrom(IType type) {
        ITypeRef pThis = this.getOrCreateTypeReference();
        if (type == pThis) {
            return true;
        }
        if (type == null) {
            return false;
        }
        if (this.isArray() && type.isArray()) {
            return this.getComponentType().isAssignableFrom(type.getComponentType());
        }
        if (this.isArray() || type.isArray()) {
            return false;
        }
        if (this.isInterface() && !this.isStructure() && type instanceof IGosuClass && ((IGosuClass)type).isStructure()) {
            return false;
        }
        if (type.getAllTypesInHierarchy().contains(pThis)) {
            return true;
        }
        if (TypeLord.areGenericOrParameterizedTypesAssignable((IType)pThis, type)) {
            return this.isGenericType() && !this.isParameterizedType() || !this.isStrictGenerics() && !this.isStructure();
        }
        return false;
    }

    public boolean isStrictGenerics() {
        if (this._bStrictGenerics != null) {
            return this._bStrictGenerics;
        }
        this._bStrictGenerics = this.getGosuAnnotations().stream().anyMatch(anno -> anno.getType() == JavaTypes.STRICT_GENERICS());
        return this._bStrictGenerics;
    }

    public boolean isMutable() {
        return true;
    }

    public boolean isValid() {
        try {
            this.compileDefinitionsIfNeeded();
        }
        catch (ErrantGosuClassException egce) {
            return false;
        }
        return (Boolean)this._valid.get();
    }

    public boolean isStatic() {
        return Modifier.isStatic((int)this.getModifiers());
    }

    public ModifierInfo getModifierInfo() {
        if (this.isParameterizedType()) {
            return (ModifierInfo)this.getGenericType().getModifierInfo();
        }
        this.compileHeaderIfNeeded();
        return this._modifierInfo;
    }

    @Override
    public void setModifierInfo(ModifierInfo modifierInfo) {
        if (this.isParameterizedType()) {
            this.getGenericType().setModifierInfo(modifierInfo);
            return;
        }
        GosuClass.filterJavaDocAnnotations(modifierInfo.getAnnotations());
        this._modifierInfo = modifierInfo;
    }

    public int getModifiers() {
        return this.getModifierInfo().getModifiers();
    }

    @Override
    public void markStatic() {
        this.getModifierInfo().setModifiers(Modifier.setStatic((int)this.getModifiers(), (boolean)true));
    }

    public boolean isAbstract() {
        return Modifier.isAbstract((int)this.getModifiers());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GosuClassTypeInfo getTypeInfo() {
        if (this._typeInfo == null || this.hasAncestorBeenUpdated()) {
            TypeSystem.lock();
            try {
                if (this._typeInfo != null && !this.hasAncestorBeenUpdated()) return this._typeInfo;
                IGosuClassInternal self = (IGosuClassInternal)this.getOrCreateTypeReference();
                this._typeInfo = new GosuClassTypeInfo(self);
                IGosuClassInternal superClass = self.getSuperClass();
                if (superClass != null) {
                    superClass.getTypeInfo();
                }
                self.compileDeclarationsIfNeeded();
                this._iTiChecksum = TypeSystem.getSingleRefreshChecksum();
                return this._typeInfo;
            }
            finally {
                TypeSystem.unlock();
            }
        } else {
            this.compileDeclarationsIfNeeded();
        }
        return this._typeInfo;
    }

    public boolean hasAncestorBeenUpdated() {
        IGosuClassInternal genThis = (IGosuClassInternal)TypeLord.getPureGenericType(this.getOrCreateTypeReference());
        return this.haveAncestorsBeenUpdated(this, genThis.getTypeInfoChecksum());
    }

    private boolean haveAncestorsBeenUpdated(IGosuClassInternal type, int tiCheckSum) {
        IGosuClassInternal supertype = type.getSuperClass();
        if (supertype != null && (TypeSystem.isDeleted((IType)supertype) || this.hasBeenUpdated(supertype, tiCheckSum))) {
            return true;
        }
        for (IType anInterface : type.getInterfaces()) {
            IJavaTypeInternal iFace;
            if (TypeSystem.isDeleted((IType)anInterface)) {
                return true;
            }
            if (!(anInterface instanceof IJavaTypeInternal ? JavaType.hasBeenUpdated(iFace = (IJavaTypeInternal)anInterface, tiCheckSum, new HashSet<IType>()) : anInterface instanceof IGosuClassInternal && this.hasBeenUpdated((IGosuClassInternal)anInterface, tiCheckSum))) continue;
            return true;
        }
        return false;
    }

    private boolean hasBeenUpdated(IGosuClassInternal type, int tiChecksum) {
        if (!ExecutionMode.get().isRefreshSupportEnabled()) {
            return false;
        }
        IGosuClassInternal genType = TypeLord.getPureGenericType(type);
        if (genType.isProxy()) {
            IJavaTypeInternal javaType = (IJavaTypeInternal)genType.getJavaType();
            return javaType.getTypeInfoChecksum() > tiChecksum || javaType.hasAncestorBeenUpdated();
        }
        return genType.getTypeInfoChecksum() > tiChecksum || this.haveAncestorsBeenUpdated(genType, tiChecksum);
    }

    public void unloadTypeInfo() {
        if (this._typeInfo != null) {
            this._typeInfo.unload();
        }
        this._valid.clear();
        if (this._parameterizationByParamsName != null) {
            this._parameterizationByParamsName.clear();
        }
    }

    public Object readResolve() throws ObjectStreamException {
        try {
            String strProxyPrefix = "_proxy_.";
            if (this.getName().startsWith(strProxyPrefix)) {
                String strJavaName = this.getName().substring(strProxyPrefix.length());
                IJavaTypeInternal javaType = (IJavaTypeInternal)TypeSystem.getByFullName((String)strJavaName);
                return javaType.getAdapterClass();
            }
            int iIndex = this.getName().indexOf(60);
            if (iIndex > 0) {
                String strGenName = this.getName().substring(0, iIndex);
                IType type = TypeLoaderAccess.instance().getIntrinsicTypeByFullName(strGenName);
                return type.getParameterizedType(this._typeParams);
            }
            return TypeLoaderAccess.instance().getIntrinsicTypeByFullName(this.getName());
        }
        catch (ClassNotFoundException e) {
            throw new InvalidClassException(e.getMessage());
        }
    }

    public String getId() {
        return this.getName();
    }

    @Override
    public String getSource() {
        ICompilableTypeInternal enclosingType = this.getEnclosingType();
        if (enclosingType != null) {
            return enclosingType.getSource();
        }
        return this._sourceFileHandle.getSource().getSource();
    }

    @Override
    public boolean isStale() {
        return this._iMdChecksum != TypeSystem.getRefreshChecksum() && !this.isProxy();
    }

    @Override
    public int getTypeInfoChecksum() {
        return this._iTiChecksum;
    }

    @Override
    public boolean isProxy() {
        return IGosuClass.ProxyUtil.isProxy((IType)this);
    }

    public IFunctionType getFunctionalInterface() {
        return (IFunctionType)this._functionalInterface.get();
    }

    protected ITypeRef getOrCreateTypeReference() {
        if (this._typeRef == null) {
            this._typeRef = this.getOrCreateTypeReference((IType)this);
        }
        return this._typeRef;
    }

    protected ITypeRef getOrCreateTypeReference(IType type) {
        return this.getTypeLoader().getModule().getModuleTypeLoader().getTypeRefFactory().create(type);
    }

    public boolean isSubClass(IType gsSubType) {
        if (gsSubType == null) {
            return false;
        }
        if (gsSubType instanceof IGosuClassInternal) {
            IGosuClassInternal gsSuperClass = TypeLord.getPureGenericType(((IGosuClassInternal)gsSubType).getSuperClass());
            return gsSuperClass == TypeLord.getPureGenericType(this.getOrCreateTypeReference()) || this.isSubClass((IType)gsSuperClass);
        }
        return false;
    }

    public boolean isCompiled() {
        return this.isDeclarationsCompiled() && this.isDefinitionsCompiled();
    }

    @Override
    public List<DynamicFunctionSymbol> getConstructorFunctions() {
        this.compileDeclarationsIfNeeded();
        Map<String, DynamicFunctionSymbol> ctors = this.getParseInfo().getConstructorFunctions();
        return ctors.isEmpty() ? Collections.emptyList() : this.getUnmodifiableValues(ctors);
    }

    private List getUnmodifiableValues(Map functionSymbolMap) {
        return Collections.unmodifiableList(new ArrayList(functionSymbolMap.values()));
    }

    @Override
    public DynamicFunctionSymbol getConstructorFunction(String name) {
        this.compileDeclarationsIfNeeded();
        return this.getParseInfo().getConstructorFunctions().get(name);
    }

    @Override
    public DynamicFunctionSymbol getDefaultConstructor() {
        this.compileDeclarationsIfNeeded();
        return this.getConstructorFunction(this._defaultConstructorName);
    }

    @Override
    public List<DynamicFunctionSymbol> getStaticFunctions() {
        this.compileDeclarationsIfNeeded();
        return Collections.unmodifiableList(this.getParseInfo().getStaticFunctions());
    }

    public Map<CharSequence, IGosuClassInternal> getInnerClassesMap() {
        this.compileHeaderIfNeeded();
        return this._mapInnerClasses;
    }

    public List<IGosuClassInternal> getInnerClasses() {
        this.compileHeaderIfNeeded();
        return new ArrayList<IGosuClassInternal>(this._mapInnerClasses.values());
    }

    public Map<CharSequence, ? extends IGosuClass> getKnownInnerClassesWithoutCompiling() {
        return this._mapInnerClasses;
    }

    public IGosuClass getBlock(int i) {
        return this.getBlocks().get(i);
    }

    @Override
    public void addInnerClass(IGosuClassInternal innerGsClass) {
        innerGsClass.setCreateEditorParser(this.isCreateEditorParser());
        if (this._mapInnerClasses == Collections.EMPTY_MAP) {
            this._mapInnerClasses = new LinkedHashMap<CharSequence, IGosuClassInternal>(2);
        }
        this._mapInnerClasses.put(StringPool.get((String)innerGsClass.getName().substring(this.getName().length() + 1)), innerGsClass);
    }

    @Override
    public void removeInnerClass(IGosuClassInternal innerGsClass) {
        if (!this._mapInnerClasses.isEmpty()) {
            this._mapInnerClasses.remove(innerGsClass.getRelativeName());
        }
    }

    public IType resolveRelativeInnerClass(String strRelativeInnerClassName, boolean bForce) {
        if (!(bForce || this.getCompilationState().isHeaderCompiled() && !this.getCompilationState().isReparsingHeader())) {
            ICompilableTypeInternal outerClass = this.getEnclosingType();
            return outerClass == null ? null : outerClass.resolveRelativeInnerClass(strRelativeInnerClassName, true);
        }
        return super.resolveRelativeInnerClass(strRelativeInnerClassName, bForce);
    }

    public List<DynamicFunctionSymbol> getMemberFunctions() {
        this.compileDeclarationsIfNeeded();
        Map<String, DynamicFunctionSymbol> memberFunctions = this.getParseInfo().getMemberFunctions();
        return memberFunctions.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<DynamicFunctionSymbol>(memberFunctions.values()));
    }

    @Override
    public DynamicFunctionSymbol getMemberFunction(IFunctionType funcType, String signature, boolean bContravariant) {
        DynamicFunctionSymbol dfs = this.getParseInfo().getMemberFunctions().get(signature);
        if (dfs == null) {
            dfs = this.getMemberFunction(funcType, bContravariant);
        }
        return dfs;
    }

    @Override
    public List<DynamicFunctionSymbol> getMemberFunctions(String names) {
        Collection<DynamicFunctionSymbol> dfss = this.getParseInfo().getMemberFunctions().values();
        ArrayList<DynamicFunctionSymbol> returnDFSs = new ArrayList<DynamicFunctionSymbol>();
        for (DynamicFunctionSymbol dfs : dfss) {
            if (!names.equals(dfs.getDisplayName())) continue;
            returnDFSs.add(dfs);
        }
        return returnDFSs;
    }

    @Override
    public DynamicFunctionSymbol getMemberFunction(IFunctionType funcType, boolean bContravariant) {
        String name = funcType.getDisplayName();
        for (DynamicFunctionSymbol dfs : this.getParseInfo().getMemberFunctions().values()) {
            if (!name.equals(dfs.getDisplayName())) continue;
            if (this.isParameterizedType()) {
                dfs = dfs.getParameterizedVersion((IGosuClass)this.getOrCreateTypeReference());
            }
            if (!this.isAssignable(funcType, dfs, bContravariant)) continue;
            return dfs;
        }
        return null;
    }

    private boolean isAssignable(IFunctionType funcType, IDynamicFunctionSymbol dfs, boolean bContravariant) {
        if (dfs == null) {
            return false;
        }
        if (funcType.isAssignableFrom(dfs.getType(), bContravariant)) {
            return true;
        }
        if (dfs.getBackingDfs() != dfs && this.isAssignable(funcType, dfs.getBackingDfs(), bContravariant)) {
            return true;
        }
        return dfs.getSuperDfs() != dfs && this.isAssignable(funcType, dfs.getSuperDfs(), bContravariant);
    }

    @Override
    public DynamicPropertySymbol getStaticProperty(String name) {
        this.compileDeclarationsIfNeeded();
        for (DynamicPropertySymbol dps : this.getParseInfo().getStaticProperties()) {
            if (!name.equals(dps.getName())) continue;
            return dps;
        }
        return null;
    }

    @Override
    public List<DynamicPropertySymbol> getStaticProperties() {
        this.compileDeclarationsIfNeeded();
        return Collections.unmodifiableList(this.getParseInfo().getStaticProperties());
    }

    @Override
    public List<DynamicPropertySymbol> getMemberProperties() {
        this.compileDeclarationsIfNeeded();
        Map<String, DynamicPropertySymbol> properties = this.getParseInfo().getMemberProperties();
        return properties.isEmpty() ? Collections.emptyList() : this.getUnmodifiableValues(properties);
    }

    @Override
    public DynamicPropertySymbol getMemberProperty(String name) {
        return this.getParseInfo().getMemberProperties().get(name);
    }

    @Override
    public List<IVarStatement> getStaticFields() {
        this.compileDeclarationsIfNeeded();
        Map<String, VarStatement> fields = this.getParseInfo().getStaticFields();
        return fields.isEmpty() ? Collections.emptyList() : this.getUnmodifiableValues(fields);
    }

    @Override
    public VarStatement getStaticField(String name) {
        return this.getParseInfo().getStaticFields().get(name);
    }

    @Override
    public Map<CharSequence, ISymbol> getMemberFieldIndexByName() {
        this.compileDeclarationsIfNeeded();
        return this.getParseInfo().getMemberFieldIndexByName();
    }

    public List<IVarStatement> getMemberFields() {
        this.compileDeclarationsIfNeeded();
        Map<String, VarStatement> fields = this.getParseInfo().getMemberFields();
        return fields.isEmpty() ? Collections.emptyList() : this.getUnmodifiableValues(fields);
    }

    public Map<String, VarStatement> getMemberFieldsMap() {
        this.compileDeclarationsIfNeeded();
        return this.getParseInfo().getMemberFields();
    }

    @Override
    public Symbol getStaticThisSymbol() {
        this.compileDeclarationsIfNeeded();
        return this.getParseInfo().getStaticThisSymbol();
    }

    @Override
    public Map<String, ICapturedSymbol> getCapturedSymbols() {
        this.compileDefinitionsIfNeeded();
        return this.getParseInfo().getCapturedSymbols();
    }

    @Override
    public ICapturedSymbol getCapturedSymbol(String strName) {
        return this.getCapturedSymbols().get(strName);
    }

    @Override
    public void addCapturedSymbol(ICapturedSymbol sym) {
        this.compileDefinitionsIfNeeded();
        this.getParseInfo().addCapturedSymbolSilent(sym);
    }

    @Override
    public boolean ensureDefaultConstructor(ISymbolTable symbolTable, GosuParser parser) {
        return !this.getConstructorFunctions().isEmpty() || this.getParseInfo().addDefaultConstructor(symbolTable, parser);
    }

    public ClassStatement getClassStatement() {
        this.compileDeclarationsIfNeeded();
        return this.getParseInfo().getClassStatement();
    }

    public ClassStatement getClassStatementWithoutCompile() {
        return this.getParseInfo().getClassStatement();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void setSuperType(IType superType) {
        this._superType = superType;
    }

    public void setEnclosingType(IType enclosingType) {
        this._enclosingType = enclosingType;
    }

    public IType getEnclosingTypeReference() {
        return this._enclosingType;
    }

    public boolean isAnonymous() {
        return this.getRelativeName().startsWith("AnonymouS_") && this.getEnclosingTypeReference() != null;
    }

    @Override
    public int getDepth() {
        if (this.getEnclosingType() != null) {
            return this.getEnclosingType().getDepth() + 1;
        }
        return 0;
    }

    @Override
    public void compileDefinitionsIfNeeded() {
        this.compileDefinitionsIfNeeded(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compileDefinitionsIfNeeded(boolean bForce) {
        boolean bHasError;
        block28: {
            bHasError = false;
            if (!this.isDefinitionsCompiled()) {
                ((GosuClass)this.getPureGenericClass().dontEverCallThis())._hasError = null;
                if (this.isParameterizedType()) {
                    this.getGenericType().compileDefinitionsIfNeeded();
                    return;
                }
                if (this.getEnclosingType() instanceof IGosuClass && !this.getRelativeName().startsWith("ProxyFor_")) {
                    this.getEnclosingType().compileDefinitionsIfNeeded(bForce);
                    return;
                }
                TypeSystem.lock();
                try {
                    block29: {
                        if (this.isTypeRefreshedOutsideOfLock()) {
                            return;
                        }
                        if (this.isCompilingDefinitions() || this.isDefinitionsCompiled()) break block28;
                        try {
                            this.compileDeclarationsIfNeeded();
                            if (!this.isDeclarationsCompiled()) {
                                return;
                            }
                        }
                        catch (ErrantGosuClassException e) {
                            if (bForce) break block29;
                            throw e;
                        }
                    }
                    this.setCompilingDefinitions(true);
                    try {
                        if (this.shouldResolve()) {
                            IGosuClassInternal gosuClass = (IGosuClassInternal)this.getOrCreateTypeReference();
                            GosuParser parser = this.makeParserForPhase();
                            GosuClassParser classParser = new GosuClassParser(parser);
                            classParser.parseDefinitions(gosuClass);
                        }
                        this.postAnalyze();
                        if (this.getClassStatement().hasParseIssues() || this.hasParseIssuesInUsesStatements()) {
                            this.updateParseResultsException();
                        }
                    }
                    finally {
                        this.setCompilingDefinitions(false);
                        this._sourceFileHandle.getSource().stopCachingSource();
                    }
                }
                finally {
                    try {
                        if (!this.isTypeRefreshedOutsideOfLock()) {
                            ((GosuClass)this.getPureGenericClass().dontEverCallThis())._hasError = null;
                            bHasError = this.hasError();
                            this.getParseInfo().maybeClearDebugInfo();
                        }
                    }
                    finally {
                        TypeSystem.unlock();
                    }
                }
            }
        }
        if (bHasError) {
            throw new ErrantGosuClassException((IGosuClass)this.getOrCreateTypeReference());
        }
    }

    private boolean isTypeRefreshedOutsideOfLock() {
        return this.getOrCreateTypeReference().isTypeRefreshedOutsideOfLock((IType)this);
    }

    private void postAnalyze() {
        if (!this.isAnonymous() && this.getEnclosingType() == null) {
            PostCompilationAnalysis.maybeAnalyze((IParsedElement)this.getClassStatement().getClassFileStatement(), (IParsedElement[])new IParsedElement[]{this.getClassStatement()});
        }
    }

    private boolean hasParseIssuesInUsesStatements() {
        if (this.getTypeUsesMap() != null) {
            for (IUsesStatement usesStatement : this.getTypeUsesMap().getUsesStatements()) {
                if (!usesStatement.hasParseIssues()) continue;
                return true;
            }
        }
        return false;
    }

    private void updateParseResultsException() {
        if (this.getParseResultsException() == null) {
            ClassFileStatement classFileStmt = this.getClassStatement().getClassFileStatement();
            this.setParseResultsException(new ParseResultsException((IParsedElement)(classFileStmt == null ? this.getClassStatement() : classFileStmt)));
        } else {
            Statement stmt = (Statement)this.getParseResultsException().getParsedElement();
            if (!(stmt != null && stmt.hasParseExceptions() || (stmt = this.getParseInfo().getClassFileStatement()) != null)) {
                stmt = this.getParseInfo().getClassStatement();
            }
            this.getParseResultsException().reset((IParsedElement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compileDeclarationsIfNeeded() {
        block12: {
            if (this.shouldCompileDeclarations()) {
                if (this.isParameterizedType()) {
                    this.getGenericType().compileDeclarationsIfNeeded();
                    return;
                }
                ICompilableTypeInternal enclosingType = this.getEnclosingType();
                if (enclosingType instanceof IGosuClass && !this.getRelativeName().startsWith("ProxyFor_")) {
                    enclosingType.compileDeclarationsIfNeeded();
                    return;
                }
                TypeSystem.lock();
                try {
                    if (this.isCompilingHeader() || this.isCompilingDeclarations() || !this.shouldCompileDeclarations()) break block12;
                    try {
                        this.compileHeaderIfNeeded();
                    }
                    catch (ErrantGosuClassException errantGosuClassException) {
                        // empty catch block
                    }
                    this.setCompilingDeclarations(true);
                    try {
                        if (!this.isDeclarationsCompiled()) {
                            IGosuClassInternal gosuClass = (IGosuClassInternal)this.getOrCreateTypeReference();
                            GosuParser parser = this.makeParserForPhase();
                            GosuClassParser classParser = new GosuClassParser(parser);
                            classParser.parseDeclarations(gosuClass);
                        }
                        this.getParseInfo().maybeClearDebugInfo();
                        this.forceTypeInfoInitialization();
                    }
                    finally {
                        this.setCompilingDeclarations(false);
                    }
                }
                finally {
                    TypeSystem.unlock();
                }
            }
        }
    }

    @Override
    public void forceTypeInfoInitialization() {
        if (!this.isDeclarationsCompiled()) {
            return;
        }
        if (!this.getClassStatement().hasParseExceptions()) {
            this.getTypeInfo().forceInit();
            for (IGosuClass iGosuClass : this.getKnownInnerClassesWithoutCompiling().values()) {
                if (!iGosuClass.isDeclarationsCompiled()) continue;
                ((IGosuClassInternal)iGosuClass).forceTypeInfoInitialization();
            }
        }
    }

    @Override
    public void syncGenericAndParameterizedClasses() {
        if (this.isParameterizedType()) {
            this.copyGenericState(true);
        } else if (this.isGenericType() && this._parameterizationByParamsName != null) {
            IGosuClassInternal[] gosuClasses;
            Collection<IGosuClassInternal> values = this._parameterizationByParamsName.values();
            for (IGosuClassInternal gosuClass : gosuClasses = values.toArray(new IGosuClassInternal[values.size()])) {
                gosuClass.copyGenericState(true);
            }
        }
    }

    @Override
    public Collection<IGosuClassInternal> getParameterizedTypes() {
        return this._parameterizationByParamsName == null ? Collections.emptyList() : this._parameterizationByParamsName.values();
    }

    @Override
    public void setAnnotations(List<IGosuAnnotation> annotations) {
        GosuClass.filterJavaDocAnnotations(annotations);
        this.getModifierInfo().setAnnotations(annotations);
    }

    private static void filterJavaDocAnnotations(List<IGosuAnnotation> annotations) {
        Iterator<IGosuAnnotation> it = annotations.iterator();
        while (it.hasNext()) {
            IGosuAnnotation annotation = it.next();
            if (!(annotation instanceof GosuDocAnnotation) || !JavaTypes.THROWS().equals(annotation.getType()) && !JavaTypes.getGosuType(Returns.class).equals(annotation.getType()) && !JavaTypes.PARAMS().equals(annotation.getType()) && !JavaTypes.PARAM().equals(annotation.getType())) continue;
            it.remove();
        }
    }

    @Override
    public IType getEnclosingNonBlockType() {
        ICompilableTypeInternal type = this.getEnclosingType();
        while (type instanceof IBlockClassInternal) {
            type = type.getEnclosingType();
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compileHeaderIfNeeded() {
        block16: {
            if (this.isHeaderCompiled()) {
                return;
            }
            if (this.isParameterizedType()) {
                this.getGenericType().compileHeaderIfNeeded();
                return;
            }
            if (this.getEnclosingType() instanceof IGosuClass && !this.getRelativeName().startsWith("ProxyFor_")) {
                this.getEnclosingType().compileHeaderIfNeeded();
                IGosuClassInternal gosuClass = (IGosuClassInternal)this.getOrCreateTypeReference();
                gosuClass.createNewParseInfo();
                return;
            }
            TypeSystem.lock();
            try {
                if (this.isCompilingHeader() || this.isHeaderCompiled()) break block16;
                this.setCompilingHeader(true);
                try {
                    GosuClassCompilingStack.pushCompilingType((IType)this.getOrCreateTypeReference());
                    try {
                        if (this.getSuperClass() != null) {
                            try {
                                this.getSuperClass().compileHeaderIfNeeded();
                            }
                            catch (ErrantGosuClassException gosuClass) {
                                // empty catch block
                            }
                        }
                    }
                    finally {
                        GosuClassCompilingStack.popCompilingType();
                    }
                    if (!this.isHeaderCompiled()) {
                        IGosuClassInternal gosuClass = (IGosuClassInternal)this.getOrCreateTypeReference();
                        GosuParser parser = this.makeParserForPhase();
                        GosuClassParser classParser = new GosuClassParser(parser);
                        classParser.parseHeader(gosuClass, false, false, false);
                    }
                }
                finally {
                    this.setCompilingHeader(false);
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
    }

    private boolean shouldCompileDeclarations() {
        return !this.isDeclarationsCompiled() || !this._compilationState.isInnerDeclarationsCompiled();
    }

    public CompilationState getCompilationState() {
        return this._compilationState;
    }

    public boolean isCompilingHeader() {
        return this.getCompilationState().isCompilingHeader();
    }

    @Override
    public void setCompilingHeader(boolean bCompilingHeader) {
        this.getCompilationState().setCompilingHeader(bCompilingHeader);
    }

    public boolean isHeaderCompiled() {
        return this.getCompilationState().isHeaderCompiled();
    }

    @Override
    public void setHeaderCompiled() {
        this.getCompilationState().setHeaderCompiled();
    }

    public boolean isCompilingDeclarations() {
        return this.getCompilationState().isCompilingDeclarations();
    }

    @Override
    public void setCompilingDeclarations(boolean bCompilingDeclarations) {
        this.getCompilationState().setCompilingDeclarations(bCompilingDeclarations);
    }

    public boolean isDeclarationsCompiled() {
        return this.getCompilationState().isDeclarationsCompiled();
    }

    public boolean isDeclarationsBypassed() {
        return this.getCompilationState().isDeclarationsBypassed();
    }

    @Override
    public void setDeclarationsBypassed() {
        this.getCompilationState().setDeclarationsBypassed();
    }

    public boolean isInnerDeclarationsCompiled() {
        return this.getCompilationState().isInnerDeclarationsCompiled();
    }

    @Override
    public void setDeclarationsCompiled() {
        this.getCompilationState().setDeclarationsCompiled();
    }

    @Override
    public void setInnerDeclarationsCompiled() {
        this.getCompilationState().setInnerDeclarationsCompiled();
    }

    public boolean isCompilingDefinitions() {
        return this.getCompilationState().isCompilingDefinitions();
    }

    @Override
    public boolean shouldFullyCompileAnnotations() {
        return this.getCompilationState().isCompilingDefinitions();
    }

    @Override
    public void setCompilingDefinitions(boolean bCompilingDefinitions) {
        this.getCompilationState().setCompilingDefinitions(bCompilingDefinitions);
    }

    public boolean isDefinitionsCompiled() {
        return this.getCompilationState().isDefinitionsCompiled();
    }

    @Override
    public void setDefinitionsCompiled() {
        this.getCompilationState().setDefinitionsCompiled();
    }

    public ISourceFileHandle getSourceFileHandle() {
        return this._sourceFileHandle;
    }

    public List<IType> getLoadedInnerClasses() {
        if (this.isDeclarationsCompiled()) {
            Collection<? extends IGosuClass> innerClasses = this.getKnownInnerClassesWithoutCompiling().values();
            return new ArrayList<IGosuClass>(innerClasses);
        }
        return Collections.emptyList();
    }

    public ClassType getClassType() {
        return ClassType.Class;
    }

    @Override
    public List<? extends IGosuAnnotation> getGosuAnnotations() {
        return this.getModifierInfo().getAnnotations();
    }

    @Override
    public GosuClassParseInfo createNewParseInfo() {
        if (this._parseInfo == null) {
            this._parseInfo = new GosuClassParseInfo((IGosuClassInternal)this.getOrCreateTypeReference());
        }
        return this._parseInfo;
    }

    public boolean isTestClass() {
        return this._sourceFileHandle.isTestClass();
    }

    public IGosuClassInternal getInnerClass(CharSequence relativeName) {
        IGosuClassInternal innerClass;
        int dotIndex;
        String strRelativeName;
        String string = strRelativeName = relativeName == null ? null : relativeName.toString();
        if (strRelativeName != null && strRelativeName.startsWith("AnonymouS_")) {
            try {
                this.compileDefinitionsIfNeeded();
            }
            catch (ErrantGosuClassException errantGosuClassException) {
                // empty catch block
            }
        }
        int n = dotIndex = strRelativeName == null ? -1 : strRelativeName.indexOf(46);
        if (dotIndex == -1) {
            innerClass = this.getInnerClassesMap().get(strRelativeName);
        } else {
            innerClass = this.getInnerClassesMap().get(strRelativeName.subSequence(0, dotIndex).toString());
            if (innerClass != null) {
                innerClass = (IGosuClassInternal)innerClass.getInnerClass(strRelativeName.subSequence(dotIndex + 1, strRelativeName.length()).toString());
            }
        }
        if (innerClass == null && (innerClass = this.maybeLoadBlockToInterfaceProxy(strRelativeName)) != null) {
            boolean b;
            boolean bl = b = this.getInnerClassesMap().get(strRelativeName) == innerClass;
            assert (b);
        }
        return innerClass;
    }

    private IGosuClassInternal maybeLoadBlockToInterfaceProxy(String relativeName) {
        if (relativeName.startsWith("ProxyFor_")) {
            return (IGosuClassInternal)FunctionToInterfaceClassGenerator.getBlockToInterfaceConversionClass(relativeName, (IType)this.getOrCreateTypeReference());
        }
        return null;
    }

    @Override
    public VarStatement getMemberField(String charSequence) {
        return this.getParseInfo().getMemberFields().get(charSequence);
    }

    public boolean shouldKeepDebugInfo() {
        return !this.isProxy();
    }

    @Override
    public IGosuClassInternal getSuperClass() {
        this.compileHeaderIfNeeded();
        IType superType = this.getSupertype();
        if (superType instanceof IGosuClassInternal) {
            return (IGosuClassInternal)superType;
        }
        if (superType instanceof IJavaType) {
            return IGosuClassInternal.Util.getGosuClassFrom(superType);
        }
        return null;
    }

    @Override
    public ICompilableTypeInternal getEnclosingType() {
        return this._enclosingType == null || this._enclosingType instanceof ErrorType || !(this._enclosingType instanceof ICompilableTypeInternal) ? null : (ICompilableTypeInternal)this._enclosingType;
    }

    public boolean hasBackingClass() {
        return this._javaClass != null && this._javaClass.get() != null || this._proxiedJavaClassInGosuProxy != null && !this._proxiedJavaClassInGosuProxy.getBackingClassInfo().isAnnotation();
    }

    public void unloadBackingClass() {
        SingleServingGosuClassLoader.clearCache(this.getName());
        if (this._javaClass != null) {
            TypeSystem.lock();
            try {
                this._javaClass = null;
            }
            finally {
                TypeSystem.unlock();
            }
        }
    }

    public Class<?> getBackingClass() {
        Class clazz;
        if (this.isParameterizedType()) {
            return this.getGenericType().getBackingClass();
        }
        if (this._proxiedJavaClassInGosuProxy != null && !this._proxiedJavaClassInGosuProxy.getBackingClassInfo().isAnnotation()) {
            return this._proxiedJavaClassInGosuProxy.getIntrinsicClass();
        }
        Class clazz2 = clazz = this._javaClass == null ? null : this._javaClass.get();
        if (clazz == null) {
            TypeSystem.lock();
            try {
                Class clazz3 = clazz = this._javaClass == null ? null : this._javaClass.get();
                if (clazz == null) {
                    clazz = GosuClassLoader.instance().defineClass((IGosuClassInternal)this.getOrCreateTypeReference(), false);
                    this._javaClass = new SoftReference<Class>(clazz);
                }
            }
            catch (ClassNotFoundException e) {
                throw GosuExceptionUtil.forceThrow((Throwable)e);
            }
            finally {
                TypeSystem.unlock();
            }
        }
        return clazz;
    }

    public boolean isCompilable() {
        return this._proxiedJavaClassInGosuProxy == null || this._proxiedJavaClassInGosuProxy.getBackingClassInfo().isAnnotation();
    }

    public byte[] compile() {
        if (this.isParameterizedType()) {
            return this.getGenericType().compile();
        }
        if (!this.isCompilable()) {
            throw new RuntimeException();
        }
        return TransformingCompiler.compileClass((IGosuClassInternal)this.getOrCreateTypeReference(), false);
    }

    public ISymbol getExternalSymbol(String strName) {
        if (this.getEnclosingType() != null) {
            return this.getEnclosingType().getExternalSymbol(strName);
        }
        return null;
    }

    @Override
    public void putClassMembers(GosuParser owner, ISymbolTable table, IGosuClassInternal gsContextClass, boolean bStatic) {
        this.putClassMembers(this.getTypeLoader(), owner, table, gsContextClass, bStatic);
    }

    @Override
    public void putClassMembers(GosuClassTypeLoader loader, GosuParser owner, ISymbolTable table, IGosuClassInternal gsContextClass, boolean bStatic) {
        this.putClassMembers(loader, owner, table, gsContextClass, bStatic, false);
    }

    @Override
    public void putClassMembers(GosuClassTypeLoader loader, GosuParser owner, ISymbolTable table, IGosuClassInternal gsContextClass, boolean bStatic, boolean bStaticImport) {
        this.compileDeclarationsIfNeeded();
        for (int i = 0; i < this._interfaces.length; ++i) {
            IGosuClassInternal gsClass;
            IType type = this._interfaces[i];
            if (type instanceof ErrorType || (gsClass = IGosuClassInternal.Util.getGosuClassFrom(type)) == null || gsClass == this.getOrCreateTypeReference()) continue;
            gsClass.putClassMembers(owner, table, gsContextClass, bStatic);
        }
        if (this.getEnclosingType() instanceof IGosuClassInternal && ((IGosuClassInternal)this.getEnclosingType()).isHeaderCompiled() && TypeLord.encloses((IType)this.getEnclosingType(), (IType)owner.getGosuClass())) {
            this.getEnclosingType().putClassMembers(loader, owner, table, gsContextClass, bStatic || this.isStatic());
        }
        if (this.getSuperClass() != null) {
            this.getSuperClass().putClassMembers(owner, table, gsContextClass, bStatic);
            if (this.getSuperClass().isProxy()) {
                this.addJavaEnhancements(owner, table, gsContextClass, bStatic, this.getSuperClass().getJavaType());
            }
        }
        this.putEnhancements(owner, table, gsContextClass, bStatic, loader.getModule(), (IType)this.getOrCreateTypeReference());
        boolean bSuperClass = gsContextClass != this.getOrCreateTypeReference();
        this.putStaticFields(table, gsContextClass, bSuperClass, bStaticImport);
        if (gsContextClass == null || bStaticImport || !this.isInterface() || this.getOrCreateTypeReference((IType)gsContextClass) == this.getOrCreateTypeReference()) {
            this.putStaticFunctions(owner, table, gsContextClass, bSuperClass, bStaticImport);
            this.putStaticProperties(table, gsContextClass, bSuperClass, bStaticImport);
        }
        if (!bStatic) {
            this.putFields(table, gsContextClass, bSuperClass);
            this.putFunctions(owner, table, gsContextClass, bSuperClass);
            this.putProperties(table, gsContextClass, bSuperClass);
            this.putConstructors(owner, table, bSuperClass);
        }
    }

    private void addJavaEnhancements(GosuParser owner, ISymbolTable table, IGosuClassInternal gsContextClass, boolean bStatic, IJavaType type) {
        IType superType = type.getSupertype();
        if (superType instanceof IJavaType) {
            this.addJavaEnhancements(owner, table, gsContextClass, bStatic, (IJavaType)superType);
        }
        for (IType iface : type.getInterfaces()) {
            if (!(iface instanceof IJavaType)) continue;
            this.addJavaEnhancements(owner, table, gsContextClass, bStatic, (IJavaType)iface);
        }
        this.putEnhancements(owner, table, gsContextClass, bStatic, this.getTypeLoader().getModule(), (IType)type);
    }

    private void putEnhancements(GosuParser owner, ISymbolTable table, IGosuClassInternal gsContextClass, boolean bStatic, IModule module, IType type) {
        IModule[] moduleTraversalList;
        for (IModule m : moduleTraversalList = module.getModuleTraversalList()) {
            GosuClassTypeLoader loader = GosuClassTypeLoader.getDefaultClassLoader((IModule)m);
            if (loader == null) continue;
            for (IGosuEnhancement enhancement : loader.getEnhancementIndex().getEnhancementsForType(type)) {
                ((IGosuEnhancementInternal)enhancement).putClassMembers(loader, owner, table, gsContextClass, bStatic);
            }
        }
    }

    private void putFunctions(GosuParser owner, ISymbolTable table, IGosuClassInternal gsContextClass, boolean bSuperClass) {
        for (DynamicFunctionSymbol dfs : this.getMemberFunctions()) {
            if (bSuperClass && (!this.isAccessible(gsContextClass, dfs) || this.isHidden(dfs))) continue;
            if (this.isParameterizedType()) {
                dfs = dfs.getParameterizedVersion((IGosuClass)this.getOrCreateTypeReference());
            }
            table.putSymbol((ISymbol)dfs);
            if (owner == null) continue;
            owner.putDfsDeclInSetByName(dfs);
        }
    }

    private boolean isHidden(DynamicFunctionSymbol dfs) {
        if (ILanguageLevel.Util.STANDARD_GOSU()) {
            return false;
        }
        if (this.isCompilingDeclarationsFor(dfs.getScriptPart())) {
            return false;
        }
        IAttributedFeatureInfo mi = dfs.getMethodOrConstructorInfo(true);
        return mi != null && mi.isHidden();
    }

    private boolean isHidden(DynamicPropertySymbol dps) {
        if (ILanguageLevel.Util.STANDARD_GOSU()) {
            return false;
        }
        DynamicFunctionSymbol getterDfs = dps.getGetterDfs();
        if (this.isCompilingDeclarationsFor(dps.getScriptPart())) {
            return false;
        }
        IAttributedFeatureInfo miGetter = getterDfs == null ? null : getterDfs.getMethodOrConstructorInfo(true);
        return miGetter != null && miGetter.isHidden();
    }

    private boolean isHidden(IVarStatement varStmt) {
        if (ILanguageLevel.Util.STANDARD_GOSU()) {
            return false;
        }
        if (this.isCompilingDeclarationsFor(varStmt.getScriptPart())) {
            return false;
        }
        for (IGosuAnnotation ann : ((VarStatement)varStmt).getAnnotations()) {
            if (!ann.getType().getName().equals(InternalAPI.class.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isCompilingDeclarationsFor(IScriptPartId scriptPart) {
        if (scriptPart != null) {
            IGosuClass type = (IGosuClass)scriptPart.getContainingType();
            return type != null && type.isCompilingDeclarations();
        }
        return false;
    }

    private void putProperties(ISymbolTable table, IGosuClassInternal gsContextClass, boolean bSuperClass) {
        for (DynamicPropertySymbol dps : this.getMemberProperties()) {
            if (bSuperClass && (!this.isAccessible(gsContextClass, dps) || this.isHidden(dps))) continue;
            if (this.isParameterizedType()) {
                dps = dps.getParameterizedVersion((IGosuClass)this.getOrCreateTypeReference());
            }
            table.putSymbol((ISymbol)dps);
        }
    }

    private void putConstructors(GosuParser owner, ISymbolTable table, boolean bSuperClass) {
        for (DynamicFunctionSymbol dfs : this.getConstructorFunctions()) {
            if (bSuperClass) continue;
            if (this.isParameterizedType()) {
                dfs = dfs.getParameterizedVersion((IGosuClass)this.getOrCreateTypeReference());
            }
            table.putSymbol((ISymbol)dfs);
            if (owner == null) continue;
            owner.putDfsDeclInSetByName(dfs);
        }
    }

    private void putStaticFunctions(GosuParser owner, ISymbolTable table, IGosuClassInternal gsContextClass, boolean bSuperClass, boolean bStaticImport) {
        List<DynamicFunctionSymbol> staticFunctions = this.getStaticFunctions();
        for (int i = 0; i < staticFunctions.size(); ++i) {
            DynamicFunctionSymbol dfs = staticFunctions.get(i);
            if (bSuperClass && (!this.isAccessible(gsContextClass, dfs) || this.isHidden(dfs))) continue;
            if (this.isParameterizedType()) {
                dfs = dfs.getParameterizedVersion((IGosuClass)this.getOrCreateTypeReference());
            }
            if (!bStaticImport || table.getSymbol((CharSequence)dfs.getName()) == null) {
                table.putSymbol((ISymbol)dfs);
            }
            if (owner == null) continue;
            if (bStaticImport) {
                List<IFunctionSymbol> existing = owner.getDfsDeclsForFunction(dfs.getDisplayName());
                if (existing != null && existing.contains(dfs)) continue;
                owner.putDfsDeclInSetByName(dfs);
                continue;
            }
            owner.putDfsDeclInSetByName(dfs);
        }
    }

    private void putStaticProperties(ISymbolTable table, IGosuClassInternal gsContextClass, boolean bSuperClass, boolean bStaticImport) {
        List<DynamicPropertySymbol> staticProperties = this.getStaticProperties();
        for (int i = 0; i < staticProperties.size(); ++i) {
            DynamicPropertySymbol dps = staticProperties.get(i);
            if (bSuperClass && (!this.isAccessible(gsContextClass, dps) || this.isHidden(dps))) continue;
            if (this.isParameterizedType()) {
                dps = dps.getParameterizedVersion((IGosuClass)this.getOrCreateTypeReference());
            }
            if (bStaticImport && table.getSymbol((CharSequence)dps.getName()) != null) continue;
            table.putSymbol((ISymbol)dps);
        }
    }

    private void putStaticFields(ISymbolTable table, IGosuClassInternal gsContextClass, boolean bSuperClass, boolean bStaticImport) {
        for (IVarStatement varStmt : this.getStaticFields()) {
            if (varStmt.isAbstract() || bSuperClass && (!this.isAccessible(gsContextClass, varStmt) || this.isHidden(varStmt))) continue;
            ISymbol existingSymbol = table.getSymbol((CharSequence)varStmt.getSymbol().getName());
            if (bStaticImport && existingSymbol != null) continue;
            if (existingSymbol != null && !this.areSymbolsFromSameDeclaration(varStmt, existingSymbol)) {
                table.putSymbol((ISymbol)new AmbiguousSymbol(varStmt.getSymbol().getName()));
                continue;
            }
            table.putSymbol(varStmt.getSymbol());
        }
    }

    private boolean areSymbolsFromSameDeclaration(IVarStatement varStmt, ISymbol existingSymbol) {
        boolean sameDeclaringType = GosuObjectUtil.equals((Object)existingSymbol.getScriptPart(), (Object)varStmt.getSymbol().getScriptPart());
        if (sameDeclaringType) {
            return true;
        }
        if (existingSymbol.getScriptPart() != null) {
            IGosuClassInternal existingDeclaringType = (IGosuClassInternal)existingSymbol.getScriptPart().getContainingType();
            if (this.isProxy() && existingDeclaringType.isProxy()) {
                IPropertyInfo pi = ((IRelativeTypeInfo)this.getJavaType().getTypeInfo()).getProperty(this.getTheRef(), (CharSequence)existingSymbol.getName());
                return pi != null && pi.getOwnersType() == existingDeclaringType.getJavaType();
            }
        }
        return false;
    }

    private void putFields(ISymbolTable table, IGosuClassInternal gsContextClass, boolean bSuperClass) {
        for (IVarStatement varStmt : this.getMemberFields()) {
            if (varStmt.isAbstract() || bSuperClass && (!this.isAccessible(gsContextClass, varStmt) || this.isHidden(varStmt))) continue;
            Object symbol = varStmt.getSymbol();
            if (this.isParameterizedType() && symbol instanceof AbstractDynamicSymbol) {
                symbol = ((AbstractDynamicSymbol)symbol).getParameterizedVersion((IGosuClass)this.getOrCreateTypeReference());
            }
            table.putSymbol(symbol);
        }
    }

    @Override
    public boolean isAccessible(IGosuClassInternal compilingClass, AbstractDynamicSymbol ads) {
        return this.getOuterMostEnclosingClass((IType)compilingClass) == this.getOuterMostEnclosingClass((IType)this.getOrCreateTypeReference()) || ads.isPublic() || ads.isProtected() || ads.isInternal() && (this.isProxy() ? this.getNamespace().endsWith(compilingClass.getNamespace()) : this.getNamespace().equals(compilingClass.getNamespace()));
    }

    private boolean isAccessible(IGosuClassInternal compilingClass, IVarStatement varStmt) {
        return this.getOuterMostEnclosingClass((IType)compilingClass) == this.getOuterMostEnclosingClass((IType)this.getOrCreateTypeReference()) || varStmt.isPublic() || varStmt.isProtected() || varStmt.isInternal() && (this.isProxy() ? this.getNamespace().endsWith(compilingClass.getNamespace()) : this.getNamespace().equals(compilingClass.getNamespace()));
    }

    private IType getOuterMostEnclosingClass(IType innerClass) {
        IType outerMost;
        for (outerMost = innerClass; outerMost != null && outerMost.getEnclosingType() != null; outerMost = outerMost.getEnclosingType()) {
        }
        return outerMost;
    }

    @Override
    public void setParseResultsException(ParseResultsException pe) {
        this.getParseInfo().setParseResultsException(pe);
        this._valid.clear();
    }

    public boolean hasError() {
        Boolean hasError;
        Boolean bl = hasError = this._hasError != null ? this._hasError : ((GosuClass)this.getPureGenericClass().dontEverCallThis())._hasError;
        if (!this.isCompilingDefinitions() && hasError != null) {
            return hasError;
        }
        TypeSystem.lock();
        try {
            this.compileDeclarationsIfNeeded();
        }
        finally {
            TypeSystem.unlock();
        }
        ParseResultsException pe = this.getParseResultsException();
        ((GosuClass)this.getPureGenericClass().dontEverCallThis())._hasError = pe != null && pe.hasParseExceptions() ? Boolean.TRUE : Boolean.FALSE;
        return ((GosuClass)this.getPureGenericClass().dontEverCallThis())._hasError;
    }

    public boolean hasWarnings() {
        ParseResultsException pe = this.getParseResultsException();
        return pe != null && pe.hasParseWarnings();
    }

    private IGosuClassInternal getPureGenericClass() {
        return (IGosuClassInternal)TypeLord.getPureGenericType(this.getOrCreateTypeReference());
    }

    public ParseResultsException getParseResultsException() {
        return this.getParseInfo() == null ? null : this.getParseInfo().getParseResultsException();
    }

    public int compareTo(Object o) {
        return this.getName().compareTo(((IType)o).getName());
    }

    @Override
    public boolean shouldResolve() {
        return !this.isCompiled() && this.isDeclarationsCompiled();
    }

    private GosuParser makeParserForPhase() {
        this.createNewParseInfo();
        CompiledGosuClassSymbolTable symbolTable = CompiledGosuClassSymbolTable.instance();
        GosuParser parser = this.getOrCreateParser(symbolTable);
        ISource source = this._sourceFileHandle.getSource();
        parser.setScript(source);
        this._parseInfo.updateSource(source.getSource());
        if (ExecutionMode.isIDE()) {
            parser.setThrowParseExceptionForWarnings(true);
            parser.setDontOptimizeStatementLists(true);
            parser.setWarnOnCaseIssue(true);
            parser.setEditorParser(true);
        }
        this.assignTypeUsesMap(parser);
        return parser;
    }

    public ITypeUsesMap getTypeUsesMap() {
        return this._typeUsesMap;
    }

    @Override
    public void setTypeUsesMap(ITypeUsesMap usesMap) {
        this._typeUsesMap = usesMap;
    }

    @Override
    public void assignTypeUsesMap(GosuParser parser) {
        if (this._typeUsesMap != null) {
            parser.setTypeUsesMap(this._typeUsesMap);
            if (this._strNamespace != null) {
                parser.getTypeUsesMap().addToTypeUses(this._strNamespace + ".*");
            }
        } else {
            ICompilableTypeInternal gsOuter = this.getEnclosingType();
            if (gsOuter != null) {
                gsOuter.assignTypeUsesMap(parser);
            } else if (this._strNamespace != null) {
                parser.getTypeUsesMap().addToTypeUses(this._strNamespace + ".*");
            }
        }
    }

    @Override
    public void setEditorParser(GosuParser parser) {
        this._parser = parser;
    }

    public void setCreateEditorParser(boolean bEditorParser) {
        this._bEditorParser = bEditorParser;
    }

    @Override
    public boolean isCreateEditorParser() {
        return this._bEditorParser;
    }

    @Override
    public int getAnonymousInnerClassCount() {
        Collection<? extends IGosuClass> innerClasses = this.getKnownInnerClassesWithoutCompiling().values();
        int iCount = 0;
        for (IGosuClass iGosuClass : innerClasses) {
            if (!iGosuClass.isAnonymous()) continue;
            ++iCount;
        }
        return iCount;
    }

    public GosuParser getParser() {
        return this._parser;
    }

    protected GosuParser getOrCreateParser(CompiledGosuClassSymbolTable symbolTable) {
        if (this._parser != null) {
            return this._parser;
        }
        GosuParser parser = this.createParser(symbolTable);
        if (ExecutionMode.isIDE()) {
            this._parser = parser;
        }
        return parser;
    }

    private GosuParser createParser(CompiledGosuClassSymbolTable symbolTable) {
        GosuParser parser = (GosuParser)GosuParserFactory.createParser((ISymbolTable)symbolTable, (IScriptabilityModifier)ScriptabilityModifiers.SCRIPTABLE);
        parser.pushScriptPart((IScriptPartId)new ScriptPartId((IType)this.getOrCreateTypeReference(), null));
        ICompilableTypeInternal enclosingType = this.getEnclosingType();
        if (enclosingType != null) {
            IGosuParser enclosingParser = enclosingType.getParser();
            if (enclosingParser != null) {
                parser.setThrowParseExceptionForWarnings(enclosingParser.isThrowParseResultsExceptionForWarnings());
                parser.setWarnOnCaseIssue(enclosingParser.isThrowParseResultsExceptionForWarnings());
                parser.setEditorParser(enclosingParser.isThrowParseResultsExceptionForWarnings());
            } else {
                parser.setThrowParseExceptionForWarnings(enclosingType.isCreateEditorParser());
                parser.setWarnOnCaseIssue(enclosingType.isCreateEditorParser());
                parser.setEditorParser(enclosingType.isCreateEditorParser());
            }
        } else {
            parser.setThrowParseExceptionForWarnings(this._bEditorParser);
            parser.setWarnOnCaseIssue(this._bEditorParser);
            parser.setEditorParser(this._bEditorParser);
        }
        return parser;
    }

    @Override
    public void addDelegateImpls(ISymbolTable symTable, GosuClassParser parser) {
        ArrayList<DynamicPropertySymbol> props = new ArrayList<DynamicPropertySymbol>();
        ArrayList<DelegateFunctionSymbol> meths = new ArrayList<DelegateFunctionSymbol>();
        HashMap<DelegateFunctionType, DelegateFunctionType> delegated = new HashMap<DelegateFunctionType, DelegateFunctionType>();
        IGosuClassInternal pThis = (IGosuClassInternal)this.getOrCreateTypeReference();
        for (VarStatement varStmt : this.getMemberFieldsMap().values()) {
            if (!(varStmt instanceof DelegateStatement)) continue;
            DelegateStatement delegateStmt = (DelegateStatement)varStmt;
            List<IFunctionType> unimpled = new ArrayList<IFunctionType>();
            for (IType iface : delegateStmt.getConstituents()) {
                IGosuClassInternal gsInterface = IGosuClassInternal.Util.getGosuClassFrom(iface);
                if (gsInterface == null) continue;
                unimpled = GosuClass.getUnimplementedMethods(gsInterface, pThis, unimpled, true, false);
                for (IMethodInfo mi : gsInterface.getTypeInfo().getMethods()) {
                    DelegateFunctionSymbol delegateFs;
                    GosuMethodInfo gmi;
                    FunctionType type;
                    if (mi.isDefaultImpl() || !unimpled.contains(type = new FunctionType((IMethodInfo)(gmi = (GosuMethodInfo)mi)))) continue;
                    DelegateFunctionType dft = new DelegateFunctionType((IMethodInfo)gmi);
                    if (delegated.containsKey((Object)dft)) {
                        IFunctionType existing = (IFunctionType)delegated.get((Object)dft);
                        parser.addDeclaredNameParseError((IParsedElementWithAtLeastOneDeclaration)delegateStmt, Res.MSG_DELEGATE_METHOD_CONFLICT, existing.getEnclosingType() + "#" + existing.getParamSignature(), dft.getEnclosingType() + "#" + dft.getParamSignature());
                        continue;
                    }
                    delegated.put(dft, dft);
                    IReducedDynamicFunctionSymbol dfs = gmi.getDfs();
                    mi = (IMethodInfo)dfs.getMethodOrConstructorInfo();
                    if (!(iface instanceof IGosuClass)) {
                        String strMethodName = mi.getDisplayName();
                        mi = iface.getTypeInfo().getMethod((CharSequence)strMethodName, ((IFunctionType)dfs.getType()).getParameterTypes());
                        if (mi == null) {
                            if (dfs.getDisplayName().startsWith("@") && (mi = iface.getTypeInfo().getMethod((CharSequence)("get" + strMethodName.substring(1)), new IType[0])) == null) {
                                mi = iface.getTypeInfo().getMethod((CharSequence)("is" + strMethodName.substring(1)), new IType[0]);
                            }
                            if (mi == null) {
                                mi = iface.getTypeInfo().getCallableMethod((CharSequence)strMethodName, ((IFunctionType)dfs.getType()).getParameterTypes());
                            }
                            if (mi == null) {
                                throw new IllegalStateException("Did not find method info for: " + dfs.getMethodOrConstructorInfo());
                            }
                        }
                    }
                    if ((delegateFs = new DelegateFunctionSymbol(pThis, symTable, (ReducedDynamicFunctionSymbol)dfs, mi, delegateStmt)).getName().startsWith("@")) {
                        DynamicPropertySymbol dps = parser.getOrCreateDynamicPropertySymbol(this.getParseInfo().getClassStatement(), pThis, delegateFs, delegateFs.getReturnType() != GosuParserTypes.NULL_TYPE());
                        props.add(dps);
                        continue;
                    }
                    meths.add(delegateFs);
                }
            }
        }
        for (DynamicPropertySymbol dps : props) {
            parser.processPropertySymbol(dps, pThis);
        }
        for (DelegateFunctionSymbol delegateFs : meths) {
            parser.processFunctionSymbol(delegateFs, pThis);
        }
    }

    @Override
    public List<IFunctionType> getUnimplementedMethods() {
        List<IFunctionType> emptyList = Collections.emptyList();
        return this.getUnimplementedMethods(emptyList, (IGosuClassInternal)this.getOrCreateTypeReference(), this.isAbstract());
    }

    @Override
    public List<IFunctionType> getUnimplementedMethods(List<IFunctionType> unimpled, IGosuClassInternal implClass, boolean bAcceptAbstract) {
        IGosuClassInternal gsSuper;
        IType superType;
        for (Object iface : this._interfaces) {
            if (iface instanceof ErrorType || this.isEnum() && iface == JavaTypes.getGosuType(IEnumValue.class) || iface == JavaTypes.IPROGRAM_INSTANCE() || (iface = IGosuClassInternal.Util.getGosuClassFrom(iface)) == null) continue;
            unimpled = GosuClass.getUnimplementedMethods((IGosuClassInternal)iface, implClass, unimpled, true, bAcceptAbstract);
        }
        if (!bAcceptAbstract && (superType = this.getSupertype()) != null && superType.isAbstract() && (gsSuper = IGosuClassInternal.Util.getGosuClassFrom(superType)) != null) {
            unimpled = GosuClass.getUnimplementedMethods(gsSuper, implClass, unimpled, false, false);
            unimpled = gsSuper.getUnimplementedMethods(unimpled, implClass, bAcceptAbstract);
        }
        return unimpled;
    }

    public static List<IFunctionType> getUnimplementedMethods(IGosuClass gsIface, IGosuClass implClass, List<IFunctionType> unimpled, boolean ensurePublic, boolean bAcceptAbstract) {
        if (gsIface.isGenericType() && !gsIface.isParameterizedType()) {
            return Collections.emptyList();
        }
        for (IMethodInfo mi : gsIface.getTypeInfo().getMethods((IType)gsIface)) {
            FunctionType ifaceFuncType;
            DynamicFunctionSymbol implDfs;
            if (!mi.isAbstract() && !mi.isDefaultImpl() || mi.getOwnersType() == IGosuClassInternal.Util.getGosuClassFrom((IType)JavaTypes.IGOSU_OBJECT()) || (implDfs = GosuClass.getImplDfs((IGosuClassInternal)implClass, (IFunctionType)(ifaceFuncType = new FunctionType(mi)), bAcceptAbstract)) != null && GosuClass.isAssignable(implDfs, (IFunctionType)ifaceFuncType) && (!ensurePublic || implDfs.isPublic()) || GosuClass.isObjectMethod(mi) || GosuClass.handleParameterizedDfs(implClass, mi, (IFunctionType)ifaceFuncType, bAcceptAbstract)) continue;
            if (unimpled.isEmpty()) {
                unimpled = new ArrayList<IFunctionType>(8);
            }
            unimpled.add((IFunctionType)ifaceFuncType);
        }
        return unimpled;
    }

    private static boolean handleParameterizedDfs(IGosuClass implClass, IMethodInfo mi, IFunctionType ifaceFuncType, boolean bAcceptAbstract) {
        IReducedDynamicFunctionSymbol miDfs;
        if (mi instanceof GosuMethodInfo && (miDfs = ((GosuMethodInfo)mi).getDfs()) != null) {
            while (miDfs instanceof ReducedParameterizedDynamicFunctionSymbol) {
                DynamicFunctionSymbol implDfs = GosuClass.getImplDfs((IGosuClassInternal)implClass, (IFunctionType)miDfs.getBackingDfs().getType(), bAcceptAbstract);
                if (implDfs == null || !GosuClass.isAssignable(implDfs, ifaceFuncType)) {
                    miDfs = (ReducedDynamicFunctionSymbol)miDfs.getBackingDfs();
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isAssignable(DynamicFunctionSymbol implDfs, IFunctionType ifaceFuncType) {
        if (ifaceFuncType.isAssignableFrom(implDfs.getType(), false)) {
            return true;
        }
        DynamicFunctionSymbol superDfs = implDfs.getSuperDfs();
        if (superDfs != null && GosuClass.isAssignable(superDfs, ifaceFuncType)) {
            return true;
        }
        DynamicFunctionSymbol delegateDfs = (DynamicFunctionSymbol)implDfs.getBackingDfs();
        return delegateDfs != null && delegateDfs != implDfs && GosuClass.isAssignable(delegateDfs, ifaceFuncType);
    }

    static boolean isObjectMethod(IMethodInfo mi) {
        IParameterInfo[] params = mi.getParameters();
        IType[] paramTypes = new IType[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramTypes[i] = params[i].getFeatureType();
        }
        IRelativeTypeInfo ti = (IRelativeTypeInfo)JavaTypes.OBJECT().getTypeInfo();
        String name = mi.getDisplayName();
        name = name.equals("@Class") ? "getClass" : name;
        IMethodInfo objMethod = ti.getMethod((IType)JavaTypes.OBJECT(), (CharSequence)name, paramTypes);
        return objMethod != null;
    }

    private static DynamicFunctionSymbol getImplDfs(IGosuClassInternal implClass, IFunctionType ifaceFuncType, boolean bAcceptAbstract) {
        if (implClass == null) {
            return null;
        }
        String signature = ifaceFuncType.getParamSignatureForCurrentModule();
        DynamicFunctionSymbol implDfs = implClass.getMemberFunction(ifaceFuncType, signature, false);
        if (implDfs != null && implClass.isParameterizedType()) {
            implDfs = implDfs.getParameterizedVersion(implClass);
        }
        if (implDfs == null && signature.charAt(0) == '@') {
            implDfs = GosuClass.findVarPropertyAccessorDfs(signature, implClass);
        }
        if (implDfs == null) {
            implDfs = GosuClass.getImplDfs(implClass.getSuperClass(), ifaceFuncType, bAcceptAbstract);
        }
        if (!bAcceptAbstract && implDfs != null && implDfs.isAbstract()) {
            implDfs = null;
        }
        return implDfs;
    }

    private static DynamicFunctionSymbol findVarPropertyAccessorDfs(String signature, IGosuClassInternal implClass) {
        String strPropName = signature;
        DynamicPropertySymbol dps = implClass.getMemberProperty(strPropName = strPropName.substring(1, strPropName.indexOf(40)));
        if (dps != null) {
            if (dps.getGetterDfs() != null && dps.getGetterDfs().getName().equals(signature)) {
                return dps.getGetterDfs();
            }
            if (dps.getSetterDfs() != null && dps.getSetterDfs().getName().equals(signature)) {
                return dps.getSetterDfs();
            }
        }
        return null;
    }

    @Override
    public void setFullDescription(String description) {
        this._description = description;
    }

    @Override
    public String getFullDescription() {
        return this._description == null ? "" : this._description;
    }

    public List<? extends IType> getSubtypes() {
        if (this._subtypes == null) {
            this._subtypes = new ArrayList<IGosuClassInternal>();
            Set typeNames = this.getTypeLoader().getAllTypeNames();
            for (CharSequence typeName : typeNames) {
                IType type = TypeSystem.getByFullNameIfValid((String)typeName.toString());
                if (!(type instanceof IGosuClassInternal)) continue;
                IGosuClassInternal gosuClass = (IGosuClassInternal)type;
                if (this.getOrCreateTypeReference() == gosuClass || !this.isAssignableFrom((IType)gosuClass)) continue;
                this._subtypes.add(gosuClass);
            }
        }
        return this._subtypes;
    }

    public boolean isDiscarded() {
        return this._bDiscarded && !this._bInitializing;
    }

    public void setDiscarded(boolean bDiscarded) {
        if (bDiscarded) {
            this.unloadBackingClass();
        }
        this._bDiscarded = bDiscarded;
    }

    public boolean isCompoundType() {
        return false;
    }

    public Set<IType> getCompoundTypeComponents() {
        return null;
    }

    @Override
    public boolean isCannotCaptureSymbols() {
        return this._bCannotCaptureSymbols;
    }

    @Override
    public void setCannotCaptureSymbols(boolean bCannotCaptureSymbols) {
        this._bCannotCaptureSymbols = bCannotCaptureSymbols;
    }

    @Override
    public List<IGosuClass> getBlocks() {
        if (!this.isValid()) {
            return Collections.emptyList();
        }
        return this._blocks;
    }

    @Override
    public int getBlockCount() {
        return this._blocks.size();
    }

    @Override
    public void addBlock(IBlockClass block) {
        if (this._blocks == Collections.EMPTY_LIST) {
            this._blocks = new ArrayList<IGosuClass>();
        }
        this.addInnerClass((IGosuClassInternal)block);
        this._blocks.add((IGosuClass)block);
    }

    @Override
    public void removeBlock(IBlockClass block) {
        if (!this._blocks.isEmpty()) {
            this.removeInnerClass((IGosuClassInternal)block);
            this._blocks.remove(block);
        }
    }

    private void initLazyVars() {
        this._valid = LockingLazyVar.make(() -> this.getClassStatement() != null && !this.getClassStatement().hasParseExceptions() ? Boolean.TRUE : Boolean.FALSE);
        this._functionalInterface = LocklessLazyVar.make(() -> FunctionToInterfaceCoercer.getRepresentativeFunctionType((IType)this.getOrCreateTypeReference()));
    }

    public void assignTypeVarsFromTypeParams(IType[] typeParams) {
        this._typeVarDefs = new ArrayList<ITypeVariableDefinition>(2);
        for (IType typeParam : typeParams) {
            if (!(typeParam instanceof TypeVariableType)) continue;
            TypeVariableDefinitionImpl typeVarDef = this.getTypeVarDefImpl(((TypeVariableType)typeParam).getTypeVarDef());
            this._typeVarDefs.add(typeVarDef);
        }
        if (this._typeVarDefs.isEmpty()) {
            this._typeVarDefs = Collections.emptyList();
        }
    }

    public List<ITypeVariableDefinition> getTypeVarDefs() {
        return this._typeVarDefs;
    }

    @Override
    public void setGenericTypeVariables(List<ITypeVariableDefinition> typeVarExprList) {
        int i;
        if (typeVarExprList.isEmpty()) {
            typeVarExprList = Collections.emptyList();
        }
        this._typeVarDefs = new ArrayList<ITypeVariableDefinition>(typeVarExprList.size());
        for (i = 0; i < typeVarExprList.size(); ++i) {
            this._typeVarDefs.add(this.getTypeVarDefImpl((ITypeVariableDefinition)typeVarExprList.get(i)));
        }
        if (this._genTypeVar != null && this._genTypeVar.length > 0) {
            for (i = 0; i < this._typeVarDefs.size(); ++i) {
                this._genTypeVar[i] = (GenericTypeVariable)this._typeVarDefs.get(i).getTypeVar();
            }
        }
    }

    private TypeVariableDefinitionImpl getTypeVarDefImpl(ITypeVariableDefinition typeVarDef) {
        while (!(typeVarDef instanceof TypeVariableDefinitionImpl)) {
            typeVarDef = ((TypeVariableDefinition)typeVarDef).getTypeVarDef();
        }
        return (TypeVariableDefinitionImpl)typeVarDef;
    }

    public IFunctionStatement getFunctionStatement(IMethodInfo method) {
        for (IDynamicFunctionSymbol iDynamicFunctionSymbol : this.getMemberFunctions()) {
            if (!method.getName().equals(iDynamicFunctionSymbol.getName()) || !this.equalArgs(method.getParameters(), iDynamicFunctionSymbol.getArgs())) continue;
            return iDynamicFunctionSymbol.getDeclFunctionStmt();
        }
        for (IDynamicFunctionSymbol iDynamicFunctionSymbol : this.getStaticFunctions()) {
            if (!method.getName().equals(iDynamicFunctionSymbol.getName()) || !this.equalArgs(method.getParameters(), iDynamicFunctionSymbol.getArgs())) continue;
            return iDynamicFunctionSymbol.getDeclFunctionStmt();
        }
        return null;
    }

    public INameInDeclaration getPropertyDeclaration(String name) {
        int offset;
        for (VarStatement varStmt : this.getParseInfo().getMemberFields().values()) {
            offset = varStmt.getNameOffset(name);
            if (offset < 0) continue;
            return (INameInDeclaration)varStmt.getLocation().getDeepestLocation(offset, false).getParsedElement();
        }
        for (VarStatement varStmt : this.getParseInfo().getStaticFields().values()) {
            offset = varStmt.getNameOffset(name);
            if (offset < 0) continue;
            return (INameInDeclaration)varStmt.getLocation().getDeepestLocation(offset, false).getParsedElement();
        }
        return null;
    }

    public IConstructorStatement getConstructorStatement(IConstructorInfo ctor) {
        for (IDynamicFunctionSymbol iDynamicFunctionSymbol : this.getConstructorFunctions()) {
            if (iDynamicFunctionSymbol.getMethodOrConstructorInfo(true) != ctor) continue;
            return (IConstructorStatement)iDynamicFunctionSymbol.getDeclFunctionStmt();
        }
        return null;
    }

    private boolean equalArgs(IParameterInfo[] parameters, List<ISymbol> args) {
        if (parameters.length != args.size()) {
            return false;
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].getFeatureType().equals(args.get(i).getType())) continue;
            return false;
        }
        return true;
    }

    public IType[] getLoaderParameterizedTypes() {
        if (this.isHeaderCompiled() && this.isGenericType()) {
            Collection<IGosuClassInternal> types = this.getParameterizedTypes();
            return types.toArray(new IType[types.size()]);
        }
        return new IType[0];
    }

    public IFile[] getSourceFiles() {
        String filePath;
        ISourceFileHandle sourceFileHandle = this.getSourceFileHandle();
        String string = filePath = sourceFileHandle == null ? null : sourceFileHandle.getFilePath();
        if (filePath != null) {
            return new IFile[]{CommonServices.getFileSystem().getIFile(new File(filePath))};
        }
        return IFile.EMPTY_ARRAY;
    }

    public boolean isAnnotation() {
        return Modifier.isAnnotation((int)this.getModifiers()) || !ILanguageLevel.Util.STANDARD_GOSU() && JavaTypes.IANNOTATION().isAssignableFrom((IType)this);
    }
}

